/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.CountingCallback;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.Graceful;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulHandler
extends Handler.Wrapper
implements Graceful {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulHandler.class);
    private final AtomicLong _requests = new AtomicLong();
    private final AtomicLong _streamWrappers = new AtomicLong();
    private final Graceful.Shutdown _shutdown = new Graceful.Shutdown(this){

        @Override
        public boolean isShutdownDone() {
            long requestCount = GracefulHandler.this.getCurrentRequestCount();
            long streamWrapperCount = GracefulHandler.this.getCurrentStreamWrapperCount();
            if (LOG.isDebugEnabled()) {
                LOG.debug("isShutdownDone: requestCount {} streamWrapperCount {}", (Object)requestCount, (Object)streamWrapperCount);
            }
            return requestCount == 0L && streamWrapperCount == 0L;
        }
    };

    public GracefulHandler() {
        this((Handler)null);
    }

    public GracefulHandler(Handler handler) {
        super(handler);
    }

    @ManagedAttribute(value="number of requests being currently handled")
    public long getCurrentRequestCount() {
        return this._requests.longValue();
    }

    @ManagedAttribute(value="number of stream wrappers currently pending")
    public long getCurrentStreamWrapperCount() {
        return this._streamWrappers.longValue();
    }

    @Override
    public boolean isShutdown() {
        return this._shutdown.isShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        request = new ShutdownTrackingRequest(request);
        Handler handler = this.getHandler();
        if (handler == null || !this.isStarted()) {
            return false;
        }
        ShutdownTrackingCallback shutdownCallback = new ShutdownTrackingCallback(request, response, callback);
        if (this.isShutdown()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Service Unavailable: {}", (Object)request.getHttpURI());
            }
            Response.writeError(request, response, (Callback)shutdownCallback, 503);
            return true;
        }
        try {
            boolean handled = super.handle(request, response, shutdownCallback);
            if (!handled) {
                shutdownCallback.completed();
            }
            boolean bl = handled;
            return bl;
        }
        catch (Throwable t2) {
            Response.writeError(request, response, (Callback)shutdownCallback, t2);
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.isShutdown()) {
                this._shutdown.check();
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        this._shutdown.cancel();
        super.doStart();
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutdown requested");
        }
        return this._shutdown.shutdown();
    }

    private class ShutdownTrackingRequest
    extends Request.Wrapper {
        public ShutdownTrackingRequest(Request wrapped) {
            super(wrapped);
        }

        @Override
        public void addHttpStreamWrapper(Function<HttpStream, HttpStream> wrapper) {
            super.addHttpStreamWrapper(httpStream -> {
                HttpStream wrapped = (HttpStream)wrapper.apply((HttpStream)httpStream);
                GracefulHandler.this._streamWrappers.incrementAndGet();
                return new HttpStream.Wrapper(wrapped){

                    @Override
                    public void succeeded() {
                        try {
                            super.succeeded();
                        }
                        finally {
                            this.onCompletion(null);
                        }
                    }

                    @Override
                    public void failed(Throwable x) {
                        try {
                            super.failed(x);
                        }
                        finally {
                            this.onCompletion(x);
                        }
                    }

                    private void onCompletion(Throwable x) {
                        GracefulHandler.this._streamWrappers.decrementAndGet();
                        if (GracefulHandler.this.isShutdown()) {
                            GracefulHandler.this._shutdown.check();
                        }
                    }
                };
            });
        }
    }

    private class ShutdownTrackingCallback
    extends CountingCallback {
        final Request request;
        final Response response;

        public ShutdownTrackingCallback(Request request, Response response, Callback callback) {
            super(callback, 1);
            this.request = request;
            this.response = response;
            GracefulHandler.this._requests.incrementAndGet();
        }

        @Override
        public void completed() {
            GracefulHandler.this._requests.decrementAndGet();
            if (GracefulHandler.this.isShutdown()) {
                GracefulHandler.this._shutdown.check();
            }
        }
    }
}

