/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayEndPoint
extends AbstractEndPoint {
    private static final Logger LOG = LoggerFactory.getLogger(ByteArrayEndPoint.class);
    private static final SocketAddress NO_SOCKET_ADDRESS = ByteArrayEndPoint.noSocketAddress();
    private static final ByteBuffer EOF = BufferUtil.allocate(0);
    private final Runnable _runFillable = () -> this.getFillInterest().fillable();
    private final AutoLock _lock = new AutoLock();
    private final Condition _hasOutput = this._lock.newCondition();
    private final Queue<ByteBuffer> _inQ = new ArrayDeque<ByteBuffer>();
    private final RetainableByteBuffer.DynamicCapacity _buffer;

    private static SocketAddress noSocketAddress() {
        try {
            return new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0);
        }
        catch (Throwable x) {
            throw ExceptionUtil.asRuntimeException(x);
        }
    }

    public ByteArrayEndPoint() {
        this(null, 0L, null, -1, false);
    }

    public ByteArrayEndPoint(byte[] input, int outputSize) {
        this(null, 0L, input != null ? BufferUtil.toBuffer(input) : null, outputSize, false);
    }

    public ByteArrayEndPoint(String input, int outputSize) {
        this(null, 0L, input != null ? BufferUtil.toBuffer(input) : null, outputSize, false);
    }

    public ByteArrayEndPoint(byte[] input, int outputSize, boolean growable) {
        this(null, 0L, input != null ? BufferUtil.toBuffer(input) : null, outputSize, growable);
    }

    public ByteArrayEndPoint(String input, int outputSize, boolean growable) {
        this(null, 0L, input != null ? BufferUtil.toBuffer(input) : null, outputSize, growable);
    }

    public ByteArrayEndPoint(Scheduler scheduler, long idleTimeoutMs) {
        this(scheduler, idleTimeoutMs, null, -1, false);
    }

    public ByteArrayEndPoint(Scheduler timer, long idleTimeoutMs, byte[] input, int outputSize) {
        this(timer, idleTimeoutMs, input != null ? BufferUtil.toBuffer(input) : null, outputSize, false);
    }

    public ByteArrayEndPoint(Scheduler timer, long idleTimeoutMs, String input, int outputSize) {
        this(timer, idleTimeoutMs, input != null ? BufferUtil.toBuffer(input) : null, outputSize, false);
    }

    public ByteArrayEndPoint(Scheduler timer, long idleTimeoutMs, ByteBuffer input, int outputSize, boolean growable) {
        super(timer);
        if (BufferUtil.hasContent(input)) {
            this.addInput(input);
        }
        this._buffer = growable ? new RetainableByteBuffer.DynamicCapacity(null, false, -1L, outputSize) : new RetainableByteBuffer.DynamicCapacity(null, false, (long)outputSize);
        this.setIdleTimeout(idleTimeoutMs);
        this.onOpen();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return NO_SOCKET_ADDRESS;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return NO_SOCKET_ADDRESS;
    }

    @Override
    public void doShutdownOutput() {
        super.doShutdownOutput();
        try (AutoLock l = this._lock.lock();){
            this._hasOutput.signalAll();
        }
    }

    @Override
    public void doClose() {
        super.doClose();
        try (AutoLock l = this._lock.lock();){
            this._hasOutput.signalAll();
        }
    }

    @Override
    protected void onIncompleteFlush() {
    }

    protected void execute(Runnable task) {
        new Thread(task, "BAEPoint-" + Integer.toHexString(this.hashCode())).start();
    }

    @Override
    protected void needsFillInterest() throws IOException {
        try (AutoLock ignored = this._lock.lock();){
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            ByteBuffer in = this._inQ.peek();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} needsFillInterest EOF={} {}", this, in == EOF, BufferUtil.toDetailString(in));
            }
            if (BufferUtil.hasContent(in) || ByteArrayEndPoint.isEOF(in)) {
                this.execute(this._runFillable);
            }
        }
    }

    public void addInputEOF() {
        this.addInput((ByteBuffer)null);
    }

    public void addInput(ByteBuffer in) {
        boolean fillable = false;
        try (AutoLock ignored = this._lock.lock();){
            if (ByteArrayEndPoint.isEOF(this._inQ.peek())) {
                throw new UncheckedIOException(new EOFException());
            }
            boolean wasEmpty = this._inQ.isEmpty();
            if (in == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} addEOFAndRun=true", (Object)this);
                }
                this._inQ.add(EOF);
                fillable = true;
            }
            if (BufferUtil.hasContent(in)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} addInputAndRun={} {}", this, wasEmpty, BufferUtil.toDetailString(in));
                }
                this._inQ.add(in);
                fillable = wasEmpty;
            }
        }
        if (fillable) {
            this._runFillable.run();
        }
    }

    public void addInput(String s2) {
        this.addInput(BufferUtil.toBuffer(s2, StandardCharsets.UTF_8));
    }

    public void addInput(String s2, Charset charset) {
        this.addInput(BufferUtil.toBuffer(s2, charset));
    }

    public void addInputAndExecute(String s2) {
        this.addInputAndExecute(BufferUtil.toBuffer(s2, StandardCharsets.UTF_8));
    }

    public void addInputAndExecute(ByteBuffer in) {
        boolean fillable = false;
        try (AutoLock ignored = this._lock.lock();){
            if (ByteArrayEndPoint.isEOF(this._inQ.peek())) {
                throw new UncheckedIOException(new EOFException());
            }
            boolean wasEmpty = this._inQ.isEmpty();
            if (in == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} addEOFAndExecute=true", (Object)this);
                }
                this._inQ.add(EOF);
                fillable = true;
            }
            if (BufferUtil.hasContent(in)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} addInputAndExecute={} {}", this, wasEmpty, BufferUtil.toDetailString(in));
                }
                this._inQ.add(in);
                fillable = wasEmpty;
            }
        }
        if (fillable) {
            this.execute(this._runFillable);
        }
    }

    public ByteBuffer getOutput() {
        try (AutoLock ignored = this._lock.lock();){
            ByteBuffer byteBuffer = this._buffer.getByteBuffer();
            return byteBuffer;
        }
    }

    public String getOutputString() {
        return this.getOutputString(StandardCharsets.UTF_8);
    }

    public String getOutputString(Charset charset) {
        return BufferUtil.toString(this.getOutput(), charset);
    }

    public ByteBuffer takeOutput() {
        ByteBuffer taken;
        try (AutoLock ignored = this._lock.lock();){
            taken = this._buffer.take().getByteBuffer();
        }
        this.getWriteFlusher().completeWrite();
        return taken;
    }

    public ByteBuffer waitForOutput(long time, TimeUnit unit) throws InterruptedException {
        ByteBuffer taken;
        try (AutoLock ignored = this._lock.lock();){
            while (this._buffer.isEmpty() && !this.isOutputShutdown()) {
                if (this._hasOutput.await(time, unit)) continue;
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            taken = this._buffer.take().getByteBuffer();
        }
        this.getWriteFlusher().completeWrite();
        return taken;
    }

    public String takeOutputString() {
        return this.takeOutputString(StandardCharsets.UTF_8);
    }

    public String takeOutputString(Charset charset) {
        ByteBuffer buffer = this.takeOutput();
        return BufferUtil.toString(buffer, charset);
    }

    @Deprecated
    public void setOutput(ByteBuffer out) {
        throw new UnsupportedOperationException();
    }

    public boolean hasMore() {
        return this.getOutput().position() > 0;
    }

    @Override
    public int fill(ByteBuffer buffer) throws IOException {
        int filled = 0;
        try (AutoLock ignored = this._lock.lock();){
            while (true) {
                if (!this.isOpen()) {
                    throw new EofException("CLOSED");
                }
                if (this.isInputShutdown()) {
                    int n = -1;
                    return n;
                }
                if (this._inQ.isEmpty()) {
                    break;
                }
                ByteBuffer in = this._inQ.peek();
                if (ByteArrayEndPoint.isEOF(in)) {
                    filled = -1;
                    break;
                }
                if (BufferUtil.hasContent(in)) {
                    filled = BufferUtil.append(buffer, in);
                    if (BufferUtil.isEmpty(in)) {
                        this._inQ.poll();
                    }
                    break;
                }
                this._inQ.poll();
            }
        }
        if (filled > 0) {
            this.notIdle();
        } else if (filled < 0) {
            this.shutdownInput();
        }
        return filled;
    }

    @Override
    public boolean flush(ByteBuffer ... buffers) throws IOException {
        boolean flushed = true;
        try (AutoLock ignored = this._lock.lock();){
            if (!this.isOpen()) {
                throw new IOException("CLOSED");
            }
            if (this.isOutputShutdown()) {
                throw new IOException("OSHUT");
            }
            boolean notIdle = false;
            for (ByteBuffer b : buffers) {
                int remaining = b.remaining();
                flushed = this._buffer.append(b);
                notIdle |= b.remaining() < remaining;
                if (!flushed) break;
            }
            if (notIdle) {
                this.notIdle();
                this._hasOutput.signalAll();
            }
            boolean bl = flushed;
            return bl;
        }
    }

    @Override
    public void reset() {
        try (AutoLock ignored = this._lock.lock();){
            this._inQ.clear();
            this._hasOutput.signalAll();
            this._buffer.clear();
        }
        super.reset();
    }

    @Override
    public Object getTransport() {
        return null;
    }

    public boolean isGrowOutput() {
        return this._buffer instanceof RetainableByteBuffer.DynamicCapacity;
    }

    @Deprecated
    public void setGrowOutput(boolean growOutput) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        String o;
        String b;
        int q;
        try (AutoLock lock = this._lock.tryLock();){
            boolean held = lock.isHeldByCurrentThread();
            q = held ? this._inQ.size() : -1;
            b = held ? this._inQ.peek() : "?";
            o = held ? this._buffer.toString() : "?";
        }
        return String.format("%s[q=%d,q[0]=%s,o=%s]", super.toString(), q, b, o);
    }

    private static boolean isEOF(ByteBuffer buffer) {
        boolean isEof = buffer == EOF;
        return isEof;
    }
}

