/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.MultiPartCompliance;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.content.ByteBufferContentSource;
import org.eclipse.jetty.io.content.ChunksContentSource;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ConstantThrowable;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.SearchPattern;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.SerializedInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPart {
    private static final Logger LOG = LoggerFactory.getLogger(MultiPart.class);
    private static final QuotedStringTokenizer CONTENT_DISPOSITION_TOKENIZER = QuotedStringTokenizer.builder().delimiters(";").ignoreOptionalWhiteSpace().allowEmbeddedQuotes().allowEscapeOnlyForQuotes().build();
    private static final int MAX_BOUNDARY_LENGTH = 70;
    private static final Pattern NON_ASCII_PATTERN = Pattern.compile("[^\\x20-\\x7E]");
    private static final Pattern WINDOWS_FILENAME = Pattern.compile(".??[a-zA-Z]:\\\\[^\\\\].*");

    private MultiPart() {
    }

    public static String encodeContentDispositionFileName(String fileName) {
        return MultiPart.encodeContentDispositionFileName(fileName, StandardCharsets.UTF_8);
    }

    static String encodeContentDispositionFileName(String fileName, Charset charset) {
        String encodedFileName = UrlEncoded.encodeString(fileName, charset);
        if (encodedFileName.equals(fileName)) {
            return "filename=\"" + fileName + "\"";
        }
        encodedFileName = encodedFileName.replace("+", "%20");
        String asciiFilename = NON_ASCII_PATTERN.matcher(fileName).replaceAll("_");
        return String.format("filename=\"%s\"; filename*=%s''%s", asciiFilename, charset.name(), encodedFileName);
    }

    static String decodeContentDispositionFileName(String encoded) throws IllegalArgumentException, IllegalCharsetNameException, UnsupportedCharsetException {
        int i = encoded.indexOf("''");
        if (i == -1) {
            throw new IllegalArgumentException("invalid encoding");
        }
        Charset charset = Charset.forName(encoded.substring(0, i));
        return UrlEncoded.decodeString(encoded, i + 2, encoded.length() - i - 2, charset);
    }

    public static String extractBoundary(String contentType) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        HttpField.getValueParameters(contentType, parameters);
        return CONTENT_DISPOSITION_TOKENIZER.unquote((String)parameters.get("boundary"));
    }

    public static String generateBoundary(String prefix, int randomLength) {
        if (prefix == null && randomLength < 1) {
            throw new IllegalArgumentException("invalid boundary length");
        }
        StringBuilder builder = new StringBuilder(prefix == null ? "" : prefix);
        int length = builder.length();
        while (builder.length() < length + randomLength) {
            long rnd = ThreadLocalRandom.current().nextLong();
            builder.append(Long.toString(rnd < 0L ? -rnd : rnd, 36));
        }
        builder.setLength(Math.min(length + randomLength, 70));
        return builder.toString();
    }

    public static abstract class AbstractPartsListener
    implements Parser.Listener {
        private static final Logger LOG = LoggerFactory.getLogger(AbstractPartsListener.class);
        private final HttpFields.Mutable fields = HttpFields.build();
        private String name;
        private String fileName;

        public String getName() {
            return this.name;
        }

        public String getFileName() {
            return this.fileName;
        }

        @Override
        public void onPartHeader(String headerName, String headerValue) {
            if (HttpHeader.CONTENT_DISPOSITION.is(headerName)) {
                String namePrefix = "name=";
                String fileNamePrefix = "filename=";
                String encodedFileNamePrefix = "filename*=";
                boolean encoded = false;
                Iterator<String> tokens = CONTENT_DISPOSITION_TOKENIZER.tokenize(headerValue);
                while (tokens.hasNext()) {
                    String token = tokens.next();
                    String lowerToken = StringUtil.asciiToLowerCase(token);
                    if (lowerToken.startsWith(namePrefix)) {
                        int index = lowerToken.indexOf(namePrefix);
                        String value = token.substring(index + namePrefix.length()).trim();
                        this.name = CONTENT_DISPOSITION_TOKENIZER.unquote(value);
                        continue;
                    }
                    if (lowerToken.startsWith(fileNamePrefix)) {
                        if (encoded) continue;
                        this.fileName = this.fileNameValue(token.substring(fileNamePrefix.length()).trim());
                        continue;
                    }
                    if (!lowerToken.startsWith(encodedFileNamePrefix)) continue;
                    try {
                        this.fileName = this.fileNameValue(MultiPart.decodeContentDispositionFileName(token.substring(encodedFileNamePrefix.length()).trim()));
                        encoded = true;
                    }
                    catch (Exception x) {
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace("ignored", x);
                    }
                }
            }
            this.fields.add(new HttpField(headerName, headerValue));
        }

        private String fileNameValue(String value) {
            if (WINDOWS_FILENAME.matcher(value).matches()) {
                char last;
                char first = value.charAt(0);
                if (first == '\"' || first == '\'') {
                    value = value.substring(1);
                }
                if ((last = value.charAt(value.length() - 1)) == '\"' || last == '\'') {
                    value = value.substring(0, value.length() - 1);
                }
                return value;
            }
            return CONTENT_DISPOSITION_TOKENIZER.unquote(value);
        }

        @Override
        public void onPartEnd() {
            String name = this.getName();
            this.name = null;
            String fileName = this.getFileName();
            this.fileName = null;
            HttpFields headers = this.fields.asImmutable();
            this.fields.clear();
            this.notifyPart(name, fileName, headers);
        }

        public abstract void onPart(String var1, String var2, HttpFields var3);

        private void notifyPart(String name, String fileName, HttpFields headers) {
            block2: {
                try {
                    this.onPart(name, fileName, headers);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.atDebug().setCause(x).log("failure while notifying part {}", (Object)name);
                }
            }
        }
    }

    public static class Parser {
        private static final Logger LOG = LoggerFactory.getLogger(Parser.class);
        private static final ByteBuffer CR = StandardCharsets.US_ASCII.encode("\r");
        private final Utf8StringBuilder text = new Utf8StringBuilder();
        private final String boundary;
        private final SearchPattern boundaryFinder;
        private final MultiPartCompliance compliance;
        private final Listener listener;
        private int partHeadersLength;
        private int partHeadersMaxLength = -1;
        private State state;
        private int partialBoundaryMatch;
        private boolean crFlag;
        private boolean crContent;
        private int trailingWhiteSpaces;
        private String fieldName;
        private String fieldValue;
        private long maxParts = 1000L;
        private int numParts;
        private EnumSet<MultiPartCompliance.Violation> eols;

        public Parser(String boundary, Listener listener) {
            this(boundary, MultiPartCompliance.RFC7578, listener);
        }

        public Parser(String boundary, MultiPartCompliance compliance, Listener listener) {
            this.boundary = boundary;
            this.boundaryFinder = SearchPattern.compile("\n--" + boundary);
            this.compliance = compliance;
            this.listener = listener;
            if (LOG.isDebugEnabled()) {
                List.of(MultiPartCompliance.Violation.CR_LINE_TERMINATION, MultiPartCompliance.Violation.BASE64_TRANSFER_ENCODING, MultiPartCompliance.Violation.WHITESPACE_BEFORE_BOUNDARY).forEach(violation -> {
                    if (compliance.allows((ComplianceViolation)violation)) {
                        LOG.debug("{} ignoring violation {}: unable to allow it", (Object)this.getClass().getName(), (Object)violation.name());
                    }
                });
            }
            this.reset();
        }

        public String getBoundary() {
            return this.boundary;
        }

        public int getPartHeadersMaxLength() {
            return this.partHeadersMaxLength;
        }

        public void setPartHeadersMaxLength(int partHeadersMaxLength) {
            this.partHeadersMaxLength = partHeadersMaxLength;
        }

        public long getMaxParts() {
            return this.maxParts;
        }

        public void setMaxParts(long maxParts) {
            this.maxParts = maxParts;
        }

        public void reset() {
            this.text.reset();
            this.partHeadersLength = 0;
            this.state = State.PREAMBLE;
            this.partialBoundaryMatch = 1;
            this.crFlag = false;
            this.crContent = false;
            this.trailingWhiteSpaces = 0;
            this.fieldName = null;
            this.fieldValue = null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void parse(Content.Chunk chunk) {
            ByteBuffer buffer = chunk.getByteBuffer();
            boolean last = chunk.isLast();
            try {
                block13: while (true) {
                    if (!buffer.hasRemaining()) {
                        if (!last) return;
                        if (this.state != State.EPILOGUE) throw new EOFException("unexpected EOF in " + String.valueOf((Object)this.state));
                        this.notifyComplete();
                        return;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("parse {} {}", (Object)this.state, (Object)BufferUtil.toDetailString(buffer));
                    }
                    switch (this.state.ordinal()) {
                        case 0: {
                            if (!this.parsePreamble(buffer)) continue block13;
                            this.state = State.BOUNDARY;
                            break;
                        }
                        case 1: {
                            HttpTokens.Token token = this.next(buffer);
                            HttpTokens.Type type = token.getType();
                            if (type == HttpTokens.Type.CR) continue block13;
                            if (type == HttpTokens.Type.LF) {
                                ++this.numParts;
                                if (this.maxParts >= 0L && (long)this.numParts > this.maxParts) {
                                    throw new IllegalStateException(String.format("Form with too many keys [%d > %d]", this.numParts, this.maxParts));
                                }
                                this.notifyPartBegin();
                                this.state = State.HEADER_START;
                                this.trailingWhiteSpaces = 0;
                                this.text.reset();
                                this.partHeadersLength = 0;
                                break;
                            }
                            if (token.getByte() == 45) {
                                this.state = State.BOUNDARY_CLOSE;
                                break;
                            }
                            if (type == HttpTokens.Type.SPACE || type == HttpTokens.Type.HTAB) continue block13;
                            throw new BadMessageException("bad last boundary");
                        }
                        case 2: {
                            HttpTokens.Token token = this.next(buffer);
                            if (token.getByte() != 45) {
                                throw new BadMessageException("bad last boundary");
                            }
                            this.notifyEndOfLineViolations();
                            this.state = State.EPILOGUE;
                            break;
                        }
                        case 3: {
                            this.state = this.parseHeaderStart(buffer);
                            break;
                        }
                        case 4: {
                            if (!this.parseHeaderName(buffer)) continue block13;
                            this.state = State.HEADER_VALUE;
                            break;
                        }
                        case 5: {
                            if (!this.parseHeaderValue(buffer)) continue block13;
                            this.state = State.HEADER_START;
                            break;
                        }
                        case 6: {
                            if (this.parseContent(chunk)) {
                                this.state = State.BOUNDARY;
                                break;
                            }
                            this.state = State.CONTENT;
                            break;
                        }
                        case 7: {
                            if (!this.parseContent(chunk)) continue block13;
                            this.state = State.BOUNDARY;
                            break;
                        }
                        case 8: {
                            buffer.position(buffer.limit());
                            continue block13;
                        }
                    }
                }
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.atDebug().setCause(x).log("parse failure {} {}", (Object)this.state, (Object)BufferUtil.toDetailString(buffer));
                }
                buffer.position(buffer.limit());
                this.notifyEndOfLineViolations();
                this.notifyFailure(x);
            }
        }

        private HttpTokens.Token next(ByteBuffer buffer) {
            byte b = buffer.get();
            HttpTokens.Token t2 = HttpTokens.TOKENS[b & 0xFF];
            switch (t2.getType()) {
                case CNTL: {
                    throw new BadMessageException("invalid byte " + Integer.toHexString(t2.getChar()));
                }
                case LF: {
                    if (!this.crFlag) {
                        MultiPartCompliance.Violation violation = MultiPartCompliance.Violation.LF_LINE_TERMINATION;
                        this.addEndOfLineViolation(violation);
                        if (!this.compliance.allows(violation)) {
                            throw new BadMessageException("invalid LF-only EOL");
                        }
                    }
                    this.crFlag = false;
                    break;
                }
                case CR: {
                    if (this.crFlag) {
                        MultiPartCompliance.Violation violation = MultiPartCompliance.Violation.CR_LINE_TERMINATION;
                        this.addEndOfLineViolation(violation);
                        if (!this.compliance.allows(violation)) {
                            throw new BadMessageException("invalid CR-only EOL");
                        }
                    }
                    this.crFlag = true;
                    break;
                }
                default: {
                    if (!this.crFlag) break;
                    MultiPartCompliance.Violation violation = MultiPartCompliance.Violation.CR_LINE_TERMINATION;
                    this.addEndOfLineViolation(violation);
                    if (this.compliance.allows(violation)) break;
                    throw new BadMessageException("invalid CR-only EOL");
                }
            }
            return t2;
        }

        private boolean parsePreamble(ByteBuffer buffer) {
            int boundaryOffset;
            if (this.partialBoundaryMatch > 0) {
                int boundaryMatch = this.boundaryFinder.startsWith(buffer, this.partialBoundaryMatch);
                if (boundaryMatch > 0) {
                    if (boundaryMatch == this.boundaryFinder.getLength()) {
                        buffer.position(buffer.position() + boundaryMatch - this.partialBoundaryMatch);
                        this.partialBoundaryMatch = 0;
                        return true;
                    }
                    buffer.position(buffer.limit());
                    this.partialBoundaryMatch = boundaryMatch;
                    return false;
                }
                this.partialBoundaryMatch = 0;
            }
            if ((boundaryOffset = this.boundaryFinder.match(buffer)) >= 0) {
                buffer.position(buffer.position() + boundaryOffset + this.boundaryFinder.getLength());
                return true;
            }
            this.partialBoundaryMatch = this.boundaryFinder.endsWith(buffer);
            buffer.position(buffer.limit());
            return false;
        }

        private State parseHeaderStart(ByteBuffer buffer) {
            block5: while (buffer.hasRemaining()) {
                HttpTokens.Token token = this.next(buffer);
                switch (token.getType()) {
                    case CR: {
                        continue block5;
                    }
                    case LF: {
                        this.notifyPartHeaders();
                        this.partialBoundaryMatch = 1;
                        return State.CONTENT_START;
                    }
                    case COLON: {
                        throw new BadMessageException("invalid empty header name");
                    }
                }
                if (Character.isWhitespace(token.getByte())) {
                    if (this.text.length() != 0) continue;
                    throw new BadMessageException("invalid leading whitespace before header");
                }
                this.incrementAndCheckPartHeadersLength();
                this.text.append(token.getByte());
                return State.HEADER_NAME;
            }
            return State.HEADER_START;
        }

        private boolean parseHeaderName(ByteBuffer buffer) {
            block4: while (buffer.hasRemaining()) {
                byte current;
                HttpTokens.Token token = this.next(buffer);
                switch (token.getType()) {
                    case COLON: {
                        this.incrementAndCheckPartHeadersLength();
                        this.fieldName = this.text.takeCompleteString(null);
                        this.trailingWhiteSpaces = 0;
                        return true;
                    }
                    case ALPHA: 
                    case DIGIT: 
                    case TCHAR: {
                        current = token.getByte();
                        if (this.trailingWhiteSpaces > 0) {
                            throw new BadMessageException("invalid header name");
                        }
                        this.incrementAndCheckPartHeadersLength();
                        this.text.append(current);
                        continue block4;
                    }
                }
                current = token.getByte();
                if (Character.isWhitespace(current)) {
                    this.incrementAndCheckPartHeadersLength();
                    ++this.trailingWhiteSpaces;
                    continue;
                }
                throw new BadMessageException("invalid header name");
            }
            return false;
        }

        private boolean parseHeaderValue(ByteBuffer buffer) {
            block4: while (buffer.hasRemaining()) {
                HttpTokens.Token token = this.next(buffer);
                switch (token.getType()) {
                    case CR: {
                        continue block4;
                    }
                    case LF: {
                        this.fieldValue = this.text.toCompleteString().stripTrailing();
                        this.text.reset();
                        this.notifyPartHeader(this.fieldName, this.fieldValue);
                        this.fieldName = null;
                        this.fieldValue = null;
                        return true;
                    }
                }
                byte current = token.getByte();
                this.incrementAndCheckPartHeadersLength();
                if (Character.isWhitespace(current)) {
                    if (this.text.length() <= 0) continue;
                    this.text.append(" ");
                    continue;
                }
                this.text.append(current);
            }
            return false;
        }

        private void incrementAndCheckPartHeadersLength() {
            ++this.partHeadersLength;
            int max = this.getPartHeadersMaxLength();
            if (max > 0 && this.partHeadersLength > max) {
                throw new IllegalStateException("headers max length exceeded: %d".formatted(max));
            }
        }

        private boolean parseContent(Content.Chunk chunk) {
            ByteBuffer buffer = chunk.getByteBuffer();
            if (this.partialBoundaryMatch > 0) {
                int boundaryMatch = this.boundaryFinder.startsWith(buffer, this.partialBoundaryMatch);
                if (boundaryMatch > 0) {
                    if (boundaryMatch == this.boundaryFinder.getLength()) {
                        buffer.position(buffer.position() + boundaryMatch - this.partialBoundaryMatch);
                        if (!this.crContent) {
                            MultiPartCompliance.Violation violation = MultiPartCompliance.Violation.LF_LINE_TERMINATION;
                            this.addEndOfLineViolation(violation);
                            if (!this.compliance.allows(violation)) {
                                throw new BadMessageException("invalid LF-only EOL");
                            }
                        }
                        this.partialBoundaryMatch = 0;
                        this.crContent = false;
                        this.notifyPartContent(Content.Chunk.EOF);
                        this.notifyPartEnd();
                        return true;
                    }
                    buffer.position(buffer.limit());
                    this.partialBoundaryMatch = boundaryMatch;
                    return false;
                }
                if (this.state == State.CONTENT_START) {
                    this.partialBoundaryMatch = 0;
                    return false;
                }
                this.notifyCRContent();
                ByteBuffer content = ByteBuffer.wrap(this.boundaryFinder.getPattern(), 0, this.partialBoundaryMatch);
                this.partialBoundaryMatch = 0;
                Content.Chunk partContentChunk = Content.Chunk.from(content, false);
                this.notifyPartContent(partContentChunk);
                partContentChunk.release();
                return false;
            }
            int boundaryOffset = this.boundaryFinder.match(buffer);
            if (boundaryOffset >= 0) {
                if (boundaryOffset == 0) {
                    if (!this.crContent) {
                        MultiPartCompliance.Violation violation = MultiPartCompliance.Violation.LF_LINE_TERMINATION;
                        this.addEndOfLineViolation(violation);
                        if (!this.compliance.allows(violation)) {
                            throw new BadMessageException("invalid LF-only EOL");
                        }
                    }
                    this.crContent = false;
                }
                this.notifyCRContent();
                int position = buffer.position();
                int length = boundaryOffset;
                if (length > 0 && buffer.get(position + length - 1) == 13) {
                    --length;
                } else {
                    MultiPartCompliance.Violation violation = MultiPartCompliance.Violation.LF_LINE_TERMINATION;
                    this.addEndOfLineViolation(violation);
                    if (!this.compliance.allows(violation)) {
                        throw new BadMessageException("invalid LF-only EOL");
                    }
                }
                Content.Chunk content = this.asSlice(chunk, position, length, true);
                buffer.position(position + boundaryOffset + this.boundaryFinder.getLength());
                this.notifyPartContent(content);
                this.notifyPartEnd();
                return true;
            }
            this.partialBoundaryMatch = this.boundaryFinder.endsWith(buffer);
            if (this.partialBoundaryMatch > 0 && this.partialBoundaryMatch == buffer.remaining()) {
                buffer.position(buffer.limit());
                return false;
            }
            this.notifyCRContent();
            int limit = buffer.limit();
            int sliceLimit = limit - this.partialBoundaryMatch;
            if (buffer.get(sliceLimit - 1) == 13) {
                this.crContent = true;
                --sliceLimit;
            }
            int position = buffer.position();
            Content.Chunk content = this.asSlice(chunk, position, sliceLimit - position, false);
            buffer.position(limit);
            if (content.hasRemaining()) {
                this.notifyPartContent(content);
            }
            return false;
        }

        private void notifyCRContent() {
            if (!this.crContent) {
                return;
            }
            this.crContent = false;
            Content.Chunk partContentChunk = Content.Chunk.from(CR.slice(), false);
            this.notifyPartContent(partContentChunk);
            partContentChunk.release();
        }

        private Content.Chunk asSlice(Content.Chunk chunk, int position, int length, boolean last) {
            if (chunk.isLast() && !chunk.hasRemaining()) {
                return chunk;
            }
            if (length == 0) {
                return last ? Content.Chunk.EOF : Content.Chunk.EMPTY;
            }
            return Content.Chunk.asChunk(chunk.getByteBuffer().slice(position, length), last, chunk);
        }

        private void notifyPartBegin() {
            block2: {
                try {
                    this.listener.onPartBegin();
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
                }
            }
        }

        private void notifyPartHeader(String name, String value) {
            block2: {
                try {
                    this.listener.onPartHeader(name, value);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
                }
            }
        }

        private void notifyPartHeaders() {
            block2: {
                try {
                    this.listener.onPartHeaders();
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
                }
            }
        }

        private void notifyPartContent(Content.Chunk chunk) {
            block2: {
                try {
                    this.listener.onPartContent(chunk);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
                }
            }
        }

        private void notifyPartEnd() {
            block2: {
                try {
                    this.listener.onPartEnd();
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
                }
            }
        }

        private void notifyComplete() {
            block2: {
                try {
                    this.listener.onComplete();
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
                }
            }
        }

        private void notifyFailure(Throwable failure) {
            block2: {
                try {
                    this.listener.onFailure(failure);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
                }
            }
        }

        private void notifyEndOfLineViolations() {
            if (this.eols != null) {
                for (MultiPartCompliance.Violation violation : this.eols) {
                    this.notifyViolation(violation);
                }
                this.eols = null;
            }
        }

        private void addEndOfLineViolation(MultiPartCompliance.Violation violation) {
            if (this.eols == null) {
                this.eols = EnumSet.of(violation);
            } else {
                this.eols.add(violation);
            }
        }

        private void notifyViolation(MultiPartCompliance.Violation violation) {
            block2: {
                try {
                    this.listener.onViolation(violation);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.atDebug().setCause(x).log("failure while notifying listener {}", (Object)this.listener);
                }
            }
        }

        public static interface Listener {
            default public void onPartBegin() {
            }

            default public void onPartHeader(String name, String value) {
            }

            default public void onPartHeaders() {
            }

            default public void onPartContent(Content.Chunk chunk) {
            }

            default public void onPartEnd() {
            }

            default public void onComplete() {
            }

            default public void onFailure(Throwable failure) {
            }

            default public void onViolation(MultiPartCompliance.Violation violation) {
            }
        }

        private static enum State {
            PREAMBLE,
            BOUNDARY,
            BOUNDARY_CLOSE,
            HEADER_START,
            HEADER_NAME,
            HEADER_VALUE,
            CONTENT_START,
            CONTENT,
            EPILOGUE;

        }
    }

    public static abstract class AbstractContentSource
    implements Content.Source,
    Closeable {
        private final AutoLock lock = new AutoLock();
        private final SerializedInvoker invoker = new SerializedInvoker(AbstractContentSource.class);
        private final Queue<Part> parts = new ArrayDeque<Part>();
        private final String boundary;
        private final ByteBuffer firstBoundary;
        private final ByteBuffer middleBoundary;
        private final ByteBuffer onlyBoundary;
        private final ByteBuffer lastBoundary;
        private int partHeadersMaxLength = -1;
        private State state = State.FIRST;
        private boolean closed;
        private Runnable demand;
        private Content.Chunk errorChunk;
        private Part part;

        public AbstractContentSource(String boundary) {
            if (boundary.isBlank() || boundary.length() > 70) {
                throw new IllegalArgumentException("Invalid boundary: must consists of 1 to 70 characters");
            }
            this.boundary = boundary = boundary.stripTrailing();
            String firstBoundaryLine = "--" + boundary + "\r\n";
            this.firstBoundary = ByteBuffer.wrap(firstBoundaryLine.getBytes(StandardCharsets.US_ASCII));
            String middleBoundaryLine = "\r\n" + firstBoundaryLine;
            this.middleBoundary = ByteBuffer.wrap(middleBoundaryLine.getBytes(StandardCharsets.US_ASCII));
            String onlyBoundaryLine = "--" + boundary + "--\r\n";
            this.onlyBoundary = ByteBuffer.wrap(onlyBoundaryLine.getBytes(StandardCharsets.US_ASCII));
            String lastBoundaryLine = "\r\n" + onlyBoundaryLine;
            this.lastBoundary = ByteBuffer.wrap(lastBoundaryLine.getBytes(StandardCharsets.US_ASCII));
        }

        public String getBoundary() {
            return this.boundary;
        }

        public int getPartHeadersMaxLength() {
            return this.partHeadersMaxLength;
        }

        public void setPartHeadersMaxLength(int partHeadersMaxLength) {
            this.partHeadersMaxLength = partHeadersMaxLength;
        }

        public boolean addPart(Part part) {
            boolean wasEmpty;
            try (AutoLock ignored = this.lock.lock();){
                if (this.closed || this.errorChunk != null) {
                    boolean bl = false;
                    return bl;
                }
                wasEmpty = this.parts.isEmpty();
                this.parts.offer(part);
            }
            if (wasEmpty) {
                this.invoker.run(this::invokeDemandCallback);
            }
            return true;
        }

        @Override
        public void close() {
            boolean wasEmpty;
            try (AutoLock ignored = this.lock.lock();){
                this.closed = true;
                wasEmpty = this.parts.isEmpty();
            }
            if (wasEmpty) {
                this.invoker.run(this::invokeDemandCallback);
            }
        }

        @Override
        public long getLength() {
            return -1L;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Content.Chunk read() {
            ignored = this.lock.lock();
            try {
                error = this.errorChunk;
                if (error != null) {
                    this.errorChunk = Content.Chunk.next(error);
                    var3_4 = error;
                    return var3_4;
                }
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            switch (this.state.ordinal()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case 0: {
                    ignored = this.lock.lock();
                    if (this.parts.isEmpty()) {
                        if (this.closed) {
                            this.state = State.COMPLETE;
                            var1_1 = Content.Chunk.from(this.onlyBoundary.slice(), true);
                            v0 = var1_1;
                            break;
                        }
                        var1_1 = null;
                        v0 = var1_1;
                        break;
                    }
                    this.part = this.parts.poll();
                    this.state = State.HEADERS;
                    var1_1 = Content.Chunk.from(this.firstBoundary.slice(), false);
                    v0 = var1_1;
                    break;
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                }
                case 1: {
                    this.part = null;
                    ignored = this.lock.lock();
                    if (this.parts.isEmpty()) {
                        if (this.closed) {
                            this.state = State.COMPLETE;
                            var1_1 = Content.Chunk.from(this.lastBoundary.slice(), true);
                            v0 = var1_1;
                            break;
                        }
                        var1_1 = null;
                        v0 = var1_1;
                        break;
                    }
                    this.part = this.parts.poll();
                    this.state = State.HEADERS;
                    var1_1 = Content.Chunk.from(this.middleBoundary.slice(), false);
                    v0 = var1_1;
                    break;
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                }
                case 2: {
                    headers = this.customizePartHeaders(this.part);
                    builder = new Utf8StringBuilder(4096);
                    headers.forEach((Consumer<HttpField>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$read$0(org.eclipse.jetty.util.Utf8StringBuilder org.eclipse.jetty.http.HttpField ), (Lorg/eclipse/jetty/http/HttpField;)V)((AbstractContentSource)this, (Utf8StringBuilder)builder));
                    builder.append("\r\n");
                    byteBuffer = ByteBuffer.wrap(builder.toCompleteString().getBytes(StandardCharsets.UTF_8));
                    this.state = State.CONTENT;
                    v0 = var1_1 = Content.Chunk.from(byteBuffer, false);
                    break;
                }
                case 3: {
                    chunk = this.part.getContentSource().read();
                    if (chunk == null) {
                        v0 = var1_1 = null;
                        break;
                    }
                    if (!Content.Chunk.isFailure(chunk, true)) ** GOTO lbl85
                    ignored = this.lock.lock();
                    try {
                        this.errorChunk = chunk;
                    }
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                    v0 = var1_1 = chunk;
                    break;
lbl85:
                    // 1 sources

                    if (!chunk.isLast()) {
                        v0 = var1_1 = chunk;
                        break;
                    }
                    this.state = State.MIDDLE;
                    if (chunk.hasRemaining()) {
                        v0 = var1_1 = Content.Chunk.asChunk(chunk.getByteBuffer(), false, chunk);
                        break;
                    }
                    chunk.release();
                    v0 = var1_1 = Content.Chunk.EMPTY;
                    break;
                }
                case 4: {
                    v0 = var1_1 = Content.Chunk.EOF;
                }
            }
            return v0;
        }

        protected HttpFields customizePartHeaders(Part part) {
            return part.getHeaders();
        }

        private void checkPartHeadersLength(Utf8StringBuilder builder) {
            int max = this.getPartHeadersMaxLength();
            if (max > 0 && builder.length() > max) {
                throw new IllegalStateException("headers max length exceeded: %d".formatted(max));
            }
        }

        @Override
        public void demand(Runnable demandCallback) {
            Part part = null;
            boolean invoke = false;
            try (AutoLock ignored = this.lock.lock();){
                if (this.demand != null) {
                    throw new IllegalStateException("demand pending");
                }
                this.demand = Objects.requireNonNull(demandCallback);
                if (this.state == State.CONTENT) {
                    part = this.part;
                } else {
                    invoke = !this.parts.isEmpty() || this.closed || this.errorChunk != null;
                }
            }
            if (part != null) {
                part.getContentSource().demand(new DemandTask(demandCallback));
            } else if (invoke) {
                this.invoker.run(this::invokeDemandCallback);
            }
        }

        @Override
        public void fail(Throwable failure) {
            Part part;
            List<Part> drained;
            try (AutoLock ignored = this.lock.lock();){
                if (this.errorChunk != null) {
                    return;
                }
                this.errorChunk = Content.Chunk.from(failure);
                drained = List.copyOf(this.parts);
                this.parts.clear();
                part = this.part;
                this.part = null;
            }
            if (part != null) {
                part.fail(failure);
            }
            drained.forEach(p -> p.fail(failure));
            this.invoker.run(this::invokeDemandCallback);
        }

        private void invokeDemandCallback() {
            Runnable callback;
            try (AutoLock ignored = this.lock.lock();){
                callback = this.demand;
                this.demand = null;
            }
            if (callback != null) {
                this.runDemandCallback(callback);
            }
        }

        private void runDemandCallback(Runnable callback) {
            try {
                callback.run();
            }
            catch (Throwable x) {
                this.fail(x);
            }
        }

        private /* synthetic */ void lambda$read$0(Utf8StringBuilder builder, HttpField field) {
            HttpHeader header = field.getHeader();
            if (header != null) {
                builder.append(header.getBytesColonSpace());
            } else {
                builder.append(field.getName());
                builder.append(": ");
            }
            this.checkPartHeadersLength(builder);
            String value = field.getValue();
            if (value != null) {
                builder.append(value);
                this.checkPartHeadersLength(builder);
            }
            builder.append("\r\n");
        }

        private static enum State {
            FIRST,
            MIDDLE,
            HEADERS,
            CONTENT,
            COMPLETE;

        }

        private class DemandTask
        extends Invocable.Task.Abstract {
            private final Runnable demandCallback;

            private DemandTask(Runnable demandCallback) {
                super(Invocable.getInvocationType(demandCallback));
                this.demandCallback = demandCallback;
            }

            @Override
            public void run() {
                try (AutoLock ignoredAgain = AbstractContentSource.this.lock.lock();){
                    AbstractContentSource.this.demand = null;
                }
                this.demandCallback.run();
            }
        }
    }

    public static class ContentSourcePart
    extends Part {
        private Content.Source content;

        public ContentSourcePart(String name, String fileName, HttpFields fields, Content.Source content) {
            super(null, name, fileName, fields);
            this.content = Objects.requireNonNull(content);
        }

        @Override
        public long getLength() {
            return this.content.getLength();
        }

        @Override
        public Content.Source newContentSource(ByteBufferPool.Sized bufferPool, long offset, long length) {
            length = TypeUtil.checkOffsetLengthSize(offset, length, this.content.getLength());
            Content.Source c = this.content;
            this.content = null;
            return Content.Source.from(c, offset, length);
        }

        public String toString() {
            return "%s@%x[name=%s,fileName=%s,length=%d]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getName(), this.getFileName(), this.getLength());
        }
    }

    public static class PathPart
    extends Part {
        @Deprecated(since="12.0.20", forRemoval=true)
        public PathPart(String name, String fileName, HttpFields fields, Path path) {
            super(null, 0L, -1L, name, fileName, fields, path);
        }

        public PathPart(ByteBufferPool.Sized bufferPool, String name, String fileName, HttpFields fields, Path path) {
            super(bufferPool, 0L, -1L, name, fileName, fields, path);
        }

        public PathPart(ByteBufferPool.Sized bufferPool, long offset, long length, String name, String fileName, HttpFields fields, Path path) {
            super(bufferPool, offset, length, name, fileName, fields, path);
        }

        public Path getPath() {
            return super.getPath();
        }

        @Override
        public Content.Source newContentSource(ByteBufferPool.Sized bufferPool, long offset, long length) {
            return Content.Source.from(bufferPool, this.getPath(), offset, length);
        }

        public String toString() {
            return "%s@%x[name=%s,fileName=%s,path=%s]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getName(), this.getFileName(), this.getPath());
        }
    }

    public static class ChunksPart
    extends Part {
        private final AutoLock lock = new AutoLock();
        private final List<Content.Chunk> content = new ArrayList<Content.Chunk>();
        private final List<Content.Source> contentSources = new ArrayList<Content.Source>();
        private boolean closed = false;

        public ChunksPart(String name, String fileName, HttpFields fields, List<Content.Chunk> content) {
            super(null, name, fileName, fields);
            this.content.addAll(content);
            content.forEach(Retainable::retain);
        }

        @Override
        public long getLength() {
            long length = 0L;
            for (Content.Chunk c : this.content) {
                length += c.size();
            }
            return length;
        }

        @Override
        public Content.Source newContentSource(ByteBufferPool.Sized bufferPool, long offset, long length) {
            long size = this.getLength();
            length = TypeUtil.checkOffsetLengthSize(offset, length, size);
            try (AutoLock ignored = this.lock.lock();){
                if (this.closed) {
                    Content.Source source = null;
                    return source;
                }
                List<Content.Chunk> chunks = this.content.stream().map(chunk -> {
                    if (Content.Chunk.isFailure(chunk)) {
                        return chunk;
                    }
                    return Content.Chunk.from(chunk.getByteBuffer().slice(), chunk.isLast());
                }).toList();
                ChunksContentSource newContentSource = new ChunksContentSource(chunks);
                chunks.forEach(Retainable::release);
                this.contentSources.add(newContentSource);
                Content.Source source = Content.Source.from(newContentSource, offset, length);
                return source;
            }
        }

        @Override
        public void fail(Throwable t2) {
            List<Content.Source> contentSourcesToFail;
            try (AutoLock ignored = this.lock.lock();){
                this.closed = true;
                this.content.forEach(Retainable::release);
                this.content.clear();
                contentSourcesToFail = List.copyOf(this.contentSources);
                this.contentSources.clear();
            }
            contentSourcesToFail.forEach(c -> c.fail(t2));
            super.fail(t2);
        }

        public String toString() {
            return "%s@%x[name=%s,fileName=%s,length=%d]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getName(), this.getFileName(), this.getLength());
        }
    }

    public static class ByteBufferPart
    extends Part {
        private final List<ByteBuffer> content;

        public ByteBufferPart(String name, String fileName, HttpFields fields, ByteBuffer ... buffers) {
            this(name, fileName, fields, List.of(buffers));
        }

        public ByteBufferPart(String name, String fileName, HttpFields fields, List<ByteBuffer> content) {
            super(null, name, fileName, fields);
            this.content = content;
        }

        @Override
        public long getLength() {
            long length = 0L;
            for (ByteBuffer b : this.content) {
                length += (long)BufferUtil.length(b);
            }
            return length;
        }

        @Override
        public Content.Source newContentSource(ByteBufferPool.Sized bufferPool, long offset, long length) {
            return new ByteBufferContentSource(this.content, offset, length);
        }

        public String toString() {
            return "%s@%x[name=%s,fileName=%s,length=%d]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getName(), this.getFileName(), this.getLength());
        }
    }

    public static abstract class Part
    implements Content.Source.Factory,
    Closeable {
        static final Throwable CLOSE_EXCEPTION = new ConstantThrowable("Closed");
        private final AutoLock lock = new AutoLock();
        private final ByteBufferPool.Sized bufferPool;
        private final long first;
        private final long length;
        private final String name;
        private final String fileName;
        private final HttpFields fields;
        private Path path;
        private Content.Source contentSource;
        private boolean temporary;

        @Deprecated(since="12.0.20", forRemoval=true)
        public Part(String name, String fileName, HttpFields fields) {
            this(null, 0L, -1L, name, fileName, fields, null);
        }

        public Part(ByteBufferPool.Sized bufferPool, String name, String fileName, HttpFields fields) {
            this(bufferPool, 0L, -1L, name, fileName, fields, null);
        }

        public Part(ByteBufferPool.Sized bufferPool, long first, long length, String name, String fileName, HttpFields fields) {
            this(bufferPool, first, length, name, fileName, fields, null);
        }

        private Part(ByteBufferPool.Sized bufferPool, long first, long length, String name, String fileName, HttpFields fields, Path path) {
            this.bufferPool = bufferPool;
            this.first = first;
            this.length = length;
            this.name = name;
            this.fileName = fileName;
            this.fields = fields != null ? fields : HttpFields.EMPTY;
            this.path = path;
            this.temporary = true;
        }

        private Path getPath() {
            try (AutoLock ignored = this.lock.lock();){
                Path path = this.path;
                return path;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getFileName() {
            return this.fileName;
        }

        public ByteBufferPool.Sized getBufferPool() {
            return this.bufferPool;
        }

        public Content.Source getContentSource() {
            try (AutoLock ignored = this.lock.lock();){
                if (this.contentSource == null) {
                    this.contentSource = this.createContentSource();
                }
                Content.Source source = this.contentSource;
                return source;
            }
        }

        @Deprecated(since="12.0.20", forRemoval=true)
        public Content.Source newContentSource() {
            return null;
        }

        public final Content.Source createContentSource() {
            return this.newContentSource(this.bufferPool, this.first, this.length);
        }

        @Override
        public Content.Source newContentSource(ByteBufferPool.Sized bufferPool, long offset, long length) {
            return Content.Source.from(this.newContentSource(), offset, length);
        }

        public long getLength() {
            Content.Source source = this.getContentSource();
            if (source != null) {
                return source.getLength();
            }
            return -1L;
        }

        public String getContentAsString(Charset defaultCharset) {
            try {
                Charset charset;
                String contentType = this.getHeaders().get(HttpHeader.CONTENT_TYPE);
                String charsetName = MimeTypes.getCharsetFromContentType(contentType);
                Charset charset2 = charset = defaultCharset != null ? defaultCharset : StandardCharsets.UTF_8;
                if (charsetName != null) {
                    charset = Charset.forName(charsetName);
                }
                return Content.Source.asString(this.createContentSource(), charset);
            }
            catch (IOException x) {
                throw new UncheckedIOException(x);
            }
        }

        public HttpFields getHeaders() {
            return this.fields;
        }

        public void writeTo(Path path) throws IOException {
            Path newPath;
            Path currentPath = this.getPath();
            if (currentPath == null) {
                try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                    IO.copy(Content.Source.asInputStream(this.createContentSource()), out);
                }
                newPath = path;
            } else {
                newPath = Files.move(currentPath, path, StandardCopyOption.REPLACE_EXISTING);
            }
            try (AutoLock ignored = this.lock.lock();){
                this.temporary = false;
                this.path = newPath;
            }
        }

        public void delete() throws IOException {
            Path path = this.getPath();
            if (path != null) {
                Files.deleteIfExists(path);
                try (AutoLock ignored = this.lock.lock();){
                    this.path = null;
                }
            }
        }

        @Override
        public void close() {
            this.fail(CLOSE_EXCEPTION);
        }

        public void fail(Throwable t2) {
            block12: {
                try {
                    Content.Source source;
                    Path path = null;
                    try (AutoLock ignored = this.lock.lock();){
                        source = this.contentSource;
                        if (this.temporary) {
                            path = this.path;
                            this.path = null;
                        }
                    }
                    if (source != null) {
                        source.fail(t2);
                    }
                    if (path != null) {
                        Files.deleteIfExists(path);
                    }
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block12;
                    LOG.atDebug().setCause(x).log("Error closing part {}", (Object)this);
                }
            }
        }
    }
}

