/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.Index;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpParser {
    private static final Logger LOG = LoggerFactory.getLogger(HttpParser.class);
    public static final int INITIAL_URI_LENGTH = 256;
    private static final int MAX_CHUNK_LENGTH = 0x7FFFFEF;
    private static final String UNMATCHED_VALUE = "\u0000";
    public static final Index<HttpField> CACHE = new Index.Builder().caseSensitive(false).with(HttpFields.CONNECTION_CLOSE).with(HttpFields.CONNECTION_KEEPALIVE).with(new HttpField(HttpHeader.CONNECTION, HttpHeaderValue.UPGRADE)).with(new HttpField(HttpHeader.ACCEPT_ENCODING, "gzip")).with(new HttpField(HttpHeader.ACCEPT_ENCODING, "gzip, deflate")).with(new HttpField(HttpHeader.ACCEPT_ENCODING, "gzip, deflate, br")).with(new HttpField(HttpHeader.ACCEPT_LANGUAGE, "en-US,enq=0.5")).with(new HttpField(HttpHeader.ACCEPT_LANGUAGE, "en-GB,en-USq=0.8,enq=0.6")).with(new HttpField(HttpHeader.ACCEPT_LANGUAGE, "en-AU,enq=0.9,it-ITq=0.8,itq=0.7,en-GBq=0.6,en-USq=0.5")).with(new HttpField(HttpHeader.ACCEPT_CHARSET, "ISO-8859-1,utf-8q=0.7,*q=0.3")).with(new HttpField(HttpHeader.ACCEPT, "*/*")).with(new HttpField(HttpHeader.ACCEPT, "image/png,image/*q=0.8,*/*q=0.5")).with(new HttpField(HttpHeader.ACCEPT, "text/html,application/xhtml+xml,application/xmlq=0.9,*/*q=0.8")).with(new HttpField(HttpHeader.ACCEPT, "text/html,application/xhtml+xml,application/xmlq=0.9,image/webp,image/apng,*/*q=0.8")).with(new HttpField(HttpHeader.ACCEPT_RANGES, HttpHeaderValue.BYTES)).with(new HttpField(HttpHeader.PRAGMA, "no-cache")).with(new HttpField(HttpHeader.CACHE_CONTROL, "private, no-cache, no-cache=Set-Cookie, proxy-revalidate")).with(new HttpField(HttpHeader.CACHE_CONTROL, "no-cache")).with(new HttpField(HttpHeader.CACHE_CONTROL, "max-age=0")).with(HttpFields.CONTENT_LENGTH_0).with(new HttpField(HttpHeader.CONTENT_ENCODING, "gzip")).with(new HttpField(HttpHeader.CONTENT_ENCODING, "deflate")).with(new HostPortHttpField("localhost")).with(new HttpField(HttpHeader.TRANSFER_ENCODING, "chunked")).with(new HttpField(HttpHeader.EXPIRES, "Fri, 01 Jan 1990 00:00:00 GMT")).withAll(() -> {
        LinkedHashMap<String, HttpField> map = new LinkedHashMap<String, HttpField>();
        for (MimeTypes.Type mimetype : MimeTypes.Type.values()) {
            HttpField contentTypeField = mimetype.getContentTypeField();
            map.put(contentTypeField.toString(), contentTypeField);
            if (!contentTypeField.getValue().contains(";charset=")) continue;
            MimeTypes.ContentTypeField contentTypeFieldWithSpace = new MimeTypes.ContentTypeField(MimeTypes.getMimeTypeFromContentType(contentTypeField), contentTypeField.getValue().replace(";charset=", "; charset="));
            map.put(contentTypeFieldWithSpace.toString(), contentTypeFieldWithSpace);
        }
        return map;
    }).withAll(() -> {
        LinkedHashMap<CallSite, HttpField> map = new LinkedHashMap<CallSite, HttpField>();
        for (HttpHeader h2 : HttpHeader.values()) {
            HttpField httpField = new HttpField(h2, UNMATCHED_VALUE);
            map.put((CallSite)((Object)(String.valueOf((Object)h2) + ": ")), httpField);
        }
        return map;
    }).build();
    private static final Index.Mutable<HttpField> NO_CACHE = new Index.Builder().caseSensitive(false).mutable().maxCapacity(0).build();
    private static final long HTTP_1_0_AS_LONG = HttpParser.stringAsLong("HTTP/1.0");
    private static final long HTTP_1_1_AS_LONG = HttpParser.stringAsLong("HTTP/1.1");
    private static final long GET_SLASH_HT_AS_LONG = HttpParser.stringAsLong("GET / HT");
    private static final long TP_SLASH_1_0_CRLF_AS_LONG = HttpParser.stringAsLong("TP/1.0\r\n");
    private static final long TP_SLASH_1_1_CRLF_AS_LONG = HttpParser.stringAsLong("TP/1.1\r\n");
    private static final long SPACE_200_OK_CR_AS_LONG = HttpParser.stringAsLong(" 200 OK\r");
    private static final int CRLF_AS_SHORT = 3338;
    private static final EnumSet<State> __idleStates = EnumSet.of(State.START, State.END, State.CLOSE, State.CLOSED);
    private static final EnumSet<State> __completeStates = EnumSet.of(State.END, State.CLOSE, State.CLOSED);
    private static final EnumSet<State> __terminatedStates = EnumSet.of(State.CLOSE, State.CLOSED);
    private final boolean debugEnabled = LOG.isDebugEnabled();
    private final HttpHandler _handler;
    private final RequestHandler _requestHandler;
    private final ResponseHandler _responseHandler;
    private final boolean _requestParser;
    private final int _maxHeaderBytes;
    private final HttpCompliance _complianceMode;
    private final Utf8StringBuilder _uri = new Utf8StringBuilder(256);
    private final FieldCache _fieldCache = new FieldCache();
    private HttpField _field;
    private HttpHeader _header;
    private long _beginNanoTime;
    private String _headerString;
    private String _valueString;
    private int _responseStatus;
    private int _headerBytes;
    private String _parsedHost;
    private boolean _headerComplete;
    private volatile State _state = State.START;
    private volatile FieldState _fieldState = FieldState.FIELD;
    private volatile boolean _eof;
    private HttpMethod _method;
    private String _methodString;
    private HttpVersion _version;
    private HttpTokens.EndOfContent _endOfContent;
    private boolean _hasContentLength;
    private boolean _hasTransferEncoding;
    private long _contentLength = -1L;
    private long _contentPosition;
    private int _chunkLength;
    private int _chunkOffset;
    private boolean _headResponse;
    private boolean _cr;
    private ByteBuffer _contentChunk;
    private int _length;
    private final StringBuilder _string = new StringBuilder();

    private static long stringAsLong(String s2) {
        if (s2 == null || s2.length() != 8) {
            throw new IllegalArgumentException();
        }
        long l = 0L;
        for (char c : s2.toCharArray()) {
            l = l << 8 | (long)c & 0xFFL;
        }
        return l;
    }

    private static HttpCompliance compliance() {
        return HttpCompliance.RFC9110;
    }

    public HttpParser(RequestHandler handler) {
        this(handler, -1, HttpParser.compliance());
    }

    public HttpParser(ResponseHandler handler) {
        this(handler, -1, HttpParser.compliance());
    }

    public HttpParser(RequestHandler handler, int maxHeaderBytes) {
        this(handler, maxHeaderBytes, HttpParser.compliance());
    }

    public HttpParser(ResponseHandler handler, int maxHeaderBytes) {
        this(handler, maxHeaderBytes, HttpParser.compliance());
    }

    public HttpParser(RequestHandler handler, HttpCompliance compliance) {
        this(handler, -1, compliance);
    }

    public HttpParser(RequestHandler handler, int maxHeaderBytes, HttpCompliance compliance) {
        this(handler, null, maxHeaderBytes, compliance == null ? HttpParser.compliance() : compliance);
    }

    public HttpParser(ResponseHandler handler, HttpCompliance compliance) {
        this(handler, -1, compliance);
    }

    public HttpParser(ResponseHandler handler, int maxHeaderBytes, HttpCompliance compliance) {
        this(null, handler, maxHeaderBytes, compliance == null ? HttpParser.compliance() : compliance);
    }

    private HttpParser(RequestHandler requestHandler, ResponseHandler responseHandler, int maxHeaderBytes, HttpCompliance compliance) {
        this._requestHandler = requestHandler;
        this._responseHandler = responseHandler;
        boolean bl = this._requestParser = this._requestHandler != null;
        if (!this._requestParser && this._responseHandler == null) {
            throw new IllegalStateException();
        }
        this._handler = this._requestParser ? requestHandler : responseHandler;
        this._maxHeaderBytes = maxHeaderBytes;
        this._complianceMode = compliance;
    }

    public long getBeginNanoTime() {
        return this._beginNanoTime;
    }

    public HttpHandler getHandler() {
        return this._handler;
    }

    public int getHeaderCacheSize() {
        return this._fieldCache.getCapacity();
    }

    public void setHeaderCacheSize(int headerCacheSize) {
        this._fieldCache.setCapacity(headerCacheSize);
    }

    public boolean isHeaderCacheCaseSensitive() {
        return this._fieldCache.isCaseSensitive();
    }

    public void setHeaderCacheCaseSensitive(boolean headerCacheCaseSensitive) {
        this._fieldCache.setCaseSensitive(headerCacheCaseSensitive);
    }

    protected void checkViolation(HttpCompliance.Violation violation) throws BadMessageException {
        if (!violation.isAllowedBy(this._complianceMode)) {
            throw new BadMessageException(violation.getDescription());
        }
        this.reportComplianceViolation(violation, violation.getDescription());
    }

    protected void reportComplianceViolation(HttpCompliance.Violation violation) {
        this.reportComplianceViolation(violation, violation.getDescription());
    }

    protected void reportComplianceViolation(HttpCompliance.Violation violation, String reason) {
        if (this._requestParser) {
            this._requestHandler.onViolation(new ComplianceViolation.Event(this._complianceMode, violation, reason));
        }
    }

    protected String caseInsensitiveHeader(String orig, String normative) {
        if (HttpCompliance.Violation.CASE_SENSITIVE_FIELD_NAME.isAllowedBy(this._complianceMode)) {
            return normative;
        }
        if (!orig.equals(normative)) {
            this.reportComplianceViolation(HttpCompliance.Violation.CASE_SENSITIVE_FIELD_NAME, orig);
        }
        return orig;
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public long getContentRead() {
        return this._contentPosition;
    }

    public int getHeaderLength() {
        return this._headerBytes;
    }

    public void setHeadResponse(boolean head) {
        this._headResponse = head;
    }

    protected void setResponseStatus(int status) {
        this._responseStatus = status;
    }

    public State getState() {
        return this._state;
    }

    public boolean hasContent() {
        return this._endOfContent != HttpTokens.EndOfContent.NO_CONTENT;
    }

    public boolean inContentState() {
        return this._state.ordinal() >= State.CONTENT.ordinal() && this._state.ordinal() < State.END.ordinal();
    }

    public boolean inHeaderState() {
        return this._state.ordinal() < State.CONTENT.ordinal();
    }

    public boolean isChunking() {
        return this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT;
    }

    public boolean isStart() {
        return this.isState(State.START);
    }

    public boolean isClose() {
        return this.isState(State.CLOSE);
    }

    public boolean isClosed() {
        return this.isState(State.CLOSED);
    }

    public boolean isIdle() {
        return __idleStates.contains((Object)this._state);
    }

    public boolean isComplete() {
        return __completeStates.contains((Object)this._state);
    }

    public boolean isTerminated() {
        return __terminatedStates.contains((Object)this._state);
    }

    public boolean isState(State state) {
        return this._state == state;
    }

    private HttpTokens.Token next(ByteBuffer buffer) {
        byte ch = buffer.get();
        this.addAndCheckHeadersSize(1);
        HttpTokens.Token t2 = HttpTokens.getToken(ch);
        switch (t2.getType()) {
            case CNTL: {
                throw new IllegalCharacterException(this._state, t2, buffer);
            }
            case LF: {
                if (this._cr) {
                    this._cr = false;
                    return HttpTokens.EOL_CRLF;
                }
                return HttpTokens.EOL_LF;
            }
            case CR: {
                if (this._cr) {
                    throw new BadMessageException("Bad EOL");
                }
                if (buffer.hasRemaining()) {
                    ch = buffer.get();
                    this.addAndCheckHeadersSize(1);
                    t2 = HttpTokens.TOKENS[0xFF & ch];
                    switch (t2.getType()) {
                        case CNTL: {
                            throw new IllegalCharacterException(this._state, t2, buffer);
                        }
                        case LF: {
                            break;
                        }
                        default: {
                            throw new BadMessageException("Bad EOL");
                        }
                    }
                    return HttpTokens.EOL_CRLF;
                }
                this._cr = true;
                return null;
            }
            case ALPHA: 
            case DIGIT: 
            case TCHAR: 
            case VCHAR: 
            case HTAB: 
            case SPACE: 
            case OTEXT: 
            case COLON: {
                if (!this._cr) break;
                throw new BadMessageException("Bad EOL");
            }
        }
        return t2;
    }

    private void addAndCheckHeadersSize(int delta) {
        if (this._maxHeaderBytes > 0 && (this._state.ordinal() <= State.HEADER.ordinal() || this._state.ordinal() == State.TRAILER.ordinal())) {
            this._headerBytes += delta;
            if (this._headerBytes > this._maxHeaderBytes) {
                if (this._state == State.URI) {
                    throw new BadMessageException(414);
                }
                if (this._requestParser) {
                    throw new BadMessageException(431);
                }
                throw new HttpException.RuntimeException(this._responseStatus, "Response Header Bytes Too Large");
            }
        }
    }

    private boolean quickStartRequestLine(ByteBuffer buffer) {
        int position = buffer.position();
        int remaining = buffer.remaining();
        if (remaining >= 16) {
            long lookahead = buffer.getLong(position);
            if (lookahead == GET_SLASH_HT_AS_LONG) {
                long v = buffer.getLong(position + 8);
                if (v == TP_SLASH_1_1_CRLF_AS_LONG) {
                    int delta = 16;
                    buffer.position(position + delta);
                    this.addAndCheckHeadersSize(delta);
                    this._methodString = HttpMethod.GET.asString();
                    this._version = HttpVersion.HTTP_1_1;
                    this._fieldCache.prepare();
                    this.setState(State.HEADER);
                    this._requestHandler.startRequest(this._methodString, "/", this._version);
                    return true;
                }
                if (v == TP_SLASH_1_0_CRLF_AS_LONG) {
                    int delta = 16;
                    buffer.position(position + delta);
                    this.addAndCheckHeadersSize(delta);
                    this._methodString = HttpMethod.GET.asString();
                    this._version = HttpVersion.HTTP_1_0;
                    this._fieldCache.prepare();
                    this.setState(State.HEADER);
                    this._requestHandler.startRequest(this._methodString, "/", this._version);
                    return true;
                }
            } else {
                this._method = HttpMethod.lookAheadGet(buffer, (int)(lookahead >> 32));
            }
        } else if (remaining >= 4) {
            this._method = HttpMethod.lookAheadGet(buffer);
        }
        if (this._method != null) {
            this._methodString = this._method.asString();
            int delta = this._methodString.length() + 1;
            buffer.position(position + delta);
            this.addAndCheckHeadersSize(delta);
            this.setState(State.SPACE1);
            return true;
        }
        return false;
    }

    private boolean quickStartResponseLine(ByteBuffer buffer) {
        int position = buffer.position();
        int remaining = buffer.remaining();
        if (remaining > 8) {
            long v = buffer.getLong(position);
            if (v == HTTP_1_1_AS_LONG) {
                this._version = HttpVersion.HTTP_1_1;
            } else if (v == HTTP_1_0_AS_LONG) {
                this._version = HttpVersion.HTTP_1_0;
            }
            if (this._version != null) {
                if (remaining > 16 && buffer.get((position += 8) + 8) == 10 && buffer.getLong(position) == SPACE_200_OK_CR_AS_LONG) {
                    buffer.position(position + 9);
                    this.addAndCheckHeadersSize(9);
                    this._responseStatus = 200;
                    this._fieldCache.prepare();
                    this.setState(State.HEADER);
                    this._responseHandler.startResponse(this._version, this._responseStatus, "OK");
                    return true;
                }
                if (buffer.get(position) == 32) {
                    buffer.position(position + 1);
                    this.addAndCheckHeadersSize(1);
                    this.setState(State.SPACE1);
                    return true;
                }
                this._version = null;
            }
        }
        return false;
    }

    private void quickStart(ByteBuffer buffer) {
        HttpTokens.Token t2;
        if (this._requestParser ? this.quickStartRequestLine(buffer) : this.quickStartResponseLine(buffer)) {
            return;
        }
        while (this._state == State.START && buffer.hasRemaining() && (t2 = this.next(buffer)) != null) {
            if (t2 == HttpTokens.EOL_LF) {
                this.checkViolation(HttpCompliance.Violation.LF_HEADER_TERMINATION);
            }
            switch (t2.getType()) {
                case ALPHA: 
                case DIGIT: 
                case TCHAR: 
                case VCHAR: {
                    this._string.setLength(0);
                    this._string.append(t2.getChar());
                    this.setState(this._requestParser ? State.METHOD : State.RESPONSE_VERSION);
                    return;
                }
                case HTAB: 
                case SPACE: 
                case OTEXT: {
                    throw new IllegalCharacterException(this._state, t2, buffer);
                }
            }
        }
    }

    private void setString(String s2) {
        this._string.setLength(0);
        this._string.append(s2);
        this._length = s2.length();
    }

    private String takeString() {
        this._string.setLength(this._length);
        String s2 = this._string.toString();
        this._string.setLength(0);
        this._length = -1;
        return s2;
    }

    private boolean handleHeaderContentMessage() {
        boolean handleHeader = this._handler.headerComplete();
        this._headerComplete = true;
        if (handleHeader) {
            return true;
        }
        this.setState(State.CONTENT_END);
        return this.handleContentMessage();
    }

    private boolean handleContentMessage() {
        boolean handleContent = this._handler.contentComplete();
        if (handleContent) {
            return true;
        }
        this.setState(State.END);
        return this._handler.messageComplete();
    }

    private boolean parseLine(ByteBuffer buffer) {
        HttpTokens.Token t2;
        boolean handle = false;
        block52: while (this._state.ordinal() < State.HEADER.ordinal() && buffer.hasRemaining() && !handle && (t2 = this.next(buffer)) != null) {
            if (t2 == HttpTokens.EOL_LF) {
                this.checkViolation(HttpCompliance.Violation.LF_HEADER_TERMINATION);
            }
            block0 : switch (this._state.ordinal()) {
                case 1: {
                    switch (t2.getType()) {
                        case SPACE: {
                            this._length = this._string.length();
                            this._methodString = this.takeString();
                            HttpMethod method = HttpMethod.CACHE.get(this._methodString);
                            if (method != null) {
                                this._methodString = method.asString();
                            } else if (HttpCompliance.Violation.CASE_INSENSITIVE_METHOD.isAllowedBy(this._complianceMode) && (method = HttpMethod.INSENSITIVE_CACHE.get(this._methodString)) != null) {
                                this._methodString = method.asString();
                                this.reportComplianceViolation(HttpCompliance.Violation.CASE_INSENSITIVE_METHOD, this._methodString);
                            }
                            this.setState(State.SPACE1);
                            break block0;
                        }
                        case EOL: {
                            throw new BadMessageException("No URI");
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: {
                            this._string.append(t2.getChar());
                            break block0;
                        }
                    }
                    throw new IllegalCharacterException(this._state, t2, buffer);
                }
                case 2: {
                    switch (t2.getType()) {
                        case SPACE: {
                            this._length = this._string.length();
                            String version = this.takeString();
                            this._version = HttpVersion.CACHE.get(version);
                            this.checkVersion();
                            this.setState(State.SPACE1);
                            break block0;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case COLON: {
                            this._string.append(t2.getChar());
                            break block0;
                        }
                        case EOL: {
                            throw new BadMessageException("No Status");
                        }
                    }
                    throw new IllegalCharacterException(this._state, t2, buffer);
                }
                case 3: {
                    switch (t2.getType()) {
                        case SPACE: {
                            break block0;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case COLON: {
                            if (!this._requestParser) {
                                if (t2.getType() != HttpTokens.Type.DIGIT || t2.getByte() == 48) {
                                    throw new BadMessageException("Bad status");
                                }
                                this.setState(State.STATUS);
                                this.setResponseStatus(t2.getByte() - 48);
                                break block0;
                            }
                            this._uri.reset();
                            this.setState(State.URI);
                            if (buffer.hasArray()) {
                                int i;
                                byte[] array = buffer.array();
                                int position = buffer.position();
                                int p = buffer.arrayOffset() + position;
                                int l = buffer.arrayOffset() + buffer.limit();
                                for (i = p; i < l && array[i] > 32; ++i) {
                                }
                                int len = i - p;
                                buffer.position(position + len);
                                this.addAndCheckHeadersSize(len);
                                this._uri.append(array, p - 1, len + 1);
                                break block0;
                            }
                            this._uri.append(t2.getByte());
                            break block0;
                        }
                    }
                    if (this._requestParser) {
                        throw new BadMessageException("No URI");
                    }
                    throw new HttpException.RuntimeException(this._responseStatus, "No Status");
                }
                case 4: {
                    assert (!this._requestParser);
                    switch (t2.getType()) {
                        case SPACE: {
                            if (this._responseStatus < 100) {
                                throw new BadMessageException("Bad status");
                            }
                            this.setState(State.SPACE2);
                            break block0;
                        }
                        case DIGIT: {
                            this._responseStatus = this._responseStatus * 10 + (t2.getByte() - 48);
                            if (this._responseStatus < 1000) continue block52;
                            throw new BadMessageException("Bad status");
                        }
                        case EOL: {
                            this._fieldCache.prepare();
                            this.setState(State.HEADER);
                            this._responseHandler.startResponse(this._version, this._responseStatus, null);
                            break block0;
                        }
                    }
                    throw new BadMessageException("Bad status");
                }
                case 5: {
                    assert (this._requestParser);
                    int position = buffer.position();
                    int remaining = buffer.remaining();
                    switch (t2.getType()) {
                        case SPACE: {
                            int endOfVersion = position + 8;
                            if (remaining >= 10 && buffer.getShort(endOfVersion) == 3338) {
                                HttpVersion version;
                                long versionAsLong = buffer.getLong(position);
                                HttpVersion httpVersion = versionAsLong == HTTP_1_1_AS_LONG ? HttpVersion.HTTP_1_1 : (version = versionAsLong == HTTP_1_0_AS_LONG ? HttpVersion.HTTP_1_0 : null);
                                if (version != null) {
                                    buffer.position(endOfVersion + 2);
                                    this.addAndCheckHeadersSize(endOfVersion + 2 - position);
                                    this._version = version;
                                    this._string.setLength(0);
                                    this.checkVersion();
                                    this._fieldCache.prepare();
                                    this.setState(State.HEADER);
                                    this._requestHandler.startRequest(this._methodString, this._uri.toCompleteString(), this._version);
                                    continue block52;
                                }
                            }
                            this.setState(State.SPACE2);
                            break block0;
                        }
                        case EOL: {
                            if (HttpCompliance.Violation.HTTP_0_9.isAllowedBy(this._complianceMode)) {
                                this.reportComplianceViolation(HttpCompliance.Violation.HTTP_0_9, HttpCompliance.Violation.HTTP_0_9.getDescription());
                                this._requestHandler.startRequest(this._methodString, this._uri.toCompleteString(), HttpVersion.HTTP_0_9);
                                this.setState(State.CONTENT);
                                this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
                                BufferUtil.clear(buffer);
                                handle = this.handleHeaderContentMessage();
                                break block0;
                            }
                            throw new HttpException.RuntimeException(505, "HTTP/0.9 not supported");
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case OTEXT: 
                        case COLON: {
                            this._uri.append(t2.getByte());
                            break block0;
                        }
                    }
                    throw new IllegalCharacterException(this._state, t2, buffer);
                }
                case 6: {
                    switch (t2.getType()) {
                        case SPACE: {
                            break block0;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case COLON: {
                            this._string.setLength(0);
                            this._string.append(t2.getChar());
                            this._length = 1;
                            this.setState(this._requestParser ? State.REQUEST_VERSION : State.REASON);
                            break block0;
                        }
                        case EOL: {
                            if (!this._requestParser) {
                                this._fieldCache.prepare();
                                this.setState(State.HEADER);
                                this._responseHandler.startResponse(this._version, this._responseStatus, null);
                                break block0;
                            }
                            this.checkViolation(HttpCompliance.Violation.HTTP_0_9);
                            this._requestHandler.startRequest(this._methodString, this._uri.toCompleteString(), HttpVersion.HTTP_0_9);
                            this.setState(State.CONTENT);
                            this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
                            BufferUtil.clear(buffer);
                            handle = this.handleHeaderContentMessage();
                            break block0;
                        }
                    }
                    throw new IllegalCharacterException(this._state, t2, buffer);
                }
                case 7: {
                    switch (t2.getType()) {
                        case EOL: {
                            if (this._version == null) {
                                this._length = this._string.length();
                                this._version = HttpVersion.CACHE.get(this.takeString());
                            }
                            this.checkVersion();
                            this._fieldCache.prepare();
                            this.setState(State.HEADER);
                            this._requestHandler.startRequest(this._methodString, this._uri.toCompleteString(), this._version);
                            continue block52;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case COLON: {
                            if (this._string.isEmpty()) {
                                HttpVersion version = HttpVersion.CACHE.getBest(buffer);
                                if (version == null) continue block52;
                                String versionString = version.asString();
                                buffer.position(buffer.position() + versionString.length());
                                this.addAndCheckHeadersSize(versionString.length());
                                HttpTokens.Token next = this.next(buffer);
                                if (next == null) {
                                    this._string.append(versionString);
                                    break block0;
                                }
                                switch (next.getType()) {
                                    case EOL: {
                                        if (next == HttpTokens.EOL_LF) {
                                            this.checkViolation(HttpCompliance.Violation.LF_HEADER_TERMINATION);
                                        }
                                        this._version = version;
                                        this.checkVersion();
                                        this._fieldCache.prepare();
                                        this.setState(State.HEADER);
                                        this._requestHandler.startRequest(this._methodString, this._uri.toCompleteString(), this._version);
                                        break block0;
                                    }
                                    case ALPHA: 
                                    case DIGIT: 
                                    case TCHAR: 
                                    case VCHAR: 
                                    case SPACE: 
                                    case COLON: {
                                        this._string.append(versionString);
                                        this._string.append(next.getChar());
                                        break block0;
                                    }
                                }
                                throw new IllegalCharacterException(this._state, next, buffer);
                            }
                            this._string.append(t2.getChar());
                            break block0;
                        }
                        default: {
                            throw new IllegalCharacterException(this._state, t2, buffer);
                        }
                    }
                }
                case 8: {
                    assert (!this._requestParser);
                    switch (t2.getType()) {
                        case EOL: {
                            String reason = this.takeString();
                            this._fieldCache.prepare();
                            this.setState(State.HEADER);
                            this._responseHandler.startResponse(this._version, this._responseStatus, reason);
                            continue block52;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case OTEXT: 
                        case COLON: {
                            this._string.append(t2.getChar());
                            this._length = this._string.length();
                            break block0;
                        }
                        case HTAB: 
                        case SPACE: {
                            this._string.append(t2.getChar());
                            break block0;
                        }
                    }
                    throw new IllegalCharacterException(this._state, t2, buffer);
                }
                default: {
                    throw new IllegalStateException(this._state.toString());
                }
            }
        }
        return handle;
    }

    private void checkVersion() {
        if (this._version == null) {
            throw new HttpException.RuntimeException(505, "Unknown Version");
        }
        if (this._version.getVersion() < 10 || this._version.getVersion() > 20) {
            throw new HttpException.RuntimeException(505, "Unsupported Version");
        }
    }

    private void parsedHeader() {
        if (this._headerString != null || this._valueString != null) {
            if (this._header != null) {
                boolean addToFieldCache = false;
                switch (this._header) {
                    case CONTENT_LENGTH: {
                        if (this._hasTransferEncoding) {
                            this.checkViolation(HttpCompliance.Violation.TRANSFER_ENCODING_WITH_CONTENT_LENGTH);
                        }
                        long contentLength = this.convertContentLength(this._valueString);
                        if (this._hasContentLength) {
                            this.checkViolation(HttpCompliance.Violation.MULTIPLE_CONTENT_LENGTHS);
                            if (contentLength != this._contentLength) {
                                throw new BadMessageException(HttpCompliance.Violation.MULTIPLE_CONTENT_LENGTHS.getDescription());
                            }
                        }
                        this._hasContentLength = true;
                        if (this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT) break;
                        this._contentLength = contentLength;
                        this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
                        break;
                    }
                    case TRANSFER_ENCODING: {
                        this._hasTransferEncoding = true;
                        if (this._hasContentLength) {
                            this.checkViolation(HttpCompliance.Violation.TRANSFER_ENCODING_WITH_CONTENT_LENGTH);
                        }
                        if (this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT) {
                            throw new BadMessageException("Bad Transfer-Encoding, chunked not last");
                        }
                        if (HttpHeaderValue.CHUNKED.is(this._valueString)) {
                            this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
                            this._contentLength = -1L;
                            break;
                        }
                        List<String> values = new QuotedCSV(this._valueString).getValues();
                        int chunked = -1;
                        int len = values.size();
                        for (int i = 0; i < len; ++i) {
                            if (HttpHeaderValue.CHUNKED.is(values.get(i))) {
                                if (chunked != -1) {
                                    throw new BadMessageException("Bad Transfer-Encoding, multiple chunked tokens");
                                }
                                chunked = i;
                                this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
                                this._contentLength = -1L;
                                continue;
                            }
                            if (this._endOfContent != HttpTokens.EndOfContent.CHUNKED_CONTENT) continue;
                            throw new BadMessageException("Bad Transfer-Encoding, chunked not last");
                        }
                        break;
                    }
                    case HOST: {
                        if (this._parsedHost != null) {
                            if (LOG.isWarnEnabled()) {
                                LOG.warn("Encountered multiple `Host` headers.  Previous `Host` header already seen as `{}`, new `Host` header has appeared as `{}`", (Object)this._parsedHost, (Object)this._valueString);
                            }
                            this.checkViolation(HttpCompliance.Violation.DUPLICATE_HOST_HEADERS);
                        }
                        this._parsedHost = this._valueString;
                        if (this._field instanceof HostPortHttpField || this._valueString == null || this._valueString.isEmpty()) break;
                        this._field = HttpCompliance.Violation.UNSAFE_HOST_HEADER.isAllowedBy(this._complianceMode) ? new HostPortHttpField(this._header, HttpCompliance.Violation.CASE_SENSITIVE_FIELD_NAME.isAllowedBy(this._complianceMode) ? this._headerString : this._header.asString(), HostPort.unsafe(this._valueString)) : new HostPortHttpField(this._header, HttpCompliance.Violation.CASE_SENSITIVE_FIELD_NAME.isAllowedBy(this._complianceMode) ? this._headerString : this._header.asString(), this._valueString);
                        addToFieldCache = this._fieldCache.isEnabled();
                        break;
                    }
                    case CONNECTION: {
                        if (this._field == null) {
                            this._field = this.newHttpField(this._header, this.caseInsensitiveHeader(this._headerString, this._header.asString()), this._valueString);
                        }
                        if (this.getHeaderCacheSize() <= 0 || !this._field.contains(HttpHeaderValue.CLOSE.asString())) break;
                        this._fieldCache.setCapacity(-1);
                        break;
                    }
                    case AUTHORIZATION: 
                    case ACCEPT: 
                    case ACCEPT_CHARSET: 
                    case ACCEPT_ENCODING: 
                    case ACCEPT_LANGUAGE: 
                    case COOKIE: 
                    case CACHE_CONTROL: 
                    case USER_AGENT: {
                        addToFieldCache = this._field == null && this._fieldCache.cacheable(this._header, this._valueString);
                        break;
                    }
                }
                if (addToFieldCache) {
                    if (this._field == null) {
                        this._field = this.newHttpField(this._header, this.caseInsensitiveHeader(this._headerString, this._header.asString()), this._valueString);
                    }
                    this._fieldCache.add(this._field);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("parsedHeader({}) header={}, headerString=[{}], valueString=[{}]", new Object[]{this._field, this._header, this._headerString, this._valueString});
            }
            this._handler.parsedHeader(this._field != null ? this._field : this.newHttpField(this._header, this._headerString, this._valueString));
        }
        this._valueString = null;
        this._headerString = null;
        this._header = null;
        this._field = null;
    }

    private void parsedTrailer() {
        if (this._headerString != null || this._valueString != null) {
            this._handler.parsedTrailer(this._field != null ? this._field : this.newHttpField(this._header, this._headerString, this._valueString));
        }
        this._valueString = null;
        this._headerString = null;
        this._header = null;
        this._field = null;
    }

    private long convertContentLength(String valueString) {
        if (valueString == null || valueString.isEmpty()) {
            throw new BadMessageException("Invalid Content-Length Value", (Throwable)new NumberFormatException());
        }
        long value = 0L;
        int length = valueString.length();
        for (int i = 0; i < length; ++i) {
            char c = valueString.charAt(i);
            if (c < '0' || c > '9') {
                throw new BadMessageException("Invalid Content-Length Value", (Throwable)new NumberFormatException());
            }
            value = Math.addExact(Math.multiplyExact(value, 10), (long)(c - 48));
        }
        return value;
    }

    protected boolean parseFields(ByteBuffer buffer) {
        HttpTokens.Token t2;
        block37: while ((this._state == State.HEADER || this._state == State.TRAILER) && buffer.hasRemaining() && (t2 = this.next(buffer)) != null) {
            if (t2 == HttpTokens.EOL_LF) {
                this.checkViolation(HttpCompliance.Violation.LF_HEADER_TERMINATION);
            }
            switch (this._fieldState.ordinal()) {
                case 0: {
                    switch (t2.getType()) {
                        case HTAB: 
                        case SPACE: 
                        case COLON: {
                            this.checkViolation(HttpCompliance.Violation.MULTILINE_FIELD_VALUE);
                            if (StringUtil.isEmpty(this._valueString)) {
                                this._string.setLength(0);
                                this._length = 0;
                            } else {
                                this.setString(this._valueString);
                                this._string.append(' ');
                                ++this._length;
                                this._valueString = null;
                            }
                            this.setState(FieldState.VALUE);
                            continue block37;
                        }
                        case EOL: {
                            if (this._state == State.HEADER) {
                                this.parsedHeader();
                            } else {
                                this.parsedTrailer();
                            }
                            this._contentPosition = 0L;
                            if (this._state == State.TRAILER) {
                                this.setState(State.END);
                                return this._handler.messageComplete();
                            }
                            if (this._hasTransferEncoding && this._endOfContent != HttpTokens.EndOfContent.CHUNKED_CONTENT && (this._responseHandler == null || this._endOfContent != HttpTokens.EndOfContent.EOF_CONTENT)) {
                                throw new BadMessageException("Bad Transfer-Encoding, chunked not last");
                            }
                            if (this._parsedHost == null && this._version == HttpVersion.HTTP_1_1 && this._requestParser) {
                                throw new BadMessageException("No Host");
                            }
                            if (!(this._requestParser || this._responseStatus != 304 && this._responseStatus != 204 && this._responseStatus >= 200)) {
                                this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
                            } else if (this._endOfContent == HttpTokens.EndOfContent.UNKNOWN_CONTENT) {
                                this._endOfContent = this._responseStatus == 0 || this._responseStatus == 304 || this._responseStatus == 204 || this._responseStatus < 200 ? HttpTokens.EndOfContent.NO_CONTENT : HttpTokens.EndOfContent.EOF_CONTENT;
                            }
                            boolean handle = this._handler.headerComplete();
                            this._headerComplete = true;
                            switch (this._endOfContent) {
                                case EOF_CONTENT: {
                                    this.setState(State.EOF_CONTENT);
                                    break;
                                }
                                case CHUNKED_CONTENT: {
                                    this.setState(State.CHUNKED_CONTENT);
                                    break;
                                }
                                default: {
                                    this.setState(State.CONTENT);
                                }
                            }
                            return handle;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: {
                            if (this._state == State.HEADER) {
                                this.parsedHeader();
                            } else {
                                this.parsedTrailer();
                            }
                            if (buffer.hasRemaining()) {
                                HttpField cachedField = this._fieldCache.getBest(buffer, -1, buffer.remaining() + 1);
                                if (cachedField == null) {
                                    cachedField = CACHE.getBest(buffer, -1, buffer.remaining() + 1);
                                }
                                if (cachedField != null) {
                                    String n = cachedField.getName();
                                    String v = cachedField.getValue();
                                    if (!Objects.equals(v, UNMATCHED_VALUE)) {
                                        String ev;
                                        String en;
                                        if (HttpCompliance.Violation.CASE_SENSITIVE_FIELD_NAME.isAllowedBy(this._complianceMode) && !n.equals(en = BufferUtil.toString(buffer, buffer.position() - 1, n.length(), StandardCharsets.US_ASCII))) {
                                            this.reportComplianceViolation(HttpCompliance.Violation.CASE_SENSITIVE_FIELD_NAME, en);
                                            n = en;
                                            cachedField = this.newHttpField(cachedField.getHeader(), n, v);
                                        }
                                        if (this.isHeaderCacheCaseSensitive() && !v.equals(ev = BufferUtil.toString(buffer, buffer.position() + n.length() + 1, v.length(), StandardCharsets.ISO_8859_1))) {
                                            v = ev;
                                            cachedField = this.newHttpField(cachedField.getHeader(), n, v);
                                        }
                                    }
                                    this._header = cachedField.getHeader();
                                    this._headerString = n;
                                    int position = buffer.position();
                                    int delta = n.length() + 1;
                                    int posAfterName = position + delta;
                                    if (Objects.equals(v, UNMATCHED_VALUE) || posAfterName + v.length() >= buffer.limit()) {
                                        this.setState(FieldState.VALUE);
                                        this._string.setLength(0);
                                        this._length = 0;
                                        buffer.position(posAfterName);
                                        this.addAndCheckHeadersSize(delta);
                                        continue block37;
                                    }
                                    int posAfterValue = posAfterName + v.length();
                                    byte peek = buffer.get(posAfterValue);
                                    if (peek == 13 || peek == 10) {
                                        this._field = cachedField;
                                        this._valueString = v;
                                        buffer.position(posAfterValue + 1);
                                        this.addAndCheckHeadersSize(posAfterValue + 1 - position);
                                        if (peek == 10) {
                                            this.checkViolation(HttpCompliance.Violation.LF_HEADER_TERMINATION);
                                            this.setState(FieldState.FIELD);
                                            continue block37;
                                        }
                                        this.setState(FieldState.IN_VALUE);
                                        this._cr = true;
                                        continue block37;
                                    }
                                    this.setState(FieldState.IN_VALUE);
                                    this.setString(v);
                                    buffer.position(posAfterValue);
                                    this.addAndCheckHeadersSize(posAfterValue - position);
                                    continue block37;
                                }
                            }
                            this.setState(FieldState.IN_NAME);
                            this._string.setLength(0);
                            this._string.append(t2.getChar());
                            this._length = 1;
                            continue block37;
                        }
                    }
                    throw new IllegalCharacterException(this._state, t2, buffer);
                }
                case 1: {
                    switch (t2.getType()) {
                        case HTAB: 
                        case SPACE: {
                            if (HttpCompliance.Violation.WHITESPACE_AFTER_FIELD_NAME.isAllowedBy(this._complianceMode)) {
                                this._headerString = this.takeString();
                                this.reportComplianceViolation(HttpCompliance.Violation.WHITESPACE_AFTER_FIELD_NAME, "Space after " + this._headerString);
                                this._header = HttpHeader.CACHE.get(this._headerString);
                                this._length = -1;
                                this.setState(FieldState.WS_AFTER_NAME);
                                continue block37;
                            }
                            throw new IllegalCharacterException(this._state, t2, buffer);
                        }
                        case COLON: {
                            this._headerString = this.takeString();
                            this._header = HttpHeader.CACHE.get(this._headerString);
                            this._length = -1;
                            this.setState(FieldState.VALUE);
                            continue block37;
                        }
                        case EOL: {
                            this._headerString = this.takeString();
                            this._header = HttpHeader.CACHE.get(this._headerString);
                            this._string.setLength(0);
                            this._valueString = "";
                            this._length = -1;
                            if (HttpCompliance.Violation.NO_COLON_AFTER_FIELD_NAME.isAllowedBy(this._complianceMode)) {
                                this.reportComplianceViolation(HttpCompliance.Violation.NO_COLON_AFTER_FIELD_NAME, "Field " + this._headerString);
                                this.setState(FieldState.FIELD);
                                continue block37;
                            }
                            throw new IllegalCharacterException(this._state, t2, buffer);
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: {
                            this._string.append(t2.getChar());
                            this._length = this._string.length();
                            continue block37;
                        }
                    }
                    throw new IllegalCharacterException(this._state, t2, buffer);
                }
                case 4: {
                    switch (t2.getType()) {
                        case HTAB: 
                        case SPACE: {
                            continue block37;
                        }
                        case COLON: {
                            this.setState(FieldState.VALUE);
                            continue block37;
                        }
                        case EOL: {
                            if (HttpCompliance.Violation.NO_COLON_AFTER_FIELD_NAME.isAllowedBy(this._complianceMode)) {
                                this.reportComplianceViolation(HttpCompliance.Violation.NO_COLON_AFTER_FIELD_NAME, "Field " + this._headerString);
                                this.setState(FieldState.FIELD);
                                continue block37;
                            }
                            throw new IllegalCharacterException(this._state, t2, buffer);
                        }
                    }
                    throw new IllegalCharacterException(this._state, t2, buffer);
                }
                case 2: {
                    switch (t2.getType()) {
                        case EOL: {
                            this._string.setLength(0);
                            this._valueString = "";
                            this._length = -1;
                            this.setState(FieldState.FIELD);
                            continue block37;
                        }
                        case HTAB: 
                        case SPACE: {
                            continue block37;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case OTEXT: 
                        case COLON: {
                            this._string.append(t2.getChar());
                            this._length = this._string.length();
                            this.setState(FieldState.IN_VALUE);
                            continue block37;
                        }
                    }
                    throw new IllegalCharacterException(this._state, t2, buffer);
                }
                case 3: {
                    switch (t2.getType()) {
                        case EOL: {
                            if (this._length > 0) {
                                this._valueString = this.takeString();
                                this._length = -1;
                            }
                            this.setState(FieldState.FIELD);
                            continue block37;
                        }
                        case HTAB: 
                        case SPACE: {
                            this._string.append(t2.getChar());
                            continue block37;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case OTEXT: 
                        case COLON: {
                            this._string.append(t2.getChar());
                            this._length = this._string.length();
                            continue block37;
                        }
                    }
                    throw new IllegalCharacterException(this._state, t2, buffer);
                }
            }
            throw new IllegalStateException(this._state.toString());
        }
        return false;
    }

    public boolean parseNext(ByteBuffer buffer) {
        if (this.debugEnabled) {
            LOG.debug("parseNext s={} {}", (Object)this._state, (Object)BufferUtil.toDetailString(buffer));
        }
        try {
            if (this._state == State.START) {
                this._handler.messageBegin();
                this._version = null;
                this._method = null;
                this._methodString = null;
                this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
                this._header = null;
                if (buffer.hasRemaining()) {
                    this._beginNanoTime = NanoTime.now();
                }
                this.quickStart(buffer);
            }
            if (this._state.ordinal() < State.HEADER.ordinal() && this.parseLine(buffer)) {
                return true;
            }
            if (this._state == State.HEADER && this.parseFields(buffer)) {
                return true;
            }
            if (this._state.ordinal() >= State.CONTENT.ordinal() && this._state.ordinal() < State.TRAILER.ordinal()) {
                if (this._responseStatus > 0 && this._headResponse) {
                    if (this._state != State.CONTENT_END) {
                        this.setState(State.CONTENT_END);
                        return this.handleContentMessage();
                    }
                    this.setState(State.END);
                    return this._handler.messageComplete();
                }
                if (this.parseContent(buffer)) {
                    return true;
                }
            }
            if (this._state == State.TRAILER && this.parseFields(buffer)) {
                return true;
            }
            if (this._state == State.END) {
                byte b;
                int whiteSpace = 0;
                while (buffer.remaining() > 0 && ((b = buffer.get(buffer.position())) == 13 || b == 10)) {
                    buffer.get();
                    this.addAndCheckHeadersSize(1);
                    ++whiteSpace;
                }
                if (this.debugEnabled && whiteSpace > 0) {
                    LOG.debug("Discarded {} CR or LF characters", (Object)whiteSpace);
                }
            } else if (this.isTerminated()) {
                BufferUtil.clear(buffer);
            }
            if (this.isAtEOF() && !buffer.hasRemaining()) {
                switch (this._state.ordinal()) {
                    case 22: {
                        break;
                    }
                    case 20: 
                    case 21: {
                        this.setState(State.CLOSED);
                        break;
                    }
                    case 12: 
                    case 19: {
                        if (this._fieldState == FieldState.FIELD) {
                            this.setState(State.CONTENT_END);
                            boolean handle = this.handleContentMessage();
                            if (handle && this._state == State.CONTENT_END) {
                                return true;
                            }
                            this.setState(State.CLOSED);
                            return handle;
                        }
                        this.setState(State.CLOSED);
                        this._handler.earlyEOF();
                        break;
                    }
                    case 0: 
                    case 11: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        this.setState(State.CLOSED);
                        this._handler.earlyEOF();
                        break;
                    }
                    default: {
                        if (this.debugEnabled) {
                            LOG.debug("{} EOF in {}", (Object)this, (Object)this._state);
                        }
                        this.setState(State.CLOSED);
                        if (this._requestParser) {
                            this._handler.badMessage(new BadMessageException(400, "Early EOF"));
                            break;
                        }
                        this._handler.badMessage(new HttpException.RuntimeException(this._responseStatus, "Early EOF"));
                    }
                }
            }
        }
        catch (Throwable x) {
            HttpException http;
            BufferUtil.clear(buffer);
            HttpException bad = x instanceof HttpException ? (http = (HttpException)((Object)x)) : (this._requestParser ? new BadMessageException("Bad Request", x) : new HttpException.RuntimeException(this._responseStatus, "Bad Response", x));
            this.badMessage(bad);
        }
        return false;
    }

    protected void badMessage(HttpException x) {
        if (this.debugEnabled) {
            LOG.atDebug().setCause((Throwable)((Object)x)).log("Parse exception: {} for {}", (Object)this, (Object)this._handler);
        }
        this.setState(State.CLOSE);
        if (this._headerComplete) {
            this._handler.earlyEOF();
        } else {
            this._handler.badMessage(x);
        }
    }

    protected boolean parseContent(ByteBuffer buffer) {
        long content;
        int remaining = buffer.remaining();
        if (remaining == 0) {
            switch (this._state.ordinal()) {
                case 11: {
                    content = this._contentLength - this._contentPosition;
                    if (this._endOfContent != HttpTokens.EndOfContent.NO_CONTENT && content != 0L) break;
                    this.setState(State.CONTENT_END);
                    return this.handleContentMessage();
                }
                case 18: {
                    this.setState(this._endOfContent == HttpTokens.EndOfContent.EOF_CONTENT ? State.CLOSED : State.END);
                    return this._handler.messageComplete();
                }
                default: {
                    return false;
                }
            }
        }
        while (this._state.ordinal() < State.TRAILER.ordinal() && remaining > 0) {
            block4 : switch (this._state.ordinal()) {
                case 12: {
                    this._contentChunk = buffer.asReadOnlyBuffer();
                    this._contentPosition += (long)remaining;
                    buffer.position(buffer.position() + remaining);
                    if (!this._handler.content(this._contentChunk)) break;
                    return true;
                }
                case 11: {
                    content = this._contentLength - this._contentPosition;
                    if (this._endOfContent == HttpTokens.EndOfContent.NO_CONTENT || content == 0L) {
                        this.setState(State.CONTENT_END);
                        return this.handleContentMessage();
                    }
                    this._contentChunk = buffer.asReadOnlyBuffer();
                    if (this._contentLength > -1L && (long)remaining > content) {
                        this._contentChunk.limit(this._contentChunk.position() + (int)content);
                    }
                    this._contentPosition += (long)this._contentChunk.remaining();
                    buffer.position(buffer.position() + this._contentChunk.remaining());
                    if (this._handler.content(this._contentChunk)) {
                        return true;
                    }
                    if (this._contentPosition != this._contentLength) break;
                    this.setState(State.CONTENT_END);
                    return this.handleContentMessage();
                }
                case 13: {
                    HttpTokens.Token t2 = this.next(buffer);
                    if (t2 == null) break;
                    switch (t2.getType()) {
                        case DIGIT: {
                            this._chunkLength = t2.getHexDigit();
                            this.setState(State.CHUNK_SIZE);
                            break block4;
                        }
                        case ALPHA: {
                            if (t2.isHexDigit()) {
                                this._chunkLength = t2.getHexDigit();
                                this.setState(State.CHUNK_SIZE);
                                break block4;
                            }
                            throw new IllegalCharacterException(this._state, t2, buffer);
                        }
                    }
                    throw new IllegalCharacterException(this._state, t2, buffer);
                }
                case 14: {
                    HttpTokens.Token t3 = this.next(buffer);
                    if (t3 == null) break;
                    if (Objects.requireNonNull(t3.getType()) == HttpTokens.Type.EOL) {
                        if (t3 == HttpTokens.EOL_LF) {
                            this.checkViolation(HttpCompliance.Violation.LF_CHUNK_TERMINATION);
                        }
                        if (this._chunkLength == 0) {
                            this.setState(State.TRAILER);
                            if (!this._handler.contentComplete()) break;
                            return true;
                        }
                        this._chunkOffset = 0;
                        this.setState(State.CHUNK);
                        break;
                    }
                    if (t3.isHexDigit()) {
                        if (this._chunkLength > 0x7FFFFEF) {
                            throw new BadMessageException(413);
                        }
                        this._chunkLength = this._chunkLength * 16 + t3.getHexDigit();
                        break;
                    }
                    if (t3.getChar() == ';') {
                        this.setState(State.CHUNK_PARAMS);
                        break;
                    }
                    throw new IllegalCharacterException(this._state, t3, buffer);
                }
                case 15: {
                    HttpTokens.Token t4 = this.next(buffer);
                    if (t4 == null || Objects.requireNonNull(t4.getType()) != HttpTokens.Type.EOL) break;
                    if (t4 == HttpTokens.EOL_LF) {
                        this.checkViolation(HttpCompliance.Violation.LF_CHUNK_TERMINATION);
                    }
                    if (this._chunkLength == 0) {
                        this.setState(State.TRAILER);
                        if (!this._handler.contentComplete()) break;
                        return true;
                    }
                    this._chunkOffset = 0;
                    this.setState(State.CHUNK);
                    break;
                }
                case 16: {
                    int chunkLength = this._chunkLength - this._chunkOffset;
                    if (chunkLength == 0) {
                        this.setState(State.CHUNK_END);
                        break;
                    }
                    this._contentChunk = buffer.asReadOnlyBuffer();
                    if (remaining > chunkLength) {
                        this._contentChunk.limit(this._contentChunk.position() + chunkLength);
                    }
                    chunkLength = this._contentChunk.remaining();
                    this._contentPosition += (long)chunkLength;
                    this._chunkOffset += chunkLength;
                    buffer.position(buffer.position() + chunkLength);
                    if (!this._handler.content(this._contentChunk)) break;
                    return true;
                }
                case 17: {
                    HttpTokens.Token t5 = this.next(buffer);
                    if (t5 == null || Objects.requireNonNull(t5.getType()) != HttpTokens.Type.EOL) break;
                    if (t5 == HttpTokens.EOL_LF) {
                        this.checkViolation(HttpCompliance.Violation.LF_CHUNK_TERMINATION);
                    }
                    this.setState(State.CHUNKED_CONTENT);
                    break;
                }
                case 18: {
                    this.setState(this._endOfContent == HttpTokens.EndOfContent.EOF_CONTENT ? State.CLOSED : State.END);
                    return this._handler.messageComplete();
                }
            }
            remaining = buffer.remaining();
        }
        return false;
    }

    public boolean isAtEOF() {
        return this._eof;
    }

    public void atEOF() {
        if (this.debugEnabled) {
            LOG.debug("atEOF {}", (Object)this);
        }
        this._eof = true;
    }

    public void close() {
        if (this.debugEnabled) {
            LOG.debug("close {}", (Object)this);
        }
        this.setState(State.CLOSE);
    }

    public void reset() {
        if (this.debugEnabled) {
            LOG.debug("reset {}", (Object)this);
        }
        if (this._state == State.CLOSE || this._state == State.CLOSED) {
            return;
        }
        this.setState(State.START);
        this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
        this._contentLength = -1L;
        this._hasContentLength = false;
        this._hasTransferEncoding = false;
        this._contentPosition = 0L;
        this._responseStatus = 0;
        this._contentChunk = null;
        this._headerBytes = 0;
        this._parsedHost = null;
        this._headerComplete = false;
    }

    public void startTunnel() {
        this.setState(State.EOF_CONTENT);
        this._endOfContent = HttpTokens.EndOfContent.EOF_CONTENT;
        this._contentLength = -1L;
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public void servletUpgrade() {
        this.startTunnel();
    }

    protected void setState(State state) {
        if (this.debugEnabled) {
            String info;
            switch (state.ordinal()) {
                case 3: {
                    String string;
                    if (this._requestHandler == null) {
                        string = this._version.asString();
                        break;
                    }
                    string = this._methodString;
                    break;
                }
                case 6: {
                    String string;
                    if (this._requestHandler == null) {
                        string = Integer.toString(this._responseStatus);
                        break;
                    }
                    string = this._uri.toCompleteString();
                    break;
                }
                case 18: 
                case 19: {
                    String string = Long.toString(this._contentPosition);
                    break;
                }
                default: {
                    String string = info = null;
                }
            }
            if (info == null) {
                LOG.debug("{} --> {}", (Object)this._state, (Object)state);
            } else {
                LOG.debug("{} --> {}({})", new Object[]{this._state, state, info});
            }
        }
        this._state = state;
    }

    protected void setState(FieldState state) {
        if (this.debugEnabled) {
            if (state != FieldState.FIELD) {
                LOG.debug("{}:{} --> {}", new Object[]{this._state, this._fieldState, state});
            } else {
                LOG.debug("{}:{} --> {}({}: {})", new Object[]{this._state, this._fieldState, state, this._field != null ? this._field : this._headerString, this._valueString});
            }
        }
        this._fieldState = state;
    }

    public Index<HttpField> getFieldCache() {
        this._fieldCache.prepare();
        return this._fieldCache.getCache();
    }

    public HttpField newHttpField(HttpHeader header, String name, String value) {
        return new CompliantHttpField(header, name, value);
    }

    public String toString() {
        return String.format("%s{s=%s,%d of %d}", new Object[]{TypeUtil.toShortName(this.getClass()), this._state, this.getContentRead(), this.getContentLength()});
    }

    public static interface RequestHandler
    extends HttpHandler {
        public void startRequest(String var1, String var2, HttpVersion var3);
    }

    public static interface ResponseHandler
    extends HttpHandler {
        public void startResponse(HttpVersion var1, int var2, String var3);
    }

    private static class FieldCache {
        private int _size = 1024;
        private Index.Mutable<HttpField> _cache;
        private List<HttpField> _cacheableFields;
        private boolean _caseSensitive;

        private FieldCache() {
        }

        public int getCapacity() {
            return this._size;
        }

        public void setCapacity(int size) {
            this._size = size;
            this._cache = this._size <= 0 ? NO_CACHE : null;
        }

        public boolean isCaseSensitive() {
            return this._caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this._caseSensitive = caseSensitive;
        }

        public boolean isEnabled() {
            return this._cache != NO_CACHE;
        }

        public Index<HttpField> getCache() {
            return this._cache;
        }

        public HttpField getBest(ByteBuffer buffer, int i, int remaining) {
            Index.Mutable<HttpField> cache = this._cache;
            return cache == null ? null : (HttpField)this._cache.getBest(buffer, i, remaining);
        }

        public void add(HttpField field) {
            if (this._cache == null) {
                if (this._cacheableFields == null) {
                    this._cacheableFields = new ArrayList<HttpField>();
                }
                this._cacheableFields.add(field);
            } else if (!this._cache.put(field)) {
                this._cache.clear();
                this._cache.put(field);
            }
        }

        public boolean cacheable(HttpHeader header, String valueString) {
            return this.isEnabled() && header != null && valueString != null && valueString.length() <= this._size;
        }

        private void prepare() {
            if (this._cache == null && this._cacheableFields != null) {
                this._cache = Index.buildMutableVisibleAsciiAlphabet(this._caseSensitive, this._size);
                for (HttpField f : this._cacheableFields) {
                    if (!this._cache.put(f)) break;
                }
                this._cacheableFields.clear();
                this._cacheableFields = null;
            }
        }
    }

    public static enum State {
        START,
        METHOD,
        RESPONSE_VERSION,
        SPACE1,
        STATUS,
        URI,
        SPACE2,
        REQUEST_VERSION,
        REASON,
        PROXY,
        HEADER,
        CONTENT,
        EOF_CONTENT,
        CHUNKED_CONTENT,
        CHUNK_SIZE,
        CHUNK_PARAMS,
        CHUNK,
        CHUNK_END,
        CONTENT_END,
        TRAILER,
        END,
        CLOSE,
        CLOSED;

    }

    public static enum FieldState {
        FIELD,
        IN_NAME,
        VALUE,
        IN_VALUE,
        WS_AFTER_NAME;

    }

    public static interface HttpHandler {
        default public void messageBegin() {
        }

        public boolean content(ByteBuffer var1);

        public boolean headerComplete();

        public boolean contentComplete();

        public boolean messageComplete();

        public void parsedHeader(HttpField var1);

        default public void parsedTrailer(HttpField field) {
        }

        public void earlyEOF();

        default public void onViolation(ComplianceViolation.Event event) {
        }

        default public void badMessage(HttpException failure) {
        }
    }

    private static class IllegalCharacterException
    extends BadMessageException {
        private IllegalCharacterException(State state, HttpTokens.Token token, ByteBuffer buffer) {
            super(String.format("Illegal character %s", token));
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Illegal character %s in state=%s for buffer %s", new Object[]{token, state, BufferUtil.toDetailString(buffer)}));
            }
        }
    }

    private class CompliantHttpField
    extends HttpField {
        public CompliantHttpField(HttpHeader header, String name, String value) {
            super(header, name, value);
        }

        @Override
        protected QuotedCSV newQuotedCSV(boolean keepQuotes, String value) {
            if (this.getHeader() != null && HttpField.ETAG_HEADER.contains((Object)this.getHeader())) {
                return new QuotedCSV.Etags((ComplianceViolation.Mode)HttpParser.this._complianceMode, (v, r) -> {
                    try {
                        HttpParser.this._handler.onViolation(new ComplianceViolation.Event(HttpParser.this._complianceMode, (ComplianceViolation)v, (String)r));
                    }
                    catch (BadMessageException bme) {
                        throw bme;
                    }
                    catch (Throwable t2) {
                        throw new BadMessageException(t2.getMessage(), t2);
                    }
                }, value);
            }
            return new QuotedCSV(keepQuotes, new String[]{value}){

                @Override
                protected void onComplianceViolation(ComplianceViolation violation, String value) {
                    if (!HttpParser.this._complianceMode.allows(violation)) {
                        throw new BadMessageException(violation.toString());
                    }
                    HttpParser.this._handler.onViolation(new ComplianceViolation.Event(HttpParser.this._complianceMode, violation, value));
                }
            };
        }
    }
}

