/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.Index;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDateTime {
    private static final Logger LOG = LoggerFactory.getLogger(HttpDateTime.class);
    private static final Index<Integer> MONTH_CACHE = new Index.Builder().caseSensitive(false).with("Jan", 1).with("Feb", 2).with("Mar", 3).with("Apr", 4).with("May", 5).with("Jun", 6).with("Jul", 7).with("Aug", 8).with("Sep", 9).with("Oct", 10).with("Nov", 11).with("Dec", 12).build();
    private static final String DELIMITERS = new String(StringUtil.fromHexString("09202122232425262728292a2b2c2d2e2f3b3c3d3e3f405b5c5d5e5f607b7c7d7e"), StandardCharsets.US_ASCII);

    private HttpDateTime() {
    }

    public static long parseToEpoch(String datetime) {
        try {
            ZonedDateTime dateTime = HttpDateTime.parse(datetime);
            return TimeUnit.SECONDS.toMillis(dateTime.toEpochSecond());
        }
        catch (IllegalArgumentException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to parse Date/Time: {}", (Object)datetime, (Object)e);
            }
            return -1L;
        }
    }

    public static ZonedDateTime parse(String datetime) {
        int second;
        int minute;
        int hour;
        int day;
        int month;
        int year;
        block22: {
            Objects.requireNonNull(datetime, "Date/Time string cannot be null");
            year = -1;
            month = -1;
            day = -1;
            hour = -1;
            minute = -1;
            second = -1;
            try {
                int tokenCount = 0;
                StringTokenizer tokenizer = new StringTokenizer(datetime, DELIMITERS);
                while (tokenizer.hasMoreTokens()) {
                    Integer m4;
                    String token = tokenizer.nextToken();
                    if (++tokenCount > 6) {
                        throw new IllegalStateException("Too many delimiters for a Date/Time format");
                    }
                    if (token.isBlank()) continue;
                    if (hour == -1 && token.length() == 8 && token.charAt(2) == ':' && token.charAt(5) == ':') {
                        second = StringUtil.toInt(token, 6);
                        minute = StringUtil.toInt(token, 3);
                        hour = StringUtil.toInt(token, 0);
                        continue;
                    }
                    if (day == -1 && token.length() <= 2) {
                        day = StringUtil.toInt(token, 0);
                        continue;
                    }
                    if (month == -1 && token.length() == 3 && (m4 = MONTH_CACHE.getBest(token)) != null) {
                        month = m4;
                        continue;
                    }
                    if (year != -1) continue;
                    if (token.length() <= 2) {
                        year = StringUtil.toInt(token, 0);
                        continue;
                    }
                    if (token.length() != 4) continue;
                    year = StringUtil.toInt(token, 0);
                }
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block22;
                LOG.atDebug().setCause(x).log("Ignore: Unable to parse Date/Time");
            }
        }
        if (year > 70 && year <= 99) {
            year += 1900;
        }
        if (year >= 0 && year <= 69) {
            year += 2000;
        }
        if (day == -1) {
            throw new IllegalArgumentException("Missing [day]: " + datetime);
        }
        if (month == -1) {
            throw new IllegalArgumentException("Missing [month]: " + datetime);
        }
        if (year == -1) {
            throw new IllegalArgumentException("Missing [year]: " + datetime);
        }
        if (year < 1601) {
            throw new IllegalArgumentException("Too far in past [year]: " + datetime);
        }
        if (hour == -1) {
            throw new IllegalArgumentException("Missing [time]: " + datetime);
        }
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("Invalid [day]: " + datetime);
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid [month]: " + datetime);
        }
        if (hour > 23) {
            throw new IllegalArgumentException("Invalid [hour]: " + datetime);
        }
        if (minute > 59) {
            throw new IllegalArgumentException("Invalid [minute]: " + datetime);
        }
        if (second > 59) {
            throw new IllegalArgumentException("Invalid [second]: " + datetime);
        }
        try {
            ZonedDateTime dateTime = ZonedDateTime.of(year, month, day, hour, minute, second, 0, ZoneOffset.UTC);
            return dateTime;
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException("Invalid date/time: " + datetime, e);
        }
    }

    public static String format(TemporalAccessor datetime) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneOffset.UTC).format(datetime);
    }
}

