/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet.internal;

import jakarta.servlet.ReadListener;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.ee10.servlet.HttpInput;
import org.eclipse.jetty.ee10.servlet.util.ServletInputStreamWrapper;

public class UpgradedServletInputStream
extends ServletInputStreamWrapper {
    private final CompletableFuture<Void> _inputStreamComplete = new CompletableFuture();

    public UpgradedServletInputStream(HttpInput httpInput) {
        super(httpInput);
    }

    public CompletableFuture<Void> getCompletableFuture() {
        return this._inputStreamComplete;
    }

    @Override
    public int read() throws IOException {
        try {
            int read = super.read();
            if (read == -1) {
                this._inputStreamComplete.complete(null);
            }
            return read;
        }
        catch (Throwable t2) {
            this._inputStreamComplete.completeExceptionally(t2);
            throw t2;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            int read = super.read(b);
            if (read == -1) {
                this._inputStreamComplete.complete(null);
            }
            return read;
        }
        catch (Throwable t2) {
            this._inputStreamComplete.completeExceptionally(t2);
            throw t2;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int read = super.read(b, off, len);
            if (read == -1) {
                this._inputStreamComplete.complete(null);
            }
            return read;
        }
        catch (Throwable t2) {
            this._inputStreamComplete.completeExceptionally(t2);
            throw t2;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
            this._inputStreamComplete.complete(null);
        }
        catch (Throwable t2) {
            this._inputStreamComplete.completeExceptionally(t2);
            throw t2;
        }
    }

    @Override
    public void setReadListener(final ReadListener readListener) {
        super.setReadListener(new ReadListener(){
            final /* synthetic */ UpgradedServletInputStream this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onDataAvailable() throws IOException {
                readListener.onDataAvailable();
            }

            @Override
            public void onAllDataRead() throws IOException {
                try {
                    readListener.onAllDataRead();
                    this.this$0._inputStreamComplete.complete(null);
                }
                catch (Throwable t2) {
                    this.this$0._inputStreamComplete.completeExceptionally(t2);
                    throw t2;
                }
            }

            @Override
            public void onError(Throwable t2) {
                readListener.onError(t2);
                this.this$0._inputStreamComplete.completeExceptionally(t2);
            }
        });
    }
}

