/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.ee10.servlet.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorPageErrorHandler
extends ErrorHandler
implements ErrorHandler.ErrorPageMapper {
    public static final String GLOBAL_ERROR_PAGE = "org.eclipse.jetty.server.error_page.global";
    private static final Logger LOG = LoggerFactory.getLogger(ErrorPageErrorHandler.class);
    private final Map<String, String> _errorPages = new HashMap<String, String>();
    private final List<ErrorCodeRange> _errorPageList = new ArrayList<ErrorCodeRange>();
    private boolean _unwrapServletException = true;

    public boolean isUnwrapServletException() {
        return this._unwrapServletException;
    }

    public void setUnwrapServletException(boolean unwrapServletException) {
        this._unwrapServletException = unwrapServletException;
    }

    @Override
    public void prepare(ErrorHandler.ErrorPageMapper.ErrorPage errorPage, HttpServletRequest request, HttpServletResponse response) {
        Throwable unwrapped;
        if (errorPage.error() instanceof ServletException && this._unwrapServletException && (unwrapped = this.unwrapServletException(errorPage.error(), errorPage.matchedClass())) != null) {
            request.setAttribute("org.eclipse.jetty.server.error_exception", unwrapped);
            request.setAttribute("jakarta.servlet.error.exception_type", unwrapped.getClass());
        }
    }

    @Override
    public ErrorHandler.ErrorPageMapper.ErrorPage getErrorPage(Integer errorStatusCode, Throwable error) {
        String errorPage;
        Throwable cause = error;
        while (cause != null) {
            Throwable throwable;
            for (Class<?> exClass = cause.getClass(); exClass != null; exClass = exClass.getSuperclass()) {
                errorPage = this._errorPages.get(exClass.getName());
                if (errorPage == null) continue;
                return new ErrorHandler.ErrorPageMapper.ErrorPage(errorPage, ErrorHandler.ErrorPageMapper.PageLookupTechnique.THROWABLE, error, cause, exClass);
            }
            if (cause instanceof ServletException) {
                ServletException se = (ServletException)cause;
                throwable = se.getRootCause();
            } else {
                throwable = cause.getCause();
            }
            cause = throwable;
        }
        if (errorStatusCode != null) {
            errorPage = this._errorPages.get(Integer.toString(errorStatusCode));
            if (errorPage != null) {
                return new ErrorHandler.ErrorPageMapper.ErrorPage(errorPage, ErrorHandler.ErrorPageMapper.PageLookupTechnique.STATUS_CODE, error, error, null);
            }
            for (ErrorCodeRange errCode : this._errorPageList) {
                if (!errCode.isInRange(errorStatusCode)) continue;
                return new ErrorHandler.ErrorPageMapper.ErrorPage(errCode.getUri(), ErrorHandler.ErrorPageMapper.PageLookupTechnique.STATUS_CODE, error, error, null);
            }
        }
        if ((errorPage = this._errorPages.get(GLOBAL_ERROR_PAGE)) != null) {
            return new ErrorHandler.ErrorPageMapper.ErrorPage(errorPage, ErrorHandler.ErrorPageMapper.PageLookupTechnique.GLOBAL, error, error, null);
        }
        return null;
    }

    private Throwable unwrapServletException(Throwable t2, Class<?> matchedThrowable) {
        if (matchedThrowable != null && t2.getClass() == matchedThrowable) {
            return t2;
        }
        if (t2 instanceof ServletException && t2.getCause() != null) {
            return this.unwrapServletException(t2.getCause(), matchedThrowable);
        }
        return t2;
    }

    public Map<String, String> getErrorPages() {
        return this._errorPages;
    }

    public void setErrorPages(Map<String, String> errorPages) {
        this._errorPages.clear();
        if (errorPages != null) {
            this._errorPages.putAll(errorPages);
        }
    }

    public void addErrorPage(Class<? extends Throwable> exception, String uri) {
        this._errorPages.put(exception.getName(), uri);
    }

    public void addErrorPage(String exceptionClassName, String uri) {
        this._errorPages.put(exceptionClassName, uri);
    }

    public void addErrorPage(int code, String uri) {
        this._errorPages.put(Integer.toString(code), uri);
    }

    public void addErrorPage(int from, int to, String uri) {
        this._errorPageList.add(new ErrorCodeRange(from, to, uri));
    }

    private static class ErrorCodeRange {
        private final int _from;
        private final int _to;
        private final String _uri;

        ErrorCodeRange(int from, int to, String uri) throws IllegalArgumentException {
            if (from > to) {
                throw new IllegalArgumentException("from>to");
            }
            this._from = from;
            this._to = to;
            this._uri = uri;
        }

        boolean isInRange(int value) {
            return this._from <= value && value <= this._to;
        }

        String getUri() {
            return this._uri;
        }

        public String toString() {
            return "from: " + this._from + ",to: " + this._to + ",uri: " + this._uri;
        }
    }
}

