/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2.stub.readrows;

import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.ServerStreamingAttemptException;
import com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.stub.readrows.ReadRowsAttemptCallable;
import com.google.common.util.concurrent.MoreExecutors;

public final class ReadRowsRetryingCallable
extends ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> {
    private final ApiCallContext context;
    private final ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> innerCallable;
    private final ScheduledRetryingExecutor<Void> executor;
    private final StreamResumptionStrategy<ReadRowsRequest, ReadRowsResponse> resumptionStrategyPrototype;

    public ReadRowsRetryingCallable(ApiCallContext context, ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> innerCallable, ScheduledRetryingExecutor<Void> executor, StreamResumptionStrategy<ReadRowsRequest, ReadRowsResponse> resumptionStrategyPrototype) {
        this.context = context;
        this.innerCallable = innerCallable;
        this.executor = executor;
        this.resumptionStrategyPrototype = resumptionStrategyPrototype;
    }

    @Override
    public void call(ReadRowsRequest request, final ResponseObserver<ReadRowsResponse> responseObserver, ApiCallContext context) {
        ApiCallContext actualContext = this.context.merge(context);
        ReadRowsAttemptCallable attemptCallable = new ReadRowsAttemptCallable(this.innerCallable, this.resumptionStrategyPrototype.createNew(), request, actualContext, responseObserver);
        RetryingFuture<Void> retryingFuture = this.executor.createFuture(attemptCallable, actualContext);
        attemptCallable.setExternalFuture(retryingFuture);
        attemptCallable.start();
        ApiFutures.addCallback(retryingFuture, new ApiFutureCallback<Void>(){

            @Override
            public void onFailure(Throwable throwable) {
                if (throwable instanceof ServerStreamingAttemptException) {
                    throwable = throwable.getCause();
                }
                responseObserver.onError(throwable);
            }

            @Override
            public void onSuccess(Void ignored) {
                responseObserver.onComplete();
            }
        }, MoreExecutors.directExecutor());
    }
}

