/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcRawCallableFactory;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.StreamingRetryAlgorithm;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.Callables;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedServerStreamingCallable;
import com.google.cloud.bigquery.storage.v1.BigQueryReadGrpc;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.Singletons;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamResponse;
import com.google.cloud.bigquery.storage.v1.stub.BigQueryReadStubSettings;
import com.google.cloud.bigquery.storage.v1.stub.EnhancedBigQueryReadStubSettings;
import com.google.cloud.bigquery.storage.v1.stub.GrpcBigQueryReadStub;
import com.google.cloud.bigquery.storage.v1.stub.readrows.ApiResultRetryAlgorithm;
import com.google.cloud.bigquery.storage.v1.stub.readrows.ReadRowsRetryingCallable;
import com.google.common.collect.ImmutableMap;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class EnhancedBigQueryReadStub
implements BackgroundResource {
    private static final String TRACING_OUTER_CLIENT_NAME = "BigQueryStorage";
    private final GrpcBigQueryReadStub stub;
    private final BigQueryReadStubSettings stubSettings;
    private final BigQueryReadSettings.RetryAttemptListener readRowsRetryAttemptListener;
    private final ClientContext context;
    private boolean enableOpenTelemetryTracing = false;
    private Tracer openTelemetryTracer = null;

    public static EnhancedBigQueryReadStub create(EnhancedBigQueryReadStubSettings settings) throws IOException {
        return EnhancedBigQueryReadStub.create(settings, null);
    }

    public static EnhancedBigQueryReadStub create(EnhancedBigQueryReadStubSettings settings, BigQueryReadSettings.RetryAttemptListener readRowsRetryAttemptListener) throws IOException {
        return EnhancedBigQueryReadStub.create(settings, readRowsRetryAttemptListener, false, null);
    }

    public static EnhancedBigQueryReadStub create(EnhancedBigQueryReadStubSettings settings, BigQueryReadSettings.RetryAttemptListener readRowsRetryAttemptListener, boolean enableOpenTelemetryTracing, TracerProvider openTelemetryTracerProvider) throws IOException {
        BigQueryReadStubSettings.Builder baseSettingsBuilder = (BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)BigQueryReadStubSettings.newBuilder().setUniverseDomain(settings.getUniverseDomain())).setTransportChannelProvider(settings.getTransportChannelProvider())).setEndpoint(settings.getEndpoint())).setHeaderProvider(settings.getHeaderProvider())).setCredentialsProvider(settings.getCredentialsProvider())).setStreamWatchdogCheckInterval(settings.getStreamWatchdogCheckInterval())).setStreamWatchdogProvider(settings.getStreamWatchdogProvider())).setBackgroundExecutorProvider(settings.getBackgroundExecutorProvider());
        baseSettingsBuilder.createReadSessionSettings().setRetryableCodes(settings.createReadSessionSettings().getRetryableCodes()).setRetrySettings(settings.createReadSessionSettings().getRetrySettings());
        baseSettingsBuilder.readRowsSettings().setRetryableCodes(settings.readRowsSettings().getRetryableCodes()).setRetrySettings(settings.readRowsSettings().getRetrySettings()).setResumptionStrategy(settings.readRowsSettings().getResumptionStrategy()).setIdleTimeout(settings.readRowsSettings().getIdleTimeout());
        baseSettingsBuilder.splitReadStreamSettings().setRetryableCodes(settings.splitReadStreamSettings().getRetryableCodes()).setRetrySettings(settings.splitReadStreamSettings().getRetrySettings());
        BigQueryReadStubSettings baseSettings = baseSettingsBuilder.build();
        ClientContext clientContext = ClientContext.create(baseSettings);
        GrpcBigQueryReadStub stub = new GrpcBigQueryReadStub(baseSettings, clientContext);
        return new EnhancedBigQueryReadStub(stub, baseSettings, readRowsRetryAttemptListener, clientContext, enableOpenTelemetryTracing, openTelemetryTracerProvider);
    }

    @InternalApi(value="Visible for testing")
    EnhancedBigQueryReadStub(GrpcBigQueryReadStub stub, BigQueryReadStubSettings stubSettings, BigQueryReadSettings.RetryAttemptListener readRowsRetryAttemptListener, ClientContext context, boolean enableOpenTelemetryTracing, TracerProvider openTelemetryTracerProvider) {
        this.stub = stub;
        this.stubSettings = stubSettings;
        this.readRowsRetryAttemptListener = readRowsRetryAttemptListener;
        this.context = context;
        this.enableOpenTelemetryTracing = enableOpenTelemetryTracing;
        if (enableOpenTelemetryTracing) {
            this.openTelemetryTracer = openTelemetryTracerProvider == null ? Singletons.getOpenTelemetry().getTracerProvider().tracerBuilder("com.google.cloud.bigquery.storage.v1.read.stub").build() : openTelemetryTracerProvider.tracerBuilder("com.google.cloud.bigquery.storage.v1.read.stub").build();
        }
    }

    public UnaryCallable<CreateReadSessionRequest, ReadSession> createReadSessionCallable() {
        ImplicitContextKeyed createReadSessionCallable = null;
        if (this.enableOpenTelemetryTracing) {
            createReadSessionCallable = this.openTelemetryTracer.spanBuilder("com.google.cloud.bigquery.storage.v1.read.stub.createReadSessionCallable").startSpan();
        }
        try {
            Scope createReadSessionCallableScope = createReadSessionCallable != null ? createReadSessionCallable.makeCurrent() : null;
            try {
                UnaryCallable<CreateReadSessionRequest, ReadSession> unaryCallable = this.stub.createReadSessionCallable();
                if (createReadSessionCallableScope != null) {
                    createReadSessionCallableScope.close();
                }
                return unaryCallable;
            }
            catch (Throwable throwable) {
                if (createReadSessionCallableScope != null) {
                    try {
                        createReadSessionCallableScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (createReadSessionCallable != null) {
                createReadSessionCallable.end();
            }
        }
    }

    public ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable() {
        ImplicitContextKeyed readRowsCallable = null;
        if (this.enableOpenTelemetryTracing) {
            readRowsCallable = this.openTelemetryTracer.spanBuilder("com.google.cloud.bigquery.storage.v1.read.stub.readRowsCallable").startSpan();
        }
        try {
            Scope readRowsCallableScope = readRowsCallable != null ? readRowsCallable.makeCurrent() : null;
            try {
                ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> innerCallable = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigQueryReadGrpc.getReadRowsMethod()).setParamsExtractor(new RequestParamsExtractor<ReadRowsRequest>(){

                    @Override
                    public Map<String, String> extract(ReadRowsRequest request) {
                        return ImmutableMap.of("read_stream", String.valueOf(request.getReadStream()));
                    }
                }).build(), this.stubSettings.readRowsSettings().getRetryableCodes());
                ServerStreamingCallSettings<ReadRowsRequest, ReadRowsResponse> callSettings = this.stubSettings.readRowsSettings();
                StreamingRetryAlgorithm retryAlgorithm = new StreamingRetryAlgorithm(new ApiResultRetryAlgorithm(this.readRowsRetryAttemptListener), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(callSettings.getRetrySettings(), this.context.getClock()));
                ScheduledRetryingExecutor<Void> retryingExecutor = new ScheduledRetryingExecutor<Void>(retryAlgorithm, this.context.getExecutor());
                if (this.context.getStreamWatchdog() != null) {
                    innerCallable = Callables.watched(innerCallable, callSettings, this.context);
                }
                ReadRowsRetryingCallable outerCallable = new ReadRowsRetryingCallable(this.context.getDefaultCallContext(), innerCallable, retryingExecutor, callSettings.getResumptionStrategy());
                TracedServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> traced = new TracedServerStreamingCallable<ReadRowsRequest, ReadRowsResponse>(outerCallable, this.context.getTracerFactory(), SpanName.of(TRACING_OUTER_CLIENT_NAME, "ReadRows"));
                ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> serverStreamingCallable = traced.withDefaultCallContext(this.context.getDefaultCallContext());
                if (readRowsCallableScope != null) {
                    readRowsCallableScope.close();
                }
                return serverStreamingCallable;
            }
            catch (Throwable throwable) {
                if (readRowsCallableScope != null) {
                    try {
                        readRowsCallableScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (readRowsCallable != null) {
                readRowsCallable.end();
            }
        }
    }

    public UnaryCallable<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamCallable() {
        ImplicitContextKeyed splitReadStreamCallable = null;
        if (this.enableOpenTelemetryTracing) {
            splitReadStreamCallable = this.openTelemetryTracer.spanBuilder("com.google.cloud.bigquery.storage.v1.read.stub.splitReadStreamCallable").startSpan();
        }
        try {
            Scope readRowsCallableScope = splitReadStreamCallable != null ? splitReadStreamCallable.makeCurrent() : null;
            try {
                UnaryCallable<SplitReadStreamRequest, SplitReadStreamResponse> unaryCallable = this.stub.splitReadStreamCallable();
                if (readRowsCallableScope != null) {
                    readRowsCallableScope.close();
                }
                return unaryCallable;
            }
            catch (Throwable throwable) {
                if (readRowsCallableScope != null) {
                    try {
                        readRowsCallableScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (splitReadStreamCallable != null) {
                splitReadStreamCallable.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ImplicitContextKeyed close = null;
        if (this.enableOpenTelemetryTracing) {
            close = this.openTelemetryTracer.spanBuilder("com.google.cloud.bigquery.storage.v1.read.stub.close").startSpan();
        }
        try (Scope closeScope = close != null ? close.makeCurrent() : null;){
            this.stub.close();
        }
        finally {
            if (close != null) {
                close.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        ImplicitContextKeyed shutdown = null;
        if (this.enableOpenTelemetryTracing) {
            shutdown = this.openTelemetryTracer.spanBuilder("com.google.cloud.bigquery.storage.v1.read.stub.shutdown").startSpan();
        }
        try (Scope shutdownScope = shutdown != null ? shutdown.makeCurrent() : null;){
            this.stub.shutdown();
        }
        finally {
            if (shutdown != null) {
                shutdown.end();
            }
        }
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownNow() {
        ImplicitContextKeyed shutdownNow = null;
        if (this.enableOpenTelemetryTracing) {
            shutdownNow = this.openTelemetryTracer.spanBuilder("com.google.cloud.bigquery.storage.v1.read.stub.shutdownNow").startSpan();
        }
        try (Scope shutdownNowScope = shutdownNow != null ? shutdownNow.makeCurrent() : null;){
            this.stub.shutdownNow();
        }
        finally {
            if (shutdownNow != null) {
                shutdownNow.end();
            }
        }
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        ImplicitContextKeyed awaitTermination = null;
        if (this.enableOpenTelemetryTracing) {
            awaitTermination = this.openTelemetryTracer.spanBuilder("com.google.cloud.bigquery.storage.v1.read.stub.awaitTermination").setAttribute("duration", duration).setAttribute("unit", unit.toString()).startSpan();
        }
        try {
            Scope awaitTerminationScope = awaitTermination != null ? awaitTermination.makeCurrent() : null;
            try {
                boolean bl = this.stub.awaitTermination(duration, unit);
                if (awaitTerminationScope != null) {
                    awaitTerminationScope.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (awaitTerminationScope != null) {
                    try {
                        awaitTerminationScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (awaitTermination != null) {
                awaitTermination.end();
            }
        }
    }

    public BigQueryReadStubSettings getStubSettings() {
        return this.stubSettings;
    }
}

