/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.gax.paging.Page;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.AutoValue_TableResult;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.Schema;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@AutoValue
public abstract class TableResult
implements Page<FieldValueList>,
Serializable {
    private static final long serialVersionUID = 1L;

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_TableResult.Builder();
    }

    @Nullable
    public abstract Schema getSchema();

    public abstract long getTotalRows();

    public abstract Page<FieldValueList> getPageNoSchema();

    @Nullable
    public abstract JobId getJobId();

    @Nullable
    public abstract String getQueryId();

    @Override
    public boolean hasNextPage() {
        return this.getPageNoSchema().hasNextPage();
    }

    @Override
    public String getNextPageToken() {
        return this.getPageNoSchema().getNextPageToken();
    }

    public TableResult getNextPage() {
        if (this.getPageNoSchema().hasNextPage()) {
            return TableResult.newBuilder().setSchema(this.getSchema()).setTotalRows(this.getTotalRows()).setPageNoSchema(this.getPageNoSchema().getNextPage()).setQueryId(this.getQueryId()).build();
        }
        return null;
    }

    @Override
    public Iterable<FieldValueList> iterateAll() {
        return this.addSchema(this.getPageNoSchema().iterateAll());
    }

    @Override
    public Iterable<FieldValueList> getValues() {
        return this.addSchema(this.getPageNoSchema().getValues());
    }

    private Iterable<FieldValueList> addSchema(Iterable<FieldValueList> iter) {
        if (this.getSchema() == null) {
            return iter;
        }
        return Iterables.transform(iter, new Function<FieldValueList, FieldValueList>(){

            @Override
            public FieldValueList apply(FieldValueList list) {
                return list.withSchema(TableResult.this.getSchema().getFields());
            }
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("rows", this.getValues()).add("schema", this.getSchema()).add("totalRows", this.getTotalRows()).add("cursor", this.getNextPageToken()).add("queryId", this.getQueryId()).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.getPageNoSchema(), this.getSchema(), this.getTotalRows(), this.getQueryId());
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(AutoValue_TableResult.class)) {
            return false;
        }
        TableResult response = (TableResult)obj;
        return Objects.equals(this.getNextPageToken(), response.getNextPageToken()) && Iterators.elementsEqual(this.getValues().iterator(), response.getValues().iterator()) && Objects.equals(this.getSchema(), response.getSchema()) && this.getTotalRows() == response.getTotalRows() && this.getQueryId() == response.getQueryId();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSchema(Schema var1);

        public abstract Builder setTotalRows(Long var1);

        public abstract Builder setJobId(JobId var1);

        public abstract Builder setPageNoSchema(Page<FieldValueList> var1);

        public abstract Builder setQueryId(String var1);

        public abstract TableResult build();
    }
}

