/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.AutoValue_Range;
import com.google.cloud.bigquery.FieldElementType;
import com.google.cloud.bigquery.FieldValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import javax.annotation.Nullable;

@AutoValue
public abstract class Range
implements Serializable {
    private static final long serialVersionUID = 1L;

    public FieldValue getStart() {
        return FieldValue.of(FieldValue.Attribute.PRIMITIVE, this.getStartInner());
    }

    @Nullable
    abstract String getStartInner();

    public FieldValue getEnd() {
        return FieldValue.of(FieldValue.Attribute.PRIMITIVE, this.getEndInner());
    }

    @Nullable
    abstract String getEndInner();

    public ImmutableMap<String, String> getValues() {
        ImmutableMap.Builder<String, String> result = ImmutableMap.builder();
        if (!this.getStart().isNull()) {
            result.put("start", this.getStart().getStringValue());
        }
        if (!this.getEnd().isNull()) {
            result.put("end", this.getEnd().getStringValue());
        }
        return result.build();
    }

    @Nullable
    public abstract FieldElementType getType();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_Range.Builder();
    }

    public static Range of(String value) throws IllegalArgumentException {
        return Range.of(value, null);
    }

    public static Range of(String value, FieldElementType type) throws IllegalArgumentException {
        String[] startEnd;
        Preconditions.checkNotNull(value);
        Builder builder = Range.newBuilder();
        if (type != null) {
            builder.setType(type);
        }
        if ((startEnd = value.split(", ", 2)).length != 2) {
            throw new IllegalArgumentException(String.format("Expected Range value string to be [start, end) and got %s", value));
        }
        String start = startEnd[0].substring(1);
        String end = startEnd[1].substring(0, startEnd[1].length() - 1);
        if (start.equalsIgnoreCase("UNBOUNDED") || start.equalsIgnoreCase("NULL")) {
            builder.setStart(null);
        } else {
            builder.setStart(start);
        }
        if (end.equalsIgnoreCase("UNBOUNDED") || end.equalsIgnoreCase("NULL")) {
            builder.setEnd(null);
        } else {
            builder.setEnd(end);
        }
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public Builder setStart(String start) {
            return this.setStartInner(start);
        }

        abstract Builder setStartInner(String var1);

        public Builder setEnd(String end) {
            return this.setEndInner(end);
        }

        abstract Builder setEndInner(String var1);

        public abstract Builder setType(FieldElementType var1);

        public abstract Range build();
    }
}

