/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.cloud.bigquery.BigQueryError;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InsertAllResponse
implements Serializable {
    private static final long serialVersionUID = -6934152676514098452L;
    private final Map<Long, List<BigQueryError>> insertErrors;

    InsertAllResponse(Map<Long, List<BigQueryError>> insertErrors) {
        this.insertErrors = insertErrors != null ? ImmutableMap.copyOf(insertErrors) : ImmutableMap.of();
    }

    public Map<Long, List<BigQueryError>> getInsertErrors() {
        return this.insertErrors;
    }

    public List<BigQueryError> getErrorsFor(long index) {
        return this.insertErrors.get(index);
    }

    public boolean hasErrors() {
        return !this.insertErrors.isEmpty();
    }

    public final int hashCode() {
        return Objects.hash(this.insertErrors);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(InsertAllResponse.class) && Objects.equals(this.insertErrors, ((InsertAllResponse)obj).insertErrors);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("insertErrors", this.insertErrors).toString();
    }

    TableDataInsertAllResponse toPb() {
        TableDataInsertAllResponse responsePb = new TableDataInsertAllResponse();
        if (!this.insertErrors.isEmpty()) {
            responsePb.setInsertErrors(ImmutableList.copyOf(Iterables.transform(this.insertErrors.entrySet(), new Function<Map.Entry<Long, List<BigQueryError>>, TableDataInsertAllResponse.InsertErrors>(){

                @Override
                public TableDataInsertAllResponse.InsertErrors apply(Map.Entry<Long, List<BigQueryError>> entry) {
                    return new TableDataInsertAllResponse.InsertErrors().setIndex(entry.getKey()).setErrors(Lists.transform(entry.getValue(), BigQueryError.TO_PB_FUNCTION));
                }
            })));
        }
        return responsePb;
    }

    static InsertAllResponse fromPb(TableDataInsertAllResponse responsePb) {
        HashMap<Long, List<BigQueryError>> insertErrors = null;
        if (responsePb.getInsertErrors() != null) {
            List<TableDataInsertAllResponse.InsertErrors> errorsPb = responsePb.getInsertErrors();
            insertErrors = Maps.newHashMapWithExpectedSize(errorsPb.size());
            for (TableDataInsertAllResponse.InsertErrors errorPb : errorsPb) {
                insertErrors.put(errorPb.getIndex(), Lists.transform(errorPb.getErrors() != null ? errorPb.getErrors() : ImmutableList.of(), BigQueryError.FROM_PB_FUNCTION));
            }
        }
        return new InsertAllResponse(insertErrors);
    }
}

