/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.InternalApi;
import com.google.api.gax.logging.LogData;
import com.google.api.gax.logging.LoggerProvider;
import com.google.api.gax.logging.LoggingUtils;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class GrpcLoggingInterceptor
implements ClientInterceptor {
    private static final LoggerProvider LOGGER_PROVIDER = LoggerProvider.forClazz(GrpcLoggingInterceptor.class);
    ClientCall.Listener<?> currentListener;

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){
            LogData.Builder logDataBuilder;
            {
                super(delegate);
                this.logDataBuilder = LogData.builder();
            }

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                ForwardingClientCallListener.SimpleForwardingClientCallListener responseLoggingListener;
                LoggingUtils.recordServiceRpcAndRequestHeaders(method.getServiceName(), method.getFullMethodName(), null, GrpcLoggingInterceptor.metadataHeadersToMap(headers), this.logDataBuilder, LOGGER_PROVIDER);
                GrpcLoggingInterceptor.this.currentListener = responseLoggingListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    @Override
                    public void onHeaders(Metadata headers) {
                        LoggingUtils.recordResponseHeaders(GrpcLoggingInterceptor.metadataHeadersToMap(headers), logDataBuilder, LOGGER_PROVIDER);
                        super.onHeaders(headers);
                    }

                    @Override
                    public void onMessage(RespT message) {
                        LoggingUtils.recordResponsePayload(message, logDataBuilder, LOGGER_PROVIDER);
                        super.onMessage(message);
                    }

                    @Override
                    public void onClose(Status status, Metadata trailers) {
                        LoggingUtils.logResponse(status.getCode().toString(), logDataBuilder, LOGGER_PROVIDER);
                        super.onClose(status, trailers);
                    }
                };
                super.start(responseLoggingListener, headers);
            }

            @Override
            public void sendMessage(ReqT message) {
                LoggingUtils.logRequest(message, this.logDataBuilder, LOGGER_PROVIDER);
                super.sendMessage(message);
            }
        };
    }

    private static Map<String, String> metadataHeadersToMap(Metadata headers) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        LoggingUtils.executeWithTryCatch(() -> {
            for (String key : headers.keys()) {
                if (key.endsWith("-bin")) continue;
                Metadata.Key<String> metadataKey = Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER);
                String headerValue = headers.get(metadataKey);
                headersMap.put(key, headerValue);
            }
        });
        return headersMap;
    }
}

