/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.extensions.servlet.notifications.jakarta;

import com.google.api.client.googleapis.notifications.StoredChannel;
import com.google.api.client.googleapis.notifications.UnparsedNotification;
import com.google.api.client.util.Beta;
import com.google.api.client.util.LoggingInputStream;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StringUtils;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.DataStoreFactory;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

@Beta
public final class WebhookUtils {
    static final Logger LOGGER = Logger.getLogger(WebhookUtils.class.getName());
    public static final String TYPE = "web_hook";

    public static void processWebhookNotification(HttpServletRequest req, HttpServletResponse resp, DataStoreFactory dataStoreFactory) throws ServletException, IOException {
        WebhookUtils.processWebhookNotification(req, resp, StoredChannel.getDefaultDataStore(dataStoreFactory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processWebhookNotification(HttpServletRequest req, HttpServletResponse resp, DataStore<StoredChannel> channelDataStore) throws ServletException, IOException {
        Preconditions.checkArgument("POST".equals(req.getMethod()));
        try (InputStream contentStream = req.getInputStream();){
            Long messageNumber;
            if (LOGGER.isLoggable(Level.CONFIG)) {
                StringBuilder builder = new StringBuilder();
                Enumeration<String> e = req.getHeaderNames();
                if (e != null) {
                    while (e.hasMoreElements()) {
                        String name;
                        Enumeration<String> ev;
                        String nameObj = e.nextElement();
                        if (!(nameObj instanceof String) || (ev = req.getHeaders(name = nameObj)) == null) continue;
                        while (ev.hasMoreElements()) {
                            builder.append(name).append(": ").append((Object)ev.nextElement()).append(StringUtils.LINE_SEPARATOR);
                        }
                    }
                }
                LOGGER.config(builder.toString());
                contentStream = new LoggingInputStream(contentStream, LOGGER, Level.CONFIG, 16384);
            }
            try {
                messageNumber = Long.valueOf(req.getHeader("X-Goog-Message-Number"));
            }
            catch (NumberFormatException e) {
                messageNumber = null;
            }
            String resourceState = req.getHeader("X-Goog-Resource-State");
            String resourceId = req.getHeader("X-Goog-Resource-ID");
            String resourceUri = req.getHeader("X-Goog-Resource-URI");
            String channelId = req.getHeader("X-Goog-Channel-ID");
            String channelExpiration = req.getHeader("X-Goog-Channel-Expiration");
            String channelToken = req.getHeader("X-Goog-Channel-Token");
            String changed = req.getHeader("X-Goog-Changed");
            if (messageNumber == null || resourceState == null || resourceId == null || resourceUri == null || channelId == null) {
                resp.sendError(400, "Notification did not contain all required information.");
                return;
            }
            UnparsedNotification notification = new UnparsedNotification(messageNumber, resourceState, resourceId, resourceUri, channelId).setChannelExpiration(channelExpiration).setChannelToken(channelToken).setChanged(changed).setContentType(req.getContentType()).setContentStream(contentStream);
            StoredChannel storedChannel = channelDataStore.get(notification.getChannelId());
            if (storedChannel != null) {
                storedChannel.getNotificationCallback().onNotification(storedChannel, notification);
            }
        }
    }

    private WebhookUtils() {
    }
}

