/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.rules;

import app.freerouting.board.BasicBoard;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.TextManager;
import app.freerouting.rules.Net;
import app.freerouting.rules.NetClasses;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Vector;

public class Nets
implements Serializable {
    public static final int max_legal_net_no = 9999999;
    public static final int hidden_net_no = 10000001;
    private final Vector<Net> net_arr = new Vector();
    private BasicBoard board;

    public static boolean is_normal_net_no(int p_net_no) {
        return p_net_no > 0 && p_net_no <= 9999999;
    }

    public int max_net_no() {
        return this.net_arr.size();
    }

    public Net get(String p_name, int p_subnet_number) {
        for (Net curr_net : this.net_arr) {
            if (curr_net == null || !curr_net.name.equalsIgnoreCase(p_name) || curr_net.subnet_number != p_subnet_number) continue;
            return curr_net;
        }
        return null;
    }

    public Collection<Net> get(String p_name) {
        LinkedList<Net> result = new LinkedList<Net>();
        for (Net curr_net : this.net_arr) {
            if (curr_net == null || !curr_net.name.equalsIgnoreCase(p_name)) continue;
            result.add(curr_net);
        }
        return result;
    }

    public Net get(int p_net_no) {
        if (p_net_no < 1 || p_net_no > this.net_arr.size()) {
            return null;
        }
        Net result = this.net_arr.elementAt(p_net_no - 1);
        if (result != null && result.net_number != p_net_no) {
            FRLogger.warn("Nets.get: inconsistent net_no");
        }
        return result;
    }

    public Net new_net(Locale p_locale) {
        TextManager tm = new TextManager(NetClasses.class, p_locale);
        String net_name = tm.getText("net#", new String[0]) + (this.net_arr.size() + 1);
        return this.add(net_name, 1, false);
    }

    public Net add(String p_name, int p_subnet_number, boolean p_contains_plane) {
        int new_net_no = this.net_arr.size() + 1;
        if (new_net_no >= 9999999) {
            FRLogger.warn("Nets.add_net: max_net_no out of range");
        }
        Net new_net = new Net(p_name, p_subnet_number, new_net_no, this, p_contains_plane);
        this.net_arr.add(new_net);
        return new_net;
    }

    public BasicBoard get_board() {
        return this.board;
    }

    public void set_board(BasicBoard p_board) {
        this.board = p_board;
    }
}

