/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.rules;

import app.freerouting.board.LayerStructure;
import app.freerouting.management.TextManager;
import app.freerouting.rules.ClearanceMatrix;
import app.freerouting.rules.NetClass;
import app.freerouting.rules.ViaRule;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;

public class NetClasses
implements Serializable {
    private final Vector<NetClass> class_arr = new Vector();

    public int count() {
        return this.class_arr.size();
    }

    public NetClass get(int p_index) {
        assert (p_index >= 0 && p_index <= this.class_arr.size() - 1);
        return this.class_arr.get(p_index);
    }

    public NetClass get(String p_name) {
        for (NetClass curr_class : this.class_arr) {
            if (!curr_class.get_name().equals(p_name)) continue;
            return curr_class;
        }
        return null;
    }

    NetClass append(String p_name, LayerStructure p_layer_structure, ClearanceMatrix p_clearance_matrix, boolean p_is_ignored_by_autorouter) {
        NetClass new_class = new NetClass(p_name, p_layer_structure, p_clearance_matrix, p_is_ignored_by_autorouter);
        this.class_arr.add(new_class);
        return new_class;
    }

    NetClass append(LayerStructure p_layer_structure, ClearanceMatrix p_clearance_matrix, Locale p_locale) {
        String new_name;
        TextManager tm = new TextManager(NetClasses.class, p_locale);
        String name_front = tm.getText("class", new String[0]);
        int index = 0;
        while (this.get(new_name = name_front + ++index) != null) {
        }
        return this.append(new_name, p_layer_structure, p_clearance_matrix, false);
    }

    public NetClass find(int p_trace_half_width, int p_trace_clearance_class, ViaRule p_via_rule) {
        for (NetClass curr_class : this.class_arr) {
            if (curr_class.get_trace_clearance_class() != p_trace_clearance_class || curr_class.get_via_rule() != p_via_rule) continue;
            boolean trace_widths_equal = true;
            for (int i = 0; i < curr_class.layer_count(); ++i) {
                if (curr_class.get_trace_half_width(i) == p_trace_half_width) continue;
                trace_widths_equal = false;
                break;
            }
            if (!trace_widths_equal) continue;
            return curr_class;
        }
        return null;
    }

    public NetClass find(int[] p_trace_half_width_arr, int p_trace_clearance_class, ViaRule p_via_rule) {
        for (NetClass curr_class : this.class_arr) {
            if (curr_class.get_trace_clearance_class() != p_trace_clearance_class || curr_class.get_via_rule() != p_via_rule || p_trace_half_width_arr.length != curr_class.layer_count()) continue;
            boolean trace_widths_equal = true;
            for (int i = 0; i < curr_class.layer_count(); ++i) {
                if (curr_class.get_trace_half_width(i) == p_trace_half_width_arr[i]) continue;
                trace_widths_equal = false;
                break;
            }
            if (!trace_widths_equal) continue;
            return curr_class;
        }
        return null;
    }

    public boolean remove(NetClass p_net_class) {
        return this.class_arr.remove(p_net_class);
    }
}

