/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.rules;

import app.freerouting.board.BasicBoard;
import app.freerouting.board.Connectable;
import app.freerouting.board.Item;
import app.freerouting.board.ObjectInfoPanel;
import app.freerouting.board.Pin;
import app.freerouting.board.Trace;
import app.freerouting.board.Via;
import app.freerouting.datastructures.UndoableObjects;
import app.freerouting.management.TextManager;
import app.freerouting.rules.NetClass;
import app.freerouting.rules.Nets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;

public class Net
implements Comparable<Net>,
ObjectInfoPanel.Printable,
Serializable {
    public final String name;
    public final int subnet_number;
    public final int net_number;
    public final Nets net_list;
    private boolean contains_plane;
    private NetClass net_class;

    public Net(String p_name, int p_subnet_number, int p_no, Nets p_net_list, boolean p_contains_plane) {
        this.name = p_name;
        this.subnet_number = p_subnet_number;
        this.net_number = p_no;
        this.contains_plane = p_contains_plane;
        this.net_list = p_net_list;
        this.net_class = p_net_list.get_board().rules.get_default_net_class();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Net p_other) {
        return this.name.compareToIgnoreCase(p_other.name);
    }

    public NetClass get_class() {
        return this.net_class;
    }

    public void set_class(NetClass p_rule) {
        this.net_class = p_rule;
    }

    public Collection<Item> get_terminal_items() {
        Item curr_item;
        LinkedList<Item> result = new LinkedList<Item>();
        BasicBoard board = this.net_list.get_board();
        Iterator<UndoableObjects.UndoableObjectNode> it = board.item_list.start_read_object();
        while ((curr_item = (Item)board.item_list.read_object(it)) != null) {
            if (!(curr_item instanceof Connectable) || !curr_item.contains_net(this.net_number) || curr_item.is_routable()) continue;
            result.add(curr_item);
        }
        return result;
    }

    public Collection<Pin> get_pins() {
        Item curr_item;
        LinkedList<Pin> result = new LinkedList<Pin>();
        BasicBoard board = this.net_list.get_board();
        Iterator<UndoableObjects.UndoableObjectNode> it = board.item_list.start_read_object();
        while ((curr_item = (Item)board.item_list.read_object(it)) != null) {
            if (!(curr_item instanceof Pin) || !curr_item.contains_net(this.net_number)) continue;
            result.add((Pin)curr_item);
        }
        return result;
    }

    public Collection<Item> get_items() {
        Item curr_item;
        LinkedList<Item> result = new LinkedList<Item>();
        BasicBoard board = this.net_list.get_board();
        Iterator<UndoableObjects.UndoableObjectNode> it = board.item_list.start_read_object();
        while ((curr_item = (Item)board.item_list.read_object(it)) != null) {
            if (!curr_item.contains_net(this.net_number)) continue;
            result.add(curr_item);
        }
        return result;
    }

    public double get_trace_length() {
        double cumulative_trace_length = 0.0;
        Collection<Item> net_items = this.net_list.get_board().get_connectable_items(this.net_number);
        for (Item curr_item : net_items) {
            if (!(curr_item instanceof Trace)) continue;
            cumulative_trace_length += ((Trace)curr_item).get_length();
        }
        return cumulative_trace_length;
    }

    public int get_via_count() {
        int result = 0;
        Collection<Item> net_items = this.net_list.get_board().get_connectable_items(this.net_number);
        for (Item curr_item : net_items) {
            if (!(curr_item instanceof Via)) continue;
            ++result;
        }
        return result;
    }

    public void set_contains_plane(boolean p_value) {
        this.contains_plane = p_value;
    }

    public boolean contains_plane() {
        return this.contains_plane;
    }

    @Override
    public void print_info(ObjectInfoPanel p_window, Locale p_locale) {
        int via_count = this.get_via_count();
        double cumulative_trace_length = this.get_trace_length();
        Collection<Item> terminal_items = this.get_terminal_items();
        LinkedList<ObjectInfoPanel.Printable> terminals = new LinkedList<ObjectInfoPanel.Printable>(terminal_items);
        int terminal_item_count = terminals.size();
        TextManager tm = new TextManager(this.getClass(), p_locale);
        p_window.append_bold(tm.getText("net", new String[0]) + " ");
        p_window.append_bold(this.name);
        p_window.append_bold(": ");
        p_window.append(tm.getText("class", new String[0]) + " ");
        p_window.append(this.net_class.get_name(), tm.getText("net_class", new String[0]), this.net_class);
        p_window.append(", ");
        p_window.append_objects(String.valueOf(terminal_item_count), tm.getText("terminal_items_2", new String[0]), terminals);
        p_window.append(" " + tm.getText("terminal_items", new String[0]));
        p_window.append(", " + tm.getText("via_count", new String[0]) + " ");
        p_window.append(String.valueOf(via_count));
        p_window.append(", " + tm.getText("trace_length", new String[0]) + " ");
        p_window.append(cumulative_trace_length);
        p_window.newline();
    }
}

