/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.management.analytics;

import app.freerouting.management.analytics.AnalyticsClient;
import app.freerouting.management.analytics.dto.Context;
import app.freerouting.management.analytics.dto.Library;
import app.freerouting.management.analytics.dto.Payload;
import app.freerouting.management.analytics.dto.Properties;
import app.freerouting.management.analytics.dto.Traits;
import app.freerouting.management.gson.GsonProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class SegmentClient
implements AnalyticsClient {
    private static final String SEGMENT_ENDPOINT = "https://api.segment.io/v1/";
    private final String WRITE_KEY;
    private final String LIBRARY_NAME = "freerouting";
    private final String LIBRARY_VERSION;
    private boolean enabled = true;

    public SegmentClient(String libraryVersion, String writeKey) {
        this.LIBRARY_VERSION = libraryVersion;
        this.WRITE_KEY = writeKey;
    }

    private void sendPayloadAsync(String endpoint, Payload payload) throws IOException {
        if (!this.enabled) {
            return;
        }
        new Thread(() -> {
            try {
                String jsonPayload = GsonProvider.GSON.toJson(payload);
                URL url = new URI(endpoint).toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json; utf-8");
                connection.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.WRITE_KEY + ":").getBytes()));
                connection.setDoOutput(true);
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                    String responseLine;
                    StringBuilder response = new StringBuilder();
                    while ((responseLine = br.readLine()) != null) {
                        response.append(responseLine.trim());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).start();
    }

    @Override
    public void identify(String userId, String anonymousId, Traits traits) throws IOException {
        Payload payload = new Payload();
        payload.userId = userId;
        payload.anonymousId = anonymousId;
        payload.context = new Context();
        payload.context.library = new Library();
        payload.context.library.name = "freerouting";
        payload.context.library.version = this.LIBRARY_VERSION;
        payload.traits = traits;
        this.sendPayloadAsync("https://api.segment.io/v1/identify", payload);
    }

    @Override
    public void track(String userId, String anonymousId, String event, Properties properties) throws IOException {
        Payload payload = new Payload();
        payload.userId = userId;
        payload.anonymousId = anonymousId;
        payload.context = new Context();
        payload.context.library = new Library();
        payload.context.library.name = "freerouting";
        payload.context.library.version = this.LIBRARY_VERSION;
        payload.event = event;
        payload.properties = properties;
        this.sendPayloadAsync("https://api.segment.io/v1/track", payload);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

