/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.management;

import app.freerouting.Freerouting;
import app.freerouting.core.Session;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class SessionManager {
    private static final SessionManager instance = new SessionManager();
    private static final Map<String, Session> sessions = new HashMap<String, Session>();

    private SessionManager() {
    }

    public static SessionManager getInstance() {
        return instance;
    }

    public Session getSession(String sessionId) {
        return sessions.get(sessionId);
    }

    public Session getSession(String sessionId, UUID userId) {
        Session session = this.getSession(sessionId);
        if (session == null) {
            return null;
        }
        if (!session.userId.equals(userId)) {
            return null;
        }
        return session;
    }

    public Session createSession(UUID userId, String host) {
        Session session = new Session(userId, host);
        sessions.put(session.id.toString(), session);
        Freerouting.globalSettings.statistics.incrementSessionsTotal();
        return session;
    }

    public void removeSession(String sessionId) {
        sessions.remove(sessionId);
    }

    public int getActiveSessionsCount() {
        return sessions.size();
    }

    public String[] listSessionIds(UUID userId) {
        return (String[])Arrays.stream(this.getSessions(null, userId)).map(s2 -> s2.id.toString()).toArray(String[]::new);
    }

    public Session getGuiSession() throws IllegalArgumentException {
        for (Session session : sessions.values()) {
            if (!session.isGuiSession) continue;
            return session;
        }
        throw new IllegalArgumentException("There is no GUI session.");
    }

    public void setGuiSession(UUID sessionId) throws IllegalArgumentException {
        for (Session session : sessions.values()) {
            if (!session.isGuiSession) continue;
            throw new IllegalArgumentException("There is already a GUI session.");
        }
        Session session = sessions.get(sessionId.toString());
        if (session == null) {
            throw new IllegalArgumentException("Session with id " + String.valueOf(sessionId) + " does not exist.");
        }
        session.isGuiSession = true;
        if (!session.host.startsWith("Freerouting/")) {
            throw new IllegalArgumentException("Session with id " + String.valueOf(sessionId) + " and host " + session.host + " is not a valid GUI session. GUI sessions must have the prefix 'Freerouting/' for their host value.");
        }
    }

    public Session[] getSessions(String sessionId, UUID userId) {
        if (sessionId == null) {
            return (Session[])sessions.values().stream().filter(s2 -> s2.userId.equals(userId)).toArray(Session[]::new);
        }
        return new Session[]{sessions.get(sessionId)};
    }
}

