/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.management;

import app.freerouting.Freerouting;
import app.freerouting.autoroute.BatchAutorouter;
import app.freerouting.autoroute.BatchFanout;
import app.freerouting.autoroute.BatchOptimizer;
import app.freerouting.autoroute.events.BoardUpdatedEvent;
import app.freerouting.autoroute.events.BoardUpdatedEventListener;
import app.freerouting.core.BoardFileDetails;
import app.freerouting.core.RoutingJob;
import app.freerouting.core.RoutingJobState;
import app.freerouting.core.RoutingStage;
import app.freerouting.core.StoppableThread;
import app.freerouting.gui.FileFormat;
import app.freerouting.interactive.HeadlessBoardManager;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.TextManager;
import com.sun.management.ThreadMXBean;
import java.io.ByteArrayOutputStream;
import java.lang.management.ManagementFactory;
import java.time.Instant;

public class RoutingJobSchedulerActionThread
extends StoppableThread {
    private final long MAX_TIMEOUT = 86400L;
    private final int GRACE_PERIOD = 30;
    RoutingJob job;

    public RoutingJobSchedulerActionThread(RoutingJob job) {
        this.job = job;
    }

    @Override
    protected void thread_action() {
        this.job.startedAt = Instant.now();
        this.job.logInfo("Job '" + this.job.shortName + "' started at " + this.job.startedAt.toString() + " with the seed of " + TextManager.longToHexadecimalString(this.job.routerSettings.random_seed) + ".");
        Long timeout = TextManager.parseTimespanString(this.job.routerSettings.jobTimeoutString);
        if (timeout != null) {
            if (timeout > 86400L) {
                timeout = 86400L;
            }
            this.job.timeoutAt = this.job.startedAt.plusSeconds(timeout);
        }
        new Thread(() -> {
            while (this.job != null && this.job.thread != null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.job.state != RoutingJobState.RUNNING) continue;
                this.monitorCpuAndMemoryUsage(this.job);
                if (Instant.now().isBefore(this.job.timeoutAt)) continue;
                this.job.thread.requestStop();
                while (this.job.state == RoutingJobState.RUNNING && Instant.now().isBefore(this.job.timeoutAt.plusSeconds(30L))) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.job.state = RoutingJobState.TIMED_OUT;
            }
        }).start();
        if (this.job.routerSettings.getRunFanout()) {
            this.job.stage = RoutingStage.FANOUT;
            BatchFanout fanout = new BatchFanout(this.job);
            fanout.addBoardUpdatedEventListener(new BoardUpdatedEventListener(){

                @Override
                public void onBoardUpdatedEvent(BoardUpdatedEvent event) {
                    RoutingJobSchedulerActionThread.this.setJobOutputToSpecctraSes(RoutingJobSchedulerActionThread.this.job);
                }
            });
            fanout.runBatchLoop();
            this.job.stage = RoutingStage.IDLE;
        }
        if (this.job.routerSettings.getRunRouter()) {
            this.job.stage = RoutingStage.ROUTING;
            BatchAutorouter router = new BatchAutorouter(this.job);
            router.addBoardUpdatedEventListener(new BoardUpdatedEventListener(){

                @Override
                public void onBoardUpdatedEvent(BoardUpdatedEvent event) {
                    RoutingJobSchedulerActionThread.this.setJobOutputToSpecctraSes(RoutingJobSchedulerActionThread.this.job);
                }
            });
            router.runBatchLoop();
            this.job.stage = RoutingStage.IDLE;
        }
        if (this.job.routerSettings.getRunOptimizer()) {
            this.job.stage = RoutingStage.OPTIMIZATION;
            BatchOptimizer optimizer = new BatchOptimizer(this.job);
            optimizer.addBoardUpdatedEventListener(new BoardUpdatedEventListener(){

                @Override
                public void onBoardUpdatedEvent(BoardUpdatedEvent event) {
                    RoutingJobSchedulerActionThread.this.setJobOutputToSpecctraSes(RoutingJobSchedulerActionThread.this.job);
                }
            });
            optimizer.runBatchLoop();
            this.job.stage = RoutingStage.IDLE;
        }
        this.job.finishedAt = Instant.now();
        if (this.job.state == RoutingJobState.RUNNING) {
            this.job.state = RoutingJobState.COMPLETED;
            Freerouting.globalSettings.statistics.incrementJobsCompleted();
        }
    }

    private void monitorCpuAndMemoryUsage(RoutingJob job) {
        long[] threadIds;
        ThreadMXBean threadMXBean = (ThreadMXBean)ManagementFactory.getThreadMXBean();
        for (long threadId : threadIds = threadMXBean.getAllThreadIds()) {
            if (threadId != job.thread.threadId()) continue;
            float cpuTime = (float)threadMXBean.getThreadCpuTime(threadId) / 1000.0f / 1000.0f / 1000.0f;
            threadMXBean.setThreadAllocatedMemoryEnabled(true);
            long allocatedMemory = threadMXBean.getThreadAllocatedBytes(threadId);
            float allocatedMB = (float)allocatedMemory / 1048576.0f;
            job.resourceUsage.cpuTimeUsed += cpuTime;
            job.resourceUsage.maxMemoryUsed = Math.max(job.resourceUsage.maxMemoryUsed, allocatedMB);
        }
    }

    private void setJobOutputToSpecctraSes(RoutingJob job) {
        if (job.output == null) {
            job.output = new BoardFileDetails(job.board);
            job.output.addUpdatedEventListener(e -> job.fireOutputUpdatedEvent());
            job.output.format = FileFormat.SES;
            job.output.setFilename(job.input.getFilenameWithoutExtension() + ".ses");
        }
        if (job.output.format == FileFormat.SES) {
            HeadlessBoardManager boardManager = new HeadlessBoardManager(null, job);
            boardManager.replaceRoutingBoard(job.board);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                if (boardManager.saveAsSpecctraSessionSes(baos, job.name)) {
                    job.output.setData(baos.toByteArray());
                }
            }
            catch (Exception e2) {
                FRLogger.error("Couldn't save the output into the job object.", e2);
            }
        }
    }
}

