/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.management;

import app.freerouting.Freerouting;
import app.freerouting.board.ItemIdentificationNumberGenerator;
import app.freerouting.core.RoutingJob;
import app.freerouting.core.RoutingJobState;
import app.freerouting.core.Session;
import app.freerouting.gui.FileFormat;
import app.freerouting.interactive.HeadlessBoardManager;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.RoutingJobSchedulerActionThread;
import app.freerouting.management.SessionManager;
import app.freerouting.management.TextManager;
import app.freerouting.management.gson.GsonProvider;
import app.freerouting.settings.GlobalSettings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Predicate;

public class RoutingJobScheduler {
    private static final RoutingJobScheduler instance = new RoutingJobScheduler();
    public final LinkedList<RoutingJob> jobs = new LinkedList();
    private final int maxParallelJobs = 5;

    private RoutingJobScheduler() {
        Thread loopThread = new Thread(this::lambda$new$2);
        loopThread.start();
    }

    public static RoutingJobScheduler getInstance() {
        return instance;
    }

    private String UUIDtoShortCode(UUID uuid) {
        return uuid.toString().substring(0, 6).toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutingJob enqueueJob(RoutingJob job) {
        UUID sessionId = job.sessionId;
        if (sessionId == null) {
            throw new IllegalArgumentException("The job must have a session ID.");
        }
        Session session = SessionManager.getInstance().getSession(sessionId.toString());
        if (session == null) {
            throw new IllegalArgumentException("The session does not exist.");
        }
        UUID userId = session.userId;
        if (userId == null) {
            throw new IllegalArgumentException("The session must have a user ID.");
        }
        job.state = RoutingJobState.QUEUED;
        LinkedList<RoutingJob> linkedList = this.jobs;
        synchronized (linkedList) {
            this.jobs.add(job);
        }
        Freerouting.globalSettings.statistics.incrementJobsStarted();
        return job;
    }

    public void saveJob(RoutingJob job) {
        if (Freerouting.globalSettings.featureFlags.saveJobs) {
            String sessionIdString = "null";
            String userIdString = "null";
            try {
                Session session = SessionManager.getInstance().getSession(job.sessionId.toString());
                if (session == null) {
                    FRLogger.error(String.format("Failed to save job in session '%s' to disk, because the session does not exist.", job.sessionId), null);
                }
                sessionIdString = session.id.toString();
                userIdString = session.userId.toString();
                this.saveJob("U-" + this.UUIDtoShortCode(session.userId), "S-" + this.UUIDtoShortCode(session.id), job);
            }
            catch (IOException e) {
                FRLogger.error(String.format("Failed to save job for user '%s' in session '%s' to disk.", userIdString, sessionIdString), e);
            }
        }
    }

    private void saveJob(String userFolder, String sessionFolder, RoutingJob job) throws IOException {
        Path userFolderPath = GlobalSettings.getUserDataPath().resolve("data").resolve(userFolder);
        Files.createDirectories(userFolderPath, new FileAttribute[0]);
        Path sessionFolderPath = Files.list(userFolderPath).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(sessionFolder)).findFirst().orElse(null);
        if (sessionFolderPath == null) {
            int jobFolderCount = Files.list(userFolderPath).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).map(s2 -> s2.split("_")[0]).filter(s2 -> s2.matches("\\d+")).mapToInt(Integer::parseInt).max().orElse(0);
            sessionFolderPath = userFolderPath.resolve(String.format("%04d", jobFolderCount + 1) + "_" + sessionFolder);
        }
        Files.createDirectories(sessionFolderPath, new FileAttribute[0]);
        String jobFilename = "FRJ_" + TextManager.convertInstantToString(job.createdAt) + "__J-" + this.UUIDtoShortCode(job.id) + ".json";
        Path jobFilePath = sessionFolderPath.resolve(jobFilename);
        try (BufferedWriter writer = Files.newBufferedWriter(jobFilePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            GsonProvider.GSON.toJson((Object)job, (Appendable)writer);
        }
        catch (Exception e) {
            FRLogger.error(String.format("Failed to save job '%s' to disk.", job.id), e);
        }
        if (job.input != null && job.input.getFilename() != null && !job.input.getFilename().isEmpty() && job.input.getData() != null) {
            Path inputFilePath = sessionFolderPath.resolve(job.input.getFilename());
            Files.write(inputFilePath, job.input.getData().readAllBytes(), new OpenOption[0]);
        }
        if (job.output != null && job.output.getFilename() != null && !job.output.getFilename().isEmpty() && job.output.getData() != null) {
            Path outputFilePath = sessionFolderPath.resolve(job.output.getFilename());
            Files.write(outputFilePath, job.output.getData().readAllBytes(), new OpenOption[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueuePosition(RoutingJob job) {
        LinkedList<RoutingJob> linkedList = this.jobs;
        synchronized (linkedList) {
            return this.jobs.indexOf(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutingJob[] listJobs() {
        LinkedList<RoutingJob> linkedList = this.jobs;
        synchronized (linkedList) {
            return (RoutingJob[])this.jobs.toArray(RoutingJob[]::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutingJob[] listJobs(String sessionId) {
        LinkedList<RoutingJob> linkedList = this.jobs;
        synchronized (linkedList) {
            return (RoutingJob[])this.jobs.stream().filter(j -> j.sessionId.toString().equals(sessionId)).toArray(RoutingJob[]::new);
        }
    }

    public RoutingJob[] listJobs(String sessionId, UUID userId) {
        SessionManager sessionManager = SessionManager.getInstance();
        if (sessionId == null) {
            Session[] sessions = sessionManager.getSessions(null, userId);
            LinkedList<RoutingJob> result = new LinkedList<RoutingJob>();
            for (Session session : sessions) {
                result.addAll(List.of(this.listJobs(session.id.toString())));
            }
            return (RoutingJob[])result.toArray(RoutingJob[]::new);
        }
        Session session = sessionManager.getSession(sessionId, userId);
        if (session != null) {
            return this.listJobs(session.id.toString());
        }
        return new RoutingJob[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutingJob getJob(String jobId) {
        LinkedList<RoutingJob> linkedList = this.jobs;
        synchronized (linkedList) {
            return this.jobs.stream().filter(j -> j.id.toString().equals(jobId)).findFirst().orElse(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJobs(String sessionId) {
        LinkedList<RoutingJob> linkedList = this.jobs;
        synchronized (linkedList) {
            this.jobs.removeIf(j -> j.sessionId.toString().equals(sessionId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private /* synthetic */ void lambda$new$2() {
        block4: while (true) {
            try lbl-1000:
            // 3 sources

            {
                while (true) {
                    if (this.jobs.stream().count() > 0L) {
                        var2_3 = this.jobs;
                        // MONITORENTER : this.jobs
                        Collections.sort(this.jobs);
                        jobsArray = (RoutingJob[])this.jobs.toArray((IntFunction<RoutingJob[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$new$0(int ), (I)[Lapp/freerouting/core/RoutingJob;)());
                        // MONITOREXIT : var2_3
                        var2_3 = jobsArray;
                        var3_4 = var2_3.length;
                        var4_5 = 0;
                        break block4;
                    }
                    Thread.sleep(250L);
                    continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                FRLogger.error("RoutingJobScheduler thread was interrupted.", e);
                continue;
            }
            break;
        }
        while (true) {
            if (var4_5 >= var3_4) ** GOTO lbl-1000
            job = var2_3[var4_5];
            if (job.state != RoutingJobState.READY_TO_START) ** GOTO lbl45
            parallelJobs = (int)this.jobs.stream().filter((Predicate<RoutingJob>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$1(app.freerouting.core.RoutingJob ), (Lapp/freerouting/core/RoutingJob;)Z)()).count();
            if (parallelJobs < 5) ** break;
            ** continue;
            if (job.input == null || job.input.getData() == null) {
                FRLogger.warn("RoutingJob input is null, it is skipped.");
                job.state = RoutingJobState.INVALID;
            } else if (job.input.format != FileFormat.DSN) {
                FRLogger.warn("Only DSN format is supported as an input.");
                job.state = RoutingJobState.INVALID;
            } else {
                boardManager = new HeadlessBoardManager(null, job);
                boardManager.loadFromSpecctraDsn(job.input.getData(), null, new ItemIdentificationNumberGenerator());
                job.board = boardManager.get_routing_board();
                routerThread = new RoutingJobSchedulerActionThread(job);
                job.thread = routerThread;
                job.thread.start();
                job.state = RoutingJobState.RUNNING;
lbl45:
                // 2 sources

                if (job.state != RoutingJobState.COMPLETED || job.output == null || job.output.size == 0L) {
                    // empty if block
                }
            }
            ++var4_5;
        }
    }

    private static /* synthetic */ boolean lambda$new$1(RoutingJob j) {
        return j.state == RoutingJobState.RUNNING;
    }

    private static /* synthetic */ RoutingJob[] lambda$new$0(int x$0) {
        return new RoutingJob[x$0];
    }
}

