/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.logger;

import app.freerouting.Freerouting;
import app.freerouting.logger.LogEntries;
import app.freerouting.logger.LogEntry;
import app.freerouting.logger.LogEntryType;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class FRLogger {
    public static final DecimalFormat defaultFloatFormat = new DecimalFormat("0.00");
    public static final DecimalFormat defaultSignedFloatFormat = new DecimalFormat("+0.00;-0.00");
    private static final HashMap<Integer, Instant> perfData = new HashMap();
    private static final LogEntries logEntries = new LogEntries();
    private static Logger logger;
    private static boolean enabled;

    public static String formatDuration(double totalSeconds) {
        String hoursText;
        double seconds = totalSeconds;
        double minutes = seconds / 60.0;
        double hours = minutes / 60.0;
        hours = Math.floor(hours);
        minutes = Math.floor(minutes % 60.0);
        Object object = hours > 0.0 ? (int)hours + (hours == 1.0 ? " hour " : " hours ") : (hoursText = "");
        String minutesText = minutes > 0.0 ? (int)minutes + (minutes == 1.0 ? " minute " : " minutes ") : "";
        return hoursText + minutesText + defaultFloatFormat.format(seconds %= 60.0) + " seconds";
    }

    public static String formatScore(float score, int incomplete, int violations) {
        StringBuilder sb = new StringBuilder(defaultFloatFormat.format(score));
        if (incomplete > 0 || violations > 0) {
            sb.append(" (");
            if (incomplete > 0) {
                sb.append(incomplete).append(" unrouted");
            }
            if (incomplete > 0 && violations > 0) {
                sb.append(" and ");
            }
            if (violations > 0) {
                sb.append(violations).append(violations == 1 ? " violation" : " violations");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public static void traceEntry(String perfId) {
        if (!enabled) {
            return;
        }
        if (logger == null) {
            logger = LogManager.getLogger(Freerouting.class);
        }
        perfData.put(perfId.hashCode(), Instant.now());
    }

    public static double traceExit(String perfId) {
        if (!enabled) {
            return 0.0;
        }
        if (logger == null) {
            logger = LogManager.getLogger(Freerouting.class);
        }
        return FRLogger.traceExit(perfId, null);
    }

    public static double traceExit(String perfId, Object result) {
        if (!enabled) {
            return 0.0;
        }
        if (logger == null) {
            logger = LogManager.getLogger(Freerouting.class);
        }
        long timeElapsed = 0L;
        try {
            timeElapsed = Duration.between(perfData.get(perfId.hashCode()), Instant.now()).toMillis();
        }
        catch (Exception exception) {
            // empty catch block
        }
        perfData.remove(perfId.hashCode());
        if (timeElapsed < 0L) {
            timeElapsed = 0L;
        }
        String logMessage = "Method '" + perfId.replace("{}", result != null ? result.toString() : "(null)") + "' was performed in " + FRLogger.formatDuration((double)timeElapsed / 1000.0) + ".";
        FRLogger.trace(logMessage);
        return (double)timeElapsed / 1000.0;
    }

    public static LogEntry info(String msg, UUID topic) {
        LogEntry logEntry = logEntries.add(LogEntryType.Info, msg, topic);
        if (!enabled) {
            return null;
        }
        if (logger == null) {
            logger = LogManager.getLogger(Freerouting.class);
        }
        logger.info(msg);
        return logEntry;
    }

    public static LogEntry info(String msg) {
        return FRLogger.info(msg, null);
    }

    public static LogEntry warn(String msg, UUID topic) {
        LogEntry logEntry = logEntries.add(LogEntryType.Warning, msg, topic);
        if (!enabled) {
            return null;
        }
        if (logger == null) {
            logger = LogManager.getLogger(Freerouting.class);
        }
        logger.warn(msg);
        return logEntry;
    }

    public static LogEntry warn(String msg) {
        return FRLogger.warn(msg, null);
    }

    public static LogEntry debug(String msg, UUID topic) {
        LogEntry logEntry = logEntries.add(LogEntryType.Debug, msg, topic);
        if (!enabled) {
            return null;
        }
        if (logger == null) {
            logger = LogManager.getLogger(Freerouting.class);
        }
        logger.debug(msg);
        return logEntry;
    }

    public static LogEntry debug(String msg) {
        return FRLogger.debug(msg, null);
    }

    public static LogEntry error(String msg, UUID topic, Throwable exception) {
        LogEntry logEntry = logEntries.add(LogEntryType.Error, msg, topic, exception);
        if (!enabled) {
            return null;
        }
        if (logger == null) {
            logger = LogManager.getLogger(Freerouting.class);
        }
        if (exception == null) {
            logger.error(msg);
        } else {
            logger.error(msg, exception);
        }
        return logEntry;
    }

    public static LogEntry error(String msg, Throwable exception) {
        return FRLogger.error(msg, null, exception);
    }

    public static LogEntry trace(String msg) {
        LogEntry logEntry = logEntries.add(LogEntryType.Trace, msg, null);
        if (!enabled) {
            return null;
        }
        if (logger == null) {
            logger = LogManager.getLogger(Freerouting.class);
        }
        logger.trace(msg);
        return logEntry;
    }

    public static void disableLogging() {
        enabled = false;
    }

    public static LogEntries getLogEntries() {
        return logEntries;
    }

    public static void changeFileLogLevel(Level level) {
        org.apache.logging.log4j.spi.LoggerContext contextObject = LogManager.getContext(false);
        if (!(contextObject instanceof LoggerContext)) {
            FRLogger.warn("Failed to change the log level. The context object is not an instance of org.apache.logging.log4j.core.LoggerContext.");
            return;
        }
        LoggerContext context = (LoggerContext)contextObject;
        Configuration config = context.getConfiguration();
        LoggerConfig rootLoggerConfig = config.getRootLogger();
        List<AppenderRef> refList = rootLoggerConfig.getAppenderRefs();
        AppenderRef[] refs = refList.toArray(new AppenderRef[0]);
        for (int i = 0; i < refs.length; ++i) {
            if (!refs[i].getRef().equals("Console")) continue;
            refs[i] = AppenderRef.createAppenderRef("Console", level, null);
        }
        rootLoggerConfig.removeAppender("Console");
        for (AppenderRef ref : refs) {
            rootLoggerConfig.addAppender((Appender)config.getAppender(ref.getRef()), ref.getLevel(), ref.getFilter());
        }
        context.updateLoggers();
    }

    public static void changeFileLogLevel(String level) {
        String logLevel = level.toUpperCase();
        if (logLevel.equals("OFF") || logLevel.equals("0")) {
            FRLogger.disableLogging();
        } else if (logLevel.equals("FATAL") || logLevel.equals("1")) {
            FRLogger.changeFileLogLevel(Level.FATAL);
        } else if (logLevel.equals("ERROR") || logLevel.equals("2")) {
            FRLogger.changeFileLogLevel(Level.ERROR);
        } else if (logLevel.equals("WARN") || logLevel.equals("3")) {
            FRLogger.changeFileLogLevel(Level.WARN);
        } else if (logLevel.equals("INFO") || logLevel.equals("4")) {
            FRLogger.changeFileLogLevel(Level.INFO);
        } else if (logLevel.equals("DEBUG") || logLevel.equals("5")) {
            FRLogger.changeFileLogLevel(Level.DEBUG);
        } else if (logLevel.equals("TRACE") || logLevel.equals("6")) {
            FRLogger.changeFileLogLevel(Level.TRACE);
        } else if (logLevel.equals("ALL") || logLevel.equals("7")) {
            FRLogger.changeFileLogLevel(Level.ALL);
        }
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = LogManager.getLogger(Freerouting.class);
        }
        return logger;
    }

    public static void changeFileLogLocation(Path userDataPath) {
        Path logFilePath = userDataPath.resolve("freerouting.log");
        LoggerContext context = (LoggerContext)LogManager.getContext(false);
        if (context == null) {
            FRLogger.warn("Failed to change the log file location. The context object is not an instance of org.apache.logging.log4j.core.LoggerContext.");
            return;
        }
        Configuration config = context.getConfiguration();
        LoggerConfig rootLoggerConfig = config.getRootLogger();
        if (config.getAppender("File") != null) {
            config.getAppender("File").stop();
            rootLoggerConfig.removeAppender("File");
        }
        FileAppender newFileAppender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((AbstractAppender.Builder)((FileAppender.Builder)((AbstractAppender.Builder)FileAppender.newBuilder()).setName("File")).withFileName(logFilePath.toString())).setLayout(PatternLayout.newBuilder().withPattern("%d{yyyy-MM-dd HH:mm:ss.SSS} %-6level %msg%n").build())).setImmediateFlush(true)).setConfiguration(config)).build();
        newFileAppender.start();
        rootLoggerConfig.addAppender(newFileAppender, rootLoggerConfig.getLevel(), null);
        context.updateLoggers();
    }

    static {
        enabled = true;
    }
}

