/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.ItemSelectionFilter;
import app.freerouting.boardgraphics.ColorIntensityTable;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.gui.BoardFrame;
import app.freerouting.interactive.ActivityReplayFile;
import app.freerouting.interactive.DragMenuState;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.interactive.MenuState;
import app.freerouting.interactive.RouteMenuState;
import app.freerouting.interactive.SelectMenuState;
import app.freerouting.interactive.Settings;
import java.awt.Point;
import java.io.Serializable;

public class SnapShot
implements Serializable {
    public final Settings settings;
    public final GraphicsContext graphics_context;
    public final BoardFrame.SubwindowSelections subwindow_filters;
    private final String name;
    private final int interactive_state_no;
    private final Point viewport_position;

    private SnapShot(String p_name, GuiBoardManager p_board_handling) {
        this.name = p_name;
        this.settings = new Settings(p_board_handling.settings);
        this.interactive_state_no = SnapShot.get_no(p_board_handling.interactive_state);
        this.graphics_context = new GraphicsContext(p_board_handling.graphics_context);
        this.viewport_position = new Point(p_board_handling.get_panel().get_viewport_position());
        this.subwindow_filters = p_board_handling.get_panel().board_frame.get_snapshot_subwindow_selections();
    }

    public static SnapShot get_instance(String p_name, GuiBoardManager p_board_handling) {
        InteractiveState interactive_state = p_board_handling.interactive_state;
        if (!(interactive_state instanceof MenuState)) {
            return null;
        }
        return new SnapShot(p_name, p_board_handling);
    }

    private static int get_no(InteractiveState p_interactive_state) {
        int result = p_interactive_state instanceof RouteMenuState ? 1 : (p_interactive_state instanceof DragMenuState ? 2 : 0);
        return result;
    }

    public String toString() {
        return this.name;
    }

    public Point copy_viewport_position() {
        if (this.viewport_position == null) {
            return null;
        }
        return new Point(this.viewport_position);
    }

    public void go_to(GuiBoardManager p_board_handling) {
        Attributes snapshot_attributes = this.settings.snapshot_attributes;
        if (snapshot_attributes.object_visibility) {
            p_board_handling.graphics_context.color_intensity_table = new ColorIntensityTable(this.graphics_context.color_intensity_table);
        }
        if (snapshot_attributes.layer_visibility) {
            p_board_handling.graphics_context.set_layer_visibility_arr(this.graphics_context.copy_layer_visibility_arr());
        }
        if (snapshot_attributes.interactive_state) {
            p_board_handling.set_interactive_state(this.get_interactive_state(p_board_handling, p_board_handling.activityReplayFile));
        }
        if (snapshot_attributes.selection_layers) {
            p_board_handling.settings.select_on_all_visible_layers = this.settings.select_on_all_visible_layers;
        }
        if (snapshot_attributes.selectable_items) {
            p_board_handling.settings.item_selection_filter = new ItemSelectionFilter(this.settings.item_selection_filter);
        }
        if (snapshot_attributes.current_layer) {
            p_board_handling.settings.layer = this.settings.layer;
        }
        if (snapshot_attributes.rule_selection) {
            p_board_handling.settings.manual_rule_selection = this.settings.manual_rule_selection;
        }
        if (snapshot_attributes.manual_rule_settings) {
            p_board_handling.settings.manual_trace_clearance_class = this.settings.manual_trace_clearance_class;
            p_board_handling.settings.manual_via_rule_index = this.settings.manual_via_rule_index;
            System.arraycopy(this.settings.manual_trace_half_width_arr, 0, p_board_handling.settings.manual_trace_half_width_arr, 0, p_board_handling.settings.manual_trace_half_width_arr.length);
        }
        if (snapshot_attributes.push_and_shove_enabled) {
            p_board_handling.settings.push_enabled = this.settings.push_enabled;
        }
        if (snapshot_attributes.drag_components_enabled) {
            p_board_handling.settings.drag_components_enabled = this.settings.drag_components_enabled;
        }
        if (snapshot_attributes.pull_tight_region) {
            p_board_handling.settings.trace_pull_tight_region_width = this.settings.trace_pull_tight_region_width;
        }
        if (snapshot_attributes.component_grid) {
            p_board_handling.settings.horizontal_component_grid = this.settings.horizontal_component_grid;
            p_board_handling.settings.vertical_component_grid = this.settings.vertical_component_grid;
        }
        if (snapshot_attributes.info_list_selections) {
            p_board_handling.get_panel().board_frame.set_snapshot_subwindow_selections(this.subwindow_filters);
        }
    }

    public InteractiveState get_interactive_state(GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        MenuState result = this.interactive_state_no == 1 ? RouteMenuState.get_instance(p_board_handling, p_activityReplayFile) : (this.interactive_state_no == 2 ? DragMenuState.get_instance(p_board_handling, p_activityReplayFile) : SelectMenuState.get_instance(p_board_handling, p_activityReplayFile));
        return result;
    }

    public static class Attributes
    implements Serializable {
        public boolean object_colors;
        public boolean object_visibility;
        public boolean layer_visibility;
        public boolean display_region;
        public boolean interactive_state;
        public boolean selection_layers;
        public boolean selectable_items;
        public boolean current_layer;
        public boolean rule_selection;
        public boolean manual_rule_settings;
        public boolean push_and_shove_enabled;
        public boolean drag_components_enabled;
        public boolean pull_tight_region;
        public boolean component_grid;
        public boolean info_list_selections;

        Attributes() {
            this.object_colors = true;
            this.object_visibility = true;
            this.layer_visibility = true;
            this.display_region = true;
            this.interactive_state = true;
            this.selection_layers = true;
            this.selectable_items = true;
            this.current_layer = true;
            this.rule_selection = true;
            this.manual_rule_settings = true;
            this.push_and_shove_enabled = true;
            this.drag_components_enabled = true;
            this.pull_tight_region = true;
            this.component_grid = true;
            this.info_list_selections = true;
        }

        Attributes(Attributes p_attributes) {
            this.object_colors = p_attributes.object_colors;
            this.object_visibility = p_attributes.object_visibility;
            this.layer_visibility = p_attributes.layer_visibility;
            this.display_region = p_attributes.display_region;
            this.interactive_state = p_attributes.interactive_state;
            this.selection_layers = p_attributes.selection_layers;
            this.selectable_items = p_attributes.selectable_items;
            this.current_layer = p_attributes.current_layer;
            this.rule_selection = p_attributes.rule_selection;
            this.manual_rule_settings = p_attributes.manual_rule_settings;
            this.push_and_shove_enabled = p_attributes.push_and_shove_enabled;
            this.drag_components_enabled = p_attributes.drag_components_enabled;
            this.pull_tight_region = p_attributes.pull_tight_region;
            this.component_grid = p_attributes.component_grid;
            this.info_list_selections = p_attributes.info_list_selections;
        }
    }
}

