/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.autoroute.AutorouteAttemptResult;
import app.freerouting.autoroute.AutorouteAttemptState;
import app.freerouting.board.Component;
import app.freerouting.board.Connectable;
import app.freerouting.board.DrillItem;
import app.freerouting.board.FixedState;
import app.freerouting.board.Item;
import app.freerouting.board.ObstacleArea;
import app.freerouting.board.OptViaAlgo;
import app.freerouting.board.Pin;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.Via;
import app.freerouting.core.Package;
import app.freerouting.datastructures.Stoppable;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.gui.WindowObjectInfo;
import app.freerouting.interactive.ActivityReplayFile;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.interactive.ClearanceViolations;
import app.freerouting.interactive.CutoutRouteState;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.interactive.MoveItemState;
import app.freerouting.interactive.SelectItemsInRegionState;
import app.freerouting.interactive.ZoomRegionState;
import app.freerouting.rules.Net;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JPopupMenu;

public class SelectedItemState
extends InteractiveState {
    private Set<Item> item_list;
    private ClearanceViolations clearance_violations;

    private SelectedItemState(Set<Item> p_item_list, InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        super(p_parent_state, p_board_handling, p_activityReplayFile);
        this.item_list = p_item_list;
    }

    public static SelectedItemState get_instance(Set<Item> p_item_list, InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        if (p_item_list.isEmpty()) {
            return null;
        }
        SelectedItemState new_state = new SelectedItemState(p_item_list, p_parent_state, p_board_handling, p_activityReplayFile);
        return new_state;
    }

    public Collection<Item> get_item_list() {
        return this.item_list;
    }

    @Override
    public InteractiveState left_button_clicked(FloatPoint p_location) {
        return this.toggle_select(p_location);
    }

    @Override
    public InteractiveState mouse_dragged(FloatPoint p_point) {
        return SelectItemsInRegionState.get_instance(this.hdlg.get_current_mouse_position(), this, this.hdlg, this.activityReplayFile);
    }

    @Override
    public InteractiveState key_typed(char p_key_char) {
        InteractiveState result = this;
        switch (p_key_char) {
            case 'a': {
                this.hdlg.autoroute_selected_items();
                break;
            }
            case 'b': {
                this.extent_to_whole_components();
                break;
            }
            case 'd': {
                result = this.cutout_items();
                break;
            }
            case 'e': {
                result = this.extent_to_whole_connections();
                break;
            }
            case 'f': {
                this.fix_items();
                break;
            }
            case 'i': {
                result = this.info();
                break;
            }
            case 'm': {
                result = MoveItemState.get_instance(this.hdlg.get_current_mouse_position(), this.item_list, this.return_state, this.hdlg, this.activityReplayFile);
                break;
            }
            case 'n': {
                this.extent_to_whole_nets();
                break;
            }
            case 'p': {
                this.hdlg.optimize_selected_items();
                break;
            }
            case 'r': {
                result = ZoomRegionState.get_instance(this.hdlg.get_current_mouse_position(), this, this.hdlg, this.activityReplayFile);
                break;
            }
            case 's': {
                result = this.extent_to_whole_connected_sets();
                break;
            }
            case 'u': {
                this.unfix_items();
                break;
            }
            case 'v': {
                this.toggle_clearance_violations();
                break;
            }
            case 'w': {
                this.hdlg.zoom_selection();
                break;
            }
            case '\u007f': {
                result = this.delete_items();
                break;
            }
            default: {
                result = super.key_typed(p_key_char);
            }
        }
        return result;
    }

    public void fix_items() {
        for (Item curr_ob : this.item_list) {
            if (curr_ob.get_fixed_state().ordinal() >= FixedState.USER_FIXED.ordinal()) continue;
            curr_ob.set_fixed_state(FixedState.USER_FIXED);
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.FIX_SELECTED_ITEMS);
        }
    }

    public void unfix_items() {
        for (Item curr_ob : this.item_list) {
            curr_ob.unfix();
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.UNFIX_SELECTED_ITEMS);
        }
    }

    public InteractiveState assign_items_to_new_net() {
        RoutingBoard board = this.hdlg.get_routing_board();
        board.generate_snapshot();
        boolean items_already_connected = false;
        Net new_net = board.rules.nets.new_net(this.hdlg.get_locale());
        for (Item curr_item : this.item_list) {
            if (curr_item instanceof ObstacleArea) {
                board.make_conductive((ObstacleArea)curr_item, new_net.net_number);
                continue;
            }
            if (!(curr_item instanceof DrillItem)) continue;
            if (curr_item.is_connected()) {
                items_already_connected = true;
                continue;
            }
            curr_item.assign_net_no(new_net.net_number);
        }
        if (items_already_connected) {
            this.hdlg.screen_messages.set_status_message(this.tm.getText("some_items_are_not_changed_because_they_are_already_connected", new String[0]));
        } else {
            this.hdlg.screen_messages.set_status_message(this.tm.getText("new_net_created_from_selected_items", new String[0]));
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.ASSIGN_SELECTED_TO_NEW_NET);
        }
        this.hdlg.update_ratsnest();
        this.hdlg.repaint();
        return this.return_state;
    }

    public InteractiveState assign_items_to_new_group() {
        RoutingBoard board = this.hdlg.get_routing_board();
        board.generate_snapshot();
        double gravity_x = 0.0;
        double gravity_y = 0.0;
        int pin_count = 0;
        Iterator<Item> it = this.item_list.iterator();
        while (it.hasNext()) {
            Item curr_ob = it.next();
            if (curr_ob instanceof Via) {
                FloatPoint curr_center = ((DrillItem)curr_ob).get_center().to_float();
                gravity_x += curr_center.x;
                gravity_y += curr_center.y;
                ++pin_count;
                continue;
            }
            it.remove();
        }
        if (pin_count == 0) {
            return this.return_state;
        }
        IntPoint gravity_point = new IntPoint((int)Math.round(gravity_x /= (double)pin_count), (int)Math.round(gravity_y /= (double)pin_count));
        Package.Pin[] pin_arr = new Package.Pin[this.item_list.size()];
        it = this.item_list.iterator();
        for (int i = 0; i < pin_arr.length; ++i) {
            Via curr_via = (Via)it.next();
            Vector rel_coor = curr_via.get_center().difference_by((Point)gravity_point);
            String pin_name = String.valueOf(i + 1);
            pin_arr[i] = new Package.Pin(pin_name, curr_via.get_padstack().no, rel_coor, 0.0);
        }
        Package new_package = board.library.packages.add(pin_arr);
        Component new_component = board.components.add(gravity_point, 0.0, true, new_package);
        it = this.item_list.iterator();
        for (int i = 0; i < pin_arr.length; ++i) {
            Via curr_via = (Via)it.next();
            board.remove_item(curr_via);
            int[] net_no_arr = new int[curr_via.net_count()];
            for (int j = 0; j < net_no_arr.length; ++j) {
                net_no_arr[j] = curr_via.get_net_no(j);
            }
            board.insert_pin(new_component.no, i, net_no_arr, curr_via.clearance_class_no(), curr_via.get_fixed_state());
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.ASSIGN_SELECTED_TO_NEW_GROUP);
        }
        this.hdlg.repaint();
        return this.return_state;
    }

    public InteractiveState delete_items() {
        this.hdlg.get_routing_board().generate_snapshot();
        TreeSet<Integer> changed_nets = new TreeSet<Integer>();
        for (Item curr_item : this.item_list) {
            if (!(curr_item instanceof Connectable)) continue;
            for (int i = 0; i < curr_item.net_count(); ++i) {
                changed_nets.add(curr_item.get_net_no(i));
            }
        }
        boolean all_items_removed = this.hdlg.settings.push_enabled ? this.hdlg.get_routing_board().remove_items_and_pull_tight(this.item_list, this.hdlg.settings.trace_pull_tight_region_width, this.hdlg.settings.autoroute_settings.trace_pull_tight_accuracy) : this.hdlg.get_routing_board().remove_items(this.item_list);
        if (!all_items_removed) {
            this.hdlg.screen_messages.set_status_message(this.tm.getText("some_items_are_fixed_and_could_therefore_not_be_removed", new String[0]));
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.DELETE_SELECTED);
        }
        for (Integer curr_net_no : changed_nets) {
            this.hdlg.update_ratsnest(curr_net_no);
        }
        this.hdlg.repaint();
        return this.return_state;
    }

    public InteractiveState cutout_items() {
        return CutoutRouteState.get_instance(this.item_list, this.return_state, this.hdlg, this.activityReplayFile);
    }

    public InteractiveState autoroute(Stoppable p_stoppable_thread) {
        boolean saved_board_read_only = this.hdlg.is_board_read_only();
        this.hdlg.set_board_read_only(true);
        if (p_stoppable_thread != null) {
            String start_message = this.tm.getText("autoroute", new String[0]) + " " + this.tm.getText("stop_message", new String[0]);
            this.hdlg.screen_messages.set_status_message(start_message);
        }
        int not_found_count = 0;
        int found_count = 0;
        boolean interrupted = false;
        LinkedList<Item> autoroute_item_list = new LinkedList<Item>();
        for (Item curr_item : this.item_list) {
            if (!(curr_item instanceof Connectable)) continue;
            for (int i = 0; i < curr_item.net_count(); ++i) {
                if (curr_item.get_unconnected_set(curr_item.get_net_no(i)).isEmpty()) continue;
                autoroute_item_list.add(curr_item);
            }
        }
        int items_to_go_count = autoroute_item_list.size();
        this.hdlg.screen_messages.set_interactive_autoroute_info(found_count, not_found_count, items_to_go_count);
        this.item_list = new TreeSet<Item>();
        boolean ratsnest_hidden_before = this.hdlg.get_ratsnest().is_hidden();
        if (!ratsnest_hidden_before) {
            this.hdlg.get_ratsnest().hide();
        }
        for (Item curr_item : autoroute_item_list) {
            if (p_stoppable_thread != null && p_stoppable_thread.isStopRequested()) {
                interrupted = true;
                break;
            }
            if (curr_item.net_count() != 1) continue;
            boolean contains_plane = false;
            Net route_net = this.hdlg.get_routing_board().rules.nets.get(curr_item.get_net_no(0));
            if (route_net != null) {
                contains_plane = route_net.contains_plane();
            }
            int via_costs = contains_plane ? this.hdlg.settings.autoroute_settings.get_plane_via_costs() : this.hdlg.settings.autoroute_settings.get_via_costs();
            this.hdlg.get_routing_board().start_marking_changed_area();
            AutorouteAttemptResult autoroute_result = this.hdlg.get_routing_board().autoroute(curr_item, this.hdlg.settings.autoroute_settings, via_costs, p_stoppable_thread, null, false);
            if (autoroute_result.state == AutorouteAttemptState.ROUTED) {
                ++found_count;
                this.hdlg.repaint();
            } else if (autoroute_result.state != AutorouteAttemptState.ALREADY_CONNECTED) {
                ++not_found_count;
            }
            this.hdlg.screen_messages.set_interactive_autoroute_info(found_count, not_found_count, --items_to_go_count);
        }
        if (p_stoppable_thread != null) {
            this.hdlg.screen_messages.clear();
            String curr_message = interrupted ? this.tm.getText("interrupted", new String[0]) : this.tm.getText("completed", new String[0]);
            String end_message = this.tm.getText("autoroute", new String[0]) + " " + curr_message + ": " + found_count + " " + this.tm.getText("connections_found", new String[0]) + ", " + not_found_count + " " + this.tm.getText("connections_not_found", new String[0]);
            this.hdlg.screen_messages.set_status_message(end_message);
        }
        this.hdlg.set_board_read_only(saved_board_read_only);
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.AUTOROUTE_SELECTED);
        }
        this.hdlg.update_ratsnest();
        if (!ratsnest_hidden_before) {
            this.hdlg.get_ratsnest().show();
        }
        return this.return_state;
    }

    public InteractiveState fanout(Stoppable p_stoppable_thread) {
        boolean saved_board_read_only = this.hdlg.is_board_read_only();
        this.hdlg.set_board_read_only(true);
        if (p_stoppable_thread != null) {
            String start_message = this.tm.getText("fanout", new String[0]) + " " + this.tm.getText("stop_message", new String[0]);
            this.hdlg.screen_messages.set_status_message(start_message);
        }
        int not_found_count = 0;
        int found_count = 0;
        int trace_pull_tight_accuracy = this.hdlg.settings.autoroute_settings.trace_pull_tight_accuracy;
        boolean interrupted = false;
        LinkedList<Pin> fanout_list = new LinkedList<Pin>();
        for (Item curr_item : this.item_list) {
            if (!(curr_item instanceof Pin)) continue;
            fanout_list.add((Pin)curr_item);
        }
        int items_to_go_count = fanout_list.size();
        this.hdlg.screen_messages.set_interactive_autoroute_info(found_count, not_found_count, items_to_go_count);
        this.item_list = new TreeSet<Item>();
        boolean ratsnest_hidden_before = this.hdlg.get_ratsnest().is_hidden();
        if (!ratsnest_hidden_before) {
            this.hdlg.get_ratsnest().hide();
        }
        for (Pin curr_pin : fanout_list) {
            if (p_stoppable_thread != null && p_stoppable_thread.isStopRequested()) {
                interrupted = true;
                break;
            }
            this.hdlg.get_routing_board().start_marking_changed_area();
            AutorouteAttemptResult autoroute_result = this.hdlg.get_routing_board().fanout(curr_pin, this.hdlg.settings.autoroute_settings, -1, p_stoppable_thread, null);
            if (autoroute_result.state == AutorouteAttemptState.ROUTED) {
                ++found_count;
                this.hdlg.repaint();
            } else if (autoroute_result.state != AutorouteAttemptState.ALREADY_CONNECTED) {
                ++not_found_count;
            }
            this.hdlg.screen_messages.set_interactive_autoroute_info(found_count, not_found_count, --items_to_go_count);
        }
        if (p_stoppable_thread != null) {
            this.hdlg.screen_messages.clear();
            String curr_message = interrupted ? this.tm.getText("interrupted", new String[0]) : this.tm.getText("completed", new String[0]);
            String end_message = this.tm.getText("fanout", new String[0]) + " " + curr_message + ": " + found_count + " " + this.tm.getText("connections_found", new String[0]) + ", " + not_found_count + " " + this.tm.getText("connections_not_found", new String[0]);
            this.hdlg.screen_messages.set_status_message(end_message);
        }
        this.hdlg.set_board_read_only(saved_board_read_only);
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.FANOUT_SELECTED);
        }
        this.hdlg.update_ratsnest();
        if (!ratsnest_hidden_before) {
            this.hdlg.get_ratsnest().show();
        }
        return this.return_state;
    }

    public InteractiveState pull_tight(Stoppable p_stoppable_thread) {
        boolean saved_board_read_only = this.hdlg.is_board_read_only();
        this.hdlg.set_board_read_only(true);
        if (p_stoppable_thread != null) {
            String start_message = this.tm.getText("pull_tight", new String[0]) + " " + this.tm.getText("stop_message", new String[0]);
            this.hdlg.screen_messages.set_status_message(start_message);
        }
        this.hdlg.get_routing_board().start_marking_changed_area();
        boolean interrupted = false;
        for (Item curr_item : this.item_list) {
            if (p_stoppable_thread != null && p_stoppable_thread.isStopRequested()) {
                interrupted = true;
                break;
            }
            if (curr_item.net_count() != 1) continue;
            if (curr_item instanceof PolylineTrace) {
                PolylineTrace curr_trace = (PolylineTrace)curr_item;
                boolean something_changed = curr_trace.pull_tight(!this.hdlg.settings.push_enabled, this.hdlg.settings.autoroute_settings.trace_pull_tight_accuracy, p_stoppable_thread);
                if (something_changed) continue;
                curr_trace.smoothen_end_corners_fork(!this.hdlg.settings.push_enabled, this.hdlg.settings.autoroute_settings.trace_pull_tight_accuracy, p_stoppable_thread);
                continue;
            }
            if (!(curr_item instanceof Via)) continue;
            OptViaAlgo.opt_via_location(this.hdlg.get_routing_board(), (Via)curr_item, null, this.hdlg.settings.autoroute_settings.trace_pull_tight_accuracy, 10);
        }
        if (this.hdlg.settings.push_enabled && !interrupted) {
            this.hdlg.get_routing_board().opt_changed_area(new int[0], null, this.hdlg.settings.autoroute_settings.trace_pull_tight_accuracy, null, p_stoppable_thread, 0);
        }
        if (p_stoppable_thread != null) {
            String curr_message = interrupted ? this.tm.getText("interrupted", new String[0]) : this.tm.getText("completed", new String[0]);
            String end_message = this.tm.getText("pull_tight", new String[0]) + " " + curr_message;
            this.hdlg.screen_messages.set_status_message(end_message);
        }
        this.hdlg.set_board_read_only(saved_board_read_only);
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.OPTIMIZE_SELECTED);
        }
        this.hdlg.update_ratsnest();
        return this.return_state;
    }

    public InteractiveState assign_clearance_class(int p_cl_class_index) {
        RoutingBoard routing_board = this.hdlg.get_routing_board();
        if (p_cl_class_index < 0 || p_cl_class_index >= routing_board.rules.clearance_matrix.get_class_count()) {
            return this.return_state;
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.ASSIGN_CLEARANCE_CLASS);
            this.activityReplayFile.add_int(p_cl_class_index);
        }
        routing_board.generate_snapshot();
        for (Item curr_item : this.item_list) {
            if (curr_item.clearance_class_no() == p_cl_class_index) continue;
            curr_item.change_clearance_class(p_cl_class_index);
        }
        return this.return_state;
    }

    public InteractiveState extent_to_whole_nets() {
        TreeSet<Integer> curr_net_no_set = new TreeSet<Integer>();
        for (Item curr_item : this.item_list) {
            if (!(curr_item instanceof Connectable)) continue;
            for (int i = 0; i < curr_item.net_count(); ++i) {
                curr_net_no_set.add(curr_item.get_net_no(i));
            }
        }
        TreeSet<Item> new_selected_items = new TreeSet<Item>();
        Iterator iterator = curr_net_no_set.iterator();
        while (iterator.hasNext()) {
            int curr_net_no = (Integer)iterator.next();
            new_selected_items.addAll(this.hdlg.get_routing_board().get_connectable_items(curr_net_no));
        }
        this.item_list = new_selected_items;
        if (new_selected_items.isEmpty()) {
            return this.return_state;
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.EXTEND_TO_WHOLE_NETS);
        }
        this.filter();
        this.hdlg.repaint();
        return this;
    }

    public InteractiveState extent_to_whole_components() {
        TreeSet<Integer> curr_group_no_set = new TreeSet<Integer>();
        for (Item curr_item : this.item_list) {
            if (curr_item.get_component_no() <= 0) continue;
            curr_group_no_set.add(curr_item.get_component_no());
        }
        TreeSet<Item> new_selected_items = new TreeSet<Item>(this.item_list);
        Iterator iterator = curr_group_no_set.iterator();
        while (iterator.hasNext()) {
            int curr_group_no = (Integer)iterator.next();
            new_selected_items.addAll(this.hdlg.get_routing_board().get_component_items(curr_group_no));
        }
        if (new_selected_items.isEmpty()) {
            return this.return_state;
        }
        this.item_list = new_selected_items;
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.EXTEND_TO_WHOLE_COMPONENTS);
        }
        this.hdlg.repaint();
        return this;
    }

    public InteractiveState extent_to_whole_connected_sets() {
        TreeSet<Item> new_selected_items = new TreeSet<Item>();
        for (Item curr_item : this.item_list) {
            if (!(curr_item instanceof Connectable)) continue;
            new_selected_items.addAll(curr_item.get_connected_set(-1));
        }
        if (new_selected_items.isEmpty()) {
            return this.return_state;
        }
        this.item_list = new_selected_items;
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.EXTEND_TO_WHOLE_CONNECTED_SETS);
        }
        this.filter();
        this.hdlg.repaint();
        return this;
    }

    public InteractiveState extent_to_whole_connections() {
        TreeSet<Item> new_selected_items = new TreeSet<Item>();
        for (Item curr_item : this.item_list) {
            if (!(curr_item instanceof Connectable)) continue;
            new_selected_items.addAll(curr_item.get_connection_items());
        }
        if (new_selected_items.isEmpty()) {
            return this.return_state;
        }
        this.item_list = new_selected_items;
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.EXTEND_TO_WHOLE_CONNECTIONS);
        }
        this.filter();
        this.hdlg.repaint();
        return this;
    }

    public InteractiveState toggle_select(FloatPoint p_point) {
        Set<Item> picked_items = this.hdlg.pick_items(p_point);
        boolean state_ended = picked_items.isEmpty();
        if (picked_items.size() == 1) {
            Item picked_item = (Item)picked_items.iterator().next();
            if (this.item_list.contains(picked_item)) {
                this.item_list.remove(picked_item);
                if (this.item_list.isEmpty()) {
                    state_ended = true;
                }
            } else {
                this.item_list.add(picked_item);
            }
        }
        this.hdlg.repaint();
        InteractiveState result = state_ended ? this.return_state : this;
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.TOGGLE_SELECT, p_point);
        }
        return result;
    }

    public void toggle_clearance_violations() {
        if (this.clearance_violations == null) {
            this.clearance_violations = new ClearanceViolations(this.item_list);
            Integer violation_count = this.clearance_violations.list.size();
            String curr_message = violation_count + " " + this.tm.getText("clearance_violations_found", new String[0]);
            this.hdlg.screen_messages.set_status_message(curr_message);
        } else {
            this.clearance_violations = null;
            this.hdlg.screen_messages.set_status_message("");
        }
        this.hdlg.repaint();
    }

    public InteractiveState filter() {
        this.item_list = this.hdlg.settings.item_selection_filter.filter(this.item_list);
        InteractiveState result = this;
        if (this.item_list.isEmpty()) {
            result = this.return_state;
        }
        this.hdlg.repaint();
        return result;
    }

    public SelectedItemState info() {
        WindowObjectInfo.display(this.item_list, this.hdlg.get_panel().board_frame, this.hdlg.coordinate_transform, new java.awt.Point(100, 100));
        return this;
    }

    @Override
    public String get_help_id() {
        return "SelectedItemState";
    }

    @Override
    public void draw(Graphics p_graphics) {
        if (this.item_list == null) {
            return;
        }
        for (Item curr_item : this.item_list) {
            curr_item.draw(p_graphics, this.hdlg.graphics_context, this.hdlg.graphics_context.get_hilight_color(), this.hdlg.graphics_context.get_hilight_color_intensity());
        }
        if (this.clearance_violations != null) {
            this.clearance_violations.draw(p_graphics, this.hdlg.graphics_context);
        }
    }

    @Override
    public JPopupMenu get_popup_menu() {
        return this.hdlg.get_panel().popup_menu_select;
    }

    @Override
    public void set_toolbar() {
        this.hdlg.get_panel().board_frame.set_select_toolbar();
    }

    @Override
    public void display_default_message() {
        this.hdlg.screen_messages.set_status_message(this.tm.getText("in_select_item_mode", new String[0]));
    }
}

