/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.Unit;
import app.freerouting.core.RouterCounters;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.TextManager;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JLabel;

public class ScreenMessages {
    private static final String empty_string = "            ";
    final JLabel errorLabel;
    final JLabel warningLabel;
    private final String active_layer_string;
    private final String target_layer_string;
    private final NumberFormat number_format;
    private final JLabel add_field;
    private final JLabel status_field;
    private final JLabel layer_field;
    private final JLabel score_field;
    private final JLabel mouse_position;
    private final JLabel unit_label;
    private final TextManager tm;
    private String prev_target_layer_name = "            ";
    private boolean write_protected = false;

    public ScreenMessages(JLabel errorLabel, JLabel warningLabel, JLabel p_status_field, JLabel p_add_field, JLabel p_layer_field, JLabel p_score_field, JLabel p_mouse_position, JLabel p_unit_label, Locale p_locale) {
        this.tm = new TextManager(this.getClass(), p_locale);
        this.active_layer_string = this.tm.getText("current_layer", new String[0]) + " ";
        this.target_layer_string = this.tm.getText("target_layer", new String[0]) + " ";
        this.errorLabel = errorLabel;
        this.warningLabel = warningLabel;
        this.status_field = p_status_field;
        this.add_field = p_add_field;
        this.layer_field = p_layer_field;
        this.score_field = p_score_field;
        this.mouse_position = p_mouse_position;
        this.unit_label = p_unit_label;
        this.add_field.setText(empty_string);
        this.number_format = NumberFormat.getInstance(p_locale);
        this.number_format.setMinimumFractionDigits(2);
        this.number_format.setMaximumFractionDigits(2);
    }

    public void set_error_and_warning_count(int errorsCount, int warningCount) {
        this.errorLabel.setText(Integer.toString(errorsCount));
        this.warningLabel.setText(Integer.toString(warningCount));
    }

    public void set_status_message(String p_message) {
        if (!this.write_protected) {
            this.status_field.setText(p_message);
        }
    }

    public void set_layer(String p_layer_name) {
        if (!this.write_protected) {
            this.layer_field.setText(this.active_layer_string + p_layer_name);
        }
    }

    public void set_interactive_autoroute_info(int p_found, int p_not_found, int p_items_to_go) {
        int found = p_found;
        int failed = p_not_found;
        int items_to_go = p_items_to_go;
        this.add_field.setText(this.tm.getText("to_route", new String[0]) + " " + items_to_go);
        this.layer_field.setText(this.tm.getText("found", new String[0]) + " " + found + ", " + this.tm.getText("failed", new String[0]) + " " + failed);
    }

    public void set_batch_autoroute_info(RouterCounters routerCounters) {
        int items_to_go = routerCounters.queuedToBeRoutedCount;
        int routed = routerCounters.routedCount;
        int ripped = routerCounters.rippedCount;
        int failed = routerCounters.failedToBeRoutedCount;
        this.add_field.setText(this.tm.getText("to_route", new String[0]) + " " + items_to_go + ", " + this.tm.getText("routed", new String[0]) + " " + routed + ", ");
        this.layer_field.setText(this.tm.getText("ripped", new String[0]) + " " + ripped + ", " + this.tm.getText("failed", new String[0]) + " " + failed);
    }

    public void set_batch_fanout_info(int p_pass_no, int p_components_to_go) {
        int components_to_go = p_components_to_go;
        int pass_no = p_pass_no;
        this.add_field.setText(this.tm.getText("fanout_pass", new String[0]) + " " + pass_no + ": ");
        this.layer_field.setText(this.tm.getText("still", new String[0]) + " " + components_to_go + " " + this.tm.getText("components", new String[0]));
    }

    public void set_post_route_info(int p_via_count, double p_trace_length, Unit unit) {
        int via_count = p_via_count;
        this.add_field.setText(this.tm.getText("via_count", new String[0]) + " " + via_count);
        this.layer_field.setText(this.tm.getText("trace_length", new String[0]) + " " + this.number_format.format(p_trace_length) + " " + String.valueOf(unit));
    }

    public void set_target_layer(String p_layer_name) {
        if (!p_layer_name.equals(this.prev_target_layer_name) && !this.write_protected) {
            this.add_field.setText(this.target_layer_string + p_layer_name);
            this.prev_target_layer_name = p_layer_name;
        }
    }

    public void set_mouse_position(FloatPoint p_pos) {
        if (p_pos == null || this.mouse_position == null || this.write_protected) {
            return;
        }
        this.mouse_position.setText(p_pos.to_string(this.tm.getLocale(), 2, 10));
    }

    public void set_unit_label(String p_unit) {
        this.unit_label.setText(p_unit);
    }

    public void clear_add_field() {
        if (!this.write_protected) {
            this.add_field.setText(empty_string);
            this.prev_target_layer_name = empty_string;
        }
    }

    public void clear() {
        if (!this.write_protected) {
            this.status_field.setText(empty_string);
            this.clear_add_field();
            this.layer_field.setText(empty_string);
            this.score_field.setText(empty_string);
        }
    }

    public void set_write_protected(boolean p_value) {
        this.write_protected = p_value;
    }

    public void set_board_score(float score, int unrouted_count, int violation_count) {
        this.score_field.setText(this.tm.getText("score", FRLogger.defaultFloatFormat.format(score), String.valueOf(unrouted_count), String.valueOf(violation_count)));
    }
}

