/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.Item;
import app.freerouting.board.ItemSelectionFilter;
import app.freerouting.board.LayerStructure;
import app.freerouting.board.Pin;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.interactive.ActivityReplayFile;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.interactive.DragMenuState;
import app.freerouting.interactive.ExpandTestState;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.interactive.PinSwapState;
import app.freerouting.interactive.RouteMenuState;
import app.freerouting.interactive.RouteState;
import app.freerouting.interactive.SelectMenuState;
import app.freerouting.interactive.SelectedItemState;
import app.freerouting.logger.FRLogger;
import java.util.Set;
import javax.swing.JPopupMenu;

public class MenuState
extends InteractiveState {
    MenuState(GuiBoardManager p_board_handle, ActivityReplayFile p_activityReplayFile) {
        super(null, p_board_handle, p_activityReplayFile);
        this.return_state = this;
    }

    @Override
    public JPopupMenu get_popup_menu() {
        return this.hdlg.get_panel().popup_menu_main;
    }

    public InteractiveState select_items(FloatPoint p_location) {
        InteractiveState result;
        boolean something_found;
        this.hdlg.display_layer_message();
        Set<Item> picked_items = this.hdlg.pick_items(p_location);
        boolean bl = something_found = !picked_items.isEmpty();
        if (something_found) {
            result = SelectedItemState.get_instance(picked_items, this, this.hdlg, this.activityReplayFile);
            this.hdlg.screen_messages.set_status_message(this.tm.getText("in_select_mode", new String[0]));
            if (this.activityReplayFile != null) {
                this.activityReplayFile.start_scope(ActivityReplayFileScope.START_SELECT, p_location);
            }
        } else {
            result = this;
        }
        this.hdlg.repaint();
        return result;
    }

    public InteractiveState swap_pin(FloatPoint p_location) {
        ItemSelectionFilter selection_filter = new ItemSelectionFilter(ItemSelectionFilter.SelectableChoices.PINS);
        Set<Item> picked_items = this.hdlg.pick_items(p_location, selection_filter);
        InteractiveState result = this;
        if (!picked_items.isEmpty()) {
            Item first_item = (Item)picked_items.iterator().next();
            if (!(first_item instanceof Pin)) {
                FRLogger.warn("MenuState.swap_pin: Pin expected");
                return this;
            }
            Pin selected_pin = (Pin)first_item;
            result = PinSwapState.get_instance(selected_pin, this, this.hdlg, this.activityReplayFile);
        } else {
            this.hdlg.screen_messages.set_status_message(this.tm.getText("no_pin_selected", new String[0]));
        }
        this.hdlg.repaint();
        return result;
    }

    @Override
    public InteractiveState key_typed(char p_key_char) {
        InteractiveState curr_return_state = this;
        switch (p_key_char) {
            case 'b': {
                this.hdlg.redo();
                break;
            }
            case 'd': {
                curr_return_state = DragMenuState.get_instance(this.hdlg, this.activityReplayFile);
                break;
            }
            case 'e': {
                curr_return_state = ExpandTestState.get_instance(this.hdlg.get_current_mouse_position(), this, this.hdlg);
                break;
            }
            case 'g': {
                this.hdlg.toggle_ratsnest();
                break;
            }
            case 'i': {
                curr_return_state = this.select_items(this.hdlg.get_current_mouse_position());
                break;
            }
            case 'p': {
                this.hdlg.settings.set_push_enabled(!this.hdlg.settings.push_enabled);
                this.hdlg.get_panel().board_frame.refresh_windows();
                break;
            }
            case 'r': {
                curr_return_state = RouteMenuState.get_instance(this.hdlg, this.activityReplayFile);
                break;
            }
            case 's': {
                curr_return_state = SelectMenuState.get_instance(this.hdlg, this.activityReplayFile);
                break;
            }
            case 't': {
                curr_return_state = RouteState.get_instance(this.hdlg.get_current_mouse_position(), this, this.hdlg, this.activityReplayFile);
                break;
            }
            case 'u': {
                this.hdlg.undo();
                break;
            }
            case 'v': {
                this.hdlg.toggle_clearance_violations();
                break;
            }
            case 'w': {
                curr_return_state = this.swap_pin(this.hdlg.get_current_mouse_position());
                break;
            }
            case '+': {
                LayerStructure layer_structure = this.hdlg.get_routing_board().layer_structure;
                int current_layer_no = this.hdlg.settings.layer;
                while (++current_layer_no < layer_structure.arr.length && !layer_structure.arr[current_layer_no].is_signal) {
                }
                if (current_layer_no >= layer_structure.arr.length) break;
                this.hdlg.set_current_layer(current_layer_no);
                break;
            }
            case '-': {
                LayerStructure layer_structure = this.hdlg.get_routing_board().layer_structure;
                int current_layer_no = this.hdlg.settings.layer;
                while (--current_layer_no >= 0 && !layer_structure.arr[current_layer_no].is_signal) {
                }
                if (current_layer_no < 0) break;
                this.hdlg.set_current_layer(current_layer_no);
                break;
            }
            default: {
                curr_return_state = super.key_typed(p_key_char);
            }
        }
        return curr_return_state;
    }

    @Override
    public InteractiveState complete() {
        return this;
    }

    @Override
    public InteractiveState cancel() {
        return this;
    }

    @Override
    public void set_toolbar() {
        this.hdlg.get_panel().board_frame.set_menu_toolbar();
    }
}

