/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.BoardObservers;
import app.freerouting.board.Communication;
import app.freerouting.board.LayerStructure;
import app.freerouting.board.RoutingBoard;
import app.freerouting.core.BoardFileDetails;
import app.freerouting.core.RoutingJob;
import app.freerouting.core.scoring.BoardStatistics;
import app.freerouting.datastructures.IdentificationNumberGenerator;
import app.freerouting.designforms.specctra.DsnFile;
import app.freerouting.designforms.specctra.SpecctraSesFileWriter;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.PolylineShape;
import app.freerouting.interactive.ActivityReplayFile;
import app.freerouting.interactive.BoardManager;
import app.freerouting.interactive.Settings;
import app.freerouting.interactive.ThreadActionListener;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.management.gson.GsonProvider;
import app.freerouting.rules.BoardRules;
import app.freerouting.rules.DefaultItemClearanceClasses;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;

public class HeadlessBoardManager
implements BoardManager {
    public final ActivityReplayFile activityReplayFile = new ActivityReplayFile();
    public Settings settings;
    public ThreadActionListener autorouter_listener;
    protected RoutingBoard board;
    protected Locale locale;
    protected RoutingJob routingJob;
    protected long originalBoardChecksum = 0L;

    public HeadlessBoardManager(Locale p_locale, RoutingJob routingJob) {
        this.locale = p_locale;
        this.routingJob = routingJob;
    }

    @Override
    public RoutingBoard get_routing_board() {
        return this.board;
    }

    public synchronized void replaceRoutingBoard(RoutingBoard newRoutingBoard) {
        this.board = newRoutingBoard;
    }

    @Override
    public Settings get_settings() {
        return this.settings;
    }

    @Override
    public void initialize_manual_trace_half_widths() {
        for (int i = 0; i < this.settings.manual_trace_half_width_arr.length; ++i) {
            this.settings.manual_trace_half_width_arr[i] = this.board.rules.get_default_net_class().get_trace_half_width(i);
        }
    }

    @Override
    public void create_board(IntBox p_bounding_box, LayerStructure p_layer_structure, PolylineShape[] p_outline_shapes, String p_outline_clearance_class_name, BoardRules p_rules, Communication p_board_communication) {
        if (this.board != null) {
            this.routingJob.logWarning(" BoardHandling.create_board: board already created");
        }
        int outline_cl_class_no = 0;
        if (p_rules != null) {
            if (p_outline_clearance_class_name != null && p_rules.clearance_matrix != null) {
                outline_cl_class_no = p_rules.clearance_matrix.get_no(p_outline_clearance_class_name);
                outline_cl_class_no = Math.max(outline_cl_class_no, 0);
            } else {
                outline_cl_class_no = p_rules.get_default_net_class().default_item_clearance_classes.get(DefaultItemClearanceClasses.ItemClass.AREA);
            }
        }
        this.board = new RoutingBoard(p_bounding_box, p_layer_structure, p_outline_shapes, outline_cl_class_no, p_rules, p_board_communication);
        this.settings = new Settings(this.board, this.activityReplayFile);
    }

    @Override
    public Locale get_locale() {
        return this.locale;
    }

    public long calculateCrc32() {
        ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
        DsnFile.write(this, memoryStream, "N/A", false);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(memoryStream.toByteArray());
        return BoardFileDetails.calculateCrc32(inputStream).getValue();
    }

    public DsnFile.ReadResult loadFromSpecctraDsn(InputStream inputStream, BoardObservers boardObservers, IdentificationNumberGenerator identificationNumberGenerator) {
        DsnFile.ReadResult read_result;
        if (inputStream == null) {
            return DsnFile.ReadResult.ERROR;
        }
        try {
            read_result = DsnFile.read(inputStream, this, boardObservers, identificationNumberGenerator);
        }
        catch (Exception e) {
            read_result = DsnFile.ReadResult.ERROR;
            this.routingJob.logError("There was an error while reading DSN file.", e);
        }
        if (read_result == DsnFile.ReadResult.OK) {
            BoardStatistics boardStats = new BoardStatistics(this.board);
            FRAnalytics.fileLoaded("DSN", GsonProvider.GSON.toJson(boardStats));
            this.board.reduce_nets_of_route_items();
            this.originalBoardChecksum = this.calculateCrc32();
            FRAnalytics.boardLoaded(this.board.communication.specctra_parser_info.host_cad, this.board.communication.specctra_parser_info.host_version, this.board.get_layer_count(), this.board.components.count(), this.board.rules.nets.max_net_no());
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            read_result = DsnFile.ReadResult.ERROR;
        }
        return read_result;
    }

    public boolean saveAsSpecctraSessionSes(OutputStream outputStream, String designName) {
        boolean wasSaveSuccessful = SpecctraSesFileWriter.write(this.get_routing_board(), outputStream, designName);
        if (wasSaveSuccessful) {
            this.originalBoardChecksum = this.calculateCrc32();
        }
        return wasSaveSuccessful;
    }
}

