/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.autoroute.AutorouteControl;
import app.freerouting.autoroute.AutorouteEngine;
import app.freerouting.autoroute.CompleteFreeSpaceExpansionRoom;
import app.freerouting.autoroute.IncompleteFreeSpaceExpansionRoom;
import app.freerouting.autoroute.InsertFoundConnectionAlgo;
import app.freerouting.autoroute.LocateFoundConnectionAlgo;
import app.freerouting.autoroute.MazeSearchAlgo;
import app.freerouting.board.Connectable;
import app.freerouting.board.Item;
import app.freerouting.board.RoutingBoard;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveState;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

public class ExpandTestState
extends InteractiveState {
    private boolean in_autoroute = false;
    private MazeSearchAlgo maze_search_algo;
    private LocateFoundConnectionAlgo autoroute_result;
    private AutorouteControl control_settings;
    private AutorouteEngine autoroute_engine;

    private ExpandTestState(FloatPoint p_location, InteractiveState p_return_state, GuiBoardManager p_board_handling) {
        super(p_return_state, p_board_handling, null);
        this.init(p_location);
    }

    public static ExpandTestState get_instance(FloatPoint p_location, InteractiveState p_return_state, GuiBoardManager p_board_handling) {
        return new ExpandTestState(p_location, p_return_state, p_board_handling);
    }

    @Override
    public InteractiveState key_typed(char p_key_char) {
        InteractiveState result;
        if (p_key_char == 'n') {
            if (this.in_autoroute) {
                if (!this.maze_search_algo.occupy_next_element()) {
                    this.complete_autoroute();
                    this.hdlg.screen_messages.set_status_message("expansion completed");
                }
            } else {
                boolean completing_succeeded = false;
                while (!completing_succeeded) {
                    IncompleteFreeSpaceExpansionRoom next_room = this.autoroute_engine.get_first_incomplete_expansion_room();
                    if (next_room == null) {
                        this.hdlg.screen_messages.set_status_message("expansion completed");
                        break;
                    }
                    completing_succeeded = this.complete_expansion_room(next_room);
                }
            }
            result = this;
        } else if (p_key_char == 'a') {
            if (this.in_autoroute) {
                this.complete_autoroute();
            } else {
                IncompleteFreeSpaceExpansionRoom next_room = this.autoroute_engine.get_first_incomplete_expansion_room();
                while (next_room != null) {
                    this.complete_expansion_room(next_room);
                    next_room = this.autoroute_engine.get_first_incomplete_expansion_room();
                }
            }
            result = this;
        } else if (Character.isDigit(p_key_char)) {
            int d = Character.digit(p_key_char, 10);
            int max_count = (int)Math.pow(10.0, d);
            if (this.in_autoroute) {
                for (int i = 0; i < max_count; ++i) {
                    if (this.maze_search_algo.occupy_next_element()) continue;
                    this.complete_autoroute();
                    this.hdlg.screen_messages.set_status_message("expansion completed");
                    break;
                }
            } else {
                IncompleteFreeSpaceExpansionRoom next_room = this.autoroute_engine.get_first_incomplete_expansion_room();
                for (int curr_count = 0; next_room != null && curr_count < max_count; ++curr_count) {
                    this.complete_expansion_room(next_room);
                    next_room = this.autoroute_engine.get_first_incomplete_expansion_room();
                }
            }
            result = this;
        } else {
            this.autoroute_engine.clear();
            result = super.key_typed(p_key_char);
        }
        this.hdlg.repaint();
        return result;
    }

    @Override
    public InteractiveState left_button_clicked(FloatPoint p_location) {
        return this.cancel();
    }

    @Override
    public InteractiveState cancel() {
        this.autoroute_engine.clear();
        return this.return_state;
    }

    @Override
    public InteractiveState complete() {
        return this.cancel();
    }

    @Override
    public void draw(Graphics p_graphics) {
        this.autoroute_engine.draw(p_graphics, this.hdlg.graphics_context, 0.1);
        if (this.autoroute_result != null) {
            this.autoroute_result.draw(p_graphics, this.hdlg.graphics_context);
        }
    }

    private void init(FloatPoint p_location) {
        RoutingBoard board = this.hdlg.get_routing_board();
        int layer = this.hdlg.settings.layer;
        Set<Item> found_items = board.pick_items(p_location.round(), layer, null);
        Item route_item = null;
        int route_net_no = 0;
        for (Item curr_ob : found_items) {
            Item curr_item;
            if (!(curr_ob instanceof Connectable) || (curr_item = curr_ob).net_count() != 1 || curr_item.get_net_no(0) <= 0) continue;
            route_item = curr_item;
            route_net_no = curr_item.get_net_no(0);
            break;
        }
        this.control_settings = new AutorouteControl(this.hdlg.get_routing_board(), route_net_no, this.hdlg.settings.autoroute_settings);
        this.control_settings.ripup_pass_no = this.hdlg.settings.autoroute_settings.get_start_pass_no();
        this.control_settings.ripup_costs = this.control_settings.ripup_pass_no * this.hdlg.settings.autoroute_settings.get_start_ripup_costs();
        this.control_settings.vias_allowed = false;
        this.autoroute_engine = new AutorouteEngine(board, this.control_settings.trace_clearance_class_no, false, false);
        this.autoroute_engine.init_connection(route_net_no, null, null);
        if (route_item == null) {
            IntBox contained_shape = TileShape.get_instance(p_location.round());
            IncompleteFreeSpaceExpansionRoom expansion_room = this.autoroute_engine.add_incomplete_expansion_room(null, layer, contained_shape);
            this.hdlg.screen_messages.set_status_message("expansion test started");
            this.complete_expansion_room(expansion_room);
            return;
        }
        Set<Item> route_start_set = route_item.get_connected_set(route_net_no);
        Set<Item> route_dest_set = route_item.get_unconnected_set(route_net_no);
        if (!route_dest_set.isEmpty()) {
            this.hdlg.screen_messages.set_status_message("app.freerouting.autoroute test started");
            this.maze_search_algo = MazeSearchAlgo.get_instance(route_start_set, route_dest_set, this.autoroute_engine, this.control_settings);
            this.in_autoroute = this.maze_search_algo != null;
        }
    }

    private void complete_autoroute() {
        MazeSearchAlgo.Result search_result = this.maze_search_algo.find_connection();
        if (search_result != null) {
            TreeSet<Item> ripped_item_list = new TreeSet<Item>();
            this.autoroute_result = LocateFoundConnectionAlgo.get_instance(search_result, this.control_settings, this.autoroute_engine.autoroute_search_tree, this.hdlg.get_routing_board().rules.get_trace_angle_restriction(), ripped_item_list);
            this.hdlg.get_routing_board().generate_snapshot();
            TreeSet<Item> ripped_connections = new TreeSet<Item>();
            for (Item curr_ripped_item : ripped_item_list) {
                ripped_connections.addAll(curr_ripped_item.get_connection_items(Item.StopConnectionOption.VIA));
            }
            this.hdlg.get_routing_board().remove_items(ripped_connections);
            InsertFoundConnectionAlgo.get_instance(this.autoroute_result, this.hdlg.get_routing_board(), this.control_settings);
        }
    }

    private boolean complete_expansion_room(IncompleteFreeSpaceExpansionRoom p_incomplete_room) {
        Collection<CompleteFreeSpaceExpansionRoom> completed_rooms = this.autoroute_engine.complete_expansion_room(p_incomplete_room);
        return !completed_rooms.isEmpty();
    }
}

