/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.Component;
import app.freerouting.board.DrillItem;
import app.freerouting.board.Item;
import app.freerouting.board.ObstacleArea;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.Via;
import app.freerouting.core.Package;
import app.freerouting.core.Padstack;
import app.freerouting.geometry.planar.ConvexShape;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.interactive.ActivityReplayFile;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.logger.FRLogger;
import java.awt.Graphics;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPopupMenu;

public class CopyItemState
extends InteractiveState {
    private final Collection<Item> item_list = new LinkedList<Item>();
    private Point start_position;
    private Point current_position;
    private int current_layer;
    private boolean layer_changed;
    private Point previous_position;

    private CopyItemState(FloatPoint p_location, Collection<Item> p_item_list, InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        super(p_parent_state, p_board_handling, p_activityReplayFile);
        this.start_position = p_location.round();
        this.current_layer = p_board_handling.settings.layer;
        this.layer_changed = false;
        this.previous_position = this.current_position = this.start_position;
        for (Item curr_item : p_item_list) {
            if (!(curr_item instanceof DrillItem) && !(curr_item instanceof ObstacleArea)) continue;
            Item new_item = curr_item.copy(0);
            this.item_list.add(new_item);
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.COPYING_ITEMS, p_location);
        }
    }

    public static CopyItemState get_instance(FloatPoint p_location, Collection<Item> p_item_list, InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        if (p_item_list.isEmpty()) {
            return null;
        }
        p_board_handling.remove_ratsnest();
        return new CopyItemState(p_location, p_item_list, p_parent_state, p_board_handling, p_activityReplayFile);
    }

    private static Padstack change_padstack_layers(Padstack p_old_padstack, int p_new_layer, RoutingBoard p_board, Map<Padstack, Padstack> p_padstack_pairs) {
        Padstack new_padstack;
        int old_layer = p_old_padstack.from_layer();
        if (old_layer == p_new_layer) {
            new_padstack = p_old_padstack;
        } else if (p_padstack_pairs.containsKey(p_old_padstack)) {
            new_padstack = p_padstack_pairs.get(p_old_padstack);
        } else {
            ConvexShape[] new_shapes = new ConvexShape[p_board.get_layer_count()];
            int layer_diff = old_layer - p_new_layer;
            for (int i = 0; i < new_shapes.length; ++i) {
                int new_layer_no = i + layer_diff;
                if (new_layer_no < 0 || new_layer_no >= new_shapes.length) continue;
                new_shapes[i] = p_old_padstack.get_shape(i + layer_diff);
            }
            new_padstack = p_board.library.padstacks.add(new_shapes);
            p_padstack_pairs.put(p_old_padstack, new_padstack);
        }
        return new_padstack;
    }

    @Override
    public InteractiveState mouse_moved() {
        super.mouse_moved();
        this.change_position(this.hdlg.get_current_mouse_position());
        return this;
    }

    private void change_position(FloatPoint p_new_position) {
        this.current_position = p_new_position.round();
        if (!this.current_position.equals(this.previous_position)) {
            Vector translate_vector = this.current_position.difference_by(this.previous_position);
            for (Item curr_item : this.item_list) {
                curr_item.translate_by(translate_vector);
            }
            this.previous_position = this.current_position;
            this.hdlg.repaint();
        }
    }

    @Override
    public boolean change_layer_action(int p_new_layer) {
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.CHANGE_LAYER, p_new_layer);
        }
        this.current_layer = p_new_layer;
        this.layer_changed = true;
        this.hdlg.set_layer(p_new_layer);
        return true;
    }

    public void insert() {
        if (this.item_list == null) {
            return;
        }
        TreeMap<Padstack, Padstack> padstack_pairs = new TreeMap<Padstack, Padstack>();
        RoutingBoard board = this.hdlg.get_routing_board();
        if (this.layer_changed) {
            for (Item curr_ob : this.item_list) {
                if (!(curr_ob instanceof Via)) continue;
                Via curr_via = (Via)curr_ob;
                Padstack new_padstack = CopyItemState.change_padstack_layers(curr_via.get_padstack(), this.current_layer, board, padstack_pairs);
                curr_via.set_padstack(new_padstack);
            }
        }
        TreeMap<Integer, Integer> cmp_no_pairs = new TreeMap<Integer, Integer>();
        LinkedList<Component> copied_components = new LinkedList<Component>();
        Vector translate_vector = this.current_position.difference_by(this.start_position);
        for (Item curr_item : this.item_list) {
            int new_cmp_no;
            int curr_cmp_no = curr_item.get_component_no();
            if (curr_cmp_no <= 0) continue;
            Integer curr_key = curr_cmp_no;
            if (cmp_no_pairs.containsKey(curr_key)) {
                Integer curr_value = (Integer)cmp_no_pairs.get(curr_key);
                new_cmp_no = curr_value;
            } else {
                Package new_package;
                Component old_component = board.components.get(curr_cmp_no);
                if (old_component == null) {
                    FRLogger.warn("CopyItemState: component not found");
                    continue;
                }
                Point new_location = old_component.get_location().translate_by(translate_vector);
                if (this.layer_changed) {
                    Package.Pin[] new_pin_arr = new Package.Pin[old_component.get_package().pin_count()];
                    for (int i = 0; i < new_pin_arr.length; ++i) {
                        Package.Pin old_pin = old_component.get_package().get_pin(i);
                        Padstack old_padstack = board.library.padstacks.get(old_pin.padstack_no);
                        if (old_padstack == null) {
                            FRLogger.warn("CopyItemState.insert: package padstack not found");
                            return;
                        }
                        Padstack new_padstack = CopyItemState.change_padstack_layers(old_padstack, this.current_layer, board, padstack_pairs);
                        new_pin_arr[i] = new Package.Pin(old_pin.name, new_padstack.no, old_pin.relative_location, old_pin.rotation_in_degree);
                    }
                    new_package = board.library.packages.add(new_pin_arr);
                } else {
                    new_package = old_component.get_package();
                }
                Component new_component = board.components.add(new_location, old_component.get_rotation_in_degree(), old_component.placed_on_front(), new_package);
                copied_components.add(new_component);
                new_cmp_no = new_component.no;
                cmp_no_pairs.put(curr_cmp_no, new_cmp_no);
            }
            curr_item.assign_component_no(new_cmp_no);
        }
        boolean all_items_inserted = true;
        boolean first_time = true;
        for (Item curr_item : this.item_list) {
            if (curr_item.board != null && curr_item.clearance_violation_count() == 0) {
                if (first_time) {
                    board.generate_snapshot();
                    first_time = false;
                }
                board.insert_item(curr_item.copy(0));
                continue;
            }
            all_items_inserted = false;
        }
        if (all_items_inserted) {
            this.hdlg.screen_messages.set_status_message(this.tm.getText("all_items_inserted", new String[0]));
        } else {
            this.hdlg.screen_messages.set_status_message(this.tm.getText("some_items_not_inserted_because_of_obstacles", new String[0]));
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.add_corner(this.current_position.to_float());
        }
        this.start_position = this.current_position;
        this.layer_changed = false;
        this.hdlg.repaint();
    }

    @Override
    public InteractiveState left_button_clicked(FloatPoint p_location) {
        this.insert();
        return this;
    }

    @Override
    public InteractiveState process_logfile_point(FloatPoint p_location) {
        this.change_position(p_location);
        this.insert();
        return this;
    }

    @Override
    public void draw(Graphics p_graphics) {
        if (this.item_list == null) {
            return;
        }
        for (Item curr_item : this.item_list) {
            curr_item.draw(p_graphics, this.hdlg.graphics_context, this.hdlg.graphics_context.get_hilight_color(), this.hdlg.graphics_context.get_hilight_color_intensity());
        }
    }

    @Override
    public JPopupMenu get_popup_menu() {
        return this.hdlg.get_panel().popup_menu_copy;
    }
}

