/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.interactive.ActivityReplayFileScanner;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.logger.FRLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;

public class ActivityReplayFile {
    private ActivityReplayFileScanner scanner;
    private FileWriter file_writer;
    private boolean write_enabled = false;
    private Object pending_token;

    public boolean start_read(InputStream p_input_stream) {
        this.scanner = new ActivityReplayFileScanner(p_input_stream);
        return true;
    }

    public FloatPoint read_corner() {
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < 2; ++i) {
            Object curr_ob = this.next_token();
            if (!(curr_ob instanceof Double)) {
                this.pending_token = curr_ob;
                return null;
            }
            double f = (Double)curr_ob;
            if (i == 0) {
                x = f;
                continue;
            }
            y = f;
        }
        return new FloatPoint(x, y);
    }

    public void close_output() {
        if (this.file_writer != null) {
            try {
                this.file_writer.close();
            }
            catch (IOException e) {
                FRLogger.error("Unable to close the file", e);
            }
        }
        this.write_enabled = false;
    }

    public boolean start_write(File p_file) {
        try {
            this.file_writer = new FileWriter(p_file);
        }
        catch (IOException e) {
            FRLogger.error("Unable to create the file", e);
            return false;
        }
        this.write_enabled = true;
        return true;
    }

    public void start_scope(ActivityReplayFileScope p_scope) {
        if (this.write_enabled) {
            try {
                this.file_writer.write(p_scope.name);
                this.file_writer.write("\n");
            }
            catch (IOException e) {
                FRLogger.error("ActivityReplayFile.start_scope: write failed", e);
            }
        }
    }

    public void start_scope(ActivityReplayFileScope p_scope, int p_int_value) {
        this.start_scope(p_scope);
        this.add_int(p_int_value);
    }

    public void start_scope(ActivityReplayFileScope p_scope, boolean p_boolean_value) {
        this.start_scope(p_scope);
        int int_value = p_boolean_value ? 1 : 0;
        this.add_int(int_value);
    }

    public void start_scope(ActivityReplayFileScope p_scope, FloatPoint p_start_corner) {
        this.start_scope(p_scope);
        this.add_corner(p_start_corner);
    }

    public ActivityReplayFileScope start_read_scope() {
        Object curr_ob = this.next_token();
        if (curr_ob == null) {
            return null;
        }
        if (!(curr_ob instanceof String)) {
            FRLogger.warn("ActivityReplayFile.start_read_scope: String expected");
            this.pending_token = curr_ob;
            return null;
        }
        return ActivityReplayFileScope.get_scope((String)curr_ob);
    }

    public void add_int(int p_int) {
        if (this.write_enabled) {
            try {
                this.file_writer.write(String.valueOf(p_int));
                this.file_writer.write("\n");
            }
            catch (IOException e) {
                FRLogger.error("Unable to write integer to the file", e);
            }
        }
    }

    public int read_int() {
        Object curr_ob = this.next_token();
        if (!(curr_ob instanceof Integer)) {
            FRLogger.warn("ActivityReplayFile.read_int: Integer expected");
            this.pending_token = curr_ob;
            return -1;
        }
        return (Integer)curr_ob;
    }

    public void add_corner(FloatPoint p_corner) {
        if (this.write_enabled) {
            if (p_corner == null) {
                FRLogger.warn("ActivityReplayFile.add_corner: p_corner is null");
                return;
            }
            try {
                this.file_writer.write(String.valueOf(p_corner.x));
                this.file_writer.write(" ");
                this.file_writer.write(String.valueOf(p_corner.y));
                this.file_writer.write("\n");
            }
            catch (IOException e) {
                FRLogger.error("Unable to write to the file  while adding corner", e);
            }
        }
    }

    private Object next_token() {
        if (this.pending_token != null) {
            Object result = this.pending_token;
            this.pending_token = null;
            return result;
        }
        try {
            return this.scanner.next_token();
        }
        catch (IOException e) {
            FRLogger.error("ActivityReplayFile.next_token: IO error scanning file", e);
            return null;
        }
    }
}

