/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardPanel;
import app.freerouting.gui.BoardSavableSubWindow;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.management.analytics.FRAnalytics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class WindowVisibility
extends BoardSavableSubWindow {
    private static final int MAX_SLIDER_VALUE = 100;
    private final BoardPanel board_panel;
    private final JLabel header_message;
    private final JLabel[] message_arr;
    private final JSlider[] slider_arr;

    public WindowVisibility(BoardFrame p_board_frame, String p_title, String p_header_message, String[] p_message_arr) {
        this.board_panel = p_board_frame.board_panel;
        this.setLanguage(p_board_frame.get_locale());
        this.setTitle(p_title);
        JPanel main_panel = new JPanel();
        this.getContentPane().add(main_panel);
        GridBagLayout gridbag = new GridBagLayout();
        main_panel.setLayout(gridbag);
        GridBagConstraints gridbag_constraints = new GridBagConstraints();
        gridbag_constraints.insets = new Insets(5, 10, 5, 10);
        this.header_message = new JLabel();
        this.header_message.setText(p_header_message);
        gridbag_constraints.gridwidth = 0;
        gridbag_constraints.ipady = 10;
        gridbag.setConstraints(this.header_message, gridbag_constraints);
        main_panel.add(this.header_message);
        this.slider_arr = new JSlider[p_message_arr.length];
        this.message_arr = new JLabel[p_message_arr.length];
        gridbag_constraints.ipady = 0;
        for (int i = 0; i < p_message_arr.length; ++i) {
            this.message_arr[i] = new JLabel();
            this.message_arr[i].setText(p_message_arr[i]);
            gridbag_constraints.gridwidth = -1;
            gridbag.setConstraints(this.message_arr[i], gridbag_constraints);
            main_panel.add(this.message_arr[i]);
            this.slider_arr[i] = new JSlider(0, 100);
            gridbag_constraints.gridwidth = 0;
            gridbag.setConstraints(this.slider_arr[i], gridbag_constraints);
            main_panel.add(this.slider_arr[i]);
            this.slider_arr[i].addChangeListener(new SliderChangeListener(i));
        }
        JLabel empty_label = new JLabel();
        gridbag.setConstraints(empty_label, gridbag_constraints);
        main_panel.add(empty_label);
        gridbag_constraints.gridwidth = 2;
        JButton appearance_layer_visibility_min_all_button = new JButton(this.tm.getText("minimum_all", new String[0]));
        appearance_layer_visibility_min_all_button.setToolTipText(this.tm.getText("minimum_all_tooltip", new String[0]));
        appearance_layer_visibility_min_all_button.addActionListener(new MinAllButtonListener());
        appearance_layer_visibility_min_all_button.addActionListener(evt -> FRAnalytics.buttonClicked("appearance_layer_visibility_min_all_button", appearance_layer_visibility_min_all_button.getText()));
        gridbag.setConstraints(appearance_layer_visibility_min_all_button, gridbag_constraints);
        main_panel.add(appearance_layer_visibility_min_all_button);
        JButton appearance_layer_visibility_max_all_button = new JButton(this.tm.getText("maximum_all", new String[0]));
        appearance_layer_visibility_max_all_button.setToolTipText(this.tm.getText("maximum_all_tooltip", new String[0]));
        appearance_layer_visibility_max_all_button.addActionListener(new MaxAllButtonListener());
        appearance_layer_visibility_max_all_button.addActionListener(evt -> FRAnalytics.buttonClicked("appearance_layer_visibility_max_all_button", appearance_layer_visibility_max_all_button.getText()));
        gridbag.setConstraints(appearance_layer_visibility_max_all_button, gridbag_constraints);
        main_panel.add(appearance_layer_visibility_max_all_button);
        this.pack();
        this.setResizable(false);
    }

    public void set_slider_value(int p_no, double p_value) {
        int visibility = (int)Math.round(p_value * 100.0);
        this.slider_arr[p_no].setValue(visibility);
    }

    protected GuiBoardManager get_board_handling() {
        return this.board_panel.board_handling;
    }

    protected void set_all_minimum() {
        for (int i = 0; i < this.slider_arr.length; ++i) {
            this.set_slider_value(i, 0.0);
            this.set_changed_value(i, 0.0);
        }
    }

    protected void set_all_maximum() {
        for (int i = 0; i < this.slider_arr.length; ++i) {
            this.set_slider_value(i, 100.0);
            this.set_changed_value(i, 1.0);
        }
    }

    protected abstract void set_changed_value(int var1, double var2);

    private class SliderChangeListener
    implements ChangeListener {
        public int slider_no;

        public SliderChangeListener(int p_slider_no) {
            this.slider_no = p_slider_no;
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            int new_visibility = WindowVisibility.this.slider_arr[this.slider_no].getValue();
            WindowVisibility.this.set_changed_value(this.slider_no, (double)new_visibility / 100.0);
            WindowVisibility.this.board_panel.repaint();
        }
    }

    private class MinAllButtonListener
    implements ActionListener {
        private MinAllButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowVisibility.this.set_all_minimum();
            WindowVisibility.this.board_panel.repaint();
        }
    }

    private class MaxAllButtonListener
    implements ActionListener {
        private MaxAllButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowVisibility.this.set_all_maximum();
            WindowVisibility.this.board_panel.repaint();
        }
    }
}

