/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.AngleRestriction;
import app.freerouting.board.BoardOutline;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.Trace;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardSavableSubWindow;
import app.freerouting.gui.WindowManualRules;
import app.freerouting.gui.WindowMessage;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.rules.BoardRules;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.NumberFormat;
import java.util.Collection;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WindowRouteParameter
extends BoardSavableSubWindow {
    private static final int c_region_max_slider_value = 999;
    private static final int c_region_scale_factor = 200;
    private static final int c_accuracy_max_slider_value = 100;
    private static final int c_accuracy_scale_factor = 20;
    final WindowManualRules manual_rule_window;
    private final GuiBoardManager board_handling;
    private final JSlider region_slider;
    private final JFormattedTextField region_width_field;
    private final JFormattedTextField edge_to_turn_dist_field;
    private final JRadioButton settings_routing_snap_angle_90_button;
    private final JRadioButton settings_routing_snap_angle_45_button;
    private final JRadioButton settings_routing_snap_angle_none_button;
    private final JRadioButton settings_routing_dynamic_button;
    private final JRadioButton settings_routing_stitch_button;
    private final JRadioButton settings_routing_automatic_button;
    private final JRadioButton settings_routing_manual_button;
    private final JCheckBox settings_routing_shove_check_box;
    private final JCheckBox settings_routing_drag_component_check_box;
    private final JCheckBox settings_routing_ignore_conduction_check_box;
    private final JCheckBox settings_routing_via_snap_to_smd_center_check_box;
    private final JCheckBox settings_routing_hilight_routing_obstacle_check_box;
    private final JCheckBox settings_routing_neckdown_check_box;
    private final JCheckBox settings_routing_restrict_pin_exit_directions_check_box;
    private final ManualTraceWidthListener manual_trace_width_listener;
    private final JSlider accuracy_slider;
    private final JRadioButton route_detail_on_button;
    private final JRadioButton route_detail_off_button;
    private final JCheckBox route_detail_outline_keepout_check_box;
    private boolean key_input_completed = true;

    public WindowRouteParameter(BoardFrame p_board_frame) {
        this.board_handling = p_board_frame.board_panel.board_handling;
        this.manual_rule_window = new WindowManualRules(p_board_frame);
        this.setLanguage(p_board_frame.get_locale());
        this.setTitle(this.tm.getText("title", new String[0]));
        this.setDefaultCloseOperation(2);
        JPanel main_panel = new JPanel();
        this.getContentPane().add(main_panel);
        GridBagLayout gridbag = new GridBagLayout();
        main_panel.setLayout(gridbag);
        GridBagConstraints gridbag_constraints = new GridBagConstraints();
        gridbag_constraints.anchor = 17;
        gridbag_constraints.insets = new Insets(1, 10, 1, 10);
        JLabel snap_angle_label = new JLabel(this.tm.getText("snap_angle", new String[0]));
        snap_angle_label.setToolTipText(this.tm.getText("snap_angle_tooltip", new String[0]));
        gridbag_constraints.gridwidth = -1;
        gridbag_constraints.gridheight = 3;
        gridbag.setConstraints(snap_angle_label, gridbag_constraints);
        main_panel.add(snap_angle_label);
        this.settings_routing_snap_angle_90_button = new JRadioButton(this.tm.getText("90_degree", new String[0]));
        this.settings_routing_snap_angle_45_button = new JRadioButton(this.tm.getText("45_degree", new String[0]));
        this.settings_routing_snap_angle_none_button = new JRadioButton(this.tm.getText("none", new String[0]));
        this.settings_routing_snap_angle_90_button.addActionListener(new SnapAngle90Listener());
        this.settings_routing_snap_angle_90_button.addActionListener(evt -> FRAnalytics.buttonClicked("settings_routing_snap_angle_90_button", this.settings_routing_snap_angle_90_button.getText()));
        this.settings_routing_snap_angle_45_button.addActionListener(new SnapAngle45Listener());
        this.settings_routing_snap_angle_45_button.addActionListener(evt -> FRAnalytics.buttonClicked("settings_routing_snap_angle_45_button", this.settings_routing_snap_angle_45_button.getText()));
        this.settings_routing_snap_angle_none_button.addActionListener(new SnapAngleNoneListener());
        this.settings_routing_snap_angle_none_button.addActionListener(evt -> FRAnalytics.buttonClicked("settings_routing_snap_angle_none_button", this.settings_routing_snap_angle_none_button.getText()));
        ButtonGroup snap_angle_button_group = new ButtonGroup();
        snap_angle_button_group.add(this.settings_routing_snap_angle_90_button);
        snap_angle_button_group.add(this.settings_routing_snap_angle_45_button);
        snap_angle_button_group.add(this.settings_routing_snap_angle_none_button);
        this.settings_routing_snap_angle_none_button.setSelected(true);
        gridbag_constraints.gridwidth = 0;
        gridbag_constraints.gridheight = 1;
        gridbag.setConstraints(this.settings_routing_snap_angle_90_button, gridbag_constraints);
        main_panel.add((Component)this.settings_routing_snap_angle_90_button, gridbag_constraints);
        gridbag.setConstraints(this.settings_routing_snap_angle_45_button, gridbag_constraints);
        main_panel.add((Component)this.settings_routing_snap_angle_45_button, gridbag_constraints);
        gridbag.setConstraints(this.settings_routing_snap_angle_none_button, gridbag_constraints);
        main_panel.add((Component)this.settings_routing_snap_angle_none_button, gridbag_constraints);
        JLabel separator = new JLabel("   \u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        JLabel route_mode_label = new JLabel(this.tm.getText("route_mode", new String[0]));
        route_mode_label.setToolTipText(this.tm.getText("route_mode_tooltip", new String[0]));
        gridbag_constraints.gridwidth = -1;
        gridbag_constraints.gridheight = 2;
        gridbag.setConstraints(route_mode_label, gridbag_constraints);
        main_panel.add(route_mode_label);
        this.settings_routing_dynamic_button = new JRadioButton(this.tm.getText("dynamic", new String[0]));
        this.settings_routing_stitch_button = new JRadioButton(this.tm.getText("stitching", new String[0]));
        this.settings_routing_dynamic_button.addActionListener(new DynamicRouteListener());
        this.settings_routing_dynamic_button.addActionListener(evt -> FRAnalytics.buttonClicked("settings_routing_dynamic_button", this.settings_routing_dynamic_button.getText()));
        this.settings_routing_stitch_button.addActionListener(new StitchRouteListener());
        this.settings_routing_stitch_button.addActionListener(evt -> FRAnalytics.buttonClicked("settings_routing_stitch_button", this.settings_routing_stitch_button.getText()));
        ButtonGroup route_mode_button_group = new ButtonGroup();
        route_mode_button_group.add(this.settings_routing_dynamic_button);
        route_mode_button_group.add(this.settings_routing_stitch_button);
        this.settings_routing_dynamic_button.setSelected(true);
        gridbag_constraints.gridwidth = 0;
        gridbag_constraints.gridheight = 1;
        gridbag.setConstraints(this.settings_routing_dynamic_button, gridbag_constraints);
        main_panel.add((Component)this.settings_routing_dynamic_button, gridbag_constraints);
        gridbag.setConstraints(this.settings_routing_stitch_button, gridbag_constraints);
        main_panel.add((Component)this.settings_routing_stitch_button, gridbag_constraints);
        separator = new JLabel("  \u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        JLabel trace_widths_label = new JLabel(this.tm.getText("rule_selection", new String[0]));
        trace_widths_label.setToolTipText(this.tm.getText("rule_selection_tooltip", new String[0]));
        gridbag_constraints.gridwidth = -1;
        gridbag_constraints.gridheight = 2;
        gridbag.setConstraints(trace_widths_label, gridbag_constraints);
        main_panel.add(trace_widths_label);
        this.settings_routing_automatic_button = new JRadioButton(this.tm.getText("automatic", new String[0]));
        this.settings_routing_manual_button = new JRadioButton(this.tm.getText("manual", new String[0]));
        this.settings_routing_automatic_button.addActionListener(new AutomaticTraceWidthListener());
        this.settings_routing_automatic_button.addActionListener(evt -> FRAnalytics.buttonClicked("settings_routing_automatic_button", this.settings_routing_automatic_button.getText()));
        this.manual_trace_width_listener = new ManualTraceWidthListener();
        this.settings_routing_manual_button.addActionListener(this.manual_trace_width_listener);
        this.settings_routing_manual_button.addActionListener(evt -> FRAnalytics.buttonClicked("settings_routing_manual_button", this.settings_routing_manual_button.getText()));
        ButtonGroup trace_widths_button_group = new ButtonGroup();
        trace_widths_button_group.add(this.settings_routing_automatic_button);
        trace_widths_button_group.add(this.settings_routing_manual_button);
        this.settings_routing_automatic_button.setSelected(true);
        gridbag_constraints.gridwidth = 0;
        gridbag_constraints.gridheight = 1;
        gridbag.setConstraints(this.settings_routing_automatic_button, gridbag_constraints);
        main_panel.add((Component)this.settings_routing_automatic_button, gridbag_constraints);
        gridbag.setConstraints(this.settings_routing_manual_button, gridbag_constraints);
        main_panel.add((Component)this.settings_routing_manual_button, gridbag_constraints);
        separator = new JLabel("  \u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        this.settings_routing_shove_check_box = new JCheckBox(this.tm.getText("push&shove_enabled", new String[0]));
        this.settings_routing_shove_check_box.addActionListener(new ShoveListener());
        this.settings_routing_shove_check_box.addActionListener(evt -> FRAnalytics.buttonClicked("settings_routing_shove_check_box", this.settings_routing_shove_check_box.getText()));
        gridbag.setConstraints(this.settings_routing_shove_check_box, gridbag_constraints);
        this.settings_routing_shove_check_box.setToolTipText(this.tm.getText("push&shove_enabled_tooltip", new String[0]));
        main_panel.add((Component)this.settings_routing_shove_check_box, gridbag_constraints);
        this.settings_routing_drag_component_check_box = new JCheckBox(this.tm.getText("drag_components_enabled", new String[0]));
        this.settings_routing_drag_component_check_box.addActionListener(new DragComponentListener());
        this.settings_routing_drag_component_check_box.addActionListener(evt -> FRAnalytics.buttonClicked("settings_routing_drag_component_check_box", this.settings_routing_drag_component_check_box.getText()));
        gridbag.setConstraints(this.settings_routing_drag_component_check_box, gridbag_constraints);
        this.settings_routing_drag_component_check_box.setToolTipText(this.tm.getText("drag_components_enabled_tooltip", new String[0]));
        main_panel.add((Component)this.settings_routing_drag_component_check_box, gridbag_constraints);
        this.settings_routing_via_snap_to_smd_center_check_box = new JCheckBox(this.tm.getText("via_snap_to_smd_center", new String[0]));
        this.settings_routing_via_snap_to_smd_center_check_box.addActionListener(new ViaSnapToSMDCenterListener());
        this.settings_routing_via_snap_to_smd_center_check_box.addActionListener(evt -> FRAnalytics.buttonClicked("settings_routing_via_snap_to_smd_center_check_box", this.settings_routing_via_snap_to_smd_center_check_box.getText()));
        gridbag.setConstraints(this.settings_routing_via_snap_to_smd_center_check_box, gridbag_constraints);
        this.settings_routing_via_snap_to_smd_center_check_box.setToolTipText(this.tm.getText("via_snap_to_smd_center_tooltip", new String[0]));
        main_panel.add((Component)this.settings_routing_via_snap_to_smd_center_check_box, gridbag_constraints);
        this.settings_routing_hilight_routing_obstacle_check_box = new JCheckBox(this.tm.getText("hilight_routing_obstacle", new String[0]));
        this.settings_routing_hilight_routing_obstacle_check_box.addActionListener(new HilightObstacleListener());
        this.settings_routing_hilight_routing_obstacle_check_box.addActionListener(evt -> FRAnalytics.buttonClicked("settings_routing_hilight_routing_obstacle_check_box", this.settings_routing_hilight_routing_obstacle_check_box.getText()));
        gridbag.setConstraints(this.settings_routing_hilight_routing_obstacle_check_box, gridbag_constraints);
        this.settings_routing_hilight_routing_obstacle_check_box.setToolTipText(this.tm.getText("hilight_routing_obstacle_tooltip", new String[0]));
        main_panel.add((Component)this.settings_routing_hilight_routing_obstacle_check_box, gridbag_constraints);
        this.settings_routing_ignore_conduction_check_box = new JCheckBox(this.tm.getText("ignore_conduction_areas", new String[0]));
        this.settings_routing_ignore_conduction_check_box.addActionListener(new IgnoreConductionListener());
        this.settings_routing_ignore_conduction_check_box.addActionListener(evt -> FRAnalytics.buttonClicked("settings_routing_ignore_conduction_check_box", this.settings_routing_ignore_conduction_check_box.getText()));
        gridbag.setConstraints(this.settings_routing_ignore_conduction_check_box, gridbag_constraints);
        this.settings_routing_ignore_conduction_check_box.setToolTipText(this.tm.getText("ignore_conduction_areas_tooltip", new String[0]));
        main_panel.add((Component)this.settings_routing_ignore_conduction_check_box, gridbag_constraints);
        this.settings_routing_neckdown_check_box = new JCheckBox(this.tm.getText("automatic_neckdown", new String[0]));
        this.settings_routing_neckdown_check_box.addActionListener(new NeckDownListener());
        this.settings_routing_neckdown_check_box.addActionListener(evt -> FRAnalytics.buttonClicked("settings_routing_neckdown_check_box", this.settings_routing_neckdown_check_box.getText()));
        gridbag.setConstraints(this.settings_routing_neckdown_check_box, gridbag_constraints);
        this.settings_routing_neckdown_check_box.setToolTipText(this.tm.getText("automatic_neckdown_tooltip", new String[0]));
        main_panel.add((Component)this.settings_routing_neckdown_check_box, gridbag_constraints);
        separator = new JLabel("  \u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        this.settings_routing_restrict_pin_exit_directions_check_box = new JCheckBox(this.tm.getText("restrict_pin_exit_directions", new String[0]));
        this.settings_routing_restrict_pin_exit_directions_check_box.addActionListener(new RestrictPinExitDirectionsListener());
        this.settings_routing_restrict_pin_exit_directions_check_box.addActionListener(evt -> FRAnalytics.buttonClicked("settings_routing_restrict_pin_exit_directions_check_box", this.settings_routing_restrict_pin_exit_directions_check_box.getText()));
        gridbag.setConstraints(this.settings_routing_restrict_pin_exit_directions_check_box, gridbag_constraints);
        this.settings_routing_restrict_pin_exit_directions_check_box.setToolTipText(this.tm.getText("restrict_pin_exit_directions_tooltip", new String[0]));
        main_panel.add((Component)this.settings_routing_restrict_pin_exit_directions_check_box, gridbag_constraints);
        gridbag_constraints.gridwidth = -1;
        JLabel pin_exit_edge_to_turn_label = new JLabel(this.tm.getText("pin_pad_to_turn_gap", new String[0]));
        pin_exit_edge_to_turn_label.setToolTipText(this.tm.getText("pin_pad_to_turn_gap_tooltip", new String[0]));
        gridbag.setConstraints(pin_exit_edge_to_turn_label, gridbag_constraints);
        main_panel.add(pin_exit_edge_to_turn_label);
        NumberFormat number_format = NumberFormat.getInstance(p_board_frame.get_locale());
        number_format.setMaximumFractionDigits(7);
        this.edge_to_turn_dist_field = new JFormattedTextField(number_format);
        this.edge_to_turn_dist_field.setColumns(5);
        gridbag_constraints.gridwidth = 0;
        gridbag.setConstraints(this.edge_to_turn_dist_field, gridbag_constraints);
        main_panel.add(this.edge_to_turn_dist_field);
        this.edge_to_turn_dist_field.addKeyListener(new EdgeToTurnDistFieldKeyListener());
        this.edge_to_turn_dist_field.addFocusListener(new EdgeToTurnDistFieldFocusListener());
        gridbag_constraints.gridwidth = 0;
        separator = new JLabel("\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        gridbag_constraints.gridwidth = -1;
        JLabel pull_tight_region_label = new JLabel(this.tm.getText("pull_tight_region", new String[0]));
        pull_tight_region_label.setToolTipText(this.tm.getText("pull_tight_region_tooltip", new String[0]));
        gridbag.setConstraints(pull_tight_region_label, gridbag_constraints);
        main_panel.add(pull_tight_region_label);
        this.region_width_field = new JFormattedTextField(number_format);
        this.region_width_field.setColumns(3);
        gridbag_constraints.gridwidth = 0;
        gridbag.setConstraints(this.region_width_field, gridbag_constraints);
        main_panel.add(this.region_width_field);
        this.region_width_field.addKeyListener(new RegionWidthFieldKeyListener());
        this.region_width_field.addFocusListener(new RegionWidthFieldFocusListener());
        this.region_slider = new JSlider();
        this.region_slider.setMaximum(999);
        this.region_slider.addChangeListener(new SliderChangeListener());
        gridbag.setConstraints(this.region_slider, gridbag_constraints);
        main_panel.add(this.region_slider);
        separator = new JLabel("\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        JLabel clearance_compensation_label = new JLabel(this.tm.getText("clearance_compensation", new String[0]));
        clearance_compensation_label.setToolTipText(this.tm.getText("clearance_compensation_tooltip", new String[0]));
        gridbag_constraints.gridwidth = -1;
        gridbag_constraints.gridheight = 2;
        gridbag.setConstraints(clearance_compensation_label, gridbag_constraints);
        main_panel.add(clearance_compensation_label);
        this.route_detail_on_button = new JRadioButton(this.tm.getText("on", new String[0]));
        this.route_detail_off_button = new JRadioButton(this.tm.getText("off", new String[0]));
        this.route_detail_on_button.addActionListener(new CompensationOnListener());
        this.route_detail_on_button.addActionListener(evt -> FRAnalytics.buttonClicked("route_detail_on_button", this.route_detail_on_button.getText()));
        this.route_detail_off_button.addActionListener(new CompensationOffListener());
        this.route_detail_off_button.addActionListener(evt -> FRAnalytics.buttonClicked("route_detail_off_button", this.route_detail_off_button.getText()));
        ButtonGroup clearance_compensation_button_group = new ButtonGroup();
        clearance_compensation_button_group.add(this.route_detail_on_button);
        clearance_compensation_button_group.add(this.route_detail_off_button);
        this.route_detail_off_button.setSelected(true);
        gridbag_constraints.gridwidth = 0;
        gridbag_constraints.gridheight = 1;
        gridbag.setConstraints(this.route_detail_on_button, gridbag_constraints);
        main_panel.add((Component)this.route_detail_on_button, gridbag_constraints);
        gridbag.setConstraints(this.route_detail_off_button, gridbag_constraints);
        main_panel.add((Component)this.route_detail_off_button, gridbag_constraints);
        JLabel separator2 = new JLabel("  \u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator2, gridbag_constraints);
        main_panel.add((Component)separator2, gridbag_constraints);
        JLabel pull_tight_accuracy_label = new JLabel(this.tm.getText("pull_tight_accuracy", new String[0]));
        pull_tight_accuracy_label.setToolTipText(this.tm.getText("pull_tight_accuracy_tooltip", new String[0]));
        gridbag_constraints.insets = new Insets(5, 10, 5, 10);
        gridbag.setConstraints(pull_tight_accuracy_label, gridbag_constraints);
        main_panel.add(pull_tight_accuracy_label);
        this.accuracy_slider = new JSlider();
        this.accuracy_slider.setMaximum(100);
        this.accuracy_slider.addChangeListener(new AccuracySliderChangeListener());
        gridbag.setConstraints(this.accuracy_slider, gridbag_constraints);
        main_panel.add(this.accuracy_slider);
        separator = new JLabel("  \u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        this.route_detail_outline_keepout_check_box = new JCheckBox(this.tm.getText("keepout_outside_outline", new String[0]));
        this.route_detail_outline_keepout_check_box.setSelected(false);
        this.route_detail_outline_keepout_check_box.addActionListener(new OutLineKeepoutListener());
        this.route_detail_outline_keepout_check_box.addActionListener(evt -> FRAnalytics.buttonClicked("route_detail_outline_keepout_check_box", this.route_detail_outline_keepout_check_box.getText()));
        gridbag.setConstraints(this.route_detail_outline_keepout_check_box, gridbag_constraints);
        this.route_detail_outline_keepout_check_box.setToolTipText(this.tm.getText("keepout_outside_outline_tooltip", new String[0]));
        main_panel.add((Component)this.route_detail_outline_keepout_check_box, gridbag_constraints);
        this.refresh();
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void dispose() {
        this.manual_rule_window.dispose();
        super.dispose();
    }

    @Override
    public boolean read(ObjectInputStream p_object_stream) {
        boolean read_ok = super.read(p_object_stream);
        if (!read_ok) {
            return false;
        }
        read_ok = this.manual_rule_window.read(p_object_stream);
        if (!read_ok) {
            return false;
        }
        this.manual_trace_width_listener.first_time = false;
        this.refresh();
        return true;
    }

    @Override
    public void save(ObjectOutputStream p_object_stream) {
        super.save(p_object_stream);
        this.manual_rule_window.save(p_object_stream);
    }

    @Override
    public void refresh() {
        AngleRestriction snap_angle = this.board_handling.get_routing_board().rules.get_trace_angle_restriction();
        if (snap_angle == AngleRestriction.NINETY_DEGREE) {
            this.settings_routing_snap_angle_90_button.setSelected(true);
        } else if (snap_angle == AngleRestriction.FORTYFIVE_DEGREE) {
            this.settings_routing_snap_angle_45_button.setSelected(true);
        } else {
            this.settings_routing_snap_angle_none_button.setSelected(true);
        }
        if (this.board_handling.settings.get_is_stitch_route()) {
            this.settings_routing_stitch_button.setSelected(true);
        } else {
            this.settings_routing_dynamic_button.setSelected(true);
        }
        if (this.board_handling.settings.get_manual_rule_selection()) {
            this.settings_routing_manual_button.setSelected(true);
            if (this.manual_rule_window != null) {
                this.manual_rule_window.setVisible(true);
            }
        } else {
            this.settings_routing_automatic_button.setSelected(true);
        }
        this.settings_routing_shove_check_box.setSelected(this.board_handling.settings.get_push_enabled());
        this.settings_routing_drag_component_check_box.setSelected(this.board_handling.settings.get_drag_components_enabled());
        this.settings_routing_via_snap_to_smd_center_check_box.setSelected(this.board_handling.settings.get_via_snap_to_smd_center());
        this.settings_routing_ignore_conduction_check_box.setSelected(this.board_handling.get_routing_board().rules.get_ignore_conduction());
        this.settings_routing_hilight_routing_obstacle_check_box.setSelected(this.board_handling.settings.get_hilight_routing_obstacle());
        this.settings_routing_neckdown_check_box.setSelected(this.board_handling.settings.autoroute_settings.get_automatic_neckdown());
        double edge_to_turn_dist = this.board_handling.get_routing_board().rules.get_pin_edge_to_turn_dist();
        edge_to_turn_dist = this.board_handling.coordinate_transform.board_to_user(edge_to_turn_dist);
        this.edge_to_turn_dist_field.setValue(edge_to_turn_dist);
        this.settings_routing_restrict_pin_exit_directions_check_box.setSelected(edge_to_turn_dist > 0.0);
        int region_slider_value = this.board_handling.settings.get_trace_pull_tight_region_width() / 200;
        region_slider_value = Math.min(region_slider_value, 999);
        this.region_slider.setValue(region_slider_value);
        this.region_width_field.setValue(region_slider_value);
        if (this.manual_rule_window != null) {
            this.manual_rule_window.refresh();
        }
        if (this.board_handling.get_routing_board().search_tree_manager.is_clearance_compensation_used()) {
            this.route_detail_on_button.setSelected(true);
        } else {
            this.route_detail_off_button.setSelected(true);
        }
        BoardOutline outline = this.board_handling.get_routing_board().get_outline();
        if (outline != null) {
            this.route_detail_outline_keepout_check_box.setSelected(outline.keepout_outside_outline_generated());
        }
        int accuracy_slider_value = 100 - this.board_handling.settings.autoroute_settings.trace_pull_tight_accuracy / 20 + 1;
        this.accuracy_slider.setValue(accuracy_slider_value);
    }

    @Override
    public void parent_iconified() {
        this.manual_rule_window.parent_iconified();
        super.parent_iconified();
    }

    @Override
    public void parent_deiconified() {
        this.manual_rule_window.parent_deiconified();
        super.parent_deiconified();
    }

    private void set_pull_tight_region_width(int p_slider_value) {
        int new_tidy_width;
        int slider_value = Math.max(p_slider_value, 0);
        slider_value = Math.min(p_slider_value, 999);
        if ((double)slider_value >= 899.1) {
            slider_value = 999;
            new_tidy_width = Integer.MAX_VALUE;
        } else {
            new_tidy_width = slider_value * 200;
        }
        this.region_slider.setValue(slider_value);
        this.region_width_field.setValue(slider_value);
        this.board_handling.settings.set_current_pull_tight_region_width(new_tidy_width);
    }

    private class SnapAngle90Listener
    implements ActionListener {
        private SnapAngle90Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            String curr_message;
            if (WindowRouteParameter.this.board_handling.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE) {
                return;
            }
            Collection<Trace> trace_list = WindowRouteParameter.this.board_handling.get_routing_board().get_traces();
            boolean free_angle_traces_found = false;
            for (Trace curr_trace : trace_list) {
                if (!(curr_trace instanceof PolylineTrace) || ((PolylineTrace)curr_trace).polyline().is_orthogonal()) continue;
                free_angle_traces_found = true;
                break;
            }
            if (free_angle_traces_found && !WindowMessage.confirm(curr_message = WindowRouteParameter.this.tm.getText("change_snap_angle_90", new String[0]))) {
                WindowRouteParameter.this.refresh();
                return;
            }
            WindowRouteParameter.this.board_handling.set_current_snap_angle(AngleRestriction.NINETY_DEGREE);
        }
    }

    private class SnapAngle45Listener
    implements ActionListener {
        private SnapAngle45Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            String curr_message;
            if (WindowRouteParameter.this.board_handling.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.FORTYFIVE_DEGREE) {
                return;
            }
            Collection<Trace> trace_list = WindowRouteParameter.this.board_handling.get_routing_board().get_traces();
            boolean free_angle_traces_found = false;
            for (Trace curr_trace : trace_list) {
                if (!(curr_trace instanceof PolylineTrace) || ((PolylineTrace)curr_trace).polyline().is_multiple_of_45_degree()) continue;
                free_angle_traces_found = true;
                break;
            }
            if (free_angle_traces_found && !WindowMessage.confirm(curr_message = WindowRouteParameter.this.tm.getText("change_snap_angle_45", new String[0]))) {
                WindowRouteParameter.this.refresh();
                return;
            }
            WindowRouteParameter.this.board_handling.set_current_snap_angle(AngleRestriction.FORTYFIVE_DEGREE);
        }
    }

    private class SnapAngleNoneListener
    implements ActionListener {
        private SnapAngleNoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowRouteParameter.this.board_handling.set_current_snap_angle(AngleRestriction.NONE);
        }
    }

    private class DynamicRouteListener
    implements ActionListener {
        private DynamicRouteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowRouteParameter.this.board_handling.settings.set_stitch_route(false);
        }
    }

    private class StitchRouteListener
    implements ActionListener {
        private StitchRouteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowRouteParameter.this.board_handling.settings.set_stitch_route(true);
        }
    }

    private class AutomaticTraceWidthListener
    implements ActionListener {
        private AutomaticTraceWidthListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowRouteParameter.this.manual_rule_window.setVisible(false);
            WindowRouteParameter.this.board_handling.settings.set_manual_tracewidth_selection(false);
        }
    }

    private class ManualTraceWidthListener
    implements ActionListener {
        boolean first_time = true;

        private ManualTraceWidthListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            if (this.first_time) {
                Point location = WindowRouteParameter.this.getLocation();
                WindowRouteParameter.this.manual_rule_window.setLocation((int)location.getX() + 200, (int)location.getY() + 200);
                this.first_time = false;
            }
            WindowRouteParameter.this.manual_rule_window.setVisible(true);
            WindowRouteParameter.this.board_handling.settings.set_manual_tracewidth_selection(true);
        }
    }

    private class ShoveListener
    implements ActionListener {
        private ShoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowRouteParameter.this.board_handling.settings.set_push_enabled(WindowRouteParameter.this.settings_routing_shove_check_box.isSelected());
            WindowRouteParameter.this.refresh();
        }
    }

    private class DragComponentListener
    implements ActionListener {
        private DragComponentListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowRouteParameter.this.board_handling.settings.set_drag_components_enabled(WindowRouteParameter.this.settings_routing_drag_component_check_box.isSelected());
            WindowRouteParameter.this.refresh();
        }
    }

    private class ViaSnapToSMDCenterListener
    implements ActionListener {
        private ViaSnapToSMDCenterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowRouteParameter.this.board_handling.settings.set_via_snap_to_smd_center(WindowRouteParameter.this.settings_routing_via_snap_to_smd_center_check_box.isSelected());
        }
    }

    private class HilightObstacleListener
    implements ActionListener {
        private HilightObstacleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowRouteParameter.this.board_handling.settings.set_hilight_routing_obstacle(WindowRouteParameter.this.settings_routing_hilight_routing_obstacle_check_box.isSelected());
        }
    }

    private class IgnoreConductionListener
    implements ActionListener {
        private IgnoreConductionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowRouteParameter.this.board_handling.set_ignore_conduction(WindowRouteParameter.this.settings_routing_ignore_conduction_check_box.isSelected());
        }
    }

    private class NeckDownListener
    implements ActionListener {
        private NeckDownListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowRouteParameter.this.board_handling.settings.autoroute_settings.set_automatic_neckdown(WindowRouteParameter.this.settings_routing_neckdown_check_box.isSelected());
        }
    }

    private class RestrictPinExitDirectionsListener
    implements ActionListener {
        private RestrictPinExitDirectionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            if (WindowRouteParameter.this.settings_routing_restrict_pin_exit_directions_check_box.isSelected()) {
                BoardRules board_rules = WindowRouteParameter.this.board_handling.get_routing_board().rules;
                double edge_to_turn_dist = WindowRouteParameter.this.board_handling.coordinate_transform.board_to_user(board_rules.get_min_trace_half_width());
                WindowRouteParameter.this.board_handling.set_pin_edge_to_turn_dist(edge_to_turn_dist);
            } else {
                WindowRouteParameter.this.board_handling.set_pin_edge_to_turn_dist(0.0);
            }
            WindowRouteParameter.this.refresh();
        }
    }

    private class EdgeToTurnDistFieldKeyListener
    extends KeyAdapter {
        private EdgeToTurnDistFieldKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent p_evt) {
            if (p_evt.getKeyChar() == '\n') {
                WindowRouteParameter.this.key_input_completed = true;
                Object input = WindowRouteParameter.this.edge_to_turn_dist_field.getValue();
                if (!(input instanceof Number)) {
                    return;
                }
                float input_value = ((Number)input).floatValue();
                WindowRouteParameter.this.board_handling.set_pin_edge_to_turn_dist(input_value);
                WindowRouteParameter.this.settings_routing_restrict_pin_exit_directions_check_box.setSelected(input_value > 0.0f);
                WindowRouteParameter.this.refresh();
            } else {
                WindowRouteParameter.this.key_input_completed = false;
            }
        }
    }

    private class EdgeToTurnDistFieldFocusListener
    implements FocusListener {
        private EdgeToTurnDistFieldFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent p_evt) {
            if (!WindowRouteParameter.this.key_input_completed) {
                double edge_to_turn_dist = WindowRouteParameter.this.board_handling.get_routing_board().rules.get_pin_edge_to_turn_dist();
                edge_to_turn_dist = WindowRouteParameter.this.board_handling.coordinate_transform.board_to_user(edge_to_turn_dist);
                WindowRouteParameter.this.edge_to_turn_dist_field.setValue(edge_to_turn_dist);
                WindowRouteParameter.this.key_input_completed = true;
            }
        }

        @Override
        public void focusGained(FocusEvent p_evt) {
        }
    }

    private class RegionWidthFieldKeyListener
    extends KeyAdapter {
        private RegionWidthFieldKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent p_evt) {
            if (p_evt.getKeyChar() == '\n') {
                WindowRouteParameter.this.key_input_completed = true;
                Object input = WindowRouteParameter.this.region_width_field.getValue();
                if (!(input instanceof Number)) {
                    return;
                }
                int input_value = ((Number)input).intValue();
                WindowRouteParameter.this.set_pull_tight_region_width(input_value);
            } else {
                WindowRouteParameter.this.key_input_completed = false;
            }
        }
    }

    private class RegionWidthFieldFocusListener
    implements FocusListener {
        private RegionWidthFieldFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent p_evt) {
            if (!WindowRouteParameter.this.key_input_completed) {
                WindowRouteParameter.this.region_width_field.setValue(WindowRouteParameter.this.region_slider.getValue());
                WindowRouteParameter.this.key_input_completed = true;
            }
        }

        @Override
        public void focusGained(FocusEvent p_evt) {
        }
    }

    private class SliderChangeListener
    implements ChangeListener {
        private SliderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            WindowRouteParameter.this.set_pull_tight_region_width(WindowRouteParameter.this.region_slider.getValue());
        }
    }

    private class CompensationOnListener
    implements ActionListener {
        private CompensationOnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowRouteParameter.this.board_handling.set_clearance_compensation(true);
        }
    }

    private class CompensationOffListener
    implements ActionListener {
        private CompensationOffListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowRouteParameter.this.board_handling.set_clearance_compensation(false);
        }
    }

    private class AccuracySliderChangeListener
    implements ChangeListener {
        private AccuracySliderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            int new_accuracy;
            WindowRouteParameter.this.board_handling.settings.autoroute_settings.trace_pull_tight_accuracy = new_accuracy = (100 - WindowRouteParameter.this.accuracy_slider.getValue() + 1) * 20;
        }
    }

    private class OutLineKeepoutListener
    implements ActionListener {
        private OutLineKeepoutListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            if (WindowRouteParameter.this.board_handling.is_board_read_only()) {
                return;
            }
            BoardOutline outline = WindowRouteParameter.this.board_handling.get_routing_board().get_outline();
            if (outline != null) {
                outline.generate_keepout_outside(WindowRouteParameter.this.route_detail_outline_keepout_check_box.isSelected());
            }
        }
    }
}

