/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardSavableSubWindow;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.management.analytics.FRAnalytics;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class WindowMoveParameter
extends BoardSavableSubWindow {
    private final GuiBoardManager board_handling;
    private final JFormattedTextField horizontal_grid_field;
    private final JFormattedTextField vertical_grid_field;
    private final JRadioButton settings_controls_zoom_radiobutton;
    private final JRadioButton settings_controls_rotate_radiobutton;
    private boolean key_input_completed = true;

    public WindowMoveParameter(BoardFrame p_board_frame) {
        this.setLanguage(p_board_frame.get_locale());
        this.board_handling = p_board_frame.board_panel.board_handling;
        this.setTitle(this.tm.getText("title", new String[0]));
        JPanel main_panel = new JPanel();
        this.add(main_panel);
        GridBagLayout gridbag = new GridBagLayout();
        main_panel.setLayout(gridbag);
        GridBagConstraints gridbag_constraints = new GridBagConstraints();
        gridbag_constraints.anchor = 17;
        gridbag_constraints.insets = new Insets(1, 10, 1, 10);
        gridbag_constraints.gridwidth = 2;
        JLabel horizontal_grid_label = new JLabel(this.tm.getText("horizontal_component_grid", new String[0]));
        gridbag.setConstraints(horizontal_grid_label, gridbag_constraints);
        main_panel.add(horizontal_grid_label);
        NumberFormat number_format = NumberFormat.getInstance(p_board_frame.get_locale());
        number_format.setMaximumFractionDigits(7);
        this.horizontal_grid_field = new JFormattedTextField(number_format);
        this.horizontal_grid_field.setColumns(5);
        gridbag_constraints.gridwidth = 0;
        gridbag.setConstraints(this.horizontal_grid_field, gridbag_constraints);
        main_panel.add(this.horizontal_grid_field);
        this.set_horizontal_grid_field(this.board_handling.settings.get_horizontal_component_grid());
        this.horizontal_grid_field.addKeyListener(new HorizontalGridFieldKeyListener());
        this.horizontal_grid_field.addFocusListener(new HorizontalGridFieldFocusListener());
        gridbag_constraints.gridwidth = 2;
        JLabel vertical_grid_label = new JLabel(this.tm.getText("vertical_component_grid", new String[0]));
        gridbag.setConstraints(vertical_grid_label, gridbag_constraints);
        main_panel.add(vertical_grid_label);
        this.vertical_grid_field = new JFormattedTextField(number_format);
        this.vertical_grid_field.setColumns(5);
        gridbag_constraints.gridwidth = 0;
        gridbag.setConstraints(this.vertical_grid_field, gridbag_constraints);
        main_panel.add(this.vertical_grid_field);
        this.set_vertical_grid_field(this.board_handling.settings.get_vertical_component_grid());
        this.vertical_grid_field.addKeyListener(new VerticalGridFieldKeyListener());
        this.vertical_grid_field.addFocusListener(new VerticalGridFieldFocusListener());
        JLabel separator = new JLabel("  \u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        JLabel wheel_function_label = new JLabel(this.tm.getText("wheel_function", new String[0]));
        gridbag_constraints.gridwidth = -1;
        gridbag_constraints.gridheight = 2;
        gridbag.setConstraints(wheel_function_label, gridbag_constraints);
        main_panel.add(wheel_function_label);
        wheel_function_label.setToolTipText(this.tm.getText("wheel_function_tooltip", new String[0]));
        this.settings_controls_zoom_radiobutton = new JRadioButton(this.tm.getText("zoom", new String[0]));
        this.settings_controls_rotate_radiobutton = new JRadioButton(this.tm.getText("rotate", new String[0]));
        this.settings_controls_zoom_radiobutton.addActionListener(new ZoomButtonListener());
        this.settings_controls_zoom_radiobutton.addActionListener(evt -> FRAnalytics.buttonClicked("settings_controls_zoom_radiobutton", this.settings_controls_zoom_radiobutton.getText()));
        this.settings_controls_rotate_radiobutton.addActionListener(new RotateButtonListener());
        this.settings_controls_rotate_radiobutton.addActionListener(evt -> FRAnalytics.buttonClicked("settings_controls_rotate_radiobutton", this.settings_controls_rotate_radiobutton.getText()));
        ButtonGroup button_group = new ButtonGroup();
        button_group.add(this.settings_controls_zoom_radiobutton);
        button_group.add(this.settings_controls_rotate_radiobutton);
        if (this.board_handling.settings.get_zoom_with_wheel()) {
            this.settings_controls_zoom_radiobutton.setSelected(true);
        } else {
            this.settings_controls_rotate_radiobutton.setSelected(true);
        }
        gridbag_constraints.gridwidth = 0;
        gridbag_constraints.gridheight = 1;
        gridbag.setConstraints(this.settings_controls_zoom_radiobutton, gridbag_constraints);
        main_panel.add((Component)this.settings_controls_zoom_radiobutton, gridbag_constraints);
        gridbag.setConstraints(this.settings_controls_rotate_radiobutton, gridbag_constraints);
        main_panel.add((Component)this.settings_controls_rotate_radiobutton, gridbag_constraints);
        this.refresh();
        this.pack();
        this.setResizable(false);
    }

    private void set_horizontal_grid_field(double p_value) {
        if (p_value <= 0.0) {
            this.horizontal_grid_field.setValue(0);
        } else {
            Float grid_width = Float.valueOf((float)this.board_handling.coordinate_transform.board_to_user(p_value));
            this.horizontal_grid_field.setValue(grid_width);
        }
    }

    private void set_vertical_grid_field(double p_value) {
        if (p_value <= 0.0) {
            this.vertical_grid_field.setValue(0);
        } else {
            Float grid_width = Float.valueOf((float)this.board_handling.coordinate_transform.board_to_user(p_value));
            this.vertical_grid_field.setValue(grid_width);
        }
    }

    private class HorizontalGridFieldKeyListener
    extends KeyAdapter {
        private HorizontalGridFieldKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent p_evt) {
            if (p_evt.getKeyChar() == '\n') {
                double input_value;
                WindowMoveParameter.this.key_input_completed = true;
                Object input = WindowMoveParameter.this.horizontal_grid_field.getValue();
                if (!(input instanceof Number)) {
                    double d = 0.0;
                }
                if ((input_value = ((Number)input).doubleValue()) < 0.0) {
                    input_value = 0.0;
                }
                WindowMoveParameter.this.board_handling.settings.set_horizontal_component_grid((int)Math.round(WindowMoveParameter.this.board_handling.coordinate_transform.user_to_board(input_value)));
                WindowMoveParameter.this.set_horizontal_grid_field(WindowMoveParameter.this.board_handling.settings.get_horizontal_component_grid());
            } else {
                WindowMoveParameter.this.key_input_completed = false;
            }
        }
    }

    private class HorizontalGridFieldFocusListener
    implements FocusListener {
        private HorizontalGridFieldFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent p_evt) {
            if (!WindowMoveParameter.this.key_input_completed) {
                WindowMoveParameter.this.set_horizontal_grid_field(WindowMoveParameter.this.board_handling.settings.get_horizontal_component_grid());
                WindowMoveParameter.this.key_input_completed = true;
            }
        }

        @Override
        public void focusGained(FocusEvent p_evt) {
        }
    }

    private class VerticalGridFieldKeyListener
    extends KeyAdapter {
        private VerticalGridFieldKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent p_evt) {
            if (p_evt.getKeyChar() == '\n') {
                double input_value;
                WindowMoveParameter.this.key_input_completed = true;
                Object input = WindowMoveParameter.this.vertical_grid_field.getValue();
                if (!(input instanceof Number)) {
                    double d = 0.0;
                }
                if ((input_value = ((Number)input).doubleValue()) < 0.0) {
                    input_value = 0.0;
                }
                WindowMoveParameter.this.board_handling.settings.set_vertical_component_grid((int)Math.round(WindowMoveParameter.this.board_handling.coordinate_transform.user_to_board(input_value)));
                WindowMoveParameter.this.set_vertical_grid_field(WindowMoveParameter.this.board_handling.settings.get_vertical_component_grid());
            } else {
                WindowMoveParameter.this.key_input_completed = false;
            }
        }
    }

    private class VerticalGridFieldFocusListener
    implements FocusListener {
        private VerticalGridFieldFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent p_evt) {
            if (!WindowMoveParameter.this.key_input_completed) {
                WindowMoveParameter.this.set_vertical_grid_field(WindowMoveParameter.this.board_handling.settings.get_vertical_component_grid());
                WindowMoveParameter.this.key_input_completed = true;
            }
        }

        @Override
        public void focusGained(FocusEvent p_evt) {
        }
    }

    private class ZoomButtonListener
    implements ActionListener {
        private ZoomButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowMoveParameter.this.board_handling.settings.set_zoom_with_wheel(true);
        }
    }

    private class RotateButtonListener
    implements ActionListener {
        private RotateButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowMoveParameter.this.board_handling.settings.set_zoom_with_wheel(false);
        }
    }
}

