/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.Item;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.WindowObjectListWithFilter;
import app.freerouting.interactive.RatsNest;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;

public class WindowIncompletes
extends WindowObjectListWithFilter {
    public WindowIncompletes(BoardFrame p_board_frame) {
        super(p_board_frame);
        this.setLanguage(p_board_frame.get_locale());
        this.setTitle(this.tm.getText("incompletes", new String[0]));
        this.list_empty_message.setText(this.tm.getText("route_completed", new String[0]));
    }

    @Override
    protected void fill_list() {
        RatsNest ratsnest = this.board_frame.board_panel.board_handling.get_ratsnest();
        Object[] sorted_arr = ratsnest.get_airlines();
        Arrays.sort(sorted_arr);
        for (int i = 0; i < sorted_arr.length; ++i) {
            this.add_to_list(sorted_arr[i]);
        }
        this.list.setVisibleRowCount(Math.min(sorted_arr.length, 20));
    }

    @Override
    protected void select_instances() {
        List selected_incompletes = this.list.getSelectedValuesList();
        if (selected_incompletes.isEmpty()) {
            return;
        }
        TreeSet<Item> selected_items = new TreeSet<Item>();
        for (int i = 0; i < selected_incompletes.size(); ++i) {
            RatsNest.AirLine curr_airline = (RatsNest.AirLine)selected_incompletes.get(i);
            selected_items.add(curr_airline.from_item);
            selected_items.add(curr_airline.to_item);
        }
        this.board_frame.board_panel.board_handling.select_items(selected_items);
        this.board_frame.board_panel.board_handling.zoom_selection();
    }
}

