/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.RoutingBoard;
import app.freerouting.core.Padstack;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardSavableSubWindow;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.rules.BoardRules;
import app.freerouting.rules.DefaultItemClearanceClasses;
import app.freerouting.rules.NetClass;
import app.freerouting.rules.ViaInfo;
import app.freerouting.rules.ViaInfos;
import app.freerouting.rules.ViaRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class WindowEditVias
extends BoardSavableSubWindow {
    private static final int TEXTFIELD_HEIGHT = 16;
    private static final int TEXTFIELD_WIDTH = 100;
    private final BoardFrame board_frame;
    private final JPanel main_panel;
    private final JComboBox<String> cl_class_combo_box;
    private final JComboBox<String> padstack_combo_box;
    private JScrollPane scroll_pane;
    private JTable table;
    private ViaTableModel table_model;

    public WindowEditVias(BoardFrame p_board_frame) {
        this.setLanguage(p_board_frame.get_locale());
        this.setTitle(this.tm.getText("title", new String[0]));
        this.board_frame = p_board_frame;
        this.main_panel = new JPanel();
        this.main_panel.setLayout(new BorderLayout());
        this.cl_class_combo_box = new JComboBox();
        this.padstack_combo_box = new JComboBox();
        this.add_combobox_items();
        this.add_table();
        JPanel via_info_button_panel = new JPanel();
        via_info_button_panel.setLayout(new FlowLayout());
        this.main_panel.add((Component)via_info_button_panel, "South");
        JButton rules_vias_vias_edit_add_button = new JButton(this.tm.getText("add", new String[0]));
        rules_vias_vias_edit_add_button.setToolTipText(this.tm.getText("add_tooltip", new String[0]));
        rules_vias_vias_edit_add_button.addActionListener(new AddViaListener());
        rules_vias_vias_edit_add_button.addActionListener(evt -> FRAnalytics.buttonClicked("rules_vias_vias_edit_add_button", rules_vias_vias_edit_add_button.getText()));
        via_info_button_panel.add(rules_vias_vias_edit_add_button);
        JButton rules_vias_vias_edit_remove_button = new JButton(this.tm.getText("remove", new String[0]));
        rules_vias_vias_edit_remove_button.setToolTipText(this.tm.getText("remove_tooltip", new String[0]));
        rules_vias_vias_edit_remove_button.addActionListener(new RemoveViaListener());
        rules_vias_vias_edit_remove_button.addActionListener(evt -> FRAnalytics.buttonClicked("rules_vias_vias_edit_remove_button", rules_vias_vias_edit_remove_button.getText()));
        via_info_button_panel.add(rules_vias_vias_edit_remove_button);
        this.add(this.main_panel);
        this.pack();
    }

    @Override
    public void refresh() {
        this.padstack_combo_box.removeAllItems();
        this.cl_class_combo_box.removeAllItems();
        this.add_combobox_items();
        this.table_model.set_values();
    }

    private void add_table() {
        this.table_model = new ViaTableModel();
        this.table = new JTable(this.table_model);
        this.scroll_pane = new JScrollPane(this.table);
        int table_height = 16 * this.table_model.getRowCount();
        int table_width = 100 * this.table_model.getColumnCount();
        this.table.setPreferredScrollableViewportSize(new Dimension(table_width, table_height));
        this.table.setSelectionMode(0);
        this.main_panel.add((Component)this.scroll_pane, "Center");
        this.table.getColumnModel().getColumn(ColumnName.CLEARANCE_CLASS.ordinal()).setCellEditor(new DefaultCellEditor(this.cl_class_combo_box));
        this.table.getColumnModel().getColumn(ColumnName.PADSTACK.ordinal()).setCellEditor(new DefaultCellEditor(this.padstack_combo_box));
    }

    private void add_combobox_items() {
        int i;
        RoutingBoard routing_board = this.board_frame.board_panel.board_handling.get_routing_board();
        for (i = 0; i < routing_board.rules.clearance_matrix.get_class_count(); ++i) {
            this.cl_class_combo_box.addItem(routing_board.rules.clearance_matrix.get_name(i));
        }
        for (i = 0; i < routing_board.library.via_padstack_count(); ++i) {
            this.padstack_combo_box.addItem(routing_board.library.get_via_padstack((int)i).name);
        }
    }

    private void adjust_table() {
        this.table_model = new ViaTableModel();
        this.table = new JTable(this.table_model);
        this.main_panel.remove(this.scroll_pane);
        this.add_table();
        this.pack();
        this.board_frame.refresh_windows();
    }

    private class AddViaListener
    implements ActionListener {
        private AddViaListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            String new_name;
            RoutingBoard routing_board = WindowEditVias.this.board_frame.board_panel.board_handling.get_routing_board();
            ViaInfos via_infos = routing_board.rules.via_infos;
            int no = 1;
            String name_start = WindowEditVias.this.tm.getText("new_via", new String[0]);
            while (via_infos.name_exists(new_name = name_start + no)) {
                ++no;
            }
            NetClass default_net_class = routing_board.rules.get_default_net_class();
            ViaInfo new_via = new ViaInfo(new_name, routing_board.library.get_via_padstack(0), default_net_class.default_item_clearance_classes.get(DefaultItemClearanceClasses.ItemClass.VIA), false, routing_board.rules);
            via_infos.add(new_via);
            WindowEditVias.this.adjust_table();
        }
    }

    private class RemoveViaListener
    implements ActionListener {
        private RemoveViaListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            if (WindowEditVias.this.table_model.getRowCount() <= 1) {
                WindowEditVias.this.board_frame.screen_messages.set_status_message(WindowEditVias.this.tm.getText("message_1", new String[0]));
                return;
            }
            int selected_row = WindowEditVias.this.table.getSelectedRow();
            if (selected_row < 0) {
                return;
            }
            Object via_name = WindowEditVias.this.table_model.getValueAt(selected_row, ColumnName.NAME.ordinal());
            if (!(via_name instanceof String)) {
                return;
            }
            BoardRules board_rules = WindowEditVias.this.board_frame.board_panel.board_handling.get_routing_board().rules;
            ViaInfo via_info = board_rules.via_infos.get((String)via_name);
            for (ViaRule curr_rule : board_rules.via_rules) {
                if (!curr_rule.contains(via_info)) continue;
                String message = WindowEditVias.this.tm.getText("message_2", new String[0]) + " " + curr_rule.name;
                WindowEditVias.this.board_frame.screen_messages.set_status_message(message);
                return;
            }
            if (board_rules.via_infos.remove(via_info)) {
                WindowEditVias.this.adjust_table();
                String message = WindowEditVias.this.tm.getText("via", new String[0]) + " " + via_info.get_name() + " " + WindowEditVias.this.tm.getText("removed", new String[0]);
                WindowEditVias.this.board_frame.screen_messages.set_status_message(message);
            }
        }
    }

    private class ViaTableModel
    extends AbstractTableModel {
        private final Object[][] data;
        private final String[] column_names = new String[ColumnName.values().length];

        public ViaTableModel() {
            for (int i = 0; i < this.column_names.length; ++i) {
                this.column_names[i] = WindowEditVias.this.tm.getText(ColumnName.values()[i].toString(), new String[0]);
            }
            BoardRules board_rules = WindowEditVias.this.board_frame.board_panel.board_handling.get_routing_board().rules;
            this.data = new Object[board_rules.via_infos.count()][];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = new Object[ColumnName.values().length];
            }
            this.set_values();
        }

        public void set_values() {
            BoardRules board_rules = WindowEditVias.this.board_frame.board_panel.board_handling.get_routing_board().rules;
            for (int i = 0; i < this.data.length; ++i) {
                ViaInfo curr_via = board_rules.via_infos.get(i);
                this.data[i][ColumnName.NAME.ordinal()] = curr_via.get_name();
                this.data[i][ColumnName.PADSTACK.ordinal()] = curr_via.get_padstack().name;
                this.data[i][ColumnName.CLEARANCE_CLASS.ordinal()] = board_rules.clearance_matrix.get_name(curr_via.get_clearance_class());
                this.data[i][ColumnName.ATTACH_SMD.ordinal()] = curr_via.attach_smd_allowed();
            }
        }

        @Override
        public String getColumnName(int p_col) {
            return this.column_names[p_col];
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.column_names.length;
        }

        @Override
        public Object getValueAt(int p_row, int p_col) {
            return this.data[p_row][p_col];
        }

        @Override
        public void setValueAt(Object p_value, int p_row, int p_col) {
            RoutingBoard routing_board = WindowEditVias.this.board_frame.board_panel.board_handling.get_routing_board();
            BoardRules board_rules = routing_board.rules;
            Object via_name = this.getValueAt(p_row, ColumnName.NAME.ordinal());
            if (!(via_name instanceof String)) {
                FRLogger.warn("ViaVindow.setValueAt: String expected");
                return;
            }
            ViaInfo via_info = board_rules.via_infos.get((String)via_name);
            if (via_info == null) {
                FRLogger.warn("ViaVindow.setValueAt: via_info not found");
                return;
            }
            if (p_col == ColumnName.NAME.ordinal()) {
                if (!(p_value instanceof String)) {
                    return;
                }
                String new_name = (String)p_value;
                if (board_rules.via_infos.name_exists(new_name)) {
                    return;
                }
                via_info.set_name(new_name);
                WindowEditVias.this.board_frame.via_window.refresh();
            } else if (p_col == ColumnName.PADSTACK.ordinal()) {
                if (!(p_value instanceof String)) {
                    return;
                }
                String new_name = (String)p_value;
                Padstack new_padstack = routing_board.library.get_via_padstack(new_name);
                if (new_padstack == null) {
                    FRLogger.warn("ViaVindow.setValueAt: via padstack not found");
                    return;
                }
                via_info.set_padstack(new_padstack);
            } else if (p_col == ColumnName.CLEARANCE_CLASS.ordinal()) {
                if (!(p_value instanceof String)) {
                    return;
                }
                String new_name = (String)p_value;
                int new_cl_class_index = board_rules.clearance_matrix.get_no(new_name);
                if (new_cl_class_index < 0) {
                    FRLogger.warn("ViaVindow.setValueAt: clearance class not found");
                    return;
                }
                via_info.set_clearance_class(new_cl_class_index);
            } else if (p_col == ColumnName.ATTACH_SMD.ordinal()) {
                if (!(p_value instanceof Boolean)) {
                    FRLogger.warn("ViaVindow.setValueAt: Boolean expected");
                    return;
                }
                Boolean attach_smd = (Boolean)p_value;
                via_info.set_attach_smd_allowed(attach_smd);
            }
            this.data[p_row][p_col] = p_value;
            this.fireTableCellUpdated(p_row, p_col);
        }

        @Override
        public boolean isCellEditable(int p_row, int p_col) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int p_col) {
            return this.getValueAt(0, p_col).getClass();
        }
    }

    private static enum ColumnName {
        NAME,
        PADSTACK,
        CLEARANCE_CLASS,
        ATTACH_SMD;

    }
}

