/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.logger.FRLogger;
import app.freerouting.management.TextManager;
import app.freerouting.management.analytics.FRAnalytics;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

public class WindowBase
extends JFrame {
    protected TextManager tm = null;
    private Instant gotFocusAt = null;

    WindowBase(int minWidth, int minHeight) {
        try {
            URL resource = this.getClass().getResource("/freerouting_icon_256x256_v3.png");
            BufferedImage image = ImageIO.read(resource);
            this.setIconImage(image);
        }
        catch (IOException e) {
            FRLogger.error("Couldn't load icon file 'freerouting_icon_256x256_v3.png'.", e);
        }
        this.setMinimumSize(new Dimension(minWidth, minHeight));
        this.addWindowFocusListener(new WindowFocusListener(this){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                Window window = e.getWindow();
                String className = window.getClass().getName();
                String title = "";
                if (window instanceof Frame) {
                    title = ((Frame)window).getTitle();
                }
                if (window instanceof WindowBase) {
                    ((WindowBase)window).gotFocusAt = Instant.now();
                }
                FRLogger.trace("Window '" + className + "' with title of '" + title + "' gained focus.");
                if (!Objects.equals(title, "")) {
                    FRAnalytics.setAppLocation(className, title);
                }
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                long gotFocusFor;
                Instant gotFocusAt;
                Window window = e.getWindow();
                String className = window.getClass().getName();
                String title = "";
                if (window instanceof Frame) {
                    title = ((Frame)window).getTitle();
                }
                if (window instanceof WindowBase && (gotFocusAt = ((WindowBase)window).gotFocusAt) != null && (gotFocusFor = Instant.now().getEpochSecond() - gotFocusAt.getEpochSecond()) > 1L) {
                    FRLogger.trace("Window '" + className + "' with title of '" + title + "' got the focus for " + gotFocusFor + " seconds.");
                }
                FRLogger.trace("Window '" + className + "' with title of '" + title + "' lost focus.");
            }
        });
    }

    public void setLanguage(Locale locale) {
        if (this.tm != null) {
            this.tm.setLocale(locale);
            this.updateTexts();
        } else {
            this.tm = new TextManager(this.getClass(), locale);
        }
    }

    public void updateTexts() {
    }
}

