/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.Layer;
import app.freerouting.board.LayerStructure;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardSavableSubWindow;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.settings.RouterSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WindowAutorouteParameter
extends BoardSavableSubWindow {
    private final GuiBoardManager board_handling;
    private final JLabel[] layer_name_arr;
    private final JLabel[] signal_layer_name_arr;
    private final JCheckBox[] settings_autorouter_layer_active_arr;
    private final List<JComboBox<String>> settings_autorouter_combo_box_arr;
    private final JCheckBox settings_autorouter_vias_allowed;
    private final JCheckBox settings_autorouter_fanout_pass_button;
    private final JCheckBox settings_autorouter_autoroute_pass_button;
    private final JCheckBox settings_autorouter_postroute_pass_button;
    private final String horizontal;
    private final String vertical;
    private final JFormattedTextField via_cost_field;
    private final JFormattedTextField plane_via_cost_field;
    private final JFormattedTextField start_ripup_costs;
    private final JFormattedTextField start_pass_no;
    private final JComboBox<String> settings_autorouter_detailed_speed_combo_box;
    private final String speed_fast;
    private final String speed_slow;
    private final JFormattedTextField[] preferred_direction_trace_cost_arr;
    private final JFormattedTextField[] against_preferred_direction_trace_cost_arr;
    private final boolean[] preferred_direction_trace_costs_input_completed;
    private final boolean[] against_preferred_direction_trace_costs_input_completed;
    private boolean via_cost_input_completed = true;
    private boolean plane_via_cost_input_completed = true;
    private boolean start_ripup_cost_input_completed = true;

    public WindowAutorouteParameter(BoardFrame p_board_frame) {
        this.setLanguage(p_board_frame.get_locale());
        this.board_handling = p_board_frame.board_panel.board_handling;
        this.setTitle(this.tm.getText("title", new String[0]));
        this.setDefaultCloseOperation(2);
        JPanel main_panel = new JPanel();
        this.getContentPane().add(main_panel);
        GridBagLayout gridbag = new GridBagLayout();
        main_panel.setLayout(gridbag);
        GridBagConstraints gridbag_constraints = new GridBagConstraints();
        gridbag_constraints.anchor = 17;
        gridbag_constraints.insets = new Insets(1, 10, 1, 10);
        gridbag_constraints.gridwidth = 3;
        JLabel layer_label = new JLabel(this.tm.getText("layer", new String[0]));
        gridbag.setConstraints(layer_label, gridbag_constraints);
        main_panel.add(layer_label);
        JLabel active_label = new JLabel(this.tm.getText("active", new String[0]));
        gridbag.setConstraints(active_label, gridbag_constraints);
        main_panel.add(active_label);
        gridbag_constraints.gridwidth = 0;
        JLabel preferred_direction_label = new JLabel(this.tm.getText("preferred_direction", new String[0]));
        gridbag.setConstraints(preferred_direction_label, gridbag_constraints);
        main_panel.add(preferred_direction_label);
        this.horizontal = this.tm.getText("horizontal", new String[0]);
        this.vertical = this.tm.getText("vertical", new String[0]);
        LayerStructure layer_structure = this.board_handling.get_routing_board().layer_structure;
        int layer_count = layer_structure.arr.length;
        this.layer_name_arr = new JLabel[layer_count];
        this.settings_autorouter_layer_active_arr = new JCheckBox[layer_count];
        this.settings_autorouter_combo_box_arr = new ArrayList<JComboBox<String>>(layer_count);
        for (int i = 0; i < layer_count; ++i) {
            gridbag_constraints.gridwidth = 3;
            Layer curr_layer = layer_structure.arr[i];
            this.layer_name_arr[i] = new JLabel();
            this.layer_name_arr[i].setText(curr_layer.name);
            gridbag.setConstraints(this.layer_name_arr[i], gridbag_constraints);
            main_panel.add(this.layer_name_arr[i]);
            this.settings_autorouter_layer_active_arr[i] = new JCheckBox();
            this.settings_autorouter_layer_active_arr[i].addActionListener(new LayerActiveListener(i));
            this.settings_autorouter_layer_active_arr[i].addActionListener(evt -> FRAnalytics.buttonClicked("settings_autorouter_layer_active_arr", null));
            this.board_handling.settings.autoroute_settings.set_layer_active(i, curr_layer.is_signal);
            this.settings_autorouter_layer_active_arr[i].setEnabled(curr_layer.is_signal);
            gridbag.setConstraints(this.settings_autorouter_layer_active_arr[i], gridbag_constraints);
            main_panel.add(this.settings_autorouter_layer_active_arr[i]);
            this.settings_autorouter_combo_box_arr.add(new JComboBox());
            this.settings_autorouter_combo_box_arr.get(i).addItem(this.horizontal);
            this.settings_autorouter_combo_box_arr.get(i).addItem(this.vertical);
            this.settings_autorouter_combo_box_arr.get(i).addActionListener(new PreferredDirectionListener(i));
            gridbag_constraints.gridwidth = 0;
            gridbag.setConstraints(this.settings_autorouter_combo_box_arr.get(i), gridbag_constraints);
            main_panel.add(this.settings_autorouter_combo_box_arr.get(i));
        }
        JLabel separator = new JLabel("\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        gridbag_constraints.gridwidth = 2;
        JLabel vias_allowed_label = new JLabel(this.tm.getText("vias_allowed", new String[0]));
        gridbag.setConstraints(vias_allowed_label, gridbag_constraints);
        main_panel.add(vias_allowed_label);
        this.settings_autorouter_vias_allowed = new JCheckBox();
        this.settings_autorouter_vias_allowed.addActionListener(new ViasAllowedListener());
        this.settings_autorouter_vias_allowed.addActionListener(evt -> FRAnalytics.buttonClicked("settings_autorouter_vias_allowed", this.settings_autorouter_vias_allowed.getText()));
        gridbag_constraints.gridwidth = 0;
        gridbag.setConstraints(this.settings_autorouter_vias_allowed, gridbag_constraints);
        main_panel.add(this.settings_autorouter_vias_allowed);
        separator = new JLabel("\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        JLabel passes_label = new JLabel(this.tm.getText("passes", new String[0]));
        gridbag_constraints.gridwidth = 2;
        gridbag_constraints.gridheight = 3;
        gridbag.setConstraints(passes_label, gridbag_constraints);
        main_panel.add(passes_label);
        this.settings_autorouter_fanout_pass_button = new JCheckBox(this.tm.getText("fanout", new String[0]));
        this.settings_autorouter_fanout_pass_button.setToolTipText(this.tm.getText("fanout_tooltip", new String[0]));
        this.settings_autorouter_autoroute_pass_button = new JCheckBox(this.tm.getText("autoroute", new String[0]));
        this.settings_autorouter_autoroute_pass_button.setToolTipText(this.tm.getText("autoroute_tooltip", new String[0]));
        this.settings_autorouter_postroute_pass_button = new JCheckBox(this.tm.getText("postroute", new String[0]));
        this.settings_autorouter_postroute_pass_button.setToolTipText(this.tm.getText("postroute_tooltip", new String[0]));
        this.settings_autorouter_fanout_pass_button.addActionListener(new FanoutListener());
        this.settings_autorouter_fanout_pass_button.addActionListener(evt -> FRAnalytics.buttonClicked("settings_autorouter_fanout_pass_button", this.settings_autorouter_fanout_pass_button.getText()));
        this.settings_autorouter_autoroute_pass_button.addActionListener(new AutorouteListener());
        this.settings_autorouter_autoroute_pass_button.addActionListener(evt -> FRAnalytics.buttonClicked("settings_autorouter_autoroute_pass_button", this.settings_autorouter_autoroute_pass_button.getText()));
        this.settings_autorouter_postroute_pass_button.addActionListener(new PostrouteListener());
        this.settings_autorouter_postroute_pass_button.addActionListener(evt -> FRAnalytics.buttonClicked("settings_autorouter_postroute_pass_button", this.settings_autorouter_postroute_pass_button.getText()));
        this.settings_autorouter_fanout_pass_button.setSelected(false);
        this.settings_autorouter_autoroute_pass_button.setSelected(true);
        this.settings_autorouter_postroute_pass_button.setSelected(false);
        gridbag_constraints.gridwidth = 0;
        gridbag_constraints.gridheight = 1;
        gridbag.setConstraints(this.settings_autorouter_fanout_pass_button, gridbag_constraints);
        main_panel.add((Component)this.settings_autorouter_fanout_pass_button, gridbag_constraints);
        gridbag.setConstraints(this.settings_autorouter_autoroute_pass_button, gridbag_constraints);
        main_panel.add((Component)this.settings_autorouter_autoroute_pass_button, gridbag_constraints);
        gridbag.setConstraints(this.settings_autorouter_postroute_pass_button, gridbag_constraints);
        main_panel.add((Component)this.settings_autorouter_postroute_pass_button, gridbag_constraints);
        separator = new JLabel("\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        gridbag_constraints.gridwidth = 2;
        JLabel via_cost_label = new JLabel(this.tm.getText("via_costs", new String[0]));
        gridbag.setConstraints(via_cost_label, gridbag_constraints);
        main_panel.add(via_cost_label);
        NumberFormat number_format = NumberFormat.getIntegerInstance(p_board_frame.get_locale());
        this.via_cost_field = new JFormattedTextField(number_format);
        this.via_cost_field.setColumns(3);
        this.via_cost_field.addKeyListener(new ViaCostFieldKeyListener());
        this.via_cost_field.addFocusListener(new ViaCostFieldFocusListener());
        gridbag_constraints.gridwidth = 0;
        gridbag.setConstraints(this.via_cost_field, gridbag_constraints);
        main_panel.add(this.via_cost_field);
        this.plane_via_cost_field = new JFormattedTextField(number_format);
        this.plane_via_cost_field.setColumns(3);
        this.plane_via_cost_field.addKeyListener(new PlaneViaCostFieldKeyListener());
        this.plane_via_cost_field.addFocusListener(new PlaneViaCostFieldFocusListener());
        gridbag_constraints.gridwidth = 2;
        JLabel plane_via_cost_label = new JLabel(this.tm.getText("plane_via_costs", new String[0]));
        gridbag.setConstraints(plane_via_cost_label, gridbag_constraints);
        main_panel.add(plane_via_cost_label);
        gridbag_constraints.gridwidth = 0;
        gridbag.setConstraints(this.plane_via_cost_field, gridbag_constraints);
        main_panel.add(this.plane_via_cost_field);
        gridbag_constraints.gridwidth = 2;
        JLabel start_pass_label = new JLabel(this.tm.getText("start_pass", new String[0]));
        gridbag.setConstraints(start_pass_label, gridbag_constraints);
        main_panel.add(start_pass_label);
        this.start_pass_no = new JFormattedTextField(number_format);
        this.start_pass_no.setColumns(5);
        this.start_pass_no.addKeyListener(new StartPassFieldKeyListener());
        this.start_pass_no.addFocusListener(new StartPassFieldFocusListener());
        gridbag_constraints.gridwidth = 0;
        gridbag.setConstraints(this.start_pass_no, gridbag_constraints);
        main_panel.add(this.start_pass_no);
        gridbag_constraints.gridwidth = 2;
        JLabel start_ripup_costs_label = new JLabel();
        start_ripup_costs_label.setText(this.tm.getText("start_ripup_costs", new String[0]));
        gridbag.setConstraints(start_ripup_costs_label, gridbag_constraints);
        main_panel.add(start_ripup_costs_label);
        this.start_ripup_costs = new JFormattedTextField(number_format);
        this.start_ripup_costs.setColumns(3);
        this.start_ripup_costs.addKeyListener(new StartRipupCostFieldKeyListener());
        this.start_ripup_costs.addFocusListener(new StartRipupCostFieldFocusListener());
        gridbag_constraints.gridwidth = 0;
        gridbag.setConstraints(this.start_ripup_costs, gridbag_constraints);
        main_panel.add(this.start_ripup_costs);
        this.speed_fast = this.tm.getText("fast", new String[0]);
        this.speed_slow = this.tm.getText("slow", new String[0]);
        this.settings_autorouter_detailed_speed_combo_box = new JComboBox();
        this.settings_autorouter_detailed_speed_combo_box.addItem(this.speed_fast);
        this.settings_autorouter_detailed_speed_combo_box.addItem(this.speed_slow);
        this.settings_autorouter_detailed_speed_combo_box.addActionListener(new SpeedListener());
        this.settings_autorouter_detailed_speed_combo_box.addActionListener(evt -> FRAnalytics.buttonClicked("settings_autorouter_detailed_speed_combo_box", this.settings_autorouter_detailed_speed_combo_box.getSelectedItem().toString()));
        gridbag_constraints.gridwidth = 2;
        JLabel speed_label = new JLabel();
        speed_label.setText(this.tm.getText("speed", new String[0]));
        gridbag.setConstraints(speed_label, gridbag_constraints);
        main_panel.add(speed_label);
        gridbag_constraints.gridwidth = 0;
        gridbag.setConstraints(this.settings_autorouter_detailed_speed_combo_box, gridbag_constraints);
        main_panel.add(this.settings_autorouter_detailed_speed_combo_box);
        JLabel separator2 = new JLabel("\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator2, gridbag_constraints);
        main_panel.add((Component)separator2, gridbag_constraints);
        gridbag_constraints.gridwidth = 3;
        JLabel trace_costs_on_layer = new JLabel(this.tm.getText("trace_costs_on_layer", new String[0]));
        gridbag.setConstraints(trace_costs_on_layer, gridbag_constraints);
        main_panel.add(trace_costs_on_layer);
        JLabel pref_dir_label = new JLabel(this.tm.getText("in_preferred_direction", new String[0]));
        gridbag.setConstraints(pref_dir_label, gridbag_constraints);
        main_panel.add(pref_dir_label);
        gridbag_constraints.gridwidth = 0;
        JLabel against_pref_dir_label = new JLabel(this.tm.getText("against_preferred_direction", new String[0]));
        gridbag.setConstraints(against_pref_dir_label, gridbag_constraints);
        main_panel.add(against_pref_dir_label);
        int signal_layer_count = layer_structure.signal_layer_count();
        this.signal_layer_name_arr = new JLabel[signal_layer_count];
        this.preferred_direction_trace_cost_arr = new JFormattedTextField[signal_layer_count];
        this.against_preferred_direction_trace_cost_arr = new JFormattedTextField[signal_layer_count];
        this.preferred_direction_trace_costs_input_completed = new boolean[signal_layer_count];
        this.against_preferred_direction_trace_costs_input_completed = new boolean[signal_layer_count];
        number_format = NumberFormat.getInstance(p_board_frame.get_locale());
        number_format.setMaximumFractionDigits(2);
        int TEXT_FIELD_LENGTH = 2;
        DecimalFormat float_number_format = new DecimalFormat("0.0");
        for (int i = 0; i < signal_layer_count; ++i) {
            this.signal_layer_name_arr[i] = new JLabel();
            Layer curr_signal_layer = layer_structure.get_signal_layer(i);
            this.signal_layer_name_arr[i].setText(curr_signal_layer.name);
            gridbag_constraints.gridwidth = 3;
            gridbag.setConstraints(this.signal_layer_name_arr[i], gridbag_constraints);
            main_panel.add(this.signal_layer_name_arr[i]);
            this.preferred_direction_trace_cost_arr[i] = new JFormattedTextField(float_number_format);
            this.preferred_direction_trace_cost_arr[i].setColumns(2);
            this.preferred_direction_trace_cost_arr[i].addKeyListener(new PreferredDirectionTraceCostKeyListener(i));
            this.preferred_direction_trace_cost_arr[i].addFocusListener(new PreferredDirectionTraceCostFocusListener(i));
            gridbag.setConstraints(this.preferred_direction_trace_cost_arr[i], gridbag_constraints);
            main_panel.add(this.preferred_direction_trace_cost_arr[i]);
            this.against_preferred_direction_trace_cost_arr[i] = new JFormattedTextField(float_number_format);
            this.against_preferred_direction_trace_cost_arr[i].setColumns(2);
            this.against_preferred_direction_trace_cost_arr[i].addKeyListener(new AgainstPreferredDirectionTraceCostKeyListener(i));
            this.against_preferred_direction_trace_cost_arr[i].addFocusListener(new AgainstPreferredDirectionTraceCostFocusListener(i));
            gridbag_constraints.gridwidth = 0;
            gridbag.setConstraints(this.against_preferred_direction_trace_cost_arr[i], gridbag_constraints);
            main_panel.add(this.against_preferred_direction_trace_cost_arr[i]);
            this.preferred_direction_trace_costs_input_completed[i] = true;
            this.against_preferred_direction_trace_costs_input_completed[i] = true;
        }
        JLabel applyValuesNote = new JLabel(this.tm.getText("apply_values_note", new String[0]));
        gridbag.setConstraints(applyValuesNote, gridbag_constraints);
        main_panel.add((Component)applyValuesNote, gridbag_constraints);
        this.refresh();
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void refresh() {
        int i;
        RouterSettings settings = this.board_handling.settings.autoroute_settings;
        LayerStructure layer_structure = this.board_handling.get_routing_board().layer_structure;
        this.settings_autorouter_vias_allowed.setSelected(settings.get_vias_allowed());
        this.settings_autorouter_fanout_pass_button.setSelected(settings.getRunFanout());
        this.settings_autorouter_autoroute_pass_button.setSelected(settings.getRunRouter());
        this.settings_autorouter_postroute_pass_button.setSelected(settings.getRunOptimizer());
        for (i = 0; i < this.settings_autorouter_layer_active_arr.length; ++i) {
            this.settings_autorouter_layer_active_arr[i].setSelected(settings.get_layer_active(i));
        }
        for (i = 0; i < this.settings_autorouter_combo_box_arr.size(); ++i) {
            if (settings.get_preferred_direction_is_horizontal(layer_structure.get_layer_no(i))) {
                this.settings_autorouter_combo_box_arr.get(i).setSelectedItem(this.horizontal);
                continue;
            }
            this.settings_autorouter_combo_box_arr.get(i).setSelectedItem(this.vertical);
        }
        this.via_cost_field.setValue(settings.get_via_costs());
        this.plane_via_cost_field.setValue(settings.get_plane_via_costs());
        this.start_ripup_costs.setValue(settings.get_start_ripup_costs());
        this.start_pass_no.setValue(settings.get_start_pass_no());
        for (i = 0; i < this.preferred_direction_trace_cost_arr.length; ++i) {
            this.preferred_direction_trace_cost_arr[i].setValue(settings.get_preferred_direction_trace_costs(layer_structure.get_layer_no(i)));
        }
        for (i = 0; i < this.against_preferred_direction_trace_cost_arr.length; ++i) {
            this.against_preferred_direction_trace_cost_arr[i].setValue(settings.get_against_preferred_direction_trace_costs(layer_structure.get_layer_no(i)));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void parent_iconified() {
        super.parent_iconified();
    }

    @Override
    public void parent_deiconified() {
        super.parent_deiconified();
    }

    public void set_start_pass_no(int input_value) {
        this.board_handling.settings.autoroute_settings.set_start_pass_no(input_value);
        this.start_pass_no.setValue(input_value);
    }

    public void set_stop_pass_no(int input_value) {
        this.board_handling.settings.autoroute_settings.set_stop_pass_no(input_value);
    }

    private class LayerActiveListener
    implements ActionListener {
        private final int signal_layer_no;

        public LayerActiveListener(int p_layer_no) {
            this.signal_layer_no = p_layer_no;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            int curr_layer_no = this.signal_layer_no;
            WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.set_layer_active(curr_layer_no, WindowAutorouteParameter.this.settings_autorouter_layer_active_arr[this.signal_layer_no].isSelected());
        }
    }

    private class PreferredDirectionListener
    implements ActionListener {
        private final int signal_layer_no;

        public PreferredDirectionListener(int p_layer_no) {
            this.signal_layer_no = p_layer_no;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            int curr_layer_no = WindowAutorouteParameter.this.board_handling.get_routing_board().layer_structure.get_layer_no(this.signal_layer_no);
            WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.set_preferred_direction_is_horizontal(curr_layer_no, WindowAutorouteParameter.this.settings_autorouter_combo_box_arr.get(this.signal_layer_no).getSelectedItem() == WindowAutorouteParameter.this.horizontal);
        }
    }

    private class ViasAllowedListener
    implements ActionListener {
        private ViasAllowedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.set_vias_allowed(WindowAutorouteParameter.this.settings_autorouter_vias_allowed.isSelected());
        }
    }

    private class FanoutListener
    implements ActionListener {
        private FanoutListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            RouterSettings autoroute_settings = WindowAutorouteParameter.this.board_handling.settings.autoroute_settings;
            autoroute_settings.setRunFanout(WindowAutorouteParameter.this.settings_autorouter_fanout_pass_button.isSelected());
            autoroute_settings.set_start_pass_no(1);
        }
    }

    private class AutorouteListener
    implements ActionListener {
        private AutorouteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            RouterSettings autoroute_settings = WindowAutorouteParameter.this.board_handling.settings.autoroute_settings;
            autoroute_settings.setRunRouter(WindowAutorouteParameter.this.settings_autorouter_autoroute_pass_button.isSelected());
            autoroute_settings.set_start_pass_no(1);
        }
    }

    private class PostrouteListener
    implements ActionListener {
        private PostrouteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            RouterSettings autoroute_settings = WindowAutorouteParameter.this.board_handling.settings.autoroute_settings;
            autoroute_settings.setRunOptimizer(WindowAutorouteParameter.this.settings_autorouter_postroute_pass_button.isSelected());
            autoroute_settings.set_start_pass_no(1);
        }
    }

    private class ViaCostFieldKeyListener
    extends KeyAdapter {
        private ViaCostFieldKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent p_evt) {
            if (p_evt.getKeyChar() == '\n') {
                int input_value;
                int old_value = WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.get_via_costs();
                Object input = WindowAutorouteParameter.this.via_cost_field.getValue();
                if (input instanceof Number) {
                    input_value = ((Number)input).intValue();
                    if (input_value <= 0) {
                        input_value = 1;
                        WindowAutorouteParameter.this.via_cost_field.setValue(input_value);
                    }
                } else {
                    input_value = old_value;
                    WindowAutorouteParameter.this.via_cost_field.setValue(old_value);
                }
                WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.set_via_costs(input_value);
                WindowAutorouteParameter.this.via_cost_field.setValue(input_value);
                WindowAutorouteParameter.this.via_cost_input_completed = true;
            } else {
                WindowAutorouteParameter.this.via_cost_input_completed = false;
            }
        }
    }

    private class ViaCostFieldFocusListener
    implements FocusListener {
        private ViaCostFieldFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent p_evt) {
            if (!WindowAutorouteParameter.this.via_cost_input_completed) {
                WindowAutorouteParameter.this.via_cost_input_completed = true;
                WindowAutorouteParameter.this.refresh();
            }
        }

        @Override
        public void focusGained(FocusEvent p_evt) {
        }
    }

    private class PlaneViaCostFieldKeyListener
    extends KeyAdapter {
        private PlaneViaCostFieldKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent p_evt) {
            if (p_evt.getKeyChar() == '\n') {
                int input_value;
                int old_value = WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.get_plane_via_costs();
                Object input = WindowAutorouteParameter.this.plane_via_cost_field.getValue();
                if (input instanceof Number) {
                    input_value = ((Number)input).intValue();
                    if (input_value <= 0) {
                        input_value = 1;
                        WindowAutorouteParameter.this.plane_via_cost_field.setValue(input_value);
                    }
                } else {
                    input_value = old_value;
                    WindowAutorouteParameter.this.plane_via_cost_field.setValue(old_value);
                }
                WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.set_plane_via_costs(input_value);
                WindowAutorouteParameter.this.plane_via_cost_field.setValue(input_value);
                WindowAutorouteParameter.this.plane_via_cost_input_completed = true;
            } else {
                WindowAutorouteParameter.this.plane_via_cost_input_completed = false;
            }
        }
    }

    private class PlaneViaCostFieldFocusListener
    implements FocusListener {
        private PlaneViaCostFieldFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent p_evt) {
            if (!WindowAutorouteParameter.this.plane_via_cost_input_completed) {
                WindowAutorouteParameter.this.plane_via_cost_input_completed = true;
                WindowAutorouteParameter.this.refresh();
            }
        }

        @Override
        public void focusGained(FocusEvent p_evt) {
        }
    }

    private class StartPassFieldKeyListener
    extends KeyAdapter {
        private StartPassFieldKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent p_evt) {
            if (p_evt.getKeyChar() == '\n') {
                int input_value;
                int old_value = WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.get_start_pass_no();
                Object input = WindowAutorouteParameter.this.start_pass_no.getValue();
                if (input instanceof Number) {
                    input_value = ((Number)input).intValue();
                    if (input_value < 1) {
                        input_value = 1;
                    }
                    if (input_value > 99) {
                        input_value = 99;
                    }
                } else {
                    input_value = old_value;
                }
                WindowAutorouteParameter.this.set_start_pass_no(input_value);
            }
        }
    }

    private class StartPassFieldFocusListener
    implements FocusListener {
        private StartPassFieldFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent p_evt) {
            if (!WindowAutorouteParameter.this.start_ripup_cost_input_completed) {
                WindowAutorouteParameter.this.refresh();
            }
        }

        @Override
        public void focusGained(FocusEvent p_evt) {
        }
    }

    private class StartRipupCostFieldKeyListener
    extends KeyAdapter {
        private StartRipupCostFieldKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent p_evt) {
            if (p_evt.getKeyChar() == '\n') {
                int input_value;
                int old_value = WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.get_start_ripup_costs();
                Object input = WindowAutorouteParameter.this.start_ripup_costs.getValue();
                if (input instanceof Number) {
                    input_value = ((Number)input).intValue();
                    if (input_value <= 0) {
                        input_value = 1;
                    }
                } else {
                    input_value = old_value;
                }
                WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.set_start_ripup_costs(input_value);
                WindowAutorouteParameter.this.start_ripup_costs.setValue(input_value);
                WindowAutorouteParameter.this.start_ripup_cost_input_completed = true;
            } else {
                WindowAutorouteParameter.this.start_ripup_cost_input_completed = false;
            }
        }
    }

    private class StartRipupCostFieldFocusListener
    implements FocusListener {
        private StartRipupCostFieldFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent p_evt) {
            if (!WindowAutorouteParameter.this.start_ripup_cost_input_completed) {
                WindowAutorouteParameter.this.start_ripup_cost_input_completed = true;
                WindowAutorouteParameter.this.refresh();
            }
        }

        @Override
        public void focusGained(FocusEvent p_evt) {
        }
    }

    private class SpeedListener
    implements ActionListener {
        private SpeedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            boolean new_is_slow;
            boolean old_is_slow = WindowAutorouteParameter.this.board_handling.get_routing_board().rules.get_use_slow_autoroute_algorithm();
            boolean bl = new_is_slow = WindowAutorouteParameter.this.settings_autorouter_detailed_speed_combo_box.getSelectedItem() == WindowAutorouteParameter.this.speed_slow;
            if (old_is_slow != new_is_slow) {
                WindowAutorouteParameter.this.board_handling.get_routing_board().rules.set_use_slow_autoroute_algorithm(new_is_slow);
                WindowAutorouteParameter.this.board_handling.get_routing_board().search_tree_manager.reset_compensated_trees();
            }
        }
    }

    private class PreferredDirectionTraceCostKeyListener
    extends KeyAdapter {
        private final int signal_layer_no;

        public PreferredDirectionTraceCostKeyListener(int p_layer_no) {
            this.signal_layer_no = p_layer_no;
        }

        @Override
        public void keyTyped(KeyEvent p_evt) {
            if (p_evt.getKeyChar() == '\n') {
                double input_value;
                int curr_layer_no = WindowAutorouteParameter.this.board_handling.get_routing_board().layer_structure.get_layer_no(this.signal_layer_no);
                double old_value = WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.get_preferred_direction_trace_costs(curr_layer_no);
                Object input = WindowAutorouteParameter.this.preferred_direction_trace_cost_arr[this.signal_layer_no].getValue();
                if (input instanceof Number) {
                    input_value = ((Number)input).doubleValue();
                    if (input_value <= 0.0) {
                        input_value = old_value;
                    }
                } else {
                    input_value = old_value;
                }
                WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.set_preferred_direction_trace_costs(curr_layer_no, input_value);
                WindowAutorouteParameter.this.preferred_direction_trace_cost_arr[this.signal_layer_no].setValue(input_value);
                WindowAutorouteParameter.this.preferred_direction_trace_costs_input_completed[this.signal_layer_no] = true;
            } else {
                WindowAutorouteParameter.this.preferred_direction_trace_costs_input_completed[this.signal_layer_no] = false;
            }
        }
    }

    private class PreferredDirectionTraceCostFocusListener
    implements FocusListener {
        private final int signal_layer_no;

        public PreferredDirectionTraceCostFocusListener(int p_layer_no) {
            this.signal_layer_no = p_layer_no;
        }

        @Override
        public void focusLost(FocusEvent p_evt) {
            if (!WindowAutorouteParameter.this.preferred_direction_trace_costs_input_completed[this.signal_layer_no]) {
                WindowAutorouteParameter.this.start_ripup_cost_input_completed = true;
                WindowAutorouteParameter.this.refresh();
            }
        }

        @Override
        public void focusGained(FocusEvent p_evt) {
        }
    }

    private class AgainstPreferredDirectionTraceCostKeyListener
    extends KeyAdapter {
        private final int signal_layer_no;

        public AgainstPreferredDirectionTraceCostKeyListener(int p_layer_no) {
            this.signal_layer_no = p_layer_no;
        }

        @Override
        public void keyTyped(KeyEvent p_evt) {
            if (p_evt.getKeyChar() == '\n') {
                double input_value;
                int curr_layer_no = WindowAutorouteParameter.this.board_handling.get_routing_board().layer_structure.get_layer_no(this.signal_layer_no);
                double old_value = WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.get_against_preferred_direction_trace_costs(curr_layer_no);
                Object input = WindowAutorouteParameter.this.against_preferred_direction_trace_cost_arr[this.signal_layer_no].getValue();
                if (input instanceof Number) {
                    input_value = ((Number)input).doubleValue();
                    if (input_value <= 0.0) {
                        input_value = old_value;
                    }
                } else {
                    input_value = old_value;
                }
                WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.set_against_preferred_direction_trace_costs(curr_layer_no, input_value);
                WindowAutorouteParameter.this.against_preferred_direction_trace_cost_arr[this.signal_layer_no].setValue(input_value);
                WindowAutorouteParameter.this.against_preferred_direction_trace_costs_input_completed[this.signal_layer_no] = true;
            } else {
                WindowAutorouteParameter.this.against_preferred_direction_trace_costs_input_completed[this.signal_layer_no] = false;
            }
        }
    }

    private class AgainstPreferredDirectionTraceCostFocusListener
    implements FocusListener {
        private final int signal_layer_no;

        public AgainstPreferredDirectionTraceCostFocusListener(int p_layer_no) {
            this.signal_layer_no = p_layer_no;
        }

        @Override
        public void focusLost(FocusEvent p_evt) {
            if (!WindowAutorouteParameter.this.against_preferred_direction_trace_costs_input_completed[this.signal_layer_no]) {
                WindowAutorouteParameter.this.start_ripup_cost_input_completed = true;
                WindowAutorouteParameter.this.refresh();
            }
        }

        @Override
        public void focusGained(FocusEvent p_evt) {
        }
    }
}

