/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;

public class PlaceholderTextField
extends JTextField {
    private final String placeholder;

    public PlaceholderTextField(final String placeholder) {
        this.placeholder = placeholder;
        this.setForeground(Color.GRAY);
        this.setText(placeholder);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (PlaceholderTextField.this.getText().equals(placeholder) || PlaceholderTextField.this.getText().isEmpty()) {
                    PlaceholderTextField.this.setForeground(Color.BLACK);
                    PlaceholderTextField.this.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (PlaceholderTextField.this.getText().isEmpty() || PlaceholderTextField.this.getText().equals(placeholder)) {
                    PlaceholderTextField.this.setForeground(Color.GRAY);
                    PlaceholderTextField.this.setText(placeholder);
                }
            }
        });
    }

    @Override
    public String getText() {
        String text = super.getText();
        return text.equals(this.placeholder) ? "" : text;
    }

    @Override
    public void setText(String text) {
        super.setText(text.isEmpty() ? this.placeholder : text);
        this.setForeground(text.isEmpty() ? Color.GRAY : Color.BLACK);
    }
}

