/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.LayerStructure;
import app.freerouting.management.TextManager;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class ComboBoxLayer
extends JComboBox<Layer> {
    public static final int ALL_LAYER_INDEX = -1;
    public static final int INNER_LAYER_INDEX = -2;
    private final Layer[] layer_arr;

    public ComboBoxLayer(LayerStructure p_layer_structure, Locale p_locale) {
        boolean add_inner_layer_item;
        TextManager tm = new TextManager(this.getClass(), p_locale);
        int signal_layer_count = p_layer_structure.signal_layer_count();
        int item_count = signal_layer_count + 1;
        boolean bl = add_inner_layer_item = signal_layer_count > 2;
        if (add_inner_layer_item) {
            ++item_count;
        }
        this.layer_arr = new Layer[item_count];
        this.layer_arr[0] = new Layer(tm.getText("all", new String[0]), -1);
        int curr_layer_no = 0;
        if (add_inner_layer_item) {
            this.layer_arr[1] = new Layer(tm.getText("inner", new String[0]), -2);
            ++curr_layer_no;
        }
        for (int i = 0; i < signal_layer_count; ++i) {
            app.freerouting.board.Layer curr_signal_layer = p_layer_structure.get_signal_layer(i);
            this.layer_arr[++curr_layer_no] = new Layer(curr_signal_layer.name, p_layer_structure.get_no(curr_signal_layer));
        }
        this.setModel(new DefaultComboBoxModel<Layer>(this.layer_arr));
        this.setSelectedIndex(0);
    }

    public Layer get_selected_layer() {
        return (Layer)this.getSelectedItem();
    }

    public static class Layer {
        final String name;
        final int index;

        Layer(String p_name, int p_index) {
            this.name = p_name;
            this.index = p_index;
        }

        public String toString() {
            return this.name;
        }
    }
}

