/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardSavableSubWindow;
import app.freerouting.management.TextManager;
import app.freerouting.management.analytics.FRAnalytics;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class ColorManager
extends BoardSavableSubWindow {
    private final JTable layers_color_table;
    private final JTable general_color_table;

    public ColorManager(BoardFrame p_board_frame) {
        this.setLanguage(p_board_frame.get_locale());
        GraphicsContext graphics_context = p_board_frame.board_panel.board_handling.graphics_context;
        this.setTitle(this.tm.getText("color_manager", new String[0]));
        JPanel panel = new JPanel();
        int textfield_height = 20;
        int table_width = 1100;
        int item_color_table_height = graphics_context.item_color_table.getRowCount() * 20;
        panel.setPreferredSize(new Dimension(1110, 90 + item_color_table_height));
        this.layers_color_table = new JTable(graphics_context.item_color_table);
        this.layers_color_table.setPreferredScrollableViewportSize(new Dimension(1100, item_color_table_height));
        JScrollPane item_scroll_pane = ColorManager.init_color_table(this.layers_color_table, p_board_frame.get_locale());
        panel.add((Component)item_scroll_pane, "North");
        this.general_color_table = new JTable(graphics_context.other_color_table);
        this.general_color_table.setPreferredScrollableViewportSize(new Dimension(1100, 20));
        JScrollPane other_scroll_pane = ColorManager.init_color_table(this.general_color_table, p_board_frame.get_locale());
        panel.add((Component)other_scroll_pane, "South");
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
        this.setResizable(false);
    }

    private static JScrollPane init_color_table(JTable p_color_table, Locale p_locale) {
        JScrollPane scroll_pane = new JScrollPane(p_color_table);
        p_color_table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        ColorManager.setUpColorEditor(p_color_table, p_locale);
        return scroll_pane;
    }

    private static void setUpColorEditor(JTable p_table, Locale p_locale) {
        JButton color_editor_button = new JButton(""){

            @Override
            public void setText(String s2) {
            }
        };
        color_editor_button.setBackground(Color.white);
        color_editor_button.setBorderPainted(false);
        color_editor_button.setMargin(new Insets(0, 0, 0, 0));
        ColorEditor colorEditor = new ColorEditor(color_editor_button);
        p_table.setDefaultEditor(Color.class, colorEditor);
        JColorChooser colorChooser = new JColorChooser();
        ActionListener okListener = e -> {
            colorEditor.currentColor = colorChooser.getColor();
        };
        TextManager tm = new TextManager(ColorManager.class, p_locale);
        JDialog dialog = JColorChooser.createDialog(color_editor_button, tm.getText("pick_a_color", new String[0]), true, colorChooser, okListener, null);
        color_editor_button.addActionListener(e -> {
            color_editor_button.setBackground(colorEditor.currentColor);
            colorChooser.setColor(colorEditor.currentColor);
            dialog.setVisible(true);
        });
        color_editor_button.addActionListener(evt -> FRAnalytics.buttonClicked("color_editor_button", color_editor_button.getText()));
    }

    public void set_table_models(GraphicsContext p_graphics_context) {
        this.layers_color_table.setModel(p_graphics_context.item_color_table);
        this.general_color_table.setModel(p_graphics_context.other_color_table);
    }

    private static class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder;
        Border selectedBorder;
        boolean isBordered;

        public ColorRenderer(boolean p_is_bordered) {
            this.isBordered = p_is_bordered;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable p_table, Object p_color, boolean p_is_selected, boolean p_has_focus, int p_row, int p_column) {
            this.setBackground((Color)p_color);
            if (this.isBordered) {
                if (p_is_selected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, p_table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, p_table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            return this;
        }
    }

    private static class ColorEditor
    extends DefaultCellEditor {
        Color currentColor;

        public ColorEditor(JButton b) {
            super(new JCheckBox());
            this.editorComponent = b;
            this.setClickCountToStart(1);
            b.addActionListener(e -> this.fireEditingStopped());
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JButton)this.editorComponent).setText(value.toString());
            this.currentColor = (Color)value;
            return this.editorComponent;
        }
    }
}

