/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.management.TextManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class BoardPanelStatus
extends JPanel {
    public final JLabel errorLabel;
    public final JLabel warningLabel;
    public final JLabel statusMessage;
    public final JLabel additionalMessage;
    public final JLabel currentLayer;
    public final JLabel currentBoardScore;
    public final JLabel mousePosition;
    public final JLabel unitLabel;
    private final JPanel errorsWarningsPanel;
    private final JLabel errorIcon;
    private final JLabel warningIcon;
    private final List<ErrorOrWarningLabelClickedListener> errorOrWarningLabelClickedListeners = new ArrayList<ErrorOrWarningLabelClickedListener>();

    BoardPanelStatus(Locale locale) {
        TextManager tm = new TextManager(this.getClass(), locale);
        this.setLayout(new BorderLayout());
        this.errorsWarningsPanel = new JPanel(new FlowLayout(0));
        this.warningIcon = new JLabel();
        tm.setText(this.warningIcon, "{{icon:alert}}", new String[0]);
        this.errorIcon = new JLabel();
        tm.setText(this.errorIcon, "{{icon:close-octagon}}", new String[0]);
        this.warningLabel = new JLabel("0", 10);
        this.errorLabel = new JLabel("0", 10);
        this.errorsWarningsPanel.add((Component)this.errorIcon, "West");
        this.errorsWarningsPanel.add((Component)this.errorLabel, "West");
        this.errorsWarningsPanel.add((Component)this.warningIcon, "West");
        this.errorsWarningsPanel.add((Component)this.warningLabel, "West");
        this.addErrorOrWarningLabelClickedListener();
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 10;
        this.warningLabel.setBorder(new EmptyBorder(top, left, bottom, right));
        this.errorLabel.setBorder(new EmptyBorder(top, left, bottom, right));
        this.statusMessage = new JLabel();
        this.statusMessage.setHorizontalAlignment(0);
        tm.setText(this.statusMessage, "status_line", new String[0]);
        this.errorsWarningsPanel.add((Component)this.statusMessage, "Center");
        this.additionalMessage = new JLabel();
        tm.setText(this.additionalMessage, "additional_text_field", new String[0]);
        this.additionalMessage.setMaximumSize(new Dimension(300, 14));
        this.additionalMessage.setMinimumSize(new Dimension(140, 14));
        this.additionalMessage.setPreferredSize(new Dimension(180, 14));
        this.errorsWarningsPanel.add((Component)this.additionalMessage, "East");
        this.add((Component)this.errorsWarningsPanel, "Center");
        JPanel rightMessagePanel = new JPanel(new BorderLayout());
        rightMessagePanel.setMinimumSize(new Dimension(200, 20));
        rightMessagePanel.setOpaque(false);
        rightMessagePanel.setPreferredSize(new Dimension(450, 20));
        this.currentLayer = new JLabel();
        tm.setText(this.currentLayer, "current_layer", new String[0]);
        rightMessagePanel.add((Component)this.currentLayer, "Center");
        this.currentBoardScore = new JLabel();
        tm.setText(this.currentBoardScore, "current_board_score", new String[0]);
        rightMessagePanel.add((Component)this.currentBoardScore, "Center");
        JPanel cursorPanel = new JPanel(new BorderLayout());
        cursorPanel.setMinimumSize(new Dimension(220, 14));
        cursorPanel.setPreferredSize(new Dimension(220, 14));
        this.mousePosition = new JLabel();
        this.mousePosition.setText("X 0.00   Y 0.00");
        this.mousePosition.setMaximumSize(new Dimension(170, 14));
        this.mousePosition.setPreferredSize(new Dimension(170, 14));
        cursorPanel.add((Component)this.mousePosition, "West");
        this.unitLabel = new JLabel();
        this.unitLabel.setHorizontalAlignment(0);
        this.unitLabel.setText("unit");
        this.unitLabel.setMaximumSize(new Dimension(100, 14));
        this.unitLabel.setMinimumSize(new Dimension(50, 14));
        this.unitLabel.setPreferredSize(new Dimension(50, 14));
        cursorPanel.add((Component)this.unitLabel, "East");
        rightMessagePanel.add((Component)cursorPanel, "East");
        this.add((Component)rightMessagePanel, "East");
    }

    private void addErrorOrWarningLabelClickedListener() {
        this.errorsWarningsPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BoardPanelStatus.this.raiseErrorOrWarningLabelClickedEvent();
            }
        });
        this.errorsWarningsPanel.setCursor(new Cursor(12));
    }

    private void raiseErrorOrWarningLabelClickedEvent() {
        for (ErrorOrWarningLabelClickedListener listener : this.errorOrWarningLabelClickedListeners) {
            listener.errorOrWarningLabelClicked();
        }
    }

    public void addErrorOrWarningLabelClickedListener(ErrorOrWarningLabelClickedListener listener) {
        this.errorOrWarningLabelClickedListeners.add(listener);
    }

    @FunctionalInterface
    public static interface ErrorOrWarningLabelClickedListener {
        public void errorOrWarningLabelClicked();
    }
}

