/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.core.RoutingJob;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.Cursor;
import app.freerouting.gui.PopupMenuCopy;
import app.freerouting.gui.PopupMenuCornerItemConstruction;
import app.freerouting.gui.PopupMenuDynamicRoute;
import app.freerouting.gui.PopupMenuInsertCancel;
import app.freerouting.gui.PopupMenuMain;
import app.freerouting.gui.PopupMenuMove;
import app.freerouting.gui.PopupMenuSelectedItems;
import app.freerouting.gui.PopupMenuStitchRoute;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.ScreenMessages;
import app.freerouting.logger.FRLogger;
import app.freerouting.settings.GlobalSettings;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class BoardPanel
extends JPanel {
    private static final double c_zoom_factor = 2.0;
    public final ScreenMessages screen_messages;
    public final BoardFrame board_frame;
    private final JScrollPane scroll_pane;
    private final GlobalSettings globalSettings;
    public JPopupMenu popup_menu_insert_cancel;
    public PopupMenuCopy popup_menu_copy;
    public PopupMenuMove popup_menu_move;
    public JPopupMenu popup_menu_corneritem_construction;
    public JPopupMenu popup_menu_main;
    public PopupMenuDynamicRoute popup_menu_dynamic_route;
    public PopupMenuStitchRoute popup_menu_stitch_route;
    public JPopupMenu popup_menu_select;
    GuiBoardManager board_handling;
    Point2D right_button_click_location;
    private Robot robot;
    private Point middle_drag_position;
    private Cursor custom_cursor;

    public BoardPanel(ScreenMessages p_screen_messages, BoardFrame p_board_frame, GlobalSettings globalSettings, RoutingJob routingJob) {
        this.screen_messages = p_screen_messages;
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            FRLogger.warn("unable to create robot");
        }
        this.board_frame = p_board_frame;
        this.globalSettings = globalSettings;
        this.scroll_pane = this.board_frame.scroll_pane;
        this.default_init(globalSettings, routingJob);
    }

    private void default_init(GlobalSettings globalSettings, RoutingJob routingJob) {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(0, 0, 0));
        this.setMaximumSize(new Dimension(30000, 20000));
        this.setMinimumSize(new Dimension(90, 60));
        this.setPreferredSize(new Dimension(1200, 900));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                BoardPanel.this.mouse_dragged_action(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                BoardPanel.this.mouse_moved_action(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                BoardPanel.this.board_handling.key_typed_action(evt.getKeyChar());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BoardPanel.this.mouse_clicked_action(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                BoardPanel.this.mouse_pressed_action(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BoardPanel.this.board_handling.button_released();
                BoardPanel.this.middle_drag_position = null;
            }
        });
        this.addMouseWheelListener(evt -> this.board_handling.mouse_wheel_moved(evt.getWheelRotation()));
        globalSettings.routerSettings.save_intermediate_stages = globalSettings.featureFlags.snapshots && globalSettings.routerSettings.save_intermediate_stages;
        this.board_handling = new GuiBoardManager(this, globalSettings, routingJob);
        this.setAutoscrolls(true);
        this.setCursor(new java.awt.Cursor(1));
    }

    public void reset_board_handling(RoutingJob routingJob) {
        this.board_handling = new GuiBoardManager(this, this.globalSettings, routingJob);
    }

    void create_popup_menus() {
        this.popup_menu_main = new PopupMenuMain(this.board_frame);
        this.popup_menu_dynamic_route = new PopupMenuDynamicRoute(this.board_frame);
        this.popup_menu_stitch_route = new PopupMenuStitchRoute(this.board_frame);
        this.popup_menu_corneritem_construction = new PopupMenuCornerItemConstruction(this.board_frame);
        this.popup_menu_select = new PopupMenuSelectedItems(this.board_frame);
        this.popup_menu_insert_cancel = new PopupMenuInsertCancel(this.board_frame);
        this.popup_menu_copy = new PopupMenuCopy(this.board_frame);
        this.popup_menu_move = new PopupMenuMove(this.board_frame);
    }

    public void zoom_with_mouse_wheel(Point2D p_point, int p_wheel_rotation) {
        if (this.middle_drag_position != null || p_wheel_rotation == 0) {
            return;
        }
        double zoom_factor = 1.0 - 0.1 * (double)p_wheel_rotation;
        zoom_factor = Math.max(zoom_factor, 0.5);
        this.zoom(zoom_factor, p_point);
    }

    private void mouse_pressed_action(MouseEvent evt) {
        if (evt.getButton() == 1) {
            this.board_handling.mouse_pressed(evt.getPoint());
        } else if (evt.getButton() == 2 && this.middle_drag_position == null) {
            this.middle_drag_position = new Point(evt.getPoint());
        }
    }

    private void mouse_dragged_action(MouseEvent evt) {
        if (this.middle_drag_position != null) {
            this.scroll_middle_mouse(evt);
        } else {
            this.board_handling.mouse_dragged(evt.getPoint());
            this.scroll_near_border(evt);
        }
    }

    private void mouse_moved_action(MouseEvent p_evt) {
        this.requestFocusInWindow();
        if (this.board_handling != null) {
            this.board_handling.mouse_moved(p_evt.getPoint());
        }
        if (this.custom_cursor != null) {
            this.custom_cursor.set_location(p_evt.getPoint());
            this.repaint();
        }
    }

    private void mouse_clicked_action(MouseEvent evt) {
        if (evt.getButton() == 1) {
            this.board_handling.left_button_clicked(evt.getPoint());
        } else if (evt.getButton() == 3) {
            JPopupMenu curr_menu = this.board_handling.get_current_popup_menu();
            if (curr_menu != null) {
                int curr_x = evt.getX();
                int curr_y = evt.getY();
                curr_menu.show(this, curr_x, curr_y);
            }
            this.right_button_click_location = evt.getPoint();
        }
    }

    @Override
    public void paintComponent(Graphics p_g) {
        super.paintComponent(p_g);
        if (this.board_handling != null) {
            this.board_handling.draw(p_g);
        }
        if (this.custom_cursor != null) {
            this.custom_cursor.draw(p_g);
        }
    }

    public Point get_viewport_position() {
        JViewport viewport = this.scroll_pane.getViewport();
        return viewport.getViewPosition();
    }

    void set_viewport_position(Point p_position) {
        JViewport viewport = this.scroll_pane.getViewport();
        viewport.setViewPosition(p_position);
    }

    public void zoom_in(Point2D p_position) {
        this.zoom(2.0, p_position);
    }

    public void zoom_out(Point2D p_position) {
        double zoom_factor = 0.5;
        this.zoom(zoom_factor, p_position);
    }

    public void zoom_frame(Point2D p_position1, Point2D p_position2) {
        double width_of_zoom_frame = Math.abs(p_position1.getX() - p_position2.getX());
        double height_of_zoom_frame = Math.abs(p_position1.getY() - p_position2.getY());
        double center_x = Math.min(p_position1.getX(), p_position2.getX()) + width_of_zoom_frame / 2.0;
        double center_y = Math.min(p_position1.getY(), p_position2.getY()) + height_of_zoom_frame / 2.0;
        Point2D.Double center_point = new Point2D.Double(center_x, center_y);
        Rectangle display_rect = this.get_viewport_bounds();
        double width_factor = display_rect.getWidth() / width_of_zoom_frame;
        double height_factor = display_rect.getHeight() / height_of_zoom_frame;
        Point2D changed_location = this.zoom(Math.min(width_factor, height_factor), center_point);
        this.set_viewport_center(changed_location);
    }

    public void center_display(Point2D p_new_center) {
        Point delta = this.set_viewport_center(p_new_center);
        Point2D new_center = this.get_viewport_center();
        Point new_mouse_location = new Point((int)(new_center.getX() - delta.getX()), (int)(new_center.getY() - delta.getY()));
        this.move_mouse(new_mouse_location);
        this.repaint();
        this.board_handling.activityReplayFile.start_scope(ActivityReplayFileScope.CENTER_DISPLAY);
        FloatPoint curr_corner = new FloatPoint(p_new_center.getX(), p_new_center.getY());
        this.board_handling.activityReplayFile.add_corner(curr_corner);
    }

    public Point2D get_viewport_center() {
        Point pos = this.get_viewport_position();
        Rectangle display_rect = this.get_viewport_bounds();
        return new Point2D.Double(pos.getX() + display_rect.getCenterX(), pos.getY() + display_rect.getCenterY());
    }

    public Point2D zoom(double p_factor, Point2D p_location) {
        int max_panel_size = 10000000;
        Dimension old_size = this.getSize();
        Point2D old_center = this.get_viewport_center();
        if (p_factor > 1.0 && Math.max(old_size.getWidth(), old_size.getHeight()) >= 1.0E7) {
            return p_location;
        }
        int new_width = (int)Math.round(p_factor * old_size.getWidth());
        int new_height = (int)Math.round(p_factor * old_size.getHeight());
        Dimension new_size = new Dimension(new_width, new_height);
        this.board_handling.graphics_context.change_panel_size(new_size);
        this.setPreferredSize(new_size);
        this.setSize(new_size);
        this.revalidate();
        Point2D.Double new_cursor = new Point2D.Double(p_location.getX() * p_factor, p_location.getY() * p_factor);
        double dx = ((Point2D)new_cursor).getX() - p_location.getX();
        double dy = ((Point2D)new_cursor).getY() - p_location.getY();
        Point2D.Double new_center = new Point2D.Double(old_center.getX() + dx, old_center.getY() + dy);
        Point adjustment_vector = this.set_viewport_center(new_center);
        this.repaint();
        Point2D.Double adjusted_new_cursor = new Point2D.Double(((Point2D)new_cursor).getX() + ((Point2D)adjustment_vector).getX() + 0.5, ((Point2D)new_cursor).getY() + ((Point2D)adjustment_vector).getY() + 0.5);
        return adjusted_new_cursor;
    }

    Rectangle get_viewport_bounds() {
        return this.scroll_pane.getViewportBorderBounds();
    }

    Point set_viewport_center(Point2D p_point) {
        Rectangle display_rect = this.get_viewport_bounds();
        double x_corner = p_point.getX() - display_rect.getWidth() / 2.0;
        double y_corner = p_point.getY() - display_rect.getHeight() / 2.0;
        Dimension panel_size = this.getSize();
        double adjusted_x_corner = Math.min(x_corner, panel_size.getWidth());
        adjusted_x_corner = Math.max(x_corner, 0.0);
        double adjusted_y_corner = Math.min(y_corner, panel_size.getHeight());
        adjusted_y_corner = Math.max(y_corner, 0.0);
        Point new_position = new Point((int)adjusted_x_corner, (int)adjusted_y_corner);
        this.set_viewport_position(new_position);
        Point adjustment_vector = new Point((int)(adjusted_x_corner - x_corner), (int)(adjusted_y_corner - y_corner));
        return adjustment_vector;
    }

    public void set_selected_signal_layer(int p_signal_layer_no) {
        if (this.board_frame.select_parameter_window != null) {
            this.board_frame.select_parameter_window.select(p_signal_layer_no);
            this.popup_menu_dynamic_route.disable_layer_item(p_signal_layer_no);
            this.popup_menu_stitch_route.disable_layer_item(p_signal_layer_no);
            this.popup_menu_copy.disable_layer_item(p_signal_layer_no);
        }
    }

    void init_colors() {
        this.board_handling.graphics_context.item_color_table.addTableModelListener(new ColorTableListener());
        this.board_handling.graphics_context.other_color_table.addTableModelListener(new ColorTableListener());
        this.setBackground(this.board_handling.graphics_context.get_background_color());
    }

    private void scroll_near_border(MouseEvent p_evt) {
        int border_dist = 50;
        Rectangle r = new Rectangle(p_evt.getX() - 50, p_evt.getY() - 50, 100, 100);
        ((JPanel)p_evt.getSource()).scrollRectToVisible(r);
    }

    private void scroll_middle_mouse(MouseEvent p_evt) {
        double delta_x = this.middle_drag_position.x - p_evt.getX();
        double delta_y = this.middle_drag_position.y - p_evt.getY();
        Point view_position = this.get_viewport_position();
        double x = (double)view_position.x + delta_x;
        double y = (double)view_position.y + delta_y;
        Dimension panel_size = this.getSize();
        x = Math.min(x, panel_size.getWidth() - this.get_viewport_bounds().getWidth());
        y = Math.min(y, panel_size.getHeight() - this.get_viewport_bounds().getHeight());
        x = Math.max(x, 0.0);
        y = Math.max(y, 0.0);
        Point p = new Point((int)x, (int)y);
        this.set_viewport_position(p);
    }

    public void move_mouse(Point2D p_location) {
        if (this.robot == null) {
            return;
        }
        Point absolute_panel_location = this.board_frame.absolute_panel_location();
        Point view_position = this.get_viewport_position();
        int x = (int)Math.round(absolute_panel_location.getX() - view_position.getX() + p_location.getX()) + 1;
        int y = (int)Math.round(absolute_panel_location.getY() - view_position.getY() + p_location.getY() + 1.0);
        this.robot.mouseMove(x, y);
    }

    public void set_custom_crosshair_cursor(boolean p_value) {
        this.custom_cursor = p_value ? Cursor.get_45_degree_cross_hair_cursor() : null;
        this.board_frame.refresh_windows();
        this.repaint();
    }

    public boolean is_custom_cross_hair_cursor() {
        return this.custom_cursor != null;
    }

    private class ColorTableListener
    implements TableModelListener {
        private ColorTableListener() {
        }

        @Override
        public void tableChanged(TableModelEvent p_event) {
            BoardPanel.this.setBackground(BoardPanel.this.board_handling.graphics_context.get_background_color());
            BoardPanel.this.repaint();
        }
    }
}

