/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.geometry.planar;

import app.freerouting.datastructures.BigIntAux;
import app.freerouting.datastructures.Signum;
import app.freerouting.geometry.planar.BigIntDirection;
import app.freerouting.geometry.planar.Direction;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntDirection;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.IntVector;
import app.freerouting.geometry.planar.Limits;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.RationalPoint;
import app.freerouting.geometry.planar.Side;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.logger.FRLogger;
import java.io.Serializable;
import java.math.BigInteger;

public class RationalVector
extends Vector
implements Serializable {
    public final BigInteger x;
    public final BigInteger y;
    public final BigInteger z;

    public RationalVector(BigInteger p_x, BigInteger p_y, BigInteger p_z) {
        if (p_z.signum() >= 0) {
            this.x = p_x;
            this.y = p_y;
            this.z = p_z;
        } else {
            this.x = p_x.negate();
            this.y = p_y.negate();
            this.z = p_z.negate();
        }
    }

    RationalVector(IntVector p_vector) {
        this.x = BigInteger.valueOf(p_vector.x);
        this.y = BigInteger.valueOf(p_vector.y);
        this.z = BigInteger.ONE;
    }

    @Override
    public final boolean is_zero() {
        return this.x.signum() == 0 && this.y.signum() == 0;
    }

    public final boolean equals(Object p_ob) {
        if (this == p_ob) {
            return true;
        }
        if (p_ob == null) {
            return false;
        }
        if (this.getClass() != p_ob.getClass()) {
            return false;
        }
        RationalPoint other = (RationalPoint)p_ob;
        BigInteger det = BigIntAux.determinant(this.x, other.x, this.z, other.z);
        if (det.signum() != 0) {
            return false;
        }
        det = BigIntAux.determinant(this.y, other.y, this.z, other.z);
        return det.signum() == 0;
    }

    @Override
    public Vector negate() {
        return new RationalVector(this.x.negate(), this.y.negate(), this.z);
    }

    @Override
    public final Vector add(Vector p_other) {
        return p_other.add(this);
    }

    @Override
    public Side side_of(Vector p_other) {
        Side tmp = p_other.side_of(this);
        return tmp.negate();
    }

    @Override
    public boolean is_orthogonal() {
        return this.x.signum() == 0 || this.y.signum() == 0;
    }

    @Override
    public boolean is_diagonal() {
        return this.x.abs().equals(this.y.abs());
    }

    @Override
    public Signum projection(Vector p_other) {
        return p_other.projection(this);
    }

    @Override
    public double scalar_product(Vector p_other) {
        return p_other.scalar_product(this);
    }

    @Override
    public FloatPoint to_float() {
        double xd = this.x.doubleValue();
        double yd = this.y.doubleValue();
        double zd = this.z.doubleValue();
        return new FloatPoint(xd / zd, yd / zd);
    }

    @Override
    public Vector change_length_approx(double p_length) {
        FRLogger.warn("RationalVector: change_length_approx not yet implemented");
        return this;
    }

    @Override
    public Vector turn_90_degree(int p_factor) {
        BigInteger new_y;
        BigInteger new_x;
        int n;
        for (n = p_factor; n < 0; n += 4) {
        }
        while (n >= 4) {
            n -= 4;
        }
        switch (n) {
            case 0: {
                new_x = this.x;
                new_y = this.y;
                break;
            }
            case 1: {
                new_x = this.y.negate();
                new_y = this.x;
                break;
            }
            case 2: {
                new_x = this.x.negate();
                new_y = this.y.negate();
                break;
            }
            case 3: {
                new_x = this.y;
                new_y = this.x.negate();
                break;
            }
            default: {
                return this;
            }
        }
        return new RationalVector(new_x, new_y, this.z);
    }

    @Override
    public Vector mirror_at_y_axis() {
        return new RationalVector(this.x.negate(), this.y, this.z);
    }

    @Override
    public Vector mirror_at_x_axis() {
        return new RationalVector(this.x, this.y.negate(), this.z);
    }

    @Override
    Direction to_normalized_direction() {
        BigInteger dx = this.x;
        BigInteger dy = this.y;
        BigInteger gcd = dx.gcd(this.y);
        dx = dx.divide(gcd);
        dy = dy.divide(gcd);
        if (dx.abs().compareTo(Limits.CRIT_INT_BIG) <= 0 && dy.abs().compareTo(Limits.CRIT_INT_BIG) <= 0) {
            return new IntDirection(dx.intValue(), dy.intValue());
        }
        return new BigIntDirection(dx, dy);
    }

    @Override
    double scalar_product(IntVector p_other) {
        RationalVector other = new RationalVector(p_other);
        return ((Vector)other).scalar_product(this);
    }

    @Override
    double scalar_product(RationalVector p_other) {
        FloatPoint v1 = this.to_float();
        FloatPoint v2 = p_other.to_float();
        return v1.x * v2.x + v1.y * v2.y;
    }

    @Override
    Signum projection(IntVector p_other) {
        RationalVector other = new RationalVector(p_other);
        return ((Vector)other).projection(this);
    }

    @Override
    Signum projection(RationalVector p_other) {
        BigInteger tmp1 = this.x.multiply(p_other.x);
        BigInteger tmp2 = this.y.multiply(p_other.y);
        BigInteger tmp3 = tmp1.add(tmp2);
        int result = tmp3.signum();
        return Signum.of(result);
    }

    @Override
    final Vector add(IntVector p_other) {
        RationalVector other = new RationalVector(p_other);
        return this.add(other);
    }

    @Override
    final Vector add(RationalVector p_other) {
        BigInteger[] v1 = new BigInteger[]{this.x, this.y, this.z};
        BigInteger[] v2 = new BigInteger[]{p_other.x, p_other.y, p_other.z};
        BigInteger[] result = BigIntAux.add_rational_coordinates(v1, v2);
        return new RationalVector(result[0], result[1], result[2]);
    }

    @Override
    Point add_to(IntPoint p_point) {
        BigInteger new_x = this.z.multiply(BigInteger.valueOf(p_point.x));
        new_x = new_x.add(this.x);
        BigInteger new_y = this.z.multiply(BigInteger.valueOf(p_point.y));
        new_y = new_y.add(this.y);
        return new RationalPoint(new_x, new_y, this.z);
    }

    @Override
    Point add_to(RationalPoint p_point) {
        BigInteger[] v1 = new BigInteger[]{this.x, this.y, this.z};
        BigInteger[] v2 = new BigInteger[]{p_point.x, p_point.y, p_point.z};
        BigInteger[] result = BigIntAux.add_rational_coordinates(v1, v2);
        return new RationalPoint(result[0], result[1], result[2]);
    }

    @Override
    Side side_of(IntVector p_other) {
        RationalVector other = new RationalVector(p_other);
        return this.side_of(other);
    }

    @Override
    Side side_of(RationalVector p_other) {
        BigInteger tmp_1 = this.y.multiply(p_other.x);
        BigInteger tmp_2 = this.x.multiply(p_other.y);
        BigInteger determinant = tmp_1.subtract(tmp_2);
        int signum = determinant.signum();
        return Side.of(signum);
    }
}

