/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.geometry.planar;

import app.freerouting.geometry.planar.Circle;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.FortyfiveDegreeDirection;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.IntVector;
import app.freerouting.geometry.planar.Limits;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.RegularTileShape;
import app.freerouting.geometry.planar.Shape;
import app.freerouting.geometry.planar.ShapeBoundingDirections;
import app.freerouting.geometry.planar.Side;
import app.freerouting.geometry.planar.Simplex;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.logger.FRLogger;
import java.io.Serializable;

public class IntOctagon
extends RegularTileShape
implements Serializable {
    public static final IntOctagon EMPTY = new IntOctagon(0x2000000, 0x2000000, -33554432, -33554432, 0x2000000, -33554432, 0x2000000, -33554432);
    public final int leftX;
    public final int rightX;
    public final int bottomY;
    public final int topY;
    public final int lowerLeftDiagonalX;
    public final int upperRightDiagonalX;
    public final int upperLeftDiagonalX;
    public final int lowerRightDiagonalX;
    private Simplex precalculated_to_simplex;

    public IntOctagon(int p_lx, int p_ly, int p_rx, int p_uy, int p_ulx, int p_lrx, int p_llx, int p_urx) {
        this.leftX = p_lx;
        this.bottomY = p_ly;
        this.rightX = p_rx;
        this.topY = p_uy;
        this.upperLeftDiagonalX = p_ulx;
        this.lowerRightDiagonalX = p_lrx;
        this.lowerLeftDiagonalX = p_llx;
        this.upperRightDiagonalX = p_urx;
    }

    @Override
    public boolean is_empty() {
        return this == EMPTY;
    }

    @Override
    public boolean is_IntOctagon() {
        return true;
    }

    @Override
    public boolean is_bounded() {
        return true;
    }

    @Override
    public boolean corner_is_bounded(int p_no) {
        return true;
    }

    @Override
    public IntBox bounding_box() {
        return new IntBox(this.leftX, this.bottomY, this.rightX, this.topY);
    }

    @Override
    public IntOctagon bounding_octagon() {
        return this;
    }

    @Override
    public IntOctagon bounding_tile() {
        return this;
    }

    @Override
    public int dimension() {
        if (this == EMPTY) {
            return -1;
        }
        int result = this.rightX > this.leftX && this.topY > this.bottomY && this.lowerRightDiagonalX > this.upperLeftDiagonalX && this.upperRightDiagonalX > this.lowerLeftDiagonalX ? 2 : (this.rightX == this.leftX && this.topY == this.bottomY ? 0 : 1);
        return result;
    }

    @Override
    public IntPoint corner(int p_no) {
        int x;
        return new IntPoint(x, switch (p_no) {
            case 0 -> {
                x = this.lowerLeftDiagonalX - this.bottomY;
                yield this.bottomY;
            }
            case 1 -> {
                x = this.lowerRightDiagonalX + this.bottomY;
                yield this.bottomY;
            }
            case 2 -> {
                x = this.rightX;
                yield this.rightX - this.lowerRightDiagonalX;
            }
            case 3 -> {
                x = this.rightX;
                yield this.upperRightDiagonalX - this.rightX;
            }
            case 4 -> {
                x = this.upperRightDiagonalX - this.topY;
                yield this.topY;
            }
            case 5 -> {
                x = this.upperLeftDiagonalX + this.topY;
                yield this.topY;
            }
            case 6 -> {
                x = this.leftX;
                yield this.leftX - this.upperLeftDiagonalX;
            }
            case 7 -> {
                x = this.leftX;
                yield this.lowerLeftDiagonalX - this.leftX;
            }
            default -> throw new IllegalArgumentException("IntOctagon.corner: p_no out of range");
        });
    }

    public int corner_y(int p_no) {
        return switch (p_no) {
            case 0, 1 -> this.bottomY;
            case 2 -> this.rightX - this.lowerRightDiagonalX;
            case 3 -> this.upperRightDiagonalX - this.rightX;
            case 4, 5 -> this.topY;
            case 6 -> this.leftX - this.upperLeftDiagonalX;
            case 7 -> this.lowerLeftDiagonalX - this.leftX;
            default -> throw new IllegalArgumentException("IntOctagon.corner: p_no out of range");
        };
    }

    public int corner_x(int p_no) {
        return switch (p_no) {
            case 0 -> this.lowerLeftDiagonalX - this.bottomY;
            case 1 -> this.lowerRightDiagonalX + this.bottomY;
            case 2, 3 -> this.rightX;
            case 4 -> this.upperRightDiagonalX - this.topY;
            case 5 -> this.upperLeftDiagonalX + this.topY;
            case 6, 7 -> this.leftX;
            default -> throw new IllegalArgumentException("IntOctagon.corner: p_no out of range");
        };
    }

    @Override
    public double area() {
        double result = (double)(this.lowerLeftDiagonalX - this.bottomY) * (double)(this.bottomY - this.lowerLeftDiagonalX + this.leftX);
        result += (double)(this.lowerRightDiagonalX + this.bottomY) * (double)(this.rightX - this.lowerRightDiagonalX - this.bottomY);
        result += (double)this.rightX * (double)(this.upperRightDiagonalX - 2 * this.rightX - this.bottomY + this.topY + this.lowerRightDiagonalX);
        result += (double)(this.upperRightDiagonalX - this.topY) * (double)(this.topY - this.upperRightDiagonalX + this.rightX);
        result += (double)(this.upperLeftDiagonalX + this.topY) * (double)(this.leftX - this.upperLeftDiagonalX - this.topY);
        return 0.5 * Math.abs(result += (double)this.leftX * (double)(this.lowerLeftDiagonalX - 2 * this.leftX - this.topY + this.bottomY + this.upperLeftDiagonalX));
    }

    @Override
    public int border_line_count() {
        return 8;
    }

    @Override
    public Line border_line(int p_no) {
        int b_x;
        int a_y;
        int a_x;
        return new Line(a_x, a_y, b_x, switch (p_no) {
            case 0 -> {
                a_x = 0;
                a_y = this.bottomY;
                b_x = 1;
                yield this.bottomY;
            }
            case 1 -> {
                a_x = this.lowerRightDiagonalX;
                a_y = 0;
                b_x = this.lowerRightDiagonalX + 1;
                yield 1;
            }
            case 2 -> {
                a_x = this.rightX;
                a_y = 0;
                b_x = this.rightX;
                yield 1;
            }
            case 3 -> {
                a_x = this.upperRightDiagonalX;
                a_y = 0;
                b_x = this.upperRightDiagonalX - 1;
                yield 1;
            }
            case 4 -> {
                a_x = 0;
                a_y = this.topY;
                b_x = -1;
                yield this.topY;
            }
            case 5 -> {
                a_x = this.upperLeftDiagonalX;
                a_y = 0;
                b_x = this.upperLeftDiagonalX - 1;
                yield -1;
            }
            case 6 -> {
                a_x = this.leftX;
                a_y = 0;
                b_x = this.leftX;
                yield -1;
            }
            case 7 -> {
                a_x = this.lowerLeftDiagonalX;
                a_y = 0;
                b_x = this.lowerLeftDiagonalX + 1;
                yield -1;
            }
            default -> throw new IllegalArgumentException("IntOctagon.edge_line: p_no out of range");
        });
    }

    @Override
    public IntOctagon translate_by(Vector p_rel_coor) {
        if (p_rel_coor.equals(Vector.ZERO)) {
            return this;
        }
        IntVector rel_coor = (IntVector)p_rel_coor;
        return new IntOctagon(this.leftX + rel_coor.x, this.bottomY + rel_coor.y, this.rightX + rel_coor.x, this.topY + rel_coor.y, this.upperLeftDiagonalX + rel_coor.x - rel_coor.y, this.lowerRightDiagonalX + rel_coor.x - rel_coor.y, this.lowerLeftDiagonalX + rel_coor.x + rel_coor.y, this.upperRightDiagonalX + rel_coor.x + rel_coor.y);
    }

    @Override
    public double max_width() {
        double width_1 = Math.max(this.rightX - this.leftX, this.topY - this.bottomY);
        double width2 = Math.max(this.upperRightDiagonalX - this.lowerLeftDiagonalX, this.lowerRightDiagonalX - this.upperLeftDiagonalX);
        return Math.max(width_1, width2 / Limits.sqrt2);
    }

    @Override
    public double min_width() {
        double width_1 = Math.min(this.rightX - this.leftX, this.topY - this.bottomY);
        double width2 = Math.min(this.upperRightDiagonalX - this.lowerLeftDiagonalX, this.lowerRightDiagonalX - this.upperLeftDiagonalX);
        return Math.min(width_1, width2 / Limits.sqrt2);
    }

    @Override
    public IntOctagon offset(double p_distance) {
        int width = (int)Math.round(p_distance);
        if (width == 0) {
            return this;
        }
        int dia_width = (int)Math.round(Limits.sqrt2 * p_distance);
        IntOctagon result = new IntOctagon(this.leftX - width, this.bottomY - width, this.rightX + width, this.topY + width, this.upperLeftDiagonalX - dia_width, this.lowerRightDiagonalX + dia_width, this.lowerLeftDiagonalX - dia_width, this.upperRightDiagonalX + dia_width);
        return result.normalize();
    }

    @Override
    public IntOctagon enlarge(double p_offset) {
        return this.offset(p_offset);
    }

    @Override
    public boolean contains(RegularTileShape p_other) {
        return p_other.is_contained_in(this);
    }

    @Override
    public RegularTileShape union(RegularTileShape p_other) {
        return p_other.union(this);
    }

    @Override
    public TileShape intersection(TileShape p_other) {
        return p_other.intersection(this);
    }

    public IntOctagon normalize() {
        int diag_left_x;
        int diag_right_x;
        int diag_lower_y;
        int diag_upper_y;
        if (this.leftX > this.rightX || this.bottomY > this.topY || this.lowerLeftDiagonalX > this.upperRightDiagonalX || this.upperLeftDiagonalX > this.lowerRightDiagonalX) {
            return EMPTY;
        }
        int new_lx = this.leftX;
        int new_rx = this.rightX;
        int new_ly = this.bottomY;
        int new_uy = this.topY;
        int new_llx = this.lowerLeftDiagonalX;
        int new_ulx = this.upperLeftDiagonalX;
        int new_lrx = this.lowerRightDiagonalX;
        int new_urx = this.upperRightDiagonalX;
        if (new_lx < new_llx - new_uy) {
            new_lx = new_llx - new_uy;
        }
        if (new_lx < new_ulx + new_ly) {
            new_lx = new_ulx + new_ly;
        }
        if (new_rx > new_urx - new_ly) {
            new_rx = new_urx - new_ly;
        }
        if (new_rx > new_lrx + new_uy) {
            new_rx = new_lrx + new_uy;
        }
        if (new_ly < new_lx - new_lrx) {
            new_ly = new_lx - new_lrx;
        }
        if (new_ly < new_llx - new_rx) {
            new_ly = new_llx - new_rx;
        }
        if (new_uy > new_urx - new_lx) {
            new_uy = new_urx - new_lx;
        }
        if (new_uy > new_rx - new_ulx) {
            new_uy = new_rx - new_ulx;
        }
        if (new_llx - new_lx < new_ly) {
            new_llx = new_lx + new_ly;
        }
        if (new_rx - new_lrx < new_ly) {
            new_lrx = new_rx - new_ly;
        }
        if (new_urx - new_rx > new_uy) {
            new_urx = new_uy + new_rx;
        }
        if (new_lx - new_ulx > new_uy) {
            new_ulx = new_lx - new_uy;
        }
        if (new_uy > (diag_upper_y = (int)Math.ceil((double)(new_urx - new_ulx) / 2.0))) {
            new_uy = diag_upper_y;
        }
        if (new_ly < (diag_lower_y = (int)Math.floor((double)(new_llx - new_lrx) / 2.0))) {
            new_ly = diag_lower_y;
        }
        if (new_rx > (diag_right_x = (int)Math.ceil((double)(new_urx + new_lrx) / 2.0))) {
            new_rx = diag_right_x;
        }
        if (new_lx < (diag_left_x = (int)Math.floor((double)(new_llx + new_ulx) / 2.0))) {
            new_lx = diag_left_x;
        }
        if (new_lx > new_rx || new_ly > new_uy || new_llx > new_urx || new_ulx > new_lrx) {
            return EMPTY;
        }
        return new IntOctagon(new_lx, new_ly, new_rx, new_uy, new_ulx, new_lrx, new_llx, new_urx);
    }

    public boolean is_normalized() {
        IntOctagon on = this.normalize();
        return this.leftX == on.leftX && this.bottomY == on.bottomY && this.rightX == on.rightX && this.topY == on.topY && this.lowerLeftDiagonalX == on.lowerLeftDiagonalX && this.lowerRightDiagonalX == on.lowerRightDiagonalX && this.upperLeftDiagonalX == on.upperLeftDiagonalX && this.upperRightDiagonalX == on.upperRightDiagonalX;
    }

    @Override
    public Simplex to_Simplex() {
        if (this.is_empty()) {
            return Simplex.EMPTY;
        }
        if (this.precalculated_to_simplex == null) {
            Line[] line_arr = new Line[8];
            for (int i = 0; i < 8; ++i) {
                line_arr[i] = this.border_line(i);
            }
            Simplex curr_simplex = new Simplex(line_arr);
            this.precalculated_to_simplex = curr_simplex.remove_redundant_lines();
        }
        return this.precalculated_to_simplex;
    }

    @Override
    public RegularTileShape bounding_shape(ShapeBoundingDirections p_dirs) {
        return p_dirs.bounds(this);
    }

    @Override
    public boolean intersects(Shape p_other) {
        return p_other.intersects(this);
    }

    @Override
    public boolean contains(FloatPoint p_point) {
        if ((double)this.leftX > p_point.x || (double)this.bottomY > p_point.y || (double)this.rightX < p_point.x || (double)this.topY < p_point.y) {
            return false;
        }
        double tmp_1 = p_point.x - p_point.y;
        double tmp_2 = p_point.x + p_point.y;
        return !((double)this.upperLeftDiagonalX > tmp_1 || (double)this.lowerRightDiagonalX < tmp_1 || (double)this.lowerLeftDiagonalX > tmp_2 || (double)this.upperRightDiagonalX < tmp_2);
    }

    public Side side_of_border_line(int p_x, int p_y, int p_border_line_no) {
        int tmp;
        switch (p_border_line_no) {
            case 0: {
                int n = this.bottomY - p_y;
                break;
            }
            case 2: {
                int n = p_x - this.rightX;
                break;
            }
            case 4: {
                int n = p_y - this.topY;
                break;
            }
            case 6: {
                int n = this.leftX - p_x;
                break;
            }
            case 1: {
                int n = p_x - p_y - this.lowerRightDiagonalX;
                break;
            }
            case 3: {
                int n = p_x + p_y - this.upperRightDiagonalX;
                break;
            }
            case 5: {
                int n = this.upperLeftDiagonalX + p_y - p_x;
                break;
            }
            case 7: {
                int n = this.lowerLeftDiagonalX - p_x - p_y;
                break;
            }
            default: {
                FRLogger.warn("IntOctagon.side_of_border_line: p_border_line_no out of range");
                int n = tmp = 0;
            }
        }
        Side result = tmp < 0 ? Side.ON_THE_LEFT : (tmp > 0 ? Side.ON_THE_RIGHT : Side.COLLINEAR);
        return result;
    }

    @Override
    Simplex intersection(Simplex p_other) {
        return p_other.intersection(this);
    }

    @Override
    public IntOctagon intersection(IntOctagon p_other) {
        IntOctagon result = new IntOctagon(Math.max(this.leftX, p_other.leftX), Math.max(this.bottomY, p_other.bottomY), Math.min(this.rightX, p_other.rightX), Math.min(this.topY, p_other.topY), Math.max(this.upperLeftDiagonalX, p_other.upperLeftDiagonalX), Math.min(this.lowerRightDiagonalX, p_other.lowerRightDiagonalX), Math.max(this.lowerLeftDiagonalX, p_other.lowerLeftDiagonalX), Math.min(this.upperRightDiagonalX, p_other.upperRightDiagonalX));
        return result.normalize();
    }

    @Override
    IntOctagon intersection(IntBox p_other) {
        return this.intersection(p_other.to_IntOctagon());
    }

    @Override
    public boolean is_contained_in(IntBox p_box) {
        return this.leftX >= p_box.ll.x && this.bottomY >= p_box.ll.y && this.rightX <= p_box.ur.x && this.topY <= p_box.ur.y;
    }

    @Override
    public boolean is_contained_in(IntOctagon p_other) {
        return this.leftX >= p_other.leftX && this.bottomY >= p_other.bottomY && this.rightX <= p_other.rightX && this.topY <= p_other.topY && this.lowerLeftDiagonalX >= p_other.lowerLeftDiagonalX && this.upperLeftDiagonalX >= p_other.upperLeftDiagonalX && this.lowerRightDiagonalX <= p_other.lowerRightDiagonalX && this.upperRightDiagonalX <= p_other.upperRightDiagonalX;
    }

    @Override
    public IntOctagon union(IntOctagon p_other) {
        return new IntOctagon(Math.min(this.leftX, p_other.leftX), Math.min(this.bottomY, p_other.bottomY), Math.max(this.rightX, p_other.rightX), Math.max(this.topY, p_other.topY), Math.min(this.upperLeftDiagonalX, p_other.upperLeftDiagonalX), Math.max(this.lowerRightDiagonalX, p_other.lowerRightDiagonalX), Math.min(this.lowerLeftDiagonalX, p_other.lowerLeftDiagonalX), Math.max(this.upperRightDiagonalX, p_other.upperRightDiagonalX));
    }

    @Override
    public boolean intersects(IntBox p_other) {
        return this.intersects(p_other.to_IntOctagon());
    }

    @Override
    public boolean intersects(IntOctagon p_other) {
        int is_lrx;
        int is_urx;
        int is_uy;
        int is_rx;
        int is_lx = Math.max(p_other.leftX, this.leftX);
        if (is_lx > (is_rx = Math.min(p_other.rightX, this.rightX))) {
            return false;
        }
        int is_ly = Math.max(p_other.bottomY, this.bottomY);
        if (is_ly > (is_uy = Math.min(p_other.topY, this.topY))) {
            return false;
        }
        int is_llx = Math.max(p_other.lowerLeftDiagonalX, this.lowerLeftDiagonalX);
        if (is_llx > (is_urx = Math.min(p_other.upperRightDiagonalX, this.upperRightDiagonalX))) {
            return false;
        }
        int is_ulx = Math.max(p_other.upperLeftDiagonalX, this.upperLeftDiagonalX);
        return is_ulx <= (is_lrx = Math.min(p_other.lowerRightDiagonalX, this.lowerRightDiagonalX));
    }

    public boolean overlaps(IntOctagon p_other) {
        int is_lrx;
        int is_urx;
        int is_uy;
        int is_rx;
        int is_lx = Math.max(p_other.leftX, this.leftX);
        if (is_lx >= (is_rx = Math.min(p_other.rightX, this.rightX))) {
            return false;
        }
        int is_ly = Math.max(p_other.bottomY, this.bottomY);
        if (is_ly >= (is_uy = Math.min(p_other.topY, this.topY))) {
            return false;
        }
        int is_llx = Math.max(p_other.lowerLeftDiagonalX, this.lowerLeftDiagonalX);
        if (is_llx >= (is_urx = Math.min(p_other.upperRightDiagonalX, this.upperRightDiagonalX))) {
            return false;
        }
        int is_ulx = Math.max(p_other.upperLeftDiagonalX, this.upperLeftDiagonalX);
        return is_ulx < (is_lrx = Math.min(p_other.lowerRightDiagonalX, this.lowerRightDiagonalX));
    }

    @Override
    public boolean intersects(Simplex p_other) {
        return p_other.intersects(this);
    }

    @Override
    public boolean intersects(Circle p_other) {
        return p_other.intersects(this);
    }

    @Override
    public IntOctagon union(IntBox p_other) {
        return this.union(p_other.to_IntOctagon());
    }

    public int left_x_value(int p_y) {
        int result = Math.max(this.leftX, this.upperLeftDiagonalX + p_y);
        return Math.max(result, this.lowerLeftDiagonalX - p_y);
    }

    public int right_x_value(int p_y) {
        int result = Math.min(this.rightX, this.upperRightDiagonalX - p_y);
        return Math.min(result, this.lowerRightDiagonalX + p_y);
    }

    public int lower_y_value(int p_x) {
        int result = Math.max(this.bottomY, this.lowerLeftDiagonalX - p_x);
        return Math.max(result, p_x - this.lowerRightDiagonalX);
    }

    public int upper_y_value(int p_x) {
        int result = Math.min(this.topY, p_x - this.upperLeftDiagonalX);
        return Math.min(result, this.upperRightDiagonalX - p_x);
    }

    @Override
    public Side compare(RegularTileShape p_other, int p_edge_no) {
        Side result = p_other.compare(this, p_edge_no);
        return result.negate();
    }

    @Override
    public Side compare(IntOctagon p_other, int p_edge_no) {
        return switch (p_edge_no) {
            case 0 -> {
                if (this.bottomY > p_other.bottomY) {
                    yield Side.ON_THE_LEFT;
                }
                if (this.bottomY < p_other.bottomY) {
                    yield Side.ON_THE_RIGHT;
                }
                yield Side.COLLINEAR;
            }
            case 1 -> {
                if (this.lowerRightDiagonalX < p_other.lowerRightDiagonalX) {
                    yield Side.ON_THE_LEFT;
                }
                if (this.lowerRightDiagonalX > p_other.lowerRightDiagonalX) {
                    yield Side.ON_THE_RIGHT;
                }
                yield Side.COLLINEAR;
            }
            case 2 -> {
                if (this.rightX < p_other.rightX) {
                    yield Side.ON_THE_LEFT;
                }
                if (this.rightX > p_other.rightX) {
                    yield Side.ON_THE_RIGHT;
                }
                yield Side.COLLINEAR;
            }
            case 3 -> {
                if (this.upperRightDiagonalX < p_other.upperRightDiagonalX) {
                    yield Side.ON_THE_LEFT;
                }
                if (this.upperRightDiagonalX > p_other.upperRightDiagonalX) {
                    yield Side.ON_THE_RIGHT;
                }
                yield Side.COLLINEAR;
            }
            case 4 -> {
                if (this.topY < p_other.topY) {
                    yield Side.ON_THE_LEFT;
                }
                if (this.topY > p_other.topY) {
                    yield Side.ON_THE_RIGHT;
                }
                yield Side.COLLINEAR;
            }
            case 5 -> {
                if (this.upperLeftDiagonalX > p_other.upperLeftDiagonalX) {
                    yield Side.ON_THE_LEFT;
                }
                if (this.upperLeftDiagonalX < p_other.upperLeftDiagonalX) {
                    yield Side.ON_THE_RIGHT;
                }
                yield Side.COLLINEAR;
            }
            case 6 -> {
                if (this.leftX > p_other.leftX) {
                    yield Side.ON_THE_LEFT;
                }
                if (this.leftX < p_other.leftX) {
                    yield Side.ON_THE_RIGHT;
                }
                yield Side.COLLINEAR;
            }
            case 7 -> {
                if (this.lowerLeftDiagonalX > p_other.lowerLeftDiagonalX) {
                    yield Side.ON_THE_LEFT;
                }
                if (this.lowerLeftDiagonalX < p_other.lowerLeftDiagonalX) {
                    yield Side.ON_THE_RIGHT;
                }
                yield Side.COLLINEAR;
            }
            default -> throw new IllegalArgumentException("IntBox.compare: p_edge_no out of range");
        };
    }

    @Override
    public Side compare(IntBox p_other, int p_edge_no) {
        return this.compare(p_other.to_IntOctagon(), p_edge_no);
    }

    @Override
    public int border_line_index(Line p_line) {
        FRLogger.warn("edge_index_of_line not yet implemented for octagons");
        return -1;
    }

    public IntPoint border_point(IntPoint p_point, FortyfiveDegreeDirection p_dir) {
        int result_y;
        int result_x;
        switch (p_dir) {
            case RIGHT: {
                result_x = Math.min(this.rightX, this.upperRightDiagonalX - p_point.y);
                result_x = Math.min(result_x, this.lowerRightDiagonalX + p_point.y);
                result_y = p_point.y;
                break;
            }
            case LEFT: {
                result_x = Math.max(this.leftX, this.upperLeftDiagonalX + p_point.y);
                result_x = Math.max(result_x, this.lowerLeftDiagonalX - p_point.y);
                result_y = p_point.y;
                break;
            }
            case UP: {
                result_x = p_point.x;
                result_y = Math.min(this.topY, p_point.x - this.upperLeftDiagonalX);
                result_y = Math.min(result_y, this.upperRightDiagonalX - p_point.x);
                break;
            }
            case DOWN: {
                result_x = p_point.x;
                result_y = Math.max(this.bottomY, this.lowerLeftDiagonalX - p_point.x);
                result_y = Math.max(result_y, p_point.x - this.lowerRightDiagonalX);
                break;
            }
            case RIGHT45: {
                result_x = (int)Math.ceil(0.5 * (double)(p_point.x - p_point.y + this.upperRightDiagonalX));
                result_x = Math.min(result_x, this.rightX);
                result_x = Math.min(result_x, p_point.x - p_point.y + this.topY);
                result_y = p_point.y - p_point.x + result_x;
                break;
            }
            case UP45: {
                result_x = (int)Math.floor(0.5 * (double)(p_point.x + p_point.y + this.upperLeftDiagonalX));
                result_x = Math.max(result_x, this.leftX);
                result_x = Math.max(result_x, p_point.x + p_point.y - this.topY);
                result_y = p_point.y + p_point.x - result_x;
                break;
            }
            case LEFT45: {
                result_x = (int)Math.floor(0.5 * (double)(p_point.x - p_point.y + this.lowerLeftDiagonalX));
                result_x = Math.max(result_x, this.leftX);
                result_x = Math.max(result_x, p_point.x - p_point.y + this.bottomY);
                result_y = p_point.y - p_point.x + result_x;
                break;
            }
            case DOWN45: {
                result_x = (int)Math.ceil(0.5 * (double)(p_point.x + p_point.y + this.lowerRightDiagonalX));
                result_x = Math.min(result_x, this.rightX);
                result_x = Math.min(result_x, p_point.x + p_point.y - this.bottomY);
                result_y = p_point.y + p_point.x - result_x;
                break;
            }
            default: {
                FRLogger.warn("IntOctagon.border_point: unexpected 45 degree direction");
                result_x = 0;
                result_y = 0;
            }
        }
        return new IntPoint(result_x, result_y);
    }

    public IntPoint[] nearest_border_projections(IntPoint p_point, int p_max_result_points) {
        if (!this.contains(p_point) || p_max_result_points <= 0) {
            return new IntPoint[0];
        }
        p_max_result_points = Math.min(p_max_result_points, 8);
        IntPoint[] result = new IntPoint[p_max_result_points];
        double[] min_dist = new double[p_max_result_points];
        for (int i = 0; i < p_max_result_points; ++i) {
            min_dist[i] = Double.MAX_VALUE;
        }
        FloatPoint inside_point = p_point.to_float();
        block1: for (FortyfiveDegreeDirection curr_dir : FortyfiveDegreeDirection.values()) {
            IntPoint curr_border_point = this.border_point(p_point, curr_dir);
            double curr_dist = inside_point.distance_square(curr_border_point.to_float());
            for (int i = 0; i < p_max_result_points; ++i) {
                if (!(curr_dist < min_dist[i])) continue;
                for (int k = p_max_result_points - 1; k > i; --k) {
                    min_dist[k] = min_dist[k - 1];
                    result[k] = result[k - 1];
                }
                min_dist[i] = curr_dist;
                result[i] = curr_border_point;
                continue block1;
            }
        }
        return result;
    }

    Side border_line_side_of(FloatPoint p_point, int p_line_no, double p_tolerance) {
        return switch (p_line_no) {
            case 0 -> {
                if (p_point.y > (double)this.bottomY + p_tolerance) {
                    yield Side.ON_THE_RIGHT;
                }
                if (p_point.y < (double)this.bottomY - p_tolerance) {
                    yield Side.ON_THE_LEFT;
                }
                yield Side.COLLINEAR;
            }
            case 2 -> {
                if (p_point.x < (double)this.rightX - p_tolerance) {
                    yield Side.ON_THE_RIGHT;
                }
                if (p_point.x > (double)this.rightX + p_tolerance) {
                    yield Side.ON_THE_LEFT;
                }
                yield Side.COLLINEAR;
            }
            case 4 -> {
                if (p_point.y < (double)this.topY - p_tolerance) {
                    yield Side.ON_THE_RIGHT;
                }
                if (p_point.y > (double)this.topY + p_tolerance) {
                    yield Side.ON_THE_LEFT;
                }
                yield Side.COLLINEAR;
            }
            case 6 -> {
                if (p_point.x > (double)this.leftX + p_tolerance) {
                    yield Side.ON_THE_RIGHT;
                }
                if (p_point.x < (double)this.leftX - p_tolerance) {
                    yield Side.ON_THE_LEFT;
                }
                yield Side.COLLINEAR;
            }
            case 1 -> {
                double tmp = p_point.y - p_point.x + (double)this.lowerRightDiagonalX;
                if (tmp > p_tolerance) {
                    yield Side.ON_THE_RIGHT;
                }
                if (tmp < -p_tolerance) {
                    yield Side.ON_THE_LEFT;
                }
                yield Side.COLLINEAR;
            }
            case 3 -> {
                double tmp = p_point.x + p_point.y - (double)this.upperRightDiagonalX;
                if (tmp < -p_tolerance) {
                    yield Side.ON_THE_RIGHT;
                }
                if (tmp > p_tolerance) {
                    yield Side.ON_THE_LEFT;
                }
                yield Side.COLLINEAR;
            }
            case 5 -> {
                double tmp = p_point.y - p_point.x + (double)this.upperLeftDiagonalX;
                if (tmp < -p_tolerance) {
                    yield Side.ON_THE_RIGHT;
                }
                if (tmp > p_tolerance) {
                    yield Side.ON_THE_LEFT;
                }
                yield Side.COLLINEAR;
            }
            case 7 -> {
                double tmp = p_point.x + p_point.y - (double)this.lowerLeftDiagonalX;
                if (tmp > p_tolerance) {
                    yield Side.ON_THE_RIGHT;
                }
                if (tmp < -p_tolerance) {
                    yield Side.ON_THE_LEFT;
                }
                yield Side.COLLINEAR;
            }
            default -> {
                FRLogger.warn("IntOctagon.border_line_side_of: p_line_no out of range");
                yield Side.COLLINEAR;
            }
        };
    }

    @Override
    public boolean is_IntBox() {
        if (this.lowerLeftDiagonalX != this.leftX + this.bottomY) {
            return false;
        }
        if (this.lowerRightDiagonalX != this.rightX - this.bottomY) {
            return false;
        }
        if (this.upperRightDiagonalX != this.rightX + this.topY) {
            return false;
        }
        return this.upperLeftDiagonalX == this.leftX - this.topY;
    }

    @Override
    public TileShape simplify() {
        if (this.is_IntBox()) {
            return this.bounding_box();
        }
        return this;
    }

    @Override
    public TileShape[] cutout(TileShape p_shape) {
        return p_shape.cutout_from(this);
    }

    IntOctagon[] cutout_from(IntBox p_d) {
        IntOctagon c = this.intersection(p_d);
        if (this.is_empty() || c.dimension() < this.dimension()) {
            IntOctagon[] result = new IntOctagon[]{p_d.to_IntOctagon()};
            return result;
        }
        IntBox[] boxes = new IntBox[]{new IntBox(p_d.ll.x, c.lowerLeftDiagonalX - c.leftX, c.leftX, c.leftX - c.upperLeftDiagonalX), new IntBox(c.rightX, c.rightX - c.lowerRightDiagonalX, p_d.ur.x, c.upperRightDiagonalX - c.rightX), new IntBox(c.lowerLeftDiagonalX - c.bottomY, p_d.ll.y, c.lowerRightDiagonalX + c.bottomY, c.bottomY), new IntBox(c.upperLeftDiagonalX + c.topY, c.topY, c.upperRightDiagonalX - c.topY, p_d.ur.y)};
        IntOctagon[] octagons = new IntOctagon[4];
        IntOctagon curr_oct = new IntOctagon(p_d.ll.x, boxes[0].ur.y, boxes[3].ll.x, p_d.ur.y, -33554432, c.upperLeftDiagonalX, -33554432, 0x2000000);
        octagons[0] = curr_oct.normalize();
        curr_oct = new IntOctagon(p_d.ll.x, p_d.ll.y, boxes[2].ll.x, boxes[0].ll.y, -33554432, 0x2000000, -33554432, c.lowerLeftDiagonalX);
        octagons[1] = curr_oct.normalize();
        curr_oct = new IntOctagon(boxes[2].ur.x, p_d.ll.y, p_d.ur.x, boxes[1].ll.y, c.lowerRightDiagonalX, 0x2000000, -33554432, 0x2000000);
        octagons[2] = curr_oct.normalize();
        curr_oct = new IntOctagon(boxes[3].ur.x, boxes[1].ur.y, p_d.ur.x, p_d.ur.y, -33554432, 0x2000000, c.upperRightDiagonalX, 0x2000000);
        octagons[3] = curr_oct.normalize();
        IntBox b = boxes[0];
        IntOctagon o = octagons[0];
        if (b.ur.x - b.ll.x > o.topY - o.bottomY) {
            boxes[0] = new IntBox(b.ll.x, b.ll.y, b.ur.x, o.topY);
            curr_oct = new IntOctagon(b.ur.x, o.bottomY, o.rightX, o.topY, o.upperLeftDiagonalX, o.lowerRightDiagonalX, o.lowerLeftDiagonalX, o.upperRightDiagonalX);
            octagons[0] = curr_oct.normalize();
        }
        b = boxes[3];
        o = octagons[0];
        if (b.ur.y - b.ll.y > o.rightX - o.leftX) {
            boxes[3] = new IntBox(o.leftX, b.ll.y, b.ur.x, b.ur.y);
            curr_oct = new IntOctagon(o.leftX, o.bottomY, o.rightX, b.ll.y, o.upperLeftDiagonalX, o.lowerRightDiagonalX, o.lowerLeftDiagonalX, o.upperRightDiagonalX);
            octagons[0] = curr_oct.normalize();
        }
        b = boxes[3];
        o = octagons[3];
        if (b.ur.y - b.ll.y > o.rightX - o.leftX) {
            boxes[3] = new IntBox(b.ll.x, b.ll.y, o.rightX, b.ur.y);
            curr_oct = new IntOctagon(o.leftX, o.bottomY, o.rightX, o.topY, o.upperLeftDiagonalX, o.lowerRightDiagonalX, o.lowerLeftDiagonalX, o.upperRightDiagonalX);
            octagons[3] = curr_oct.normalize();
        }
        b = boxes[1];
        o = octagons[3];
        if (b.ur.x - b.ll.x > o.topY - o.bottomY) {
            boxes[1] = new IntBox(b.ll.x, b.ll.y, b.ur.x, o.topY);
            curr_oct = new IntOctagon(o.leftX, o.bottomY, b.ll.x, o.topY, o.upperLeftDiagonalX, o.lowerRightDiagonalX, o.lowerLeftDiagonalX, o.upperRightDiagonalX);
            octagons[3] = curr_oct.normalize();
        }
        b = boxes[1];
        o = octagons[2];
        if (b.ur.x - b.ll.x > o.topY - o.bottomY) {
            boxes[1] = new IntBox(b.ll.x, o.bottomY, b.ur.x, b.ur.y);
            curr_oct = new IntOctagon(o.leftX, o.bottomY, b.ll.x, o.topY, o.upperLeftDiagonalX, o.lowerRightDiagonalX, o.lowerLeftDiagonalX, o.upperRightDiagonalX);
            octagons[2] = curr_oct.normalize();
        }
        b = boxes[2];
        o = octagons[2];
        if (b.ur.y - b.ll.y > o.rightX - o.leftX) {
            boxes[2] = new IntBox(b.ll.x, b.ll.y, o.rightX, b.ur.y);
            curr_oct = new IntOctagon(o.leftX, b.ur.y, o.rightX, o.topY, o.upperLeftDiagonalX, o.lowerRightDiagonalX, o.lowerLeftDiagonalX, o.upperRightDiagonalX);
            octagons[2] = curr_oct.normalize();
        }
        b = boxes[2];
        o = octagons[1];
        if (b.ur.y - b.ll.y > o.rightX - o.leftX) {
            boxes[2] = new IntBox(o.leftX, b.ll.y, b.ur.x, b.ur.y);
            curr_oct = new IntOctagon(o.leftX, b.ur.y, o.rightX, o.topY, o.upperLeftDiagonalX, o.lowerRightDiagonalX, o.lowerLeftDiagonalX, o.upperRightDiagonalX);
            octagons[1] = curr_oct.normalize();
        }
        b = boxes[0];
        o = octagons[1];
        if (b.ur.x - b.ll.x > o.topY - o.bottomY) {
            boxes[0] = new IntBox(b.ll.x, o.bottomY, b.ur.x, b.ur.y);
            curr_oct = new IntOctagon(b.ur.x, o.bottomY, o.rightX, o.topY, o.upperLeftDiagonalX, o.lowerRightDiagonalX, o.lowerLeftDiagonalX, o.upperRightDiagonalX);
            octagons[1] = curr_oct.normalize();
        }
        IntOctagon[] result = new IntOctagon[8];
        for (int i = 0; i < 4; ++i) {
            result[i] = boxes[i].to_IntOctagon();
        }
        System.arraycopy(octagons, 0, result, 4, 4);
        return result;
    }

    IntOctagon[] cutout_from(IntOctagon p_d) {
        IntOctagon c = this.intersection(p_d);
        if (this.is_empty() || c.dimension() < this.dimension()) {
            IntOctagon[] result = new IntOctagon[]{p_d};
            return result;
        }
        IntOctagon[] result = new IntOctagon[8];
        int tmp = c.lowerLeftDiagonalX - c.leftX;
        result[0] = new IntOctagon(p_d.leftX, tmp, c.leftX, c.leftX - c.upperLeftDiagonalX, p_d.upperLeftDiagonalX, p_d.lowerRightDiagonalX, p_d.lowerLeftDiagonalX, p_d.upperRightDiagonalX);
        int tmp2 = c.lowerLeftDiagonalX - c.bottomY;
        result[1] = new IntOctagon(p_d.leftX, p_d.bottomY, tmp2, tmp, p_d.upperLeftDiagonalX, p_d.lowerRightDiagonalX, p_d.lowerLeftDiagonalX, c.lowerLeftDiagonalX);
        tmp = c.lowerRightDiagonalX + c.bottomY;
        result[2] = new IntOctagon(tmp2, p_d.bottomY, tmp, c.bottomY, p_d.upperLeftDiagonalX, p_d.lowerRightDiagonalX, p_d.lowerLeftDiagonalX, p_d.upperRightDiagonalX);
        tmp2 = c.rightX - c.lowerRightDiagonalX;
        result[3] = new IntOctagon(tmp, p_d.bottomY, p_d.rightX, tmp2, c.lowerRightDiagonalX, p_d.lowerRightDiagonalX, p_d.lowerLeftDiagonalX, p_d.upperRightDiagonalX);
        tmp = c.upperRightDiagonalX - c.rightX;
        result[4] = new IntOctagon(c.rightX, tmp2, p_d.rightX, tmp, p_d.upperLeftDiagonalX, p_d.lowerRightDiagonalX, p_d.lowerLeftDiagonalX, p_d.upperRightDiagonalX);
        tmp2 = c.upperRightDiagonalX - c.topY;
        result[5] = new IntOctagon(tmp2, tmp, p_d.rightX, p_d.topY, p_d.upperLeftDiagonalX, p_d.lowerRightDiagonalX, c.upperRightDiagonalX, p_d.upperRightDiagonalX);
        tmp = c.upperLeftDiagonalX + c.topY;
        result[6] = new IntOctagon(tmp, c.topY, tmp2, p_d.topY, p_d.upperLeftDiagonalX, p_d.lowerRightDiagonalX, p_d.lowerLeftDiagonalX, p_d.upperRightDiagonalX);
        tmp2 = c.leftX - c.upperLeftDiagonalX;
        result[7] = new IntOctagon(p_d.leftX, tmp2, tmp, p_d.topY, p_d.upperLeftDiagonalX, c.upperLeftDiagonalX, p_d.lowerLeftDiagonalX, p_d.upperRightDiagonalX);
        for (int i = 0; i < 8; ++i) {
            result[i] = result[i].normalize();
        }
        IntOctagon curr_1 = result[0];
        IntOctagon curr_2 = result[7];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_1.rightX - curr_1.left_x_value(curr_1.topY) > curr_2.upper_y_value(curr_1.rightX) - curr_2.bottomY) {
            curr_1 = new IntOctagon(Math.min(curr_1.leftX, curr_2.leftX), curr_1.bottomY, curr_1.rightX, curr_2.topY, curr_2.upperLeftDiagonalX, curr_1.lowerRightDiagonalX, curr_1.lowerLeftDiagonalX, curr_2.upperRightDiagonalX);
            curr_2 = new IntOctagon(curr_1.rightX, curr_2.bottomY, curr_2.rightX, curr_2.topY, curr_2.upperLeftDiagonalX, curr_2.lowerRightDiagonalX, curr_2.lowerLeftDiagonalX, curr_2.upperRightDiagonalX);
            result[0] = curr_1.normalize();
            result[7] = curr_2.normalize();
        }
        curr_1 = result[7];
        curr_2 = result[6];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_2.upper_y_value(curr_1.rightX) - curr_2.bottomY > curr_1.rightX - curr_1.left_x_value(curr_2.bottomY)) {
            curr_2 = new IntOctagon(curr_1.leftX, curr_2.bottomY, curr_2.rightX, Math.max(curr_2.topY, curr_1.topY), curr_1.upperLeftDiagonalX, curr_2.lowerRightDiagonalX, curr_1.lowerLeftDiagonalX, curr_2.upperRightDiagonalX);
            curr_1 = new IntOctagon(curr_1.leftX, curr_1.bottomY, curr_1.rightX, curr_2.bottomY, curr_1.upperLeftDiagonalX, curr_1.lowerRightDiagonalX, curr_1.lowerLeftDiagonalX, curr_1.upperRightDiagonalX);
            result[7] = curr_1.normalize();
            result[6] = curr_2.normalize();
        }
        curr_1 = result[6];
        curr_2 = result[5];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_2.upper_y_value(curr_1.rightX) - curr_1.bottomY > curr_2.right_x_value(curr_1.bottomY) - curr_2.leftX) {
            curr_1 = new IntOctagon(curr_1.leftX, curr_1.bottomY, curr_2.rightX, Math.max(curr_2.topY, curr_1.topY), curr_1.upperLeftDiagonalX, curr_2.lowerRightDiagonalX, curr_1.lowerLeftDiagonalX, curr_2.upperRightDiagonalX);
            curr_2 = new IntOctagon(curr_2.leftX, curr_2.bottomY, curr_2.rightX, curr_1.bottomY, curr_2.upperLeftDiagonalX, curr_2.lowerRightDiagonalX, curr_2.lowerLeftDiagonalX, curr_2.upperRightDiagonalX);
            result[6] = curr_1.normalize();
            result[5] = curr_2.normalize();
        }
        curr_1 = result[5];
        curr_2 = result[4];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_2.right_x_value(curr_2.topY) - curr_2.leftX > curr_1.upper_y_value(curr_2.leftX) - curr_2.topY) {
            curr_2 = new IntOctagon(curr_2.leftX, curr_2.bottomY, Math.max(curr_2.rightX, curr_1.rightX), curr_1.topY, curr_1.upperLeftDiagonalX, curr_2.lowerRightDiagonalX, curr_2.lowerLeftDiagonalX, curr_1.upperRightDiagonalX);
            curr_1 = new IntOctagon(curr_1.leftX, curr_1.bottomY, curr_2.leftX, curr_1.topY, curr_1.upperLeftDiagonalX, curr_1.lowerRightDiagonalX, curr_1.lowerLeftDiagonalX, curr_1.upperRightDiagonalX);
            result[5] = curr_1.normalize();
            result[4] = curr_2.normalize();
        }
        curr_1 = result[4];
        curr_2 = result[3];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_1.right_x_value(curr_1.bottomY) - curr_1.leftX > curr_1.bottomY - curr_2.lower_y_value(curr_1.leftX)) {
            curr_1 = new IntOctagon(curr_1.leftX, curr_2.bottomY, Math.max(curr_2.rightX, curr_1.rightX), curr_1.topY, curr_1.upperLeftDiagonalX, curr_2.lowerRightDiagonalX, curr_2.lowerLeftDiagonalX, curr_1.upperRightDiagonalX);
            curr_2 = new IntOctagon(curr_2.leftX, curr_2.bottomY, curr_1.leftX, curr_2.topY, curr_2.upperLeftDiagonalX, curr_2.lowerRightDiagonalX, curr_2.lowerLeftDiagonalX, curr_2.upperRightDiagonalX);
            result[4] = curr_1.normalize();
            result[3] = curr_2.normalize();
        }
        curr_1 = result[3];
        curr_2 = result[2];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_2.topY - curr_2.lower_y_value(curr_2.rightX) > curr_1.right_x_value(curr_2.topY) - curr_2.rightX) {
            curr_2 = new IntOctagon(curr_2.leftX, Math.min(curr_1.bottomY, curr_2.bottomY), curr_1.rightX, curr_2.topY, curr_2.upperLeftDiagonalX, curr_1.lowerRightDiagonalX, curr_2.lowerLeftDiagonalX, curr_1.upperRightDiagonalX);
            curr_1 = new IntOctagon(curr_1.leftX, curr_2.topY, curr_1.rightX, curr_1.topY, curr_1.upperLeftDiagonalX, curr_1.lowerRightDiagonalX, curr_1.lowerLeftDiagonalX, curr_1.upperRightDiagonalX);
            result[3] = curr_1.normalize();
            result[2] = curr_2.normalize();
        }
        curr_1 = result[2];
        curr_2 = result[1];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_1.topY - curr_1.lower_y_value(curr_1.leftX) > curr_1.leftX - curr_2.left_x_value(curr_1.topY)) {
            curr_1 = new IntOctagon(curr_2.leftX, Math.min(curr_1.bottomY, curr_2.bottomY), curr_1.rightX, curr_1.topY, curr_2.upperLeftDiagonalX, curr_1.lowerRightDiagonalX, curr_2.lowerLeftDiagonalX, curr_1.upperRightDiagonalX);
            curr_2 = new IntOctagon(curr_2.leftX, curr_1.topY, curr_2.rightX, curr_2.topY, curr_2.upperLeftDiagonalX, curr_2.lowerRightDiagonalX, curr_2.lowerLeftDiagonalX, curr_2.upperRightDiagonalX);
            result[2] = curr_1.normalize();
            result[1] = curr_2.normalize();
        }
        curr_1 = result[1];
        curr_2 = result[0];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_2.rightX - curr_2.left_x_value(curr_2.bottomY) > curr_2.bottomY - curr_1.lower_y_value(curr_2.rightX)) {
            curr_2 = new IntOctagon(Math.min(curr_2.leftX, curr_1.leftX), curr_1.bottomY, curr_2.rightX, curr_2.topY, curr_2.upperLeftDiagonalX, curr_1.lowerRightDiagonalX, curr_1.lowerLeftDiagonalX, curr_2.upperRightDiagonalX);
            curr_1 = new IntOctagon(curr_2.rightX, curr_1.bottomY, curr_1.rightX, curr_1.topY, curr_1.upperLeftDiagonalX, curr_1.lowerRightDiagonalX, curr_1.lowerLeftDiagonalX, curr_1.upperRightDiagonalX);
            result[1] = curr_1.normalize();
            result[0] = curr_2.normalize();
        }
        return result;
    }

    Simplex[] cutout_from(Simplex p_simplex) {
        return this.to_Simplex().cutout_from(p_simplex);
    }
}

