/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.designforms.specctra;

import app.freerouting.designforms.specctra.IJFlexScanner;
import app.freerouting.designforms.specctra.Keyword;
import app.freerouting.designforms.specctra.ReadScopeParameter;
import app.freerouting.logger.FRLogger;
import java.io.IOException;

public class ScopeKeyword
extends Keyword {
    public ScopeKeyword(String p_name) {
        super(p_name);
    }

    public static boolean skip_scope(IJFlexScanner p_scanner) {
        int open_bracked_count = 1;
        while (open_bracked_count > 0) {
            Object curr_token;
            p_scanner.yybegin(3);
            try {
                curr_token = p_scanner.next_token();
            }
            catch (Exception e) {
                FRLogger.error("ScopeKeyword.skip_scope: Error while scanning file", e);
                return false;
            }
            if (curr_token == null) {
                return false;
            }
            if (curr_token == Keyword.OPEN_BRACKET) {
                ++open_bracked_count;
                continue;
            }
            if (curr_token != Keyword.CLOSED_BRACKET) continue;
            --open_bracked_count;
        }
        return true;
    }

    public boolean read_scope(ReadScopeParameter p_par) {
        Object next_token = null;
        while (true) {
            Object prev_token = next_token;
            try {
                next_token = p_par.scanner.next_token();
            }
            catch (IOException e) {
                FRLogger.error("ScopeKeyword.read_scope: IO error scanning file", e);
                return false;
            }
            if (next_token == null) {
                return true;
            }
            if (next_token == CLOSED_BRACKET) break;
            if (prev_token != OPEN_BRACKET) continue;
            if (next_token instanceof ScopeKeyword) {
                ScopeKeyword next_scope = (ScopeKeyword)next_token;
                if (next_scope.read_scope(p_par)) continue;
                return false;
            }
            ScopeKeyword.skip_scope(p_par.scanner);
        }
        return true;
    }
}

