/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.designforms.specctra;

import app.freerouting.designforms.specctra.Layer;
import java.util.Collection;
import java.util.Iterator;

public class LayerStructure {
    public final Layer[] arr;

    public LayerStructure(Collection<Layer> p_layer_list) {
        this.arr = new Layer[p_layer_list.size()];
        Iterator<Layer> it = p_layer_list.iterator();
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = it.next();
        }
    }

    public LayerStructure(app.freerouting.board.LayerStructure p_board_layer_structure) {
        this.arr = new Layer[p_board_layer_structure.arr.length];
        for (int i = 0; i < this.arr.length; ++i) {
            app.freerouting.board.Layer board_layer = p_board_layer_structure.arr[i];
            this.arr[i] = new Layer(board_layer.name, i, board_layer.is_signal);
        }
    }

    public int get_no(String p_name) {
        for (int i = 0; i < this.arr.length; ++i) {
            if (!p_name.equals(this.arr[i].name)) continue;
            return i;
        }
        if (p_name.contains("Top")) {
            return 0;
        }
        if (p_name.contains("Bottom")) {
            return this.arr.length - 1;
        }
        return -1;
    }

    public int signal_layer_count() {
        int result = 0;
        for (Layer curr_layer : this.arr) {
            if (!curr_layer.is_signal) continue;
            ++result;
        }
        return result;
    }

    public boolean contains_plane(String p_net_name) {
        for (Layer curr_layer : this.arr) {
            if (curr_layer.is_signal || !curr_layer.net_names.contains(p_net_name)) continue;
            return true;
        }
        return false;
    }
}

