/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.designforms.specctra;

import app.freerouting.datastructures.IdentifierType;
import app.freerouting.datastructures.IndentFileWriter;
import app.freerouting.designforms.specctra.CoordinateTransform;
import app.freerouting.designforms.specctra.Layer;
import app.freerouting.designforms.specctra.Rectangle;
import app.freerouting.designforms.specctra.Shape;
import app.freerouting.geometry.planar.IntPoint;
import java.io.IOException;

public class Circle
extends Shape {
    public final double[] coor;

    public Circle(Layer p_layer, double[] p_coor) {
        super(p_layer);
        this.coor = p_coor;
    }

    public Circle(Layer p_layer, double p_radius, double p_center_x, double p_center_y) {
        super(p_layer);
        this.coor = new double[3];
        this.coor[0] = p_radius;
        this.coor[1] = p_center_x;
        this.coor[2] = p_center_y;
    }

    @Override
    public app.freerouting.geometry.planar.Shape transform_to_board(CoordinateTransform p_coordinate_transform) {
        double[] location = new double[]{this.coor[1], this.coor[2]};
        IntPoint center = p_coordinate_transform.dsn_to_board(location).round();
        int radius = (int)Math.round(p_coordinate_transform.dsn_to_board(this.coor[0]) / 2.0);
        return new app.freerouting.geometry.planar.Circle(center, radius);
    }

    @Override
    public app.freerouting.geometry.planar.Shape transform_to_board_rel(CoordinateTransform p_coordinate_transform) {
        int[] new_coor = new int[3];
        new_coor[0] = (int)Math.round(p_coordinate_transform.dsn_to_board(this.coor[0]) / 2.0);
        for (int i = 1; i < 3; ++i) {
            new_coor[i] = (int)Math.round(p_coordinate_transform.dsn_to_board(this.coor[i]));
        }
        return new app.freerouting.geometry.planar.Circle(new IntPoint(new_coor[1], new_coor[2]), new_coor[0]);
    }

    @Override
    public Rectangle bounding_box() {
        double[] bounds = new double[]{this.coor[1] - this.coor[0], this.coor[2] - this.coor[0], this.coor[1] + this.coor[0], this.coor[2] + this.coor[0]};
        return new Rectangle(this.layer, bounds);
    }

    @Override
    public void write_scope(IndentFileWriter p_file, IdentifierType p_identifier_type) throws IOException {
        p_file.new_line();
        p_file.write("(circle ");
        p_identifier_type.write(this.layer.name, p_file);
        for (int i = 0; i < this.coor.length; ++i) {
            p_file.write(" ");
            p_file.write(String.valueOf(this.coor[i]));
        }
        p_file.write(")");
    }

    @Override
    public void write_scope_int(IndentFileWriter p_file, IdentifierType p_identifier_type) throws IOException {
        p_file.new_line();
        p_file.write("(circle ");
        p_identifier_type.write(this.layer.name, p_file);
        for (int i = 0; i < this.coor.length; ++i) {
            p_file.write(" ");
            int curr_coor = (int)Math.round(this.coor[i]);
            p_file.write(String.valueOf(curr_coor));
        }
        p_file.write(")");
    }
}

