/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.datastructures;

import app.freerouting.logger.FRLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class IndentFileWriter
extends OutputStreamWriter {
    private static final String INDENT_STRING = "  ";
    private static final String BEGIN_SCOPE = "(";
    private static final String END_SCOPE = ")";
    private int current_indent_level = 0;

    public IndentFileWriter(OutputStream p_stream) {
        super(p_stream);
    }

    public void start_scope(boolean newLine) {
        if (newLine) {
            this.new_line();
        }
        try {
            this.write(BEGIN_SCOPE);
        }
        catch (IOException e) {
            FRLogger.error("IndentFileWriter.start_scope: unable to write to file", e);
        }
        ++this.current_indent_level;
    }

    public void start_scope() {
        this.start_scope(true);
    }

    public void end_scope() {
        --this.current_indent_level;
        this.new_line();
        try {
            this.write(END_SCOPE);
        }
        catch (IOException e) {
            FRLogger.error("IndentFileWriter.end_scope: unable to write to file", e);
        }
    }

    public void new_line() {
        try {
            this.write("\n");
            for (int i = 0; i < this.current_indent_level; ++i) {
                this.write(INDENT_STRING);
            }
        }
        catch (IOException e) {
            FRLogger.error("IndentFileWriter.new_line: unable to write to file", e);
        }
    }
}

