/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.core.scoring;

import app.freerouting.board.BasicBoard;
import app.freerouting.board.ComponentOutline;
import app.freerouting.board.ConductionArea;
import app.freerouting.board.DrillItem;
import app.freerouting.board.FixedState;
import app.freerouting.board.Item;
import app.freerouting.board.Pin;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.Trace;
import app.freerouting.board.Unit;
import app.freerouting.board.Via;
import app.freerouting.core.scoring.BoardStatisticsBends;
import app.freerouting.core.scoring.BoardStatisticsBoard;
import app.freerouting.core.scoring.BoardStatisticsClearanceViolations;
import app.freerouting.core.scoring.BoardStatisticsComponents;
import app.freerouting.core.scoring.BoardStatisticsConnections;
import app.freerouting.core.scoring.BoardStatisticsItems;
import app.freerouting.core.scoring.BoardStatisticsLayers;
import app.freerouting.core.scoring.BoardStatisticsNets;
import app.freerouting.core.scoring.BoardStatisticsPads;
import app.freerouting.core.scoring.BoardStatisticsTraces;
import app.freerouting.core.scoring.BoardStatisticsVias;
import app.freerouting.datastructures.UndoableObjects;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.Polyline;
import app.freerouting.gui.FileFormat;
import app.freerouting.interactive.RatsNest;
import app.freerouting.management.TextManager;
import app.freerouting.management.gson.GsonProvider;
import app.freerouting.rules.BoardRules;
import app.freerouting.settings.RouterScoringSettings;
import com.google.gson.annotations.SerializedName;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;

public class BoardStatistics
implements Serializable {
    @SerializedName(value="host")
    public String host = null;
    @SerializedName(value="unit")
    public String unit = null;
    @SerializedName(value="board")
    public BoardStatisticsBoard board = new BoardStatisticsBoard();
    @SerializedName(value="layers")
    public BoardStatisticsLayers layers = new BoardStatisticsLayers();
    @SerializedName(value="items")
    public BoardStatisticsItems items = new BoardStatisticsItems();
    @SerializedName(value="components")
    public BoardStatisticsComponents components = new BoardStatisticsComponents();
    @SerializedName(value="pads")
    public BoardStatisticsPads pads = new BoardStatisticsPads();
    @SerializedName(value="nets")
    public BoardStatisticsNets nets = new BoardStatisticsNets();
    @SerializedName(value="connections")
    public BoardStatisticsConnections connections = new BoardStatisticsConnections();
    @SerializedName(value="traces")
    public BoardStatisticsTraces traces = new BoardStatisticsTraces();
    @SerializedName(value="bends")
    public BoardStatisticsBends bends = new BoardStatisticsBends();
    @SerializedName(value="vias")
    public BoardStatisticsVias vias = new BoardStatisticsVias();
    @SerializedName(value="clearance_violations")
    public BoardStatisticsClearanceViolations clearanceViolations = new BoardStatisticsClearanceViolations();

    public BoardStatistics() {
    }

    public BoardStatistics(BasicBoard board) {
        this(board, null);
    }

    public BoardStatistics(BasicBoard board, Unit unit) {
        UndoableObjects.Storable curr_item;
        Object curr_item2;
        IntBox bb = board.get_bounding_box();
        this.host = board.communication.specctra_parser_info.host_cad + "," + board.communication.specctra_parser_info.host_version;
        if (this.host == null || this.host.isEmpty()) {
            this.host = "Freerouting,2.1.2-SNAPSHOT";
        }
        this.host = TextManager.unescapeUnicode(this.host);
        this.unit = board.communication.unit.toString();
        this.board.boundingBox = new Rectangle2D.Float(bb.ur.x, board.get_bounding_box().ur.y, board.get_bounding_box().ll.x, board.get_bounding_box().ll.y);
        this.board.size = new Rectangle2D.Float(0.0f, 0.0f, Math.abs((float)board.get_bounding_box().ll.x - (float)board.get_bounding_box().ur.x), Math.abs((float)board.get_bounding_box().ll.y - (float)board.get_bounding_box().ur.y));
        this.layers.totalCount = board.get_layer_count();
        this.layers.signalCount = board.layer_structure.signal_layer_count();
        this.items.totalCount = 0;
        this.items.traceCount = 0;
        this.items.viaCount = 0;
        this.items.conductionAreaCount = 0;
        this.items.drillItemCount = 0;
        this.items.pinCount = 0;
        this.items.componentOutlineCount = 0;
        this.items.otherCount = 0;
        Iterator<UndoableObjects.UndoableObjectNode> it = board.item_list.start_read_object();
        while ((curr_item2 = (Item)board.item_list.read_object(it)) != null) {
            BoardStatisticsItems boardStatisticsItems = this.items;
            Integer n = boardStatisticsItems.totalCount;
            boardStatisticsItems.totalCount = boardStatisticsItems.totalCount + 1;
            if (curr_item2 instanceof Trace) {
                boardStatisticsItems = this.items;
                n = boardStatisticsItems.traceCount;
                boardStatisticsItems.traceCount = boardStatisticsItems.traceCount + 1;
                continue;
            }
            if (curr_item2 instanceof Via) {
                boardStatisticsItems = this.items;
                n = boardStatisticsItems.viaCount;
                boardStatisticsItems.viaCount = boardStatisticsItems.viaCount + 1;
                continue;
            }
            if (curr_item2 instanceof ConductionArea) {
                boardStatisticsItems = this.items;
                n = boardStatisticsItems.conductionAreaCount;
                boardStatisticsItems.conductionAreaCount = boardStatisticsItems.conductionAreaCount + 1;
                continue;
            }
            if (curr_item2 instanceof DrillItem) {
                boardStatisticsItems = this.items;
                n = boardStatisticsItems.drillItemCount;
                boardStatisticsItems.drillItemCount = boardStatisticsItems.drillItemCount + 1;
                continue;
            }
            if (curr_item2 instanceof Pin) {
                boardStatisticsItems = this.items;
                n = boardStatisticsItems.pinCount;
                boardStatisticsItems.pinCount = boardStatisticsItems.pinCount + 1;
                continue;
            }
            if (curr_item2 instanceof ComponentOutline) {
                boardStatisticsItems = this.items;
                n = boardStatisticsItems.componentOutlineCount;
                boardStatisticsItems.componentOutlineCount = boardStatisticsItems.componentOutlineCount + 1;
                continue;
            }
            boardStatisticsItems = this.items;
            n = boardStatisticsItems.otherCount;
            boardStatisticsItems.otherCount = boardStatisticsItems.otherCount + 1;
        }
        this.components.totalCount = board.components.count();
        this.pads.totalCount = board.get_pins().size();
        this.nets.totalCount = board.rules.nets.max_net_no();
        this.nets.classCount = board.rules.net_classes.count();
        this.traces.totalCount = board.get_traces().size();
        this.traces.totalLength = Float.valueOf((float)board.get_traces().stream().mapToDouble(trace -> trace.get_length()).sum());
        this.traces.averageLength = this.traces.totalCount > 0 ? Float.valueOf(this.traces.totalLength.floatValue() / (float)this.traces.totalCount.intValue()) : Float.valueOf(0.0f);
        this.traces.totalSegmentCount = 0;
        this.traces.totalHorizontalLength = Float.valueOf(0.0f);
        this.traces.totalVerticalLength = Float.valueOf(0.0f);
        this.traces.totalAngledLength = Float.valueOf(0.0f);
        for (Trace trace2 : board.get_traces()) {
            if (!(trace2 instanceof PolylineTrace)) continue;
            PolylineTrace polylineTrace = (PolylineTrace)trace2;
            Polyline polyline = polylineTrace.polyline();
            int cornerCount = polyline.corner_count();
            if (cornerCount > 1) {
                Line[] lineArray = this.traces;
                Integer.valueOf(lineArray.totalSegmentCount + (cornerCount - 1));
                lineArray.totalSegmentCount = lineArray.totalSegmentCount;
            }
            for (Line line : polyline.arr) {
                BoardStatisticsTraces boardStatisticsTraces;
                FloatPoint a = line.a.to_float();
                FloatPoint b = line.b.to_float();
                float length = (float)Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0));
                if (a.x == b.x) {
                    boardStatisticsTraces = this.traces;
                    Float.valueOf(boardStatisticsTraces.totalVerticalLength.floatValue() + length);
                    boardStatisticsTraces.totalVerticalLength = boardStatisticsTraces.totalVerticalLength;
                    continue;
                }
                if (a.y == b.y) {
                    boardStatisticsTraces = this.traces;
                    Float.valueOf(boardStatisticsTraces.totalHorizontalLength.floatValue() + length);
                    boardStatisticsTraces.totalHorizontalLength = boardStatisticsTraces.totalHorizontalLength;
                    continue;
                }
                boardStatisticsTraces = this.traces;
                Float.valueOf(boardStatisticsTraces.totalAngledLength.floatValue() + length);
                boardStatisticsTraces.totalAngledLength = boardStatisticsTraces.totalAngledLength;
            }
        }
        this.traces.totalWeightedLength = Float.valueOf(0.0f);
        int default_clearance_class = BoardRules.default_clearance_class();
        Iterator<UndoableObjects.UndoableObjectNode> it2 = board.item_list.start_read_object();
        while ((curr_item = board.item_list.read_object(it2)) != null) {
            Iterator<Via> curr_trace;
            FixedState fixed_state;
            if (!(curr_item instanceof Trace) || (fixed_state = ((Item)((Object)(curr_trace = (Trace)curr_item))).get_fixed_state()) != FixedState.NOT_FIXED && fixed_state != FixedState.SHOVE_FIXED) continue;
            double weighted_trace_length = ((Trace)((Object)curr_trace)).get_length() * (double)(((Trace)((Object)curr_trace)).get_half_width() + board.clearance_value(((Item)((Object)curr_trace)).clearance_class_no(), default_clearance_class, ((Trace)((Object)curr_trace)).get_layer()));
            if (fixed_state == FixedState.SHOVE_FIXED) {
                weighted_trace_length /= 2.0;
            }
            BoardStatisticsTraces boardStatisticsTraces = this.traces;
            Float.valueOf(boardStatisticsTraces.totalWeightedLength.floatValue() + (float)weighted_trace_length);
            boardStatisticsTraces.totalWeightedLength = boardStatisticsTraces.totalWeightedLength;
        }
        RatsNest ratsnest = new RatsNest(board);
        this.connections.maximumCount = ratsnest.max_connections;
        this.connections.incompleteCount = ratsnest.incomplete_count();
        this.bends.totalCount = 0;
        this.bends.ninetyDegreeCount = 0;
        this.bends.fortyFiveDegreeCount = 0;
        this.bends.otherAngleCount = 0;
        for (Trace trace3 : board.get_traces()) {
            PolylineTrace polylineTrace;
            Polyline polyline;
            int cornerCount;
            if (!(trace3 instanceof PolylineTrace) || (cornerCount = (polyline = (polylineTrace = (PolylineTrace)trace3).polyline()).corner_count()) < 3) continue;
            int bendsInTrace = cornerCount - 2;
            BoardStatisticsBends a = this.bends;
            Integer.valueOf(a.totalCount + bendsInTrace);
            a.totalCount = a.totalCount;
            for (int i = 1; i < cornerCount - 1; ++i) {
                Integer n;
                BoardStatisticsBends boardStatisticsBends;
                FloatPoint prev = polyline.corner(i - 1).to_float();
                FloatPoint curr = polyline.corner(i).to_float();
                FloatPoint next = polyline.corner(i + 1).to_float();
                double dx1 = curr.x - prev.x;
                double dy1 = curr.y - prev.y;
                double dx2 = next.x - curr.x;
                double dy2 = next.y - curr.y;
                double angle = Math.abs(Math.toDegrees(Math.atan2(dy2, dx2) - Math.atan2(dy1, dx1)));
                double d = angle = (angle = Math.min(angle, 360.0 - angle)) > 180.0 ? 360.0 - angle : angle;
                if (Math.abs(angle - 90.0) < 1.0) {
                    boardStatisticsBends = this.bends;
                    n = boardStatisticsBends.ninetyDegreeCount;
                    boardStatisticsBends.ninetyDegreeCount = boardStatisticsBends.ninetyDegreeCount + 1;
                    continue;
                }
                if (Math.abs(angle - 45.0) < 1.0 || Math.abs(angle - 135.0) < 1.0) {
                    boardStatisticsBends = this.bends;
                    n = boardStatisticsBends.fortyFiveDegreeCount;
                    boardStatisticsBends.fortyFiveDegreeCount = boardStatisticsBends.fortyFiveDegreeCount + 1;
                    continue;
                }
                boardStatisticsBends = this.bends;
                n = boardStatisticsBends.otherAngleCount;
                boardStatisticsBends.otherAngleCount = boardStatisticsBends.otherAngleCount + 1;
            }
        }
        this.vias.totalCount = board.get_vias().size();
        this.vias.throughHoleCount = 0;
        this.vias.blindCount = 0;
        this.vias.buriedCount = 0;
        for (Via via : board.get_vias()) {
            Integer n;
            BoardStatisticsVias boardStatisticsVias;
            if (via.first_layer() == 0 && via.last_layer() == this.layers.totalCount - 1) {
                boardStatisticsVias = this.vias;
                n = boardStatisticsVias.throughHoleCount;
                boardStatisticsVias.throughHoleCount = boardStatisticsVias.throughHoleCount + 1;
                continue;
            }
            if (via.first_layer() == 0 || via.last_layer() == this.layers.totalCount - 1) {
                boardStatisticsVias = this.vias;
                n = boardStatisticsVias.blindCount;
                boardStatisticsVias.blindCount = boardStatisticsVias.blindCount + 1;
                continue;
            }
            boardStatisticsVias = this.vias;
            n = boardStatisticsVias.buriedCount;
            boardStatisticsVias.buriedCount = boardStatisticsVias.buriedCount + 1;
        }
        this.clearanceViolations.totalCount = board.get_outline().clearance_violation_count();
        if (unit == null) {
            unit = Unit.MM;
        }
        if (unit != board.communication.unit) {
            Unit fromUnit = board.communication.unit;
            Unit toUnit = unit;
            this.unit = unit.toString();
            this.board.boundingBox = new Rectangle2D.Float((float)Unit.scale(this.board.boundingBox.x, fromUnit, toUnit), (float)Unit.scale(this.board.boundingBox.y, fromUnit, toUnit), (float)Unit.scale(this.board.boundingBox.width, fromUnit, toUnit), (float)Unit.scale(this.board.boundingBox.height, fromUnit, toUnit));
            this.board.size = new Rectangle2D.Float(0.0f, 0.0f, (float)Unit.scale(this.board.size.width, fromUnit, toUnit), (float)Unit.scale(this.board.size.height, fromUnit, toUnit));
            this.traces.totalLength = Float.valueOf((float)Unit.scale(this.traces.totalLength.floatValue(), fromUnit, toUnit));
            this.traces.totalWeightedLength = Float.valueOf((float)Unit.scale(this.traces.totalWeightedLength.floatValue(), fromUnit, toUnit));
            this.traces.averageLength = Float.valueOf((float)Unit.scale(this.traces.averageLength.floatValue(), fromUnit, toUnit));
            this.traces.totalHorizontalLength = Float.valueOf((float)Unit.scale(this.traces.totalHorizontalLength.floatValue(), fromUnit, toUnit));
            this.traces.totalVerticalLength = Float.valueOf((float)Unit.scale(this.traces.totalVerticalLength.floatValue(), fromUnit, toUnit));
            this.traces.totalAngledLength = Float.valueOf((float)Unit.scale(this.traces.totalAngledLength.floatValue(), fromUnit, toUnit));
        }
    }

    public BoardStatistics(byte[] data, FileFormat format) {
        if (format == FileFormat.SES || format == FileFormat.DSN) {
            String content = new String(data, StandardCharsets.UTF_8);
            if (format == FileFormat.SES) {
                String[] lines = content.split("\\(path ");
                ArrayList<String> layers = new ArrayList<String>();
                for (int i = 0; i < lines.length; ++i) {
                    String layer;
                    String line = lines[i];
                    String[] words = line.split(" ");
                    if (i <= 0 || words.length < 2 || layers.contains(layer = words[0])) continue;
                    layers.add(layer);
                }
                this.layers.totalCount = layers.size();
                this.components.totalCount = content.split("\\(component").length - 1;
                this.nets.totalCount = content.split("\\(net").length - 1;
                this.traces.totalCount = content.split("\\(wire").length - 1;
                this.vias.totalCount = content.split("\\(via").length - 1;
            } else if (format == FileFormat.DSN) {
                String[] lines = content.split("\n");
                String host_cad = null;
                String host_version = null;
                for (String line : lines) {
                    String value = null;
                    if ((line = line.trim()).startsWith("(host_cad")) {
                        value = line.substring(9, line.length() - 1).trim();
                        host_cad = TextManager.removeQuotes(value);
                    } else if (line.startsWith("(host_version")) {
                        value = line.substring(13, line.length() - 1).trim();
                        host_version = TextManager.removeQuotes(value);
                    }
                    if (host_cad != null && host_version != null) break;
                }
                if (host_cad != null && host_version != null) {
                    this.host = host_cad + "," + host_version;
                } else if (host_cad != null) {
                    this.host = host_cad;
                }
                this.layers.totalCount = content.split("\\(layer").length - 1;
                this.components.totalCount = content.split("\\(component").length - 1;
                this.nets.classCount = content.split("\\(class").length - 1;
                this.nets.totalCount = content.split("\\(net").length - 1;
                this.traces.totalCount = content.split("\\(wire").length - 1;
                this.vias.totalCount = content.split("\\(via").length - 1;
            }
        }
    }

    public String toString() {
        return GsonProvider.GSON.toJson(this);
    }

    public float calculateScore(RouterScoringSettings scoringSettings) {
        float maximumScore = this.getMaximumScore(scoringSettings);
        float penalties = (float)this.connections.incompleteCount.intValue() * scoringSettings.unroutedNetPenalty + (float)this.clearanceViolations.totalCount.intValue() * scoringSettings.clearanceViolationPenalty + (float)this.bends.totalCount.intValue() * scoringSettings.bendPenalty;
        float costs = (float)((double)this.traces.totalLength.floatValue() * scoringSettings.defaultPreferredDirectionTraceCost + (double)(this.vias.totalCount * scoringSettings.via_costs));
        return maximumScore - penalties - costs;
    }

    public float getMaximumScore(RouterScoringSettings scoringSettings) {
        return (float)this.connections.maximumCount.intValue() * scoringSettings.unroutedNetPenalty;
    }

    public float getNormalizedScore(RouterScoringSettings scoringSettings) {
        return Math.max(0.0f, this.calculateScore(scoringSettings) / this.getMaximumScore(scoringSettings)) * 1000.0f;
    }
}

