/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.core;

import app.freerouting.board.RoutingBoard;
import app.freerouting.core.BoardFileDetails;
import app.freerouting.core.RouterJobResourceUsage;
import app.freerouting.core.RoutingJobPriority;
import app.freerouting.core.RoutingJobState;
import app.freerouting.core.RoutingStage;
import app.freerouting.core.StoppableThread;
import app.freerouting.core.events.RoutingJobLogEntryAddedEvent;
import app.freerouting.core.events.RoutingJobLogEntryAddedEventListener;
import app.freerouting.core.events.RoutingJobUpdatedEvent;
import app.freerouting.core.events.RoutingJobUpdatedEventListener;
import app.freerouting.designforms.specctra.RulesFile;
import app.freerouting.gui.FileFormat;
import app.freerouting.gui.WindowMessage;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.logger.FRLogger;
import app.freerouting.logger.LogEntry;
import app.freerouting.settings.GlobalSettings;
import app.freerouting.settings.RouterSettings;
import com.google.gson.annotations.SerializedName;
import java.awt.Component;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class RoutingJob
implements Serializable,
Comparable<RoutingJob> {
    public static final String DSN_FILE_EXTENSION = "dsn";
    public static final String BINARY_FILE_EXTENSION = "frb";
    private static final String RULES_FILE_EXTENSION = "rules";
    private static final String SES_FILE_EXTENSION = "ses";
    private static final String EAGLE_SCRIPT_FILE_EXTENSION = "scr";
    @SerializedName(value="id")
    public final UUID id = UUID.randomUUID();
    @SerializedName(value="created_at")
    public final Instant createdAt = Instant.now();
    protected final transient List<RoutingJobUpdatedEventListener> settingsUpdatedEventListeners = new ArrayList<RoutingJobUpdatedEventListener>();
    protected final transient List<RoutingJobUpdatedEventListener> inputUpdatedEventListeners = new ArrayList<RoutingJobUpdatedEventListener>();
    protected final transient List<RoutingJobUpdatedEventListener> outputUpdatedEventListeners = new ArrayList<RoutingJobUpdatedEventListener>();
    protected final transient List<RoutingJobLogEntryAddedEventListener> logEntryAddedEventListeners = new ArrayList<RoutingJobLogEntryAddedEventListener>();
    @SerializedName(value="short_name")
    public String shortName = "N/A";
    @SerializedName(value="name")
    public String name;
    @SerializedName(value="started_at")
    public Instant startedAt = null;
    @SerializedName(value="finished_at")
    public Instant finishedAt = null;
    @SerializedName(value="state")
    public RoutingJobState state = RoutingJobState.INVALID;
    @SerializedName(value="stage")
    public RoutingStage stage = RoutingStage.IDLE;
    @SerializedName(value="priority")
    public RoutingJobPriority priority = RoutingJobPriority.NORMAL;
    @SerializedName(value="session_id")
    public UUID sessionId;
    @SerializedName(value="input")
    public BoardFileDetails input = null;
    @SerializedName(value="output")
    public BoardFileDetails output = null;
    @SerializedName(value="snapshot")
    public BoardFileDetails snapshot = null;
    @SerializedName(value="router_settings")
    public RouterSettings routerSettings = new RouterSettings();
    @SerializedName(value="resource_usage")
    public RouterJobResourceUsage resourceUsage = new RouterJobResourceUsage();
    public transient StoppableThread thread = null;
    public transient RoutingBoard board = null;
    public transient Instant timeoutAt;

    public RoutingJob() {
        this.name = "J-" + this.id.toString().substring(0, 6).toUpperCase();
        this.shortName = this.id.toString().substring(0, 6).toUpperCase();
    }

    public RoutingJob(UUID sessionId) {
        this();
        this.sessionId = sessionId;
        this.shortName = this.sessionId.toString().substring(0, 6).toUpperCase() + "\\" + this.id.toString().substring(0, 6).toUpperCase();
    }

    public static File showOpenDialog(String p_default_directory, Component p_parent) {
        JFileChooser fileChooser = new JFileChooser(p_default_directory);
        fileChooser.setMinimumSize(new Dimension(500, 250));
        FileNameExtensionFilter dsnFilter = new FileNameExtensionFilter("SPECCTRA Design file (*.dsn)", DSN_FILE_EXTENSION);
        fileChooser.addChoosableFileFilter(dsnFilter);
        FileNameExtensionFilter frbFilter = new FileNameExtensionFilter("Freerouting binary file (*.frb)", BINARY_FILE_EXTENSION);
        fileChooser.addChoosableFileFilter(frbFilter);
        fileChooser.setFileFilter(dsnFilter);
        fileChooser.showOpenDialog(p_parent);
        return fileChooser.getSelectedFile();
    }

    public static boolean read_rules_file(String p_design_name, String p_parent_name, String rules_file_name, GuiBoardManager p_board_handling, String p_confirm_message) {
        boolean dsn_file_generated_by_host = p_board_handling.get_routing_board().communication.specctra_parser_info.dsn_file_generated_by_host;
        try {
            File rules_file = new File(p_parent_name, rules_file_name);
            FRLogger.info("Opening '" + rules_file_name + "'...");
            FileInputStream input_stream = new FileInputStream(rules_file);
            if (dsn_file_generated_by_host && WindowMessage.confirm(p_confirm_message)) {
                return RulesFile.read(input_stream, p_design_name, p_board_handling);
            }
        }
        catch (IOException e) {
            FRLogger.error("File '" + rules_file_name + "' was not found.", null);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileFormat getFileFormat(byte[] content) {
        try (ByteArrayInputStream fileInputStream = new ByteArrayInputStream(content);){
            byte[] buffer = new byte[6];
            int bytesRead = ((InputStream)fileInputStream).read(buffer, 0, 6);
            if (bytesRead != 6) return FileFormat.UNKNOWN;
            if (buffer[0] == -84 && buffer[1] == -19 && buffer[2] == 0 && buffer[3] == 5) {
                FileFormat fileFormat = FileFormat.FRB;
                return fileFormat;
            }
            while (buffer[0] == 10 || buffer[0] == 13) {
                buffer[0] = buffer[1];
                buffer[1] = buffer[2];
                buffer[2] = buffer[3];
                buffer[3] = buffer[4];
                buffer[4] = buffer[5];
            }
            if (buffer[0] == 40 && buffer[1] == 112 && buffer[2] == 99 && buffer[3] == 98 || buffer[0] == 40 && buffer[1] == 80 && buffer[2] == 67 && buffer[3] == 66) {
                FileFormat fileFormat = FileFormat.DSN;
                return fileFormat;
            }
            if (buffer[0] != 40 || buffer[1] != 115 || buffer[2] != 101 || buffer[3] != 115) {
                if (buffer[0] != 40) return FileFormat.UNKNOWN;
                if (buffer[1] != 83) return FileFormat.UNKNOWN;
                if (buffer[2] != 69) return FileFormat.UNKNOWN;
                if (buffer[3] != 83) return FileFormat.UNKNOWN;
            }
            FileFormat fileFormat = FileFormat.SES;
            return fileFormat;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return FileFormat.UNKNOWN;
    }

    public static FileFormat getFileFormat(Path path) {
        String filename = path.toString().toLowerCase();
        String[] parts = filename.split("\\.");
        if (parts.length > 1) {
            String extension;
            switch (extension = parts[parts.length - 1].toLowerCase()) {
                case "dsn": {
                    return FileFormat.DSN;
                }
                case "frb": {
                    return FileFormat.FRB;
                }
                case "ses": {
                    return FileFormat.SES;
                }
                case "scr": {
                    return FileFormat.SCR;
                }
            }
            return FileFormat.UNKNOWN;
        }
        return FileFormat.UNKNOWN;
    }

    public boolean setInput(byte[] inputFileContent) {
        this.input = new BoardFileDetails();
        this.input.addUpdatedEventListener(e -> this.fireInputUpdatedEvent());
        return this.tryToSetInput(inputFileContent);
    }

    private String getSnapshotFilename(File inputFile) {
        long crc32Checksum;
        try (FileInputStream inputStream = new FileInputStream(inputFile.getAbsoluteFile());){
            crc32Checksum = BoardFileDetails.calculateCrc32(inputStream).getValue();
        }
        catch (IOException e) {
            crc32Checksum = 0L;
        }
        if (crc32Checksum == 0L) {
            return null;
        }
        Path snapshotsFolderPath = GlobalSettings.getUserDataPath().resolve("snapshots");
        try {
            Files.createDirectories(snapshotsFolderPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            FRLogger.error("Failed to create the snapshots directory.", e);
        }
        String intermediate_snapshot_file_name = "snapshot-" + Long.toHexString(crc32Checksum) + ".frb";
        return String.valueOf(snapshotsFolderPath) + File.separator + intermediate_snapshot_file_name;
    }

    public File getRulesFile() {
        return new File(this.changeFileExtension(this.output.getAbsolutePath(), RULES_FILE_EXTENSION));
    }

    public File getEagleScriptFile() {
        return new File(this.changeFileExtension(this.output.getAbsolutePath(), EAGLE_SCRIPT_FILE_EXTENSION));
    }

    public void setDummyInputFile(String filename) {
        this.input = new BoardFileDetails();
        this.snapshot = new BoardFileDetails();
        this.output = new BoardFileDetails();
        if (filename != null && filename.toLowerCase().endsWith(DSN_FILE_EXTENSION)) {
            this.input.format = FileFormat.DSN;
            this.input.setFilename(filename);
            this.snapshot.setFilename(this.getSnapshotFilename(this.input.getFile()));
        }
    }

    private boolean tryToSetInput(byte[] fileContent) {
        if (fileContent == null) {
            return false;
        }
        this.input.format = RoutingJob.getFileFormat(fileContent);
        if (this.input.format != FileFormat.UNKNOWN) {
            this.input.setData(fileContent);
            this.fireInputUpdatedEvent();
            return true;
        }
        return false;
    }

    private String changeFileExtension(String filename, String newFileExtension) {
        Path filePath = Path.of(filename, new String[0]);
        String originalFullPathWithoutFilename = filePath.getParent().toAbsolutePath().toString();
        String originalFilename = filePath.getFileName().toString();
        String[] nameParts = originalFilename.split("\\.");
        if (nameParts.length > 1) {
            String extension = nameParts[nameParts.length - 1].toLowerCase();
            if (extension.equals(newFileExtension)) {
                return filePath.toString();
            }
            String newFilename = originalFilename.substring(0, originalFilename.length() - extension.length() - 1) + "." + newFileExtension;
            return Path.of(originalFullPathWithoutFilename, newFilename).toString();
        }
        return Path.of(originalFullPathWithoutFilename, originalFilename + "." + newFileExtension).toString();
    }

    public boolean tryToSetOutputFile(File outputFile) {
        if (outputFile == null) {
            return false;
        }
        FileFormat ff = RoutingJob.getFileFormat(outputFile.toPath());
        if (ff == FileFormat.DSN || ff == FileFormat.FRB || ff == FileFormat.SES || ff == FileFormat.SCR) {
            this.output = new BoardFileDetails(outputFile);
            this.output.addUpdatedEventListener(e -> this.fireInputUpdatedEvent());
            this.output.format = ff;
            this.fireOutputUpdatedEvent();
            return true;
        }
        return false;
    }

    public String getInputFileDetails() {
        return new BoardFileDetails(this.input.getFile()).toString();
    }

    public String getOutputFileDetails() {
        return new BoardFileDetails(this.output.getFile()).toString();
    }

    @Override
    public int compareTo(RoutingJob o) {
        if (this.priority.ordinal() < o.priority.ordinal()) {
            return -1;
        }
        if (this.priority.ordinal() > o.priority.ordinal()) {
            return 1;
        }
        return 0;
    }

    public BoardFileDetails getInput() {
        return this.input;
    }

    public void setInput(String inputFilePath) throws IOException {
        this.setInput(new File(inputFilePath));
    }

    public void setInput(File inputFile) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(inputFile);
        byte[] content = fileInputStream.readAllBytes();
        this.setInput(content);
        this.input.setFilename(inputFile.getAbsolutePath());
        if (this.input.format == FileFormat.UNKNOWN) {
            this.input.format = RoutingJob.getFileFormat(Path.of(this.input.getAbsolutePath(), new String[0]));
        }
        if (this.input.format == FileFormat.FRB) {
            this.output = new BoardFileDetails();
            this.output.addUpdatedEventListener(e -> this.fireOutputUpdatedEvent());
            this.output.setFilename(this.changeFileExtension(this.input.getAbsolutePath(), BINARY_FILE_EXTENSION));
        }
        if (this.input.format == FileFormat.DSN) {
            this.output = new BoardFileDetails();
            this.output.addUpdatedEventListener(e -> this.fireOutputUpdatedEvent());
            this.output.setFilename(this.changeFileExtension(this.input.getAbsolutePath(), SES_FILE_EXTENSION));
        }
        if (this.input.format != FileFormat.UNKNOWN) {
            this.input = new BoardFileDetails(inputFile);
            this.input.addUpdatedEventListener(e -> this.fireInputUpdatedEvent());
            this.name = this.input.getFilenameWithoutExtension();
            this.snapshot = new BoardFileDetails();
            this.snapshot.setFilename(this.getSnapshotFilename(this.input.getFile()));
        }
        this.fireInputUpdatedEvent();
    }

    public boolean setSettings(RouterSettings settings) {
        boolean wereSettingsChanged = this.routerSettings.applyNewValuesFrom(settings) > 0;
        this.fireSettingsUpdatedEvent();
        return wereSettingsChanged;
    }

    public void addSettingsUpdatedEventListener(RoutingJobUpdatedEventListener listener) {
        this.settingsUpdatedEventListeners.add(listener);
    }

    public void fireSettingsUpdatedEvent() {
        RoutingJobUpdatedEvent event = new RoutingJobUpdatedEvent(this, this);
        for (RoutingJobUpdatedEventListener listener : this.settingsUpdatedEventListeners) {
            listener.onRoutingJobUpdated(event);
        }
    }

    public void addInputUpdatedEventListener(RoutingJobUpdatedEventListener listener) {
        this.inputUpdatedEventListeners.add(listener);
    }

    public void fireInputUpdatedEvent() {
        RoutingJobUpdatedEvent event = new RoutingJobUpdatedEvent(this, this);
        for (RoutingJobUpdatedEventListener listener : this.inputUpdatedEventListeners) {
            listener.onRoutingJobUpdated(event);
        }
    }

    public void addOutputUpdatedEventListener(RoutingJobUpdatedEventListener listener) {
        this.outputUpdatedEventListeners.add(listener);
    }

    public void fireOutputUpdatedEvent() {
        RoutingJobUpdatedEvent event = new RoutingJobUpdatedEvent(this, this);
        for (RoutingJobUpdatedEventListener listener : this.outputUpdatedEventListeners) {
            listener.onRoutingJobUpdated(event);
        }
    }

    public void addLogEntryAddedEventListener(RoutingJobLogEntryAddedEventListener listener) {
        this.logEntryAddedEventListeners.add(listener);
    }

    public void fireLogEntryAddedEvent(LogEntry logEntry) {
        RoutingJobLogEntryAddedEvent event = new RoutingJobLogEntryAddedEvent(this, this, logEntry);
        for (RoutingJobLogEntryAddedEventListener listener : this.logEntryAddedEventListeners) {
            listener.onLogEntryAdded(event);
        }
    }

    public void logInfo(String message) {
        LogEntry logEntry = FRLogger.info("[" + this.shortName + "] " + message, this.id);
        this.fireLogEntryAddedEvent(logEntry);
    }

    public void logWarning(String message) {
        LogEntry logEntry = FRLogger.warn("[" + this.shortName + "] " + message, this.id);
        this.fireLogEntryAddedEvent(logEntry);
    }

    public void logError(String message, Throwable ex) {
        LogEntry logEntry = FRLogger.error("[" + this.shortName + "] " + message, this.id, ex);
        this.fireLogEntryAddedEvent(logEntry);
    }

    public void logDebug(String message) {
        LogEntry logEntry = FRLogger.debug("[" + this.shortName + "] " + message, this.id);
        this.fireLogEntryAddedEvent(logEntry);
    }
}

